package com.temboo.Library.Amazon.RDS;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateDBInstance

Creates a new database instance.
*/
public class CreateDBInstance extends Choreography {

	/**
	Create a new instance of the CreateDBInstance Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateDBInstance(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/RDS/CreateDBInstance"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateDBInstanceInputSet
	*/
	public CreateDBInstanceInputSet newInputSet() {
		return new CreateDBInstanceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateDBInstanceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateDBInstanceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateDBInstance
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateDBInstanceInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the AllocatedStorage input for this Choreo. 

		@param Integer - (required, integer) Storage amount (in gigabytes) to be configured for the DB. Use 5 to 1024 for MySQL , 10 to 1024 for Oracle, or 200 to 1024 for SQLServer.
		*/
		public void set_AllocatedStorage(Integer value) {
			this.setInput("AllocatedStorage", value);
		}

		/** 
		Set the value of the AllocatedStorage input for this Choreo as a String. 

		@param String - (required, integer) Storage amount (in gigabytes) to be configured for the DB. Use 5 to 1024 for MySQL , 10 to 1024 for Oracle, or 200 to 1024 for SQLServer.
		*/
		public void set_AllocatedStorage(String value) {
			this.setInput("AllocatedStorage", value);	
		}
		/** 
		Set the value of the AutoMinorVersionUpgrade input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates that minor engine upgrades will be applied to the DB Instance automatically during the maintenance window.
		*/
		public void set_AutoMinorVersionUpgrade(Boolean value) {
			this.setInput("AutoMinorVersionUpgrade", value);
		}

		/** 
		Set the value of the AutoMinorVersionUpgrade input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates that minor engine upgrades will be applied to the DB Instance automatically during the maintenance window.
		*/
		public void set_AutoMinorVersionUpgrade(String value) {
			this.setInput("AutoMinorVersionUpgrade", value);	
		}
		/** 
		Set the value of the AvailabilityZone input for this Choreo. 

		@param String - (optional, string) The EC2 Availability Zone that the database instance will be created in (e.g. us-east-1a, us-east-1b, us-east-1c).
		*/
		public void set_AvailabilityZone(String value) {
			this.setInput("AvailabilityZone", value);
		}


		/** 
		Set the value of the BackupRetentionPeriod input for this Choreo. 

		@param Integer - (optional, integer) The number of days for which automated backups are retained. When set to a positive number, backups are enabled. Set to 0 to disable automated backups.
		*/
		public void set_BackupRetentionPeriod(Integer value) {
			this.setInput("BackupRetentionPeriod", value);
		}

		/** 
		Set the value of the BackupRetentionPeriod input for this Choreo as a String. 

		@param String - (optional, integer) The number of days for which automated backups are retained. When set to a positive number, backups are enabled. Set to 0 to disable automated backups.
		*/
		public void set_BackupRetentionPeriod(String value) {
			this.setInput("BackupRetentionPeriod", value);	
		}
		/** 
		Set the value of the CharacterSetName input for this Choreo. 

		@param String - (optional, string) Indicates that the DB Instance should be associated with the specified CharacterSet.
		*/
		public void set_CharacterSetName(String value) {
			this.setInput("CharacterSetName", value);
		}


		/** 
		Set the value of the DBInstanceClass input for this Choreo. 

		@param String - (required, string) Capacity for the DB instance.  (db.t1.micro, db.m1.small, db.m1.large, db.m1.xlarge, db.m2.xlarge, db.m2.2xlarge, or db.m2.4xlarge).
		*/
		public void set_DBInstanceClass(String value) {
			this.setInput("DBInstanceClass", value);
		}


		/** 
		Set the value of the DBInstanceIdentifier input for this Choreo. 

		@param String - (required, string) The DB Instance identifier. Should be in all lowercase.
		*/
		public void set_DBInstanceIdentifier(String value) {
			this.setInput("DBInstanceIdentifier", value);
		}


		/** 
		Set the value of the DBName input for this Choreo. 

		@param String - (conditional, string) For MySQL, this is the name of the db that is created on the instance. For Oracle, it refers to the SID. Must be null for SQLServer.
		*/
		public void set_DBName(String value) {
			this.setInput("DBName", value);
		}


		/** 
		Set the value of the DBParameterGroupName input for this Choreo. 

		@param String - (optional, string) The name of the DB Parameter Group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine will be used.
		*/
		public void set_DBParameterGroupName(String value) {
			this.setInput("DBParameterGroupName", value);
		}


		/** 
		Set the value of the DBSecurityGroups input for this Choreo. 

		@param String - (optional, string) A comma separated list of up to 10 DB Security Groups to associate with this DB Instance.
		*/
		public void set_DBSecurityGroups(String value) {
			this.setInput("DBSecurityGroups", value);
		}


		/** 
		Set the value of the DBSubnetGroupName input for this Choreo. 

		@param String - (optional, string) A DB Subnet Group to associate with this DB Instance. When not specified, it indicates that this is a non-VPC DB instance.
		*/
		public void set_DBSubnetGroupName(String value) {
			this.setInput("DBSubnetGroupName", value);
		}


		/** 
		Set the value of the Engine input for this Choreo. 

		@param String - (required, string) The name of the database engine to use for the instance. Options are: MySQL, oracle-se1, oracle-se, oracle-ee, sqlserver-ee, sqlserver-se, sqlserver-ex, sqlserver-web.
		*/
		public void set_Engine(String value) {
			this.setInput("Engine", value);
		}


		/** 
		Set the value of the EngineVersion input for this Choreo. 

		@param String - (optional, string) The version number of the database engine to use.
		*/
		public void set_EngineVersion(String value) {
			this.setInput("EngineVersion", value);
		}


		/** 
		Set the value of the Iops input for this Choreo. 

		@param String - (optional, string) The amount of provisioned input/output operations per second to be initially allocated for the DB Instance.
		*/
		public void set_Iops(String value) {
			this.setInput("Iops", value);
		}


		/** 
		Set the value of the LicenseModel input for this Choreo. 

		@param String - (optional, string) License model information for this DB Instance. Valid values are: license-included, bring-your-own-license, general-public-license.
		*/
		public void set_LicenseModel(String value) {
			this.setInput("LicenseModel", value);
		}


		/** 
		Set the value of the MasterUserPassword input for this Choreo. 

		@param String - (required, password) The master password for the DB instance.
		*/
		public void set_MasterUserPassword(String value) {
			this.setInput("MasterUserPassword", value);
		}


		/** 
		Set the value of the MasterUsername input for this Choreo. 

		@param String - (required, string) The master username for the DB instance.
		*/
		public void set_MasterUsername(String value) {
			this.setInput("MasterUsername", value);
		}


		/** 
		Set the value of the MultiAZ input for this Choreo. 

		@param Boolean - (optional, boolean) Specifies if the DB Instance is a Multi-AZ deployment. You cannot set the AvailabilityZone parameter if the MultiAZ parameter is set to true.
		*/
		public void set_MultiAZ(Boolean value) {
			this.setInput("MultiAZ", value);
		}

		/** 
		Set the value of the MultiAZ input for this Choreo as a String. 

		@param String - (optional, boolean) Specifies if the DB Instance is a Multi-AZ deployment. You cannot set the AvailabilityZone parameter if the MultiAZ parameter is set to true.
		*/
		public void set_MultiAZ(String value) {
			this.setInput("MultiAZ", value);	
		}
		/** 
		Set the value of the OptionGroupName input for this Choreo. 

		@param String - (optional, string) Indicates that the DB Instance should be associated with the specified option group.
		*/
		public void set_OptionGroupName(String value) {
			this.setInput("OptionGroupName", value);
		}


		/** 
		Set the value of the Port input for this Choreo. 

		@param Integer - (optional, integer) The port number on which the database accepts connections. Valid range for MySQL is 1150-65535. Valid range for Oracle is 1150-65535. Valid range for SQLServer is 1150-65535 except for 1434 and 3389.
		*/
		public void set_Port(Integer value) {
			this.setInput("Port", value);
		}

		/** 
		Set the value of the Port input for this Choreo as a String. 

		@param String - (optional, integer) The port number on which the database accepts connections. Valid range for MySQL is 1150-65535. Valid range for Oracle is 1150-65535. Valid range for SQLServer is 1150-65535 except for 1434 and 3389.
		*/
		public void set_Port(String value) {
			this.setInput("Port", value);	
		}
		/** 
		Set the value of the PreferredBackupWindow input for this Choreo. 

		@param String - (optional, string) The daily time range during which automated backups are created if automated backups are enabled, using the BackupRetentionPeriod parameter. Must be in the format hh24:mi-hh24:mi (in UTC).
		*/
		public void set_PreferredBackupWindow(String value) {
			this.setInput("PreferredBackupWindow", value);
		}


		/** 
		Set the value of the PreferredMaintenanceWindow input for this Choreo. 

		@param String - (optional, string) The weekly time range (in UTC) during which system maintenance can occur. Format: ddd:hh24:mi-ddd:hh24:mi.
		*/
		public void set_PreferredMaintenanceWindow(String value) {
			this.setInput("PreferredMaintenanceWindow", value);
		}


		/** 
		Set the value of the PubliclyAccessible input for this Choreo. 

		@param Boolean - (optional, boolean) Specifies the accessibility options for the DB Instance. The default behavior varies depending on whether a VPC has been requested or not.
		*/
		public void set_PubliclyAccessible(Boolean value) {
			this.setInput("PubliclyAccessible", value);
		}

		/** 
		Set the value of the PubliclyAccessible input for this Choreo as a String. 

		@param String - (optional, boolean) Specifies the accessibility options for the DB Instance. The default behavior varies depending on whether a VPC has been requested or not.
		*/
		public void set_PubliclyAccessible(String value) {
			this.setInput("PubliclyAccessible", value);	
		}
		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the RDS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


		/** 
		Set the value of the VpcSecurityGroupIds input for this Choreo. 

		@param String - (optional, string) A comma separated list of up to 10 EC2 VPC Security Groups to associate with this DB Instance.
		*/
		public void set_VpcSecurityGroupIds(String value) {
			this.setInput("VpcSecurityGroupIds", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateDBInstance Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateDBInstanceResultSet extends ResultSet {
		public CreateDBInstanceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
