package com.temboo.Library.Amazon.Marketplace.Reports;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FlatFileOrderReport

Returns a tab-delimited flat file order report. The report shows orders from the previous 60 days.
*/
public class FlatFileOrderReport extends Choreography {

	/**
	Create a new instance of the FlatFileOrderReport Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FlatFileOrderReport(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/Marketplace/Reports/FlatFileOrderReport"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FlatFileOrderReportInputSet
	*/
	public FlatFileOrderReportInputSet newInputSet() {
		return new FlatFileOrderReportInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FlatFileOrderReportResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FlatFileOrderReportResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FlatFileOrderReport
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FlatFileOrderReportInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSMarketplaceId input for this Choreo. 

		@param String - (required, string) The Marketplace ID provided by Amazon Web Services.
		*/
		public void set_AWSMarketplaceId(String value) {
			this.setInput("AWSMarketplaceId", value);
		}


		/** 
		Set the value of the AWSMerchantId input for this Choreo. 

		@param String - (required, string) The Merchant ID provided by Amazon Web Services.
		*/
		public void set_AWSMerchantId(String value) {
			this.setInput("AWSMerchantId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the EndDate input for this Choreo. 

		@param String - (optional, date) The end of a date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
		*/
		public void set_EndDate(String value) {
			this.setInput("EndDate", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the MWSAuthToken input for this Choreo. 

		@param String - (optional, string) The Amazon MWS authorization token for the given seller and developer.
		*/
		public void set_MWSAuthToken(String value) {
			this.setInput("MWSAuthToken", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (optional, date) The start of a date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the TimeToWait input for this Choreo. 

		@param Integer - (optional, integer) By default, the Choreo will wait for 5 minutes to see if the report is ready for retrieval. Max is 120 minutes.
		*/
		public void set_TimeToWait(Integer value) {
			this.setInput("TimeToWait", value);
		}

		/** 
		Set the value of the TimeToWait input for this Choreo as a String. 

		@param String - (optional, integer) By default, the Choreo will wait for 5 minutes to see if the report is ready for retrieval. Max is 120 minutes.
		*/
		public void set_TimeToWait(String value) {
			this.setInput("TimeToWait", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FlatFileOrderReport Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FlatFileOrderReportResultSet extends ResultSet {
		public FlatFileOrderReportResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Report" output from this Choreo execution

		@return String - (multiline) The report contents.
		*/
		public String get_Report() {
			return this.getResultString("Report");
		}
		/** 
		Retrieve the value for the "GeneratedReportId" output from this Choreo execution

		@return String - (integer) The GeneratedReportId parsed from the Amazon response.
		*/
		public String get_GeneratedReportId() {
			return this.getResultString("GeneratedReportId");
		}
		/** 
		Retrieve the value for the "ReportProcessingStatus" output from this Choreo execution

		@return String - (string) The status of the report request parsed from the Amazon response.
		*/
		public String get_ReportProcessingStatus() {
			return this.getResultString("ReportProcessingStatus");
		}
		/** 
		Retrieve the value for the "ReportRequestId" output from this Choreo execution

		@return String - (integer) The ReportRequestId parsed from the Amazon response. This id is used in GetReportRequestList.
		*/
		public String get_ReportRequestId() {
			return this.getResultString("ReportRequestId");
		}
	}
	
}
