package com.temboo.Library.Amazon.IAM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UploadServerCertificate

Uploads a server certificate entity for the AWS account. The server certificate entity includes a public key certificate, a private key, and an optional certificate chain, which should all be PEM-encoded.
*/
public class UploadServerCertificate extends Choreography {

	/**
	Create a new instance of the UploadServerCertificate Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UploadServerCertificate(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/IAM/UploadServerCertificate"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UploadServerCertificateInputSet
	*/
	public UploadServerCertificateInputSet newInputSet() {
		return new UploadServerCertificateInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UploadServerCertificateResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UploadServerCertificateResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UploadServerCertificate
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UploadServerCertificateInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the CertificateBody input for this Choreo. 

		@param String - (required, multiline) The contents of the signing certificate.
		*/
		public void set_CertificateBody(String value) {
			this.setInput("CertificateBody", value);
		}


		/** 
		Set the value of the CertificateChain input for this Choreo. 

		@param String - (optional, multiline) The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key certificates of the chain.
		*/
		public void set_CertificateChain(String value) {
			this.setInput("CertificateChain", value);
		}


		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (optional, string) The path for the server certificate.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the PrivateKey input for this Choreo. 

		@param String - (required, multiline) The contents of the private key in PEM-encoded format.
		*/
		public void set_PrivateKey(String value) {
			this.setInput("PrivateKey", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ServerCertificateName input for this Choreo. 

		@param String - (required, string) The name for the server certificate. Do not include the path in this value.
		*/
		public void set_ServerCertificateName(String value) {
			this.setInput("ServerCertificateName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UploadServerCertificate Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UploadServerCertificateResultSet extends ResultSet {
		public UploadServerCertificateResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
