package com.temboo.Library.Zoho.CRM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GenerateAuthToken

Generates an authentication token.
*/
public class GenerateAuthToken extends Choreography {

	/**
	Create a new instance of the GenerateAuthToken Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GenerateAuthToken(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zoho/CRM/GenerateAuthToken"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GenerateAuthTokenInputSet
	*/
	public GenerateAuthTokenInputSet newInputSet() {
		return new GenerateAuthTokenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GenerateAuthTokenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GenerateAuthTokenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GenerateAuthToken
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GenerateAuthTokenInputSet extends InputSet {
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, string) Your Zoho password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) Your Zoho CRM username.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GenerateAuthToken Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GenerateAuthTokenResultSet extends ResultSet {
		public GenerateAuthTokenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AuthenticationToken" output from this Choreo execution

		@return String - (string) The authentication token returned from Zoho.
		*/
		public String get_AuthenticationToken() {
			return this.getResultString("AuthenticationToken");
		}
	}
	
}
