package com.temboo.Library.Yahoo.Weather;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTemperature

Retrieves the current temperature from Yahoo Weather for the specified location.
*/
public class GetTemperature extends Choreography {

	/**
	Create a new instance of the GetTemperature Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTemperature(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Yahoo/Weather/GetTemperature"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTemperatureInputSet
	*/
	public GetTemperatureInputSet newInputSet() {
		return new GetTemperatureInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTemperatureResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTemperatureResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTemperature
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTemperatureInputSet extends InputSet {
		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (required, string) The address to be searched.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the Units input for this Choreo. 

		@param String - (optional, string) The unit of temperature in the response. Acceptable inputs: f for Fahrenheit or c for Celsius. Defaults to f. When c is specified, all units measurements returned are changed to metric.
		*/
		public void set_Units(String value) {
			this.setInput("Units", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTemperature Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTemperatureResultSet extends ResultSet {
		public GetTemperatureResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Temperature" output from this Choreo execution

		@return String - (integer) The current temperature (defaults to Fahrenheit).
		*/
		public String get_Temperature() {
			return this.getResultString("Temperature");
		}
	}
	
}
