package com.temboo.Library.Xively.Products;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteProduct

Deletes a product batch. This will also delete all devices and feeds associated with the specified product batch.
*/
public class DeleteProduct extends Choreography {

	/**
	Create a new instance of the DeleteProduct Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteProduct(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/Products/DeleteProduct"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteProductInputSet
	*/
	public DeleteProductInputSet newInputSet() {
		return new DeleteProductInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteProductResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteProductResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteProduct
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteProductInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ProductID input for this Choreo. 

		@param String - (required, string) The ID of the product you are trying to delete.
		*/
		public void set_ProductID(String value) {
			this.setInput("ProductID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteProduct Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteProductResultSet extends ResultSet {
		public DeleteProductResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ResponseStatusCode" output from this Choreo execution

		@return String - (integer) The response status code returned from Xively. For a successful product deletion, the code should be 200.
		*/
		public String get_ResponseStatusCode() {
			return this.getResultString("ResponseStatusCode");
		}
	}
	
}
