package com.temboo.Library.WolframAlpha;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Query

Allows your application to submit free-form queries similar to the queries one might enter at the Wolfram|Alpha website.
*/
public class Query extends Choreography {

	/**
	Create a new instance of the Query Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Query(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/WolframAlpha/Query"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return QueryInputSet
	*/
	public QueryInputSet newInputSet() {
		return new QueryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public QueryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new QueryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Query
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class QueryInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The App ID provided by Wolfram|Alpha.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the Assumption input for this Choreo. 

		@param String - (optional, string) Up to 10 comma-seperated assumptions to narrow a query.  Wolfram|Alpha provides you with a list of assumptons in the response of a previous query.  Please consult the documentation for more details.
		*/
		public void set_Assumption(String value) {
			this.setInput("Assumption", value);
		}


		/** 
		Set the value of the Async input for this Choreo. 

		@param Boolean - (optional, boolean) Set to true to specify that asynchronous mode should be used. This allows partial results to come back before all the pods are computed.
		*/
		public void set_Async(Boolean value) {
			this.setInput("Async", value);
		}

		/** 
		Set the value of the Async input for this Choreo as a String. 

		@param String - (optional, boolean) Set to true to specify that asynchronous mode should be used. This allows partial results to come back before all the pods are computed.
		*/
		public void set_Async(String value) {
			this.setInput("Async", value);	
		}
		/** 
		Set the value of the ExcludePodID input for this Choreo. 

		@param String - (optional, string) Specifies the IDs of the pod(s) to exlude from the response. All pod IDs are returned by default.
		*/
		public void set_ExcludePodID(String value) {
			this.setInput("ExcludePodID", value);
		}


		/** 
		Set the value of the Format input for this Choreo. 

		@param String - (optional, string) The desired result formats separated by commas. Valid values are image, plaintext, minput, moutput, cell, mathml, imagemap, sound, wav. Defaults to "plaintext,image".
		*/
		public void set_Format(String value) {
			this.setInput("Format", value);
		}


		/** 
		Set the value of the FormatTimeout input for this Choreo. 

		@param BigDecimal - (optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "format" stage for the entire collection of pods. Default value is 8.0.
		*/
		public void set_FormatTimeout(BigDecimal value) {
			this.setInput("FormatTimeout", value);
		}

		/** 
		Set the value of the FormatTimeout input for this Choreo as a String. 

		@param String - (optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "format" stage for the entire collection of pods. Default value is 8.0.
		*/
		public void set_FormatTimeout(String value) {
			this.setInput("FormatTimeout", value);	
		}
		/** 
		Set the value of the IgnoreCase input for this Choreo. 

		@param Boolean - (optional, boolean) Whether to force Wolfram Alpha to ignore case in queries. Defaults to false.
		*/
		public void set_IgnoreCase(Boolean value) {
			this.setInput("IgnoreCase", value);
		}

		/** 
		Set the value of the IgnoreCase input for this Choreo as a String. 

		@param String - (optional, boolean) Whether to force Wolfram Alpha to ignore case in queries. Defaults to false.
		*/
		public void set_IgnoreCase(String value) {
			this.setInput("IgnoreCase", value);	
		}
		/** 
		Set the value of the IncludePodID input for this Choreo. 

		@param String - (optional, string) Specifies the IDs of the pod(s) to include in the response. All pod IDs are returned by default.
		*/
		public void set_IncludePodID(String value) {
			this.setInput("IncludePodID", value);
		}


		/** 
		Set the value of the Input input for this Choreo. 

		@param String - (required, string) Specifies the input string (e.g., "5 largest countries").
		*/
		public void set_Input(String value) {
			this.setInput("Input", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) When query results depend on your location, use this parameter to specify a latitude point.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (optional, decimal) When query results depend on your location, use this parameter to specify a latitude point.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Location input for this Choreo. 

		@param String - (optional, string) When query results depend on your location, use this parameter to specify a location such as "Los Angeles, CA", or "Madrid".
		*/
		public void set_Location(String value) {
			this.setInput("Location", value);
		}


		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) When query results depend on your location, use this parameter to specify a longitude point.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (optional, decimal) When query results depend on your location, use this parameter to specify a longitude point.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Magnification input for this Choreo. 

		@param BigDecimal - (optional, decimal) Controls the magnification of pod images. The default value is 1.0, indicating no magnification.
		*/
		public void set_Magnification(BigDecimal value) {
			this.setInput("Magnification", value);
		}

		/** 
		Set the value of the Magnification input for this Choreo as a String. 

		@param String - (optional, decimal) Controls the magnification of pod images. The default value is 1.0, indicating no magnification.
		*/
		public void set_Magnification(String value) {
			this.setInput("Magnification", value);	
		}
		/** 
		Set the value of the MaxWidth input for this Choreo. 

		@param Integer - (optional, integer) Used to change the default width of pod images. Width and MaxWidth apply to images of text and tables. This can be used to avoid undesirable line breaks if the value of Width is too small.
		*/
		public void set_MaxWidth(Integer value) {
			this.setInput("MaxWidth", value);
		}

		/** 
		Set the value of the MaxWidth input for this Choreo as a String. 

		@param String - (optional, integer) Used to change the default width of pod images. Width and MaxWidth apply to images of text and tables. This can be used to avoid undesirable line breaks if the value of Width is too small.
		*/
		public void set_MaxWidth(String value) {
			this.setInput("MaxWidth", value);	
		}
		/** 
		Set the value of the ParseTimeout input for this Choreo. 

		@param BigDecimal - (optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "parsing" stage of processing. Default value is 5.0.
		*/
		public void set_ParseTimeout(BigDecimal value) {
			this.setInput("ParseTimeout", value);
		}

		/** 
		Set the value of the ParseTimeout input for this Choreo as a String. 

		@param String - (optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "parsing" stage of processing. Default value is 5.0.
		*/
		public void set_ParseTimeout(String value) {
			this.setInput("ParseTimeout", value);	
		}
		/** 
		Set the value of the PlotWidth input for this Choreo. 

		@param Integer - (optional, integer) Controls the width at which plots and graphics are rendered. The default value is 200 pixels.
		*/
		public void set_PlotWidth(Integer value) {
			this.setInput("PlotWidth", value);
		}

		/** 
		Set the value of the PlotWidth input for this Choreo as a String. 

		@param String - (optional, integer) Controls the width at which plots and graphics are rendered. The default value is 200 pixels.
		*/
		public void set_PlotWidth(String value) {
			this.setInput("PlotWidth", value);	
		}
		/** 
		Set the value of the PodIndex input for this Choreo. 

		@param String - (optional, string) Specifies the index of the pod(s) to return. This is an alternative to specifying pods by title or ID. You can give a single number or a sequence like "2,3,5".
		*/
		public void set_PodIndex(String value) {
			this.setInput("PodIndex", value);
		}


		/** 
		Set the value of the PodState input for this Choreo. 

		@param String - (optional, string) Specifies a pod state change, which replaces a pod with a modified version, such as a switch from Imperial to metric units.
		*/
		public void set_PodState(String value) {
			this.setInput("PodState", value);
		}


		/** 
		Set the value of the PodTimeout input for this Choreo. 

		@param BigDecimal - (optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "format" stage for any one pod. Default value is 4.0.
		*/
		public void set_PodTimeout(BigDecimal value) {
			this.setInput("PodTimeout", value);
		}

		/** 
		Set the value of the PodTimeout input for this Choreo as a String. 

		@param String - (optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "format" stage for any one pod. Default value is 4.0.
		*/
		public void set_PodTimeout(String value) {
			this.setInput("PodTimeout", value);	
		}
		/** 
		Set the value of the PodTitle input for this Choreo. 

		@param String - (optional, string) Specifies the titles of the pod(s) to include in the response. All pod titles are returned by default. You can use * as a wildcard to match zero or more characters in pod titles.
		*/
		public void set_PodTitle(String value) {
			this.setInput("PodTitle", value);
		}


		/** 
		Set the value of the Reinterpret input for this Choreo. 

		@param Boolean - (optional, boolean) Whether to allow Wolfram Alpha to reinterpret queries that would otherwise not be understood. Defaults to false.
		*/
		public void set_Reinterpret(Boolean value) {
			this.setInput("Reinterpret", value);
		}

		/** 
		Set the value of the Reinterpret input for this Choreo as a String. 

		@param String - (optional, boolean) Whether to allow Wolfram Alpha to reinterpret queries that would otherwise not be understood. Defaults to false.
		*/
		public void set_Reinterpret(String value) {
			this.setInput("Reinterpret", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format for the response. Valid values are JSON and XML. This will be ignored when providng an XPath query because results are returned as a string or JSON depending on the Mode specified.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ScanTimeout input for this Choreo. 

		@param BigDecimal - (optional, decimal) The number of seconds to allow Wolfram Alpha to compute results in the "scan" stage of processing. Default value is 3.0.
		*/
		public void set_ScanTimeout(BigDecimal value) {
			this.setInput("ScanTimeout", value);
		}

		/** 
		Set the value of the ScanTimeout input for this Choreo as a String. 

		@param String - (optional, decimal) The number of seconds to allow Wolfram Alpha to compute results in the "scan" stage of processing. Default value is 3.0.
		*/
		public void set_ScanTimeout(String value) {
			this.setInput("ScanTimeout", value);	
		}
		/** 
		Set the value of the Scanner input for this Choreo. 

		@param String - (optional, string) Specifies that only pods produced by the given scanner should be returned. (e.g. Numeric, Music).  Defaults to all pods.
		*/
		public void set_Scanner(String value) {
			this.setInput("Scanner", value);
		}


		/** 
		Set the value of the Translation input for this Choreo. 

		@param Boolean - (optional, boolean) Whether to allow Wolfram Alpha to try to translate simple queries into English. Defaults to true.
		*/
		public void set_Translation(Boolean value) {
			this.setInput("Translation", value);
		}

		/** 
		Set the value of the Translation input for this Choreo as a String. 

		@param String - (optional, boolean) Whether to allow Wolfram Alpha to try to translate simple queries into English. Defaults to true.
		*/
		public void set_Translation(String value) {
			this.setInput("Translation", value);	
		}
		/** 
		Set the value of the Units input for this Choreo. 

		@param String - (optional, string) Lets you specify the preferred measurement system, either "metric" or "nonmetric" (U.S. customary units).
		*/
		public void set_Units(String value) {
			this.setInput("Units", value);
		}


		/** 
		Set the value of the Width input for this Choreo. 

		@param Integer - (optional, integer) Used to change the default width of pod images. The default is 500 pixels. Width and MaxWidth apply to images of text and tables.
		*/
		public void set_Width(Integer value) {
			this.setInput("Width", value);
		}

		/** 
		Set the value of the Width input for this Choreo as a String. 

		@param String - (optional, integer) Used to change the default width of pod images. The default is 500 pixels. Width and MaxWidth apply to images of text and tables.
		*/
		public void set_Width(String value) {
			this.setInput("Width", value);	
		}
		/** 
		Set the value of the XPath input for this Choreo. 

		@param String - (optional, string) An XPath query to apply to the API results.
		*/
		public void set_XPath(String value) {
			this.setInput("XPath", value);
		}


		/** 
		Set the value of the XPathMode input for this Choreo. 

		@param String - (optional, string) Valid values are "select" (the default) or "recursive". Recursive mode will iterate using the provided XPath. Select mode will return the first match at the position indicated by the provided XPath.
		*/
		public void set_XPathMode(String value) {
			this.setInput("XPathMode", value);
		}


		/** 
		Set the value of the XPathRegex input for this Choreo. 

		@param String - (optional, string) A regular expression that can be applied to the result of the XPath query provided.
		*/
		public void set_XPathRegex(String value) {
			this.setInput("XPathRegex", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Query Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class QueryResultSet extends ResultSet {
		public QueryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Wolfram Alpha.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
