package com.temboo.Library.Twitter.Tweets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
StatusesShow

Retrieves a single Tweet with a given ID.
*/
public class StatusesShow extends Choreography {

	/**
	Create a new instance of the StatusesShow Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public StatusesShow(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/Tweets/StatusesShow"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return StatusesShowInputSet
	*/
	public StatusesShowInputSet newInputSet() {
		return new StatusesShowInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public StatusesShowResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new StatusesShowResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the StatusesShow
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class StatusesShowInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the ID input for this Choreo. 

		@param String - (required, string) The numerical ID of the desired Tweet.
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);
		}


		/** 
		Set the value of the IncludeEntities input for this Choreo. 

		@param Boolean - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(Boolean value) {
			this.setInput("IncludeEntities", value);
		}

		/** 
		Set the value of the IncludeEntities input for this Choreo as a String. 

		@param String - (optional, boolean) The "entities" node containing extra metadata will not be included when set to false.
		*/
		public void set_IncludeEntities(String value) {
			this.setInput("IncludeEntities", value);	
		}
		/** 
		Set the value of the IncludeMyRetweet input for this Choreo. 

		@param Boolean - (optional, boolean) When set to true, any Tweets returned that have been retweeted by the authenticating user will include an additional current_user_retweet node, containing the ID of the source status for the retweet.
		*/
		public void set_IncludeMyRetweet(Boolean value) {
			this.setInput("IncludeMyRetweet", value);
		}

		/** 
		Set the value of the IncludeMyRetweet input for this Choreo as a String. 

		@param String - (optional, boolean) When set to true, any Tweets returned that have been retweeted by the authenticating user will include an additional current_user_retweet node, containing the ID of the source status for the retweet.
		*/
		public void set_IncludeMyRetweet(String value) {
			this.setInput("IncludeMyRetweet", value);	
		}
		/** 
		Set the value of the TrimUser input for this Choreo. 

		@param Boolean - (optional, boolean) When set to true, each tweet returned in a timeline will include a user object including only the status authors numerical ID. Defaults to false.
		*/
		public void set_TrimUser(Boolean value) {
			this.setInput("TrimUser", value);
		}

		/** 
		Set the value of the TrimUser input for this Choreo as a String. 

		@param String - (optional, boolean) When set to true, each tweet returned in a timeline will include a user object including only the status authors numerical ID. Defaults to false.
		*/
		public void set_TrimUser(String value) {
			this.setInput("TrimUser", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the StatusesShow Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class StatusesShowResultSet extends ResultSet {
		public StatusesShowResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The rate limit ceiling for this particular request.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The number of requests left for the 15 minute window.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Reset" output from this Choreo execution

		@return String - (date) The remaining window before the rate limit resets in UTC epoch seconds.
		*/
		public String get_Reset() {
			return this.getResultString("Reset");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
