package com.temboo.Library.Twilio.IncomingPhoneNumbers;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdatePhoneNumber

Updates an existing Twilio phone number.
*/
public class UpdatePhoneNumber extends Choreography {

	/**
	Create a new instance of the UpdatePhoneNumber Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdatePhoneNumber(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twilio/IncomingPhoneNumbers/UpdatePhoneNumber"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdatePhoneNumberInputSet
	*/
	public UpdatePhoneNumberInputSet newInputSet() {
		return new UpdatePhoneNumberInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdatePhoneNumberResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdatePhoneNumberResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdatePhoneNumber
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdatePhoneNumberInputSet extends InputSet {
		/** 
		Set the value of the APIVersion input for this Choreo. 

		@param String - (optional, string) Calls to this phone number will start a new TwiML session with this API version. Either 2010-04-01 or 2008-08-01.
		*/
		public void set_APIVersion(String value) {
			this.setInput("APIVersion", value);
		}


		/** 
		Set the value of the AccountSID input for this Choreo. 

		@param String - (required, string) The AccountSID provided when you signed up for a Twilio account.
		*/
		public void set_AccountSID(String value) {
			this.setInput("AccountSID", value);
		}


		/** 
		Set the value of the AuthToken input for this Choreo. 

		@param String - (required, string) The authorization token provided when you signed up for a Twilio account.
		*/
		public void set_AuthToken(String value) {
			this.setInput("AuthToken", value);
		}


		/** 
		Set the value of the FriendlyName input for this Choreo. 

		@param String - (optional, string) A human readable description of the new incoming phone number resource, with maximum length 64 characters.
		*/
		public void set_FriendlyName(String value) {
			this.setInput("FriendlyName", value);
		}


		/** 
		Set the value of the IncomingPhoneNumberSID input for this Choreo. 

		@param String - (required, string) The id of the incoming phone number to update.
		*/
		public void set_IncomingPhoneNumberSID(String value) {
			this.setInput("IncomingPhoneNumberSID", value);
		}


		/** 
		Set the value of the NewAccountSID input for this Choreo. 

		@param String - (optional, string) The unique 34 character id of the account to which you wish to transfer this phone number.
		*/
		public void set_NewAccountSID(String value) {
			this.setInput("NewAccountSID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SmsApplicationSID input for this Choreo. 

		@param String - (optional, string) The 34 character sid of the application Twilio should use to handle SMSs sent to this number.
		*/
		public void set_SmsApplicationSID(String value) {
			this.setInput("SmsApplicationSID", value);
		}


		/** 
		Set the value of the SmsFallbackMethod input for this Choreo. 

		@param String - (optional, string) The HTTP method that should be used to request the SmsFallbackUrl. Either GET or POST.
		*/
		public void set_SmsFallbackMethod(String value) {
			this.setInput("SmsFallbackMethod", value);
		}


		/** 
		Set the value of the SmsFallbackURL input for this Choreo. 

		@param String - (optional, string) A URL that Twilio will request if an error occurs requesting or executing the TwiML defined by SmsUrl.
		*/
		public void set_SmsFallbackURL(String value) {
			this.setInput("SmsFallbackURL", value);
		}


		/** 
		Set the value of the SmsMethod input for this Choreo. 

		@param String - (optional, string) The HTTP method that should be used to request the SmsUrl. Either GET or POST.
		*/
		public void set_SmsMethod(String value) {
			this.setInput("SmsMethod", value);
		}


		/** 
		Set the value of the SmsURL input for this Choreo. 

		@param String - (optional, string) The URL that Twilio should request when somebody sends an SMS to the new phone number.
		*/
		public void set_SmsURL(String value) {
			this.setInput("SmsURL", value);
		}


		/** 
		Set the value of the StatusCallback input for this Choreo. 

		@param String - (optional, string) The URL that Twilio will request to pass status parameters (such as call ended) to your application.
		*/
		public void set_StatusCallback(String value) {
			this.setInput("StatusCallback", value);
		}


		/** 
		Set the value of the StatusCallbackMethod input for this Choreo. 

		@param String - (optional, string) The HTTP method Twilio will use to make requests to the StatusCallback URL. Either GET or POST.
		*/
		public void set_StatusCallbackMethod(String value) {
			this.setInput("StatusCallbackMethod", value);
		}


		/** 
		Set the value of the SubAccountSID input for this Choreo. 

		@param String - (optional, string) The SID of the subaccount associated with the phone number. If not specified, the main AccountSID used to authenticate is used in the request.
		*/
		public void set_SubAccountSID(String value) {
			this.setInput("SubAccountSID", value);
		}


		/** 
		Set the value of the VoiceApplicationSID input for this Choreo. 

		@param String - (optional, string) The 34 character sid of the application Twilio should use to handle phone calls to this number.
		*/
		public void set_VoiceApplicationSID(String value) {
			this.setInput("VoiceApplicationSID", value);
		}


		/** 
		Set the value of the VoiceCallerIDLookup input for this Choreo. 

		@param String - (optional, string) Do a lookup of a caller's name from the CNAM database and post it to your app. Either true or false.
		*/
		public void set_VoiceCallerIDLookup(String value) {
			this.setInput("VoiceCallerIDLookup", value);
		}


		/** 
		Set the value of the VoiceFallbackMethod input for this Choreo. 

		@param String - (optional, string) The HTTP method that should be used to request the VoiceFallbackURL. Either GET or POST.
		*/
		public void set_VoiceFallbackMethod(String value) {
			this.setInput("VoiceFallbackMethod", value);
		}


		/** 
		Set the value of the VoiceFallbackURL input for this Choreo. 

		@param String - (optional, string) A URL that Twilio will request if an error occurs requesting or executing the TwiML defined by VoiceURL.
		*/
		public void set_VoiceFallbackURL(String value) {
			this.setInput("VoiceFallbackURL", value);
		}


		/** 
		Set the value of the VoiceMethod input for this Choreo. 

		@param String - (optional, string) The HTTP method that should be used to request the VoiceURL. Either GET or POST.
		*/
		public void set_VoiceMethod(String value) {
			this.setInput("VoiceMethod", value);
		}


		/** 
		Set the value of the VoiceURL input for this Choreo. 

		@param String - (optional, string) The URL that Twilio should request when somebody dials the phone number.
		*/
		public void set_VoiceURL(String value) {
			this.setInput("VoiceURL", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdatePhoneNumber Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdatePhoneNumberResultSet extends ResultSet {
		public UpdatePhoneNumberResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Twilio.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
