package com.temboo.Library.SendGrid.NewsletterAPI.Schedule;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ScheduleNewsletterDelivery

Schedule a delivery time for an existing Newsletter.
*/
public class ScheduleNewsletterDelivery extends Choreography {

	/**
	Create a new instance of the ScheduleNewsletterDelivery Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ScheduleNewsletterDelivery(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/SendGrid/NewsletterAPI/Schedule/ScheduleNewsletterDelivery"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ScheduleNewsletterDeliveryInputSet
	*/
	public ScheduleNewsletterDeliveryInputSet newInputSet() {
		return new ScheduleNewsletterDeliveryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ScheduleNewsletterDeliveryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ScheduleNewsletterDeliveryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ScheduleNewsletterDelivery
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ScheduleNewsletterDeliveryInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from SendGrid.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APIUser input for this Choreo. 

		@param String - (required, string) The username registered with SendGrid.
		*/
		public void set_APIUser(String value) {
			this.setInput("APIUser", value);
		}


		/** 
		Set the value of the After input for this Choreo. 

		@param Integer - (optional, integer) The number of minites after which the newsletter will be delivered.
		*/
		public void set_After(Integer value) {
			this.setInput("After", value);
		}

		/** 
		Set the value of the After input for this Choreo as a String. 

		@param String - (optional, integer) The number of minites after which the newsletter will be delivered.
		*/
		public void set_After(String value) {
			this.setInput("After", value);	
		}
		/** 
		Set the value of the At input for this Choreo. 

		@param String - (optional, string) The date and time when the newsletter is to be delievered, in ISO 8601 format (YYYY-MM-DD HH:MM:SS+-HH:MM)
		*/
		public void set_At(String value) {
			this.setInput("At", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) The name of the newsletter that is being scheduled for delivery.  If the newsletter is to be sent immediately, then leave the At, and After parameters empty.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format of the response from SendGrid, in either json, or xml.  Default is set to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ScheduleNewsletterDelivery Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ScheduleNewsletterDeliveryResultSet extends ResultSet {
		public ScheduleNewsletterDeliveryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from SendGrid. The format corresponds to the ResponseFormat input. Default is json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
