package com.temboo.Library.RunKeeper.GeneralMeasurements;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateEntry

Adds a body measurement entry to a user's feed.
*/
public class CreateEntry extends Choreography {

	/**
	Create a new instance of the CreateEntry Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateEntry(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/RunKeeper/GeneralMeasurements/CreateEntry"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateEntryInputSet
	*/
	public CreateEntryInputSet newInputSet() {
		return new CreateEntryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateEntryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateEntryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateEntry
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateEntryInputSet extends InputSet {
		/** 
		Set the value of the Entry input for this Choreo. 

		@param String - (required, json) A JSON string containing the key/value pairs for the body measurement entry to create. See documentation for formatting examples.
		*/
		public void set_Entry(String value) {
			this.setInput("Entry", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved after the final step in the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateEntry Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateEntryResultSet extends ResultSet {
		public CreateEntryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "URI" output from this Choreo execution

		@return String - (string) The entry uri that was created.
		*/
		public String get_URI() {
			return this.getResultString("URI");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (boolean) Contains the string 'true" when a new entry is created successfully.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
