package com.temboo.Library.NYTimes.MostPopular;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetMostEmailed

Retrieves information for the blog posts and articles that are most frequently emailed.
*/
public class GetMostEmailed extends Choreography {

	/**
	Create a new instance of the GetMostEmailed Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetMostEmailed(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/MostPopular/GetMostEmailed"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetMostEmailedInputSet
	*/
	public GetMostEmailedInputSet newInputSet() {
		return new GetMostEmailedInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetMostEmailedResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetMostEmailedResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetMostEmailed
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetMostEmailedInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param String - (optional, string) The first 20 results are shown by default. To page through the results, set Offset to the appropriate value.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Section input for this Choreo. 

		@param String - (required, string) Limits the results by one or more sections (i.e. arts).  To get all sections, specify all-sections.
		*/
		public void set_Section(String value) {
			this.setInput("Section", value);
		}


		/** 
		Set the value of the TimePeriod input for this Choreo. 

		@param Integer - (required, integer) Allowed integer values: 1, 7, or 30, which corresponds to a day (1) , a week (7), or a month (30) of content.
		*/
		public void set_TimePeriod(Integer value) {
			this.setInput("TimePeriod", value);
		}

		/** 
		Set the value of the TimePeriod input for this Choreo as a String. 

		@param String - (required, integer) Allowed integer values: 1, 7, or 30, which corresponds to a day (1) , a week (7), or a month (30) of content.
		*/
		public void set_TimePeriod(String value) {
			this.setInput("TimePeriod", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetMostEmailed Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetMostEmailedResultSet extends ResultSet {
		public GetMostEmailedResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
