package com.temboo.Library.Highrise;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListAllPeople

Retrieves contacts from your Highrise CRM.
*/
public class ListAllPeople extends Choreography {

	/**
	Create a new instance of the ListAllPeople Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListAllPeople(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Highrise/ListAllPeople"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListAllPeopleInputSet
	*/
	public ListAllPeopleInputSet newInputSet() {
		return new ListAllPeopleInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListAllPeopleResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListAllPeopleResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListAllPeople
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListAllPeopleInputSet extends InputSet {
		/** 
		Set the value of the AccountName input for this Choreo. 

		@param String - (required, string) A valid Highrise account name. This is the first part of the account's URL.
		*/
		public void set_AccountName(String value) {
			this.setInput("AccountName", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The Highrise account password. Use the value 'X' when specifying an API Key for the Username input.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) A Highrise account username or API Key.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListAllPeople Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListAllPeopleResultSet extends ResultSet {
		public ListAllPeopleResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Highrise.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
