package com.temboo.Library.Google.Spreadsheets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DownloadBase64EncodedSpreadsheet

Downloads a document with the title you specify, and returns the content as Base64 encoded data.
*/
public class DownloadBase64EncodedSpreadsheet extends Choreography {

	/**
	Create a new instance of the DownloadBase64EncodedSpreadsheet Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DownloadBase64EncodedSpreadsheet(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Spreadsheets/DownloadBase64EncodedSpreadsheet"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DownloadBase64EncodedSpreadsheetInputSet
	*/
	public DownloadBase64EncodedSpreadsheetInputSet newInputSet() {
		return new DownloadBase64EncodedSpreadsheetInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DownloadBase64EncodedSpreadsheetResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DownloadBase64EncodedSpreadsheetResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DownloadBase64EncodedSpreadsheet
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DownloadBase64EncodedSpreadsheetInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Format input for this Choreo. 

		@param String - (conditional, string) The format you want to export the spreadsheet to, such as "csv" or "pdf".
		*/
		public void set_Format(String value) {
			this.setInput("Format", value);
		}


		/** 
		Set the value of the Link input for this Choreo. 

		@param String - (optional, string) A file's exportLink. Required unless specifying the Title. See Choreo notes for more details about where this property can be found.
		*/
		public void set_Link(String value) {
			this.setInput("Link", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (optional, password) Deprecated (retained for backward compatibility only).
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (conditional, string) The title of the document to download. Required if the source Link is not specifed.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DownloadBase64EncodedSpreadsheet Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DownloadBase64EncodedSpreadsheetResultSet extends ResultSet {
		public DownloadBase64EncodedSpreadsheetResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "FileContents" output from this Choreo execution

		@return String - (string) The Base64 encoded file content of the downloaded file.
		*/
		public String get_FileContents() {
			return this.getResultString("FileContents");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
	}
	
}
