package com.temboo.Library.Google.Contacts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateContact

Update an existing contact's information.
*/
public class UpdateContact extends Choreography {

	/**
	Create a new instance of the UpdateContact Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateContact(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Contacts/UpdateContact"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateContactInputSet
	*/
	public UpdateContactInputSet newInputSet() {
		return new UpdateContactInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateContactResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateContactResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateContact
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateContactInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The OAuth client ID provided by Google when you register your application.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The OAuth client secret provided by Google when you registered your application.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the ID input for this Choreo. 

		@param String - (conditional, string) The id of the contact to update. Required unless providing a value for the Query input.
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);
		}


		/** 
		Set the value of the NewEmail input for this Choreo. 

		@param String - (conditional, string) The contact's new email address.
		*/
		public void set_NewEmail(String value) {
			this.setInput("NewEmail", value);
		}


		/** 
		Set the value of the NewFirstName input for this Choreo. 

		@param String - (conditional, string) The contact's new first name.
		*/
		public void set_NewFirstName(String value) {
			this.setInput("NewFirstName", value);
		}


		/** 
		Set the value of the NewLastName input for this Choreo. 

		@param String - (conditional, string) The contact's new last name.
		*/
		public void set_NewLastName(String value) {
			this.setInput("NewLastName", value);
		}


		/** 
		Set the value of the NewPhone input for this Choreo. 

		@param String - (optional, string) The contact's new telephone number.
		*/
		public void set_NewPhone(String value) {
			this.setInput("NewPhone", value);
		}


		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (conditional, string) A search term to retrieve the contact to update, such as an email address, last name, or address. Required unless providing a value for the ID input.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) The refresh token retrieved in the last step of the OAuth process. This is used when an access token is expired or not provided.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateContact Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateContactResultSet extends ResultSet {
		public UpdateContactResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AccessToken" output from this Choreo execution

		@return String - (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
		*/
		public String get_AccessToken() {
			return this.getResultString("AccessToken");
		}
		/** 
		Retrieve the value for the "ContactID" output from this Choreo execution

		@return String - (string) The unique ID for the contact returned by Google.
		*/
		public String get_ContactID() {
			return this.getResultString("ContactID");
		}
		/** 
		Retrieve the value for the "Email" output from this Choreo execution

		@return String - (string) The contact's current email address.
		*/
		public String get_Email() {
			return this.getResultString("Email");
		}
		/** 
		Retrieve the value for the "FirstName" output from this Choreo execution

		@return String - (string) The contact's current given name.
		*/
		public String get_FirstName() {
			return this.getResultString("FirstName");
		}
		/** 
		Retrieve the value for the "LastName" output from this Choreo execution

		@return String - (string) The contact's current family name.
		*/
		public String get_LastName() {
			return this.getResultString("LastName");
		}
		/** 
		Retrieve the value for the "Phone" output from this Choreo execution

		@return String - (string) The contact's current telephone number.
		*/
		public String get_Phone() {
			return this.getResultString("Phone");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
