package com.temboo.Library.Google.Contacts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetContactsWithQuery

Retrieves the contact or contacts in that account that match a specified query term.
*/
public class GetContactsWithQuery extends Choreography {

	/**
	Create a new instance of the GetContactsWithQuery Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetContactsWithQuery(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Contacts/GetContactsWithQuery"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetContactsWithQueryInputSet
	*/
	public GetContactsWithQueryInputSet newInputSet() {
		return new GetContactsWithQueryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetContactsWithQueryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetContactsWithQueryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetContactsWithQuery
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetContactsWithQueryInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (required, string) The OAuth client ID provided by Google when you register your application.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (required, string) The OAuth client secret provided by Google when you registered your application.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Group input for this Choreo. 

		@param String - (optional, string) Constrains the results to only the contacts belonging to the group specified. The value of this parameter specifies group ID.
		*/
		public void set_Group(String value) {
			this.setInput("Group", value);
		}


		/** 
		Set the value of the MaxResults input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of entries to return.
		*/
		public void set_MaxResults(Integer value) {
			this.setInput("MaxResults", value);
		}

		/** 
		Set the value of the MaxResults input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of entries to return.
		*/
		public void set_MaxResults(String value) {
			this.setInput("MaxResults", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (required, string) The contact criteria to search for, such as name or email address.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (required, string) The refresh token retrieved in the last step of the OAuth process. This is used when an access token is expired or not provided.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) Sorting order direction. Can be either ascending or descending.
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the StartIndex input for this Choreo. 

		@param Integer - (optional, integer) The index of the first result to be retrieved (for paging).
		*/
		public void set_StartIndex(Integer value) {
			this.setInput("StartIndex", value);
		}

		/** 
		Set the value of the StartIndex input for this Choreo as a String. 

		@param String - (optional, integer) The index of the first result to be retrieved (for paging).
		*/
		public void set_StartIndex(String value) {
			this.setInput("StartIndex", value);	
		}
		/** 
		Set the value of the UpdatedMin input for this Choreo. 

		@param String - (optional, date) The lower bound on entry update dates to filter by (e.g., 2015-01-16T00:00:00).
		*/
		public void set_UpdatedMin(String value) {
			this.setInput("UpdatedMin", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetContactsWithQuery Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetContactsWithQueryResultSet extends ResultSet {
		public GetContactsWithQueryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AccessToken" output from this Choreo execution

		@return String - (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
		*/
		public String get_AccessToken() {
			return this.getResultString("AccessToken");
		}
		/** 
		Retrieve the value for the "ContactID" output from this Choreo execution

		@return String - (string) The unique ID string for the retrieved contact. If more than one contact is retrieved by the request, only the first contact's ID is output.
		*/
		public String get_ContactID() {
			return this.getResultString("ContactID");
		}
		/** 
		Retrieve the value for the "Link" output from this Choreo execution

		@return String - (string) The unique edit link for the retrieved contact. If more than one contact is retrieved by the request, only the first contact's edit link is output.
		*/
		public String get_Link() {
			return this.getResultString("Link");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
