package com.temboo.Library.Foursquare.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CheckinsByUser

Retrieve a list of check-ins for an authenticated user.
*/
public class CheckinsByUser extends Choreography {

	/**
	Create a new instance of the CheckinsByUser Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CheckinsByUser(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Users/CheckinsByUser"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CheckinsByUserInputSet
	*/
	public CheckinsByUserInputSet newInputSet() {
		return new CheckinsByUserInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CheckinsByUserResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CheckinsByUserResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CheckinsByUser
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CheckinsByUserInputSet extends InputSet {
		/** 
		Set the value of the AfterTimeStamp input for this Choreo. 

		@param String - (optional, date) Retrieve the first results after the seconds entered since epoch time.
		*/
		public void set_AfterTimeStamp(String value) {
			this.setInput("AfterTimeStamp", value);
		}


		/** 
		Set the value of the BeforeTimeStamp input for this Choreo. 

		@param String - (optional, date) Retrieve the first results prior to the seconds specified. Useful for paging backward in time.
		*/
		public void set_BeforeTimeStamp(String value) {
			this.setInput("BeforeTimeStamp", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The total number of results to be returned, up to 250.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The total number of results to be returned, up to 250.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (required, string) The Foursquare API Oauth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) The number of results to skip. Used to page through results.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to skip. Used to page through results.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) Only 'self' is supported at this moment by the Foursquare API. Defaults to: self.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CheckinsByUser Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CheckinsByUserResultSet extends ResultSet {
		public CheckinsByUserResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
