package com.temboo.Library.Foursquare.Checkins;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddComment

Adds a comment to a specified check-in.
*/
public class AddComment extends Choreography {

	/**
	Create a new instance of the AddComment Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddComment(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Checkins/AddComment"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddCommentInputSet
	*/
	public AddCommentInputSet newInputSet() {
		return new AddCommentInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddCommentResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddCommentResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddComment
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddCommentInputSet extends InputSet {
		/** 
		Set the value of the CheckinID input for this Choreo. 

		@param String - (required, string) The ID of the check-in that you want to create a comment for.
		*/
		public void set_CheckinID(String value) {
			this.setInput("CheckinID", value);
		}


		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (required, string) The Foursquare API OAuth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (required, string) The text of the comment, up to 200 characters.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddComment Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddCommentResultSet extends ResultSet {
		public AddCommentResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
