package com.temboo.Library.FilesAnywhere;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddItemComment

Add a comment to an item.
*/
public class AddItemComment extends Choreography {

	/**
	Create a new instance of the AddItemComment Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddItemComment(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/FilesAnywhere/AddItemComment"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddItemCommentInputSet
	*/
	public AddItemCommentInputSet newInputSet() {
		return new AddItemCommentInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddItemCommentResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddItemCommentResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddItemComment
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddItemCommentInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (conditional, string) The API Key provided by FilesAnywhere. Required unless supplying a valid Token input.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Comment input for this Choreo. 

		@param String - (required, string) Enter item comment.
		*/
		public void set_Comment(String value) {
			this.setInput("Comment", value);
		}


		/** 
		Set the value of the FullName input for this Choreo. 

		@param String - (required, string) Provide the full name of the user entering the comment.
		*/
		public void set_FullName(String value) {
			this.setInput("FullName", value);
		}


		/** 
		Set the value of the OrgID input for this Choreo. 

		@param Integer - (conditional, integer) Defaults to 0 for a FilesAnywhere Web account.  Use 50 for a FilesAnywhere WebAdvanced account.
		*/
		public void set_OrgID(Integer value) {
			this.setInput("OrgID", value);
		}

		/** 
		Set the value of the OrgID input for this Choreo as a String. 

		@param String - (conditional, integer) Defaults to 0 for a FilesAnywhere Web account.  Use 50 for a FilesAnywhere WebAdvanced account.
		*/
		public void set_OrgID(String value) {
			this.setInput("OrgID", value);	
		}
		/** 
		Set the value of the ParentID input for this Choreo. 

		@param Integer - (required, integer) Specify the ID of the parent comment.
		*/
		public void set_ParentID(Integer value) {
			this.setInput("ParentID", value);
		}

		/** 
		Set the value of the ParentID input for this Choreo as a String. 

		@param String - (required, integer) Specify the ID of the parent comment.
		*/
		public void set_ParentID(String value) {
			this.setInput("ParentID", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (conditional, password) Your FilesAnywhere password. Required unless supplying a valid Token input.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) Enter the path to the item in the following format: \USERNAME\file.txt
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the Token input for this Choreo. 

		@param String - (conditional, string) If provided, the Choreo will use the token to authenticate. If the token is expired or not provided, the Choreo will relogin and retrieve a new token when APIKey, Username, and Password are supplied.
		*/
		public void set_Token(String value) {
			this.setInput("Token", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (conditional, string) Your FilesAnywhere username. Required unless supplying a valid Token input.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddItemComment Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddItemCommentResultSet extends ResultSet {
		public AddItemCommentResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Token" output from this Choreo execution

		@return String - (conditional, string) If provided, the Choreo will use the token to authenticate. If the token is expired or not provided, the Choreo will relogin and retrieve a new token when APIKey, Username, and Password are supplied.
		*/
		public String get_Token() {
			return this.getResultString("Token");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from FilesAnywhere.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
