package com.temboo.Library.FilesAnywhere;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AccountLogin

Retrieves an authentication token from FilesAnywhere.
*/
public class AccountLogin extends Choreography {

	/**
	Create a new instance of the AccountLogin Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AccountLogin(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/FilesAnywhere/AccountLogin"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AccountLoginInputSet
	*/
	public AccountLoginInputSet newInputSet() {
		return new AccountLoginInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AccountLoginResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AccountLoginResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AccountLogin
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AccountLoginInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by FilesAnywhere.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the AllowedIPList input for this Choreo. 

		@param String - (optional, string) List of allowed IP addresses.  Multiple IP addresses can be separated by commas.
		*/
		public void set_AllowedIPList(String value) {
			this.setInput("AllowedIPList", value);
		}


		/** 
		Set the value of the ClientEncryptParam input for this Choreo. 

		@param String - (optional, string) Used to return an encrypted password to use for subsequent logins.
		*/
		public void set_ClientEncryptParam(String value) {
			this.setInput("ClientEncryptParam", value);
		}


		/** 
		Set the value of the OrgID input for this Choreo. 

		@param Integer - (conditional, integer) Defaults to 0 for a FilesAnywhere Web account.  Use 50 for a FilesAnywhere WebAdvanced account.
		*/
		public void set_OrgID(Integer value) {
			this.setInput("OrgID", value);
		}

		/** 
		Set the value of the OrgID input for this Choreo as a String. 

		@param String - (conditional, integer) Defaults to 0 for a FilesAnywhere Web account.  Use 50 for a FilesAnywhere WebAdvanced account.
		*/
		public void set_OrgID(String value) {
			this.setInput("OrgID", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your FilesAnywhere password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) Your FilesAnywhere username.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AccountLogin Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AccountLoginResultSet extends ResultSet {
		public AccountLoginResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Token" output from this Choreo execution

		@return String - (string) The token value parsed from the FilesAnywhere response.
		*/
		public String get_Token() {
			return this.getResultString("Token");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from FilesAnywhere.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
