package com.temboo.Library.Facebook.Reading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Paginate

Retrieves the next or previous page of results.
*/
public class Paginate extends Choreography {

	/**
	Create a new instance of the Paginate Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Paginate(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Reading/Paginate"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PaginateInputSet
	*/
	public PaginateInputSet newInputSet() {
		return new PaginateInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PaginateResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PaginateResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Paginate
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PaginateInputSet extends InputSet {
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (required, string) A "next" or "previous" URL associated with another page of results to retrieve.
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Paginate Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PaginateResultSet extends ResultSet {
		public PaginateResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Next" output from this Choreo execution

		@return String - (string) The URL to use to retrieve the next page of the results.
		*/
		public String get_Next() {
			return this.getResultString("Next");
		}
		/** 
		Retrieve the value for the "Previous" output from this Choreo execution

		@return String - (string) The URL to use to retrieve the previous page of results.
		*/
		public String get_Previous() {
			return this.getResultString("Previous");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
