package com.temboo.Library.Dropbox.FilesAndMetadata;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetThumbnail

Retrieves a thumbnail for a specified image.
*/
public class GetThumbnail extends Choreography {

	/**
	Create a new instance of the GetThumbnail Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetThumbnail(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/FilesAndMetadata/GetThumbnail"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetThumbnailInputSet
	*/
	public GetThumbnailInputSet newInputSet() {
		return new GetThumbnailInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetThumbnailResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetThumbnailResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetThumbnail
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetThumbnailInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


		/** 
		Set the value of the ImageFormat input for this Choreo. 

		@param String - (optional, string) The thumbnail format to return for the specified image. Accepted values are: jpeg (default) or png.
		*/
		public void set_ImageFormat(String value) {
			this.setInput("ImageFormat", value);
		}


		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) The path to the file that you want to generate a thumbnail for (i.e. /RootFolder/SubFolder/MyFile.txt).
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the Root input for this Choreo. 

		@param String - (optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).
		*/
		public void set_Root(String value) {
			this.setInput("Root", value);
		}


		/** 
		Set the value of the Size input for this Choreo. 

		@param String - (optional, string) The size of the thumbnail to generate. Accepted values are: small, medium, s, m, l, xl. See Choreo documentation for exact dimensions. Defaults to "small".
		*/
		public void set_Size(String value) {
			this.setInput("Size", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetThumbnail Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetThumbnailResultSet extends ResultSet {
		public GetThumbnailResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) The base64 encoded image content of the thumbnail.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
