package com.temboo.Library.Dropbox.FilesAndMetadata;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Delta

Allows you keep up with changes to files and folders in a user's Dropbox.
*/
public class Delta extends Choreography {

	/**
	Create a new instance of the Delta Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Delta(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/FilesAndMetadata/Delta"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeltaInputSet
	*/
	public DeltaInputSet newInputSet() {
		return new DeltaInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeltaResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeltaResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Delta
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeltaInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


		/** 
		Set the value of the Cursor input for this Choreo. 

		@param String - (optional, string) A string that is used to keep track of your current state. On the next call pass in this value to return delta entries that have been recorded since the cursor was returned.
		*/
		public void set_Cursor(String value) {
			this.setInput("Cursor", value);
		}


		/** 
		Set the value of the IncludeMediaInfo input for this Choreo. 

		@param Boolean - (optional, boolean) If set to true, each file will include a photo_info dictionary for photos and a video_info dictionary for videos with additional media info.
		*/
		public void set_IncludeMediaInfo(Boolean value) {
			this.setInput("IncludeMediaInfo", value);
		}

		/** 
		Set the value of the IncludeMediaInfo input for this Choreo as a String. 

		@param String - (optional, boolean) If set to true, each file will include a photo_info dictionary for photos and a video_info dictionary for videos with additional media info.
		*/
		public void set_IncludeMediaInfo(String value) {
			this.setInput("IncludeMediaInfo", value);	
		}
		/** 
		Set the value of the Locale input for this Choreo. 

		@param String - (optional, string) The metadata returned will have its size field translated based on the given locale.
		*/
		public void set_Locale(String value) {
			this.setInput("Locale", value);
		}


		/** 
		Set the value of the PathPrefix input for this Choreo. 

		@param String - (optional, string) Filters the response to only include entries at or under the specified path.
		*/
		public void set_PathPrefix(String value) {
			this.setInput("PathPrefix", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Delta Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeltaResultSet extends ResultSet {
		public DeltaResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
