package com.temboo.Library.Disqus.Posts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateAuthenticatedPost

Create a new post for the authenticated user.
*/
public class CreateAuthenticatedPost extends Choreography {

	/**
	Create a new instance of the CreateAuthenticatedPost Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateAuthenticatedPost(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Disqus/Posts/CreateAuthenticatedPost"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateAuthenticatedPostInputSet
	*/
	public CreateAuthenticatedPostInputSet newInputSet() {
		return new CreateAuthenticatedPostInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateAuthenticatedPostResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateAuthenticatedPostResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateAuthenticatedPost
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateAuthenticatedPostInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) A valid OAuth 2.0 access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Date input for this Choreo. 

		@param String - (optional, string) The date of the post, either in Unix timestamp format, or ISO datetime standard. You must be a moderator to do this.
		*/
		public void set_Date(String value) {
			this.setInput("Date", value);
		}


		/** 
		Set the value of the IPAddress input for this Choreo. 

		@param String - (optional, string) The author's IP address. You must be a moderator to do this.
		*/
		public void set_IPAddress(String value) {
			this.setInput("IPAddress", value);
		}


		/** 
		Set the value of the ParentPost input for this Choreo. 

		@param String - (conditional, string) The ID of a parent post to which the new post will be responding to. Either ParentPost, or Thread must be set, or both.
		*/
		public void set_ParentPost(String value) {
			this.setInput("ParentPost", value);
		}


		/** 
		Set the value of the PostContent input for this Choreo. 

		@param String - (required, string) The text of this post.
		*/
		public void set_PostContent(String value) {
			this.setInput("PostContent", value);
		}


		/** 
		Set the value of the PostState input for this Choreo. 

		@param String - (optional, string) Specify the state of the post (comment). Available options include: unapproved, approved, spam, killed. You must be a moderator to do this. If set, pre-approval validation will be skipped.
		*/
		public void set_PostState(String value) {
			this.setInput("PostState", value);
		}


		/** 
		Set the value of the PublicKey input for this Choreo. 

		@param String - (required, string) The Public Key provided by Disqus (AKA the API Key).
		*/
		public void set_PublicKey(String value) {
			this.setInput("PublicKey", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and jsonp.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Thread input for this Choreo. 

		@param String - (conditional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_Thread(String value) {
			this.setInput("Thread", value);
		}


		/** 
		Set the value of the ThreadID input for this Choreo. 

		@param String - (conditional, string) The thread ID to attach the new post to. Either ParentPost, or Thread must be set, or both.
		*/
		public void set_ThreadID(String value) {
			this.setInput("ThreadID", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateAuthenticatedPost Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateAuthenticatedPostResultSet extends ResultSet {
		public CreateAuthenticatedPostResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Disqus.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
