package com.temboo.Library.Amazon.Marketplace.Feeds;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddOrUpdateInventoryItems

Adds or updates one or more inventory listings in your Seller Central account with a given flat flile.
*/
public class AddOrUpdateInventoryItems extends Choreography {

	/**
	Create a new instance of the AddOrUpdateInventoryItems Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddOrUpdateInventoryItems(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/Marketplace/Feeds/AddOrUpdateInventoryItems"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddOrUpdateInventoryItemsInputSet
	*/
	public AddOrUpdateInventoryItemsInputSet newInputSet() {
		return new AddOrUpdateInventoryItemsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddOrUpdateInventoryItemsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddOrUpdateInventoryItemsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddOrUpdateInventoryItems
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddOrUpdateInventoryItemsInputSet extends InputSet {
		/** 
		Set the value of the FeedData input for this Choreo. 

		@param String - (conditional, multiline) The feed data to sumbit to Amazon Marketplace.
		*/
		public void set_FeedData(String value) {
			this.setInput("FeedData", value);
		}


		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSMarketplaceId input for this Choreo. 

		@param String - (required, string) The Marketplace ID provided by Amazon Web Services.
		*/
		public void set_AWSMarketplaceId(String value) {
			this.setInput("AWSMarketplaceId", value);
		}


		/** 
		Set the value of the AWSMerchantId input for this Choreo. 

		@param String - (required, string) The Merchant ID provided by Amazon Web Services.
		*/
		public void set_AWSMerchantId(String value) {
			this.setInput("AWSMerchantId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the MWSAuthToken input for this Choreo. 

		@param String - (optional, string) The Amazon MWS authorization token for the given seller and developer.
		*/
		public void set_MWSAuthToken(String value) {
			this.setInput("MWSAuthToken", value);
		}


		/** 
		Set the value of the TimeToWait input for this Choreo. 

		@param Integer - (optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
		*/
		public void set_TimeToWait(Integer value) {
			this.setInput("TimeToWait", value);
		}

		/** 
		Set the value of the TimeToWait input for this Choreo as a String. 

		@param String - (optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
		*/
		public void set_TimeToWait(String value) {
			this.setInput("TimeToWait", value);	
		}
		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - The path to the vault file you want to submit. Required unless you using the FeedData input.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddOrUpdateInventoryItems Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddOrUpdateInventoryItemsResultSet extends ResultSet {
		public AddOrUpdateInventoryItemsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ProcessingStatus" output from this Choreo execution

		@return String - (string) The processing status of the feed submission which is parsed from the Amazon response.
		*/
		public String get_ProcessingStatus() {
			return this.getResultString("ProcessingStatus");
		}
		/** 
		Retrieve the value for the "SubmissionId" output from this Choreo execution

		@return String - (integer) The submission id parsed from the Amazon response.
		*/
		public String get_SubmissionId() {
			return this.getResultString("SubmissionId");
		}
		/** 
		Retrieve the value for the "SubmissionResult" output from this Choreo execution

		@return String - (string) The submission result returned from Amazon.
		*/
		public String get_SubmissionResult() {
			return this.getResultString("SubmissionResult");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Amazon after submitting the feed.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
