package com.temboo.Library.Amazon.MachineLearning;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateDataSourceFromS3

Creates a DataSource object.
*/
public class CreateDataSourceFromS3 extends Choreography {

	/**
	Create a new instance of the CreateDataSourceFromS3 Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateDataSourceFromS3(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/MachineLearning/CreateDataSourceFromS3"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateDataSourceFromS3InputSet
	*/
	public CreateDataSourceFromS3InputSet newInputSet() {
		return new CreateDataSourceFromS3InputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateDataSourceFromS3ResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateDataSourceFromS3ResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateDataSourceFromS3
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateDataSourceFromS3InputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the ComputeStatistics input for this Choreo. 

		@param Boolean - (optional, boolean) The compute statistics for a DataSource. This parameter must be set to true if the DataSource needs to be used for MLModel training. Defaults to false.
		*/
		public void set_ComputeStatistics(Boolean value) {
			this.setInput("ComputeStatistics", value);
		}

		/** 
		Set the value of the ComputeStatistics input for this Choreo as a String. 

		@param String - (optional, boolean) The compute statistics for a DataSource. This parameter must be set to true if the DataSource needs to be used for MLModel training. Defaults to false.
		*/
		public void set_ComputeStatistics(String value) {
			this.setInput("ComputeStatistics", value);	
		}
		/** 
		Set the value of the DataLocationS3 input for this Choreo. 

		@param String - (required, string) The location of the data file(s) used by a DataSource. The URI specifies a data file or an Amazon Simple Storage Service (Amazon S3) directory or bucket containing data files.
		*/
		public void set_DataLocationS3(String value) {
			this.setInput("DataLocationS3", value);
		}


		/** 
		Set the value of the DataRearrangement input for this Choreo. 

		@param String - (optional, json) A JSON string that represents the splitting and rearrangement requirements for the Datasource.
		*/
		public void set_DataRearrangement(String value) {
			this.setInput("DataRearrangement", value);
		}


		/** 
		Set the value of the DataSchema input for this Choreo. 

		@param String - (optional, json) A JSON string representing the schema. This is required unless specifying a valid URI for DataSchemaLocationS3.
		*/
		public void set_DataSchema(String value) {
			this.setInput("DataSchema", value);
		}


		/** 
		Set the value of the DataSchemaLocationS3 input for this Choreo. 

		@param String - (conditional, string) The Amazon S3 location of the DataSchema. This is required unless specifying a valid JSON schema file for DataSchema (see optional inputs).
		*/
		public void set_DataSchemaLocationS3(String value) {
			this.setInput("DataSchemaLocationS3", value);
		}


		/** 
		Set the value of the DataSourceId input for this Choreo. 

		@param String - (required, string) A user-supplied identifier that uniquely identifies the DataSource.
		*/
		public void set_DataSourceId(String value) {
			this.setInput("DataSourceId", value);
		}


		/** 
		Set the value of the DataSourceName input for this Choreo. 

		@param String - (optional, string) A user-supplied name or description of the DataSource.
		*/
		public void set_DataSourceName(String value) {
			this.setInput("DataSourceName", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateDataSourceFromS3 Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateDataSourceFromS3ResultSet extends ResultSet {
		public CreateDataSourceFromS3ResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
