package com.temboo.Library.Amazon.EC2;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AssociateAddress

Associates an Elastic IP address with an instance or a network interface using the Amazon EC2 API.
*/
public class AssociateAddress extends Choreography {

	/**
	Create a new instance of the AssociateAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AssociateAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/EC2/AssociateAddress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AssociateAddressInputSet
	*/
	public AssociateAddressInputSet newInputSet() {
		return new AssociateAddressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AssociateAddressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AssociateAddressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AssociateAddress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AssociateAddressInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the AllocationId input for this Choreo. 

		@param String - (optional, string) [EC2-VPC] The allocation ID.  Required for a VPC.
		*/
		public void set_AllocationId(String value) {
			this.setInput("AllocationId", value);
		}


		/** 
		Set the value of the AllowReassociation input for this Choreo. 

		@param String - (optional, string) [EC2-VPC] Allows an Elastic IP address that is already associated with an instance or network interface to be re-associated with the specified instance or network interface. False if not specified.
		*/
		public void set_AllowReassociation(String value) {
			this.setInput("AllowReassociation", value);
		}


		/** 
		Set the value of the InstanceId input for this Choreo. 

		@param String - (conditional, string) The ID of the instance.  Required for EC2-Classic. For a VPC, you can specify either an instance ID or a network interface ID, but not both.
		*/
		public void set_InstanceId(String value) {
			this.setInput("InstanceId", value);
		}


		/** 
		Set the value of the NetworkInterfaceId input for this Choreo. 

		@param String - (optional, string) [EC2-VPC] The ID of the network interface. Association fails when specifying an instance ID unless exactly one interface is attached.
		*/
		public void set_NetworkInterfaceId(String value) {
			this.setInput("NetworkInterfaceId", value);
		}


		/** 
		Set the value of the PrivateIpAddress input for this Choreo. 

		@param String - (optional, string) [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If nothing is specified, the Elastic IP address is associated with the primary private IP address.
		*/
		public void set_PrivateIpAddress(String value) {
			this.setInput("PrivateIpAddress", value);
		}


		/** 
		Set the value of the PublicIp input for this Choreo. 

		@param String - (conditional, string) The Elastic IP address.
		*/
		public void set_PublicIp(String value) {
			this.setInput("PublicIp", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AssociateAddress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AssociateAddressResultSet extends ResultSet {
		public AssociateAddressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
