/*!
 * @header Temboo iOS SDK Withings classes
 *
 * Execute Choreographies from the Temboo Withings bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBWithings.Measure.GetActivityMetrics Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetActivityMetrics Choreo.
 */
@interface TMBWithings_Measure_GetActivityMetrics_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setDate:(NSString*)Date;
	-(void)setEndDate:(NSString*)EndDate;
	-(void)setStartDate:(NSString*)StartDate;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetActivityMetrics Choreo.
 */
@interface TMBWithings_Measure_GetActivityMetrics_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves activity metrics for the specified user.
 */
@interface TMBWithings_Measure_GetActivityMetrics : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_Measure_GetActivityMetrics_Inputs*)newInputSet;
@end

/*! group TMBWithings.Measure_GetActivityMetrics Choreo */


/*! group TMBWithings.Measure.GetBodyMetrics Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetBodyMetrics Choreo.
 */
@interface TMBWithings_Measure_GetBodyMetrics_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCategory:(NSString*)Category;
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setDeviceType:(NSString*)DeviceType;
	-(void)setEndDate:(NSString*)EndDate;
	-(void)setLastUpdated:(NSString*)LastUpdated;
	-(void)setLimit:(NSString*)Limit;
	-(void)setMeasurementType:(NSString*)MeasurementType;
	-(void)setOffset:(NSString*)Offset;
	-(void)setStartDate:(NSString*)StartDate;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetBodyMetrics Choreo.
 */
@interface TMBWithings_Measure_GetBodyMetrics_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves body metrics for the specified user.
 */
@interface TMBWithings_Measure_GetBodyMetrics : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_Measure_GetBodyMetrics_Inputs*)newInputSet;
@end

/*! group TMBWithings.Measure_GetBodyMetrics Choreo */


/*! group TMBWithings.Notification.GetSubscription Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetSubscription Choreo.
 */
@interface TMBWithings_Notification_GetSubscription_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCallbackURL:(NSString*)CallbackURL;
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSubscription Choreo.
 */
@interface TMBWithings_Notification_GetSubscription_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows your application to check whether the notification service was previously subscribed on a specific user and to retrieve the subscription expiration date.
 */
@interface TMBWithings_Notification_GetSubscription : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_Notification_GetSubscription_Inputs*)newInputSet;
@end

/*! group TMBWithings.Notification_GetSubscription Choreo */


/*! group TMBWithings.Notification.ListSubscriptions Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListSubscriptions Choreo.
 */
@interface TMBWithings_Notification_ListSubscriptions_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setApplication:(NSString*)Application;
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListSubscriptions Choreo.
 */
@interface TMBWithings_Notification_ListSubscriptions_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows your application to list all the currently provisioned notification callbacks for a specific user and to retrieve the subscription expiration dates.
 */
@interface TMBWithings_Notification_ListSubscriptions : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_Notification_ListSubscriptions_Inputs*)newInputSet;
@end

/*! group TMBWithings.Notification_ListSubscriptions Choreo */


/*! group TMBWithings.Notification.RevokeSubscription Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RevokeSubscription Choreo.
 */
@interface TMBWithings_Notification_RevokeSubscription_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setApplication:(NSString*)Application;
	-(void)setCallbackURL:(NSString*)CallbackURL;
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RevokeSubscription Choreo.
 */
@interface TMBWithings_Notification_RevokeSubscription_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows your application to revoke a previously subscribed notification.
 */
@interface TMBWithings_Notification_RevokeSubscription : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_Notification_RevokeSubscription_Inputs*)newInputSet;
@end

/*! group TMBWithings.Notification_RevokeSubscription Choreo */


/*! group TMBWithings.Notification.Subscribe Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Subscribe Choreo.
 */
@interface TMBWithings_Notification_Subscribe_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setApplication:(NSString*)Application;
	-(void)setCallbackURL:(NSString*)CallbackURL;
	-(void)setComment:(NSString*)Comment;
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Subscribe Choreo.
 */
@interface TMBWithings_Notification_Subscribe_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows your application to subscribe users to notifications. 
 */
@interface TMBWithings_Notification_Subscribe : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_Notification_Subscribe_Inputs*)newInputSet;
@end

/*! group TMBWithings.Notification_Subscribe Choreo */


/*! group TMBWithings.OAuth.FinalizeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FinalizeOAuth Choreo.
 */
@interface TMBWithings_OAuth_FinalizeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setCallbackID:(NSString*)CallbackID;
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setOAuthTokenSecret:(NSString*)OAuthTokenSecret;
	-(void)setSuppressErrors:(NSString*)SuppressErrors;
	-(void)setTimeout:(NSString*)Timeout;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FinalizeOAuth Choreo.
 */
@interface TMBWithings_OAuth_FinalizeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getAccessTokenSecret;
	-(NSString*)getErrorMessage;
	-(NSString*)getUserID;	
@end

/*!
 * Completes the OAuth process by retrieving a Withings access token and access token secret for a user, after they have visited the authorization URL returned by the InitializeOAuth Choreo and clicked "allow."
 */
@interface TMBWithings_OAuth_FinalizeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_OAuth_FinalizeOAuth_Inputs*)newInputSet;
@end

/*! group TMBWithings.OAuth_FinalizeOAuth Choreo */


/*! group TMBWithings.OAuth.InitializeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InitializeOAuth Choreo.
 */
@interface TMBWithings_OAuth_InitializeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setForwardingURL:(NSString*)ForwardingURL;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InitializeOAuth Choreo.
 */
@interface TMBWithings_OAuth_InitializeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAuthorizationURL;
	-(NSString*)getCallbackID;
	-(NSString*)getOAuthTokenSecret;	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 */
@interface TMBWithings_OAuth_InitializeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_OAuth_InitializeOAuth_Inputs*)newInputSet;
@end

/*! group TMBWithings.OAuth_InitializeOAuth Choreo */


/*! group TMBWithings.Sleep.GetSleepMetrics Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetSleepMetrics Choreo.
 */
@interface TMBWithings_Sleep_GetSleepMetrics_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setEndDate:(NSString*)EndDate;
	-(void)setStartDate:(NSString*)StartDate;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSleepMetrics Choreo.
 */
@interface TMBWithings_Sleep_GetSleepMetrics_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves sleep data for the specified user.
 */
@interface TMBWithings_Sleep_GetSleepMetrics : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_Sleep_GetSleepMetrics_Inputs*)newInputSet;
@end

/*! group TMBWithings.Sleep_GetSleepMetrics Choreo */


/*! group TMBWithings.User.GetUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetUser Choreo.
 */
@interface TMBWithings_User_GetUser_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setConsumerKey:(NSString*)ConsumerKey;
	-(void)setConsumerSecret:(NSString*)ConsumerSecret;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUser Choreo.
 */
@interface TMBWithings_User_GetUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information regarding the specified user.
 */
@interface TMBWithings_User_GetUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWithings_User_GetUser_Inputs*)newInputSet;
@end

/*! group TMBWithings.User_GetUser Choreo */
