/*!
 * @header Temboo iOS SDK Nexmo classes
 *
 * Execute Choreographies from the Temboo Nexmo bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBNexmo.Account.BuyNumber Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the BuyNumber Choreo.
 */
@interface TMBNexmo_Account_BuyNumber_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setCountry:(NSString*)Country;
	-(void)setNumber:(NSString*)Number;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the BuyNumber Choreo.
 */
@interface TMBNexmo_Account_BuyNumber_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Purchase the specified inbound number.
 */
@interface TMBNexmo_Account_BuyNumber : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Account_BuyNumber_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Account_BuyNumber Choreo */


/*! group TMBNexmo.Account.CancelNumber Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CancelNumber Choreo.
 */
@interface TMBNexmo_Account_CancelNumber_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setCountry:(NSString*)Country;
	-(void)setNumber:(NSString*)Number;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CancelNumber Choreo.
 */
@interface TMBNexmo_Account_CancelNumber_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Cancels the specified inbound number subscription.
 */
@interface TMBNexmo_Account_CancelNumber : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Account_CancelNumber_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Account_CancelNumber Choreo */


/*! group TMBNexmo.Account.GetBalance Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetBalance Choreo.
 */
@interface TMBNexmo_Account_GetBalance_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetBalance Choreo.
 */
@interface TMBNexmo_Account_GetBalance_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve your current account balance.
 */
@interface TMBNexmo_Account_GetBalance : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Account_GetBalance_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Account_GetBalance Choreo */


/*! group TMBNexmo.Account.GetNumbers Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetNumbers Choreo.
 */
@interface TMBNexmo_Account_GetNumbers_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setIndex:(NSString*)Index;
	-(void)setPattern:(NSString*)Pattern;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSize:(NSString*)Size;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetNumbers Choreo.
 */
@interface TMBNexmo_Account_GetNumbers_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Get all inbound numbers associated with your Nexmo account.
 */
@interface TMBNexmo_Account_GetNumbers : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Account_GetNumbers_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Account_GetNumbers Choreo */


/*! group TMBNexmo.Account.GetPricingByCountry Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetPricingByCountry Choreo.
 */
@interface TMBNexmo_Account_GetPricingByCountry_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setCountry:(NSString*)Country;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetPricingByCountry Choreo.
 */
@interface TMBNexmo_Account_GetPricingByCountry_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve Nexmo's outbound pricing for the specified country.
 */
@interface TMBNexmo_Account_GetPricingByCountry : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Account_GetPricingByCountry_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Account_GetPricingByCountry Choreo */


/*! group TMBNexmo.Account.GetPricingByPrefix Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetPricingByPrefix Choreo.
 */
@interface TMBNexmo_Account_GetPricingByPrefix_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setPrefix:(NSString*)Prefix;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetPricingByPrefix Choreo.
 */
@interface TMBNexmo_Account_GetPricingByPrefix_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve Nexmo's outbound pricing for the specified international prefix.
 */
@interface TMBNexmo_Account_GetPricingByPrefix : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Account_GetPricingByPrefix_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Account_GetPricingByPrefix Choreo */


/*! group TMBNexmo.Account.TopUp Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TopUp Choreo.
 */
@interface TMBNexmo_Account_TopUp_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTransactionID:(NSString*)TransactionID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TopUp Choreo.
 */
@interface TMBNexmo_Account_TopUp_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to top-up your account provided that you've set up "auto-reload" in your Account Settings.
 */
@interface TMBNexmo_Account_TopUp : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Account_TopUp_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Account_TopUp Choreo */


/*! group TMBNexmo.Account.UpdateAccountSettings Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateAccountSettings Choreo.
 */
@interface TMBNexmo_Account_UpdateAccountSettings_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setDeliveryReceiptCallbackURL:(NSString*)DeliveryReceiptCallbackURL;
	-(void)setInboundCallbackURL:(NSString*)InboundCallbackURL;
	-(void)setNewSecret:(NSString*)NewSecret;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateAccountSettings Choreo.
 */
@interface TMBNexmo_Account_UpdateAccountSettings_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Update your account settings.
 */
@interface TMBNexmo_Account_UpdateAccountSettings : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Account_UpdateAccountSettings_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Account_UpdateAccountSettings Choreo */


/*! group TMBNexmo.Account.UpdateNumber Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateNumber Choreo.
 */
@interface TMBNexmo_Account_UpdateNumber_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setCallbackURL:(NSString*)CallbackURL;
	-(void)setCountry:(NSString*)Country;
	-(void)setNumber:(NSString*)Number;
	-(void)setSMPPSystemType:(NSString*)SMPPSystemType;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateNumber Choreo.
 */
@interface TMBNexmo_Account_UpdateNumber_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Updates the callback details for the specified number.
 */
@interface TMBNexmo_Account_UpdateNumber : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Account_UpdateNumber_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Account_UpdateNumber Choreo */


/*! group TMBNexmo.SMS.SendMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SendMessage Choreo.
 */
@interface TMBNexmo_SMS_SendMessage_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setBody:(NSString*)Body;
	-(void)setCallbackID:(NSString*)CallbackID;
	-(void)setClientReference:(NSString*)ClientReference;
	-(void)setDeliveryReceipt:(NSString*)DeliveryReceipt;
	-(void)setFrom:(NSString*)From;
	-(void)setMessageClass:(NSString*)MessageClass;
	-(void)setNetworkCode:(NSString*)NetworkCode;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTTL:(NSString*)TTL;
	-(void)setText:(NSString*)Text;
	-(void)setTimeout:(NSString*)Timeout;
	-(void)setTo:(NSString*)To;
	-(void)setType:(NSString*)Type;
	-(void)setUDH:(NSString*)UDH;
	-(void)setVCal:(NSString*)VCal;
	-(void)setVCard:(NSString*)VCard;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SendMessage Choreo.
 */
@interface TMBNexmo_SMS_SendMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getCallbackData;
	-(NSString*)getResponse;	
@end

/*!
 * Send a text message to any global number.
 */
@interface TMBNexmo_SMS_SendMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_SMS_SendMessage_Inputs*)newInputSet;
@end

/*! group TMBNexmo.SMS_SendMessage Choreo */


/*! group TMBNexmo.Search.SearchMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchMessage Choreo.
 */
@interface TMBNexmo_Search_SearchMessage_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setMessageID:(NSString*)MessageID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchMessage Choreo.
 */
@interface TMBNexmo_Search_SearchMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Search for a previously sent message by Message ID.  Note that a sent message won't be immediately available for search.
 */
@interface TMBNexmo_Search_SearchMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Search_SearchMessage_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Search_SearchMessage Choreo */


/*! group TMBNexmo.Search.SearchMessages Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchMessages Choreo.
 */
@interface TMBNexmo_Search_SearchMessages_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setMessageIDs:(NSString*)MessageIDs;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchMessages Choreo.
 */
@interface TMBNexmo_Search_SearchMessages_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Search for previously sent messages by Message IDs.  Note that  sent messages won't be immediately available for search.
 */
@interface TMBNexmo_Search_SearchMessages : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Search_SearchMessages_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Search_SearchMessages Choreo */


/*! group TMBNexmo.Search.SearchMessagesByRecipientAndDate Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchMessagesByRecipientAndDate Choreo.
 */
@interface TMBNexmo_Search_SearchMessagesByRecipientAndDate_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setDate:(NSString*)Date;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTo:(NSString*)To;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchMessagesByRecipientAndDate Choreo.
 */
@interface TMBNexmo_Search_SearchMessagesByRecipientAndDate_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Searches sent messages by Date and Recipient. Note that a sent message won't be immediately available for searching.
 */
@interface TMBNexmo_Search_SearchMessagesByRecipientAndDate : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Search_SearchMessagesByRecipientAndDate_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Search_SearchMessagesByRecipientAndDate Choreo */


/*! group TMBNexmo.Search.SearchNumbers Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchNumbers Choreo.
 */
@interface TMBNexmo_Search_SearchNumbers_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setCountry:(NSString*)Country;
	-(void)setIndex:(NSString*)Index;
	-(void)setPattern:(NSString*)Pattern;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSize:(NSString*)Size;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchNumbers Choreo.
 */
@interface TMBNexmo_Search_SearchNumbers_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Get available inbound numbers for a given country.
 */
@interface TMBNexmo_Search_SearchNumbers : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Search_SearchNumbers_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Search_SearchNumbers Choreo */


/*! group TMBNexmo.Search.SearchRejectedMessages Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchRejectedMessages Choreo.
 */
@interface TMBNexmo_Search_SearchRejectedMessages_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setDate:(NSString*)Date;
	-(void)setMessageID:(NSString*)MessageID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTo:(NSString*)To;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchRejectedMessages Choreo.
 */
@interface TMBNexmo_Search_SearchRejectedMessages_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Search for a previously sent message by Message ID.  Note that a sent message won't be immediately available for search.
 */
@interface TMBNexmo_Search_SearchRejectedMessages : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Search_SearchRejectedMessages_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Search_SearchRejectedMessages Choreo */


/*! group TMBNexmo.Voice.CaptureTextToSpeechPrompt Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CaptureTextToSpeechPrompt Choreo.
 */
@interface TMBNexmo_Voice_CaptureTextToSpeechPrompt_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setByeText:(NSString*)ByeText;
	-(void)setCallbackMethod:(NSString*)CallbackMethod;
	-(void)setCallbackURL:(NSString*)CallbackURL;
	-(void)setDropIfMachine:(NSString*)DropIfMachine;
	-(void)setFrom:(NSString*)From;
	-(void)setLanguage:(NSString*)Language;
	-(void)setMachineDetection:(NSString*)MachineDetection;
	-(void)setMachineTimeout:(NSString*)MachineTimeout;
	-(void)setMaxDigits:(NSString*)MaxDigits;
	-(void)setRepeat:(NSString*)Repeat;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setText:(NSString*)Text;
	-(void)setTo:(NSString*)To;
	-(void)setVoice:(NSString*)Voice;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CaptureTextToSpeechPrompt Choreo.
 */
@interface TMBNexmo_Voice_CaptureTextToSpeechPrompt_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getCallbackData;
	-(NSString*)getDigits;
	-(NSString*)getResponse;	
@end

/*!
 * Sends a Text-to-Speech message to the specifed Number and captures keypad entries from the receiver.
 */
@interface TMBNexmo_Voice_CaptureTextToSpeechPrompt : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Voice_CaptureTextToSpeechPrompt_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Voice_CaptureTextToSpeechPrompt Choreo */


/*! group TMBNexmo.Voice.ConfirmTextToSpeechPrompt Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ConfirmTextToSpeechPrompt Choreo.
 */
@interface TMBNexmo_Voice_ConfirmTextToSpeechPrompt_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setByeText:(NSString*)ByeText;
	-(void)setCallbackMethod:(NSString*)CallbackMethod;
	-(void)setCallbackURL:(NSString*)CallbackURL;
	-(void)setDropIfMachine:(NSString*)DropIfMachine;
	-(void)setFailedText:(NSString*)FailedText;
	-(void)setFrom:(NSString*)From;
	-(void)setLanguage:(NSString*)Language;
	-(void)setMachineDetection:(NSString*)MachineDetection;
	-(void)setMachineTimeout:(NSString*)MachineTimeout;
	-(void)setMaxDigits:(NSString*)MaxDigits;
	-(void)setPinCode:(NSString*)PinCode;
	-(void)setRepeat:(NSString*)Repeat;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setText:(NSString*)Text;
	-(void)setTo:(NSString*)To;
	-(void)setVoice:(NSString*)Voice;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ConfirmTextToSpeechPrompt Choreo.
 */
@interface TMBNexmo_Voice_ConfirmTextToSpeechPrompt_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Sends a Text-to-Speech message to the specifed Number and confirms the specifed pin-code.
 */
@interface TMBNexmo_Voice_ConfirmTextToSpeechPrompt : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Voice_ConfirmTextToSpeechPrompt_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Voice_ConfirmTextToSpeechPrompt Choreo */


/*! group TMBNexmo.Voice.TextToSpeech Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TextToSpeech Choreo.
 */
@interface TMBNexmo_Voice_TextToSpeech_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setCallbackMethod:(NSString*)CallbackMethod;
	-(void)setCallbackURL:(NSString*)CallbackURL;
	-(void)setDropIfMachine:(NSString*)DropIfMachine;
	-(void)setFrom:(NSString*)From;
	-(void)setLanguage:(NSString*)Language;
	-(void)setMachineDetection:(NSString*)MachineDetection;
	-(void)setMachineTimeout:(NSString*)MachineTimeout;
	-(void)setRepeat:(NSString*)Repeat;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setText:(NSString*)Text;
	-(void)setTo:(NSString*)To;
	-(void)setVoice:(NSString*)Voice;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TextToSpeech Choreo.
 */
@interface TMBNexmo_Voice_TextToSpeech_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Sends a Text-to-Speech message to the specified number.
 */
@interface TMBNexmo_Voice_TextToSpeech : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBNexmo_Voice_TextToSpeech_Inputs*)newInputSet;
@end

/*! group TMBNexmo.Voice_TextToSpeech Choreo */
