/*!
 * @header Temboo iOS SDK Microsoft classes
 *
 * Execute Choreographies from the Temboo Microsoft bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBMicrosoft.Excel.Range.DeleteRange Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRange Choreo.
 */
@interface TMBMicrosoft_Excel_Range_DeleteRange_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setRange:(NSString*)Range;
	-(void)setShift:(NSString*)Shift;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRange Choreo.
 */
@interface TMBMicrosoft_Excel_Range_DeleteRange_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the cells associated with the range.
 */
@interface TMBMicrosoft_Excel_Range_DeleteRange : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Range_DeleteRange_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Range_DeleteRange Choreo */


/*! group TMBMicrosoft.Excel.Range.GetLastCell Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLastCell Choreo.
 */
@interface TMBMicrosoft_Excel_Range_GetLastCell_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setRange:(NSString*)Range;
	-(void)setSelect:(NSString*)Select;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLastCell Choreo.
 */
@interface TMBMicrosoft_Excel_Range_GetLastCell_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the last cell within a specified range.
 */
@interface TMBMicrosoft_Excel_Range_GetLastCell : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Range_GetLastCell_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Range_GetLastCell Choreo */


/*! group TMBMicrosoft.Excel.Range.GetLastColumn Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLastColumn Choreo.
 */
@interface TMBMicrosoft_Excel_Range_GetLastColumn_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setRange:(NSString*)Range;
	-(void)setSelect:(NSString*)Select;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLastColumn Choreo.
 */
@interface TMBMicrosoft_Excel_Range_GetLastColumn_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the last column within a specified range.
 */
@interface TMBMicrosoft_Excel_Range_GetLastColumn : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Range_GetLastColumn_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Range_GetLastColumn Choreo */


/*! group TMBMicrosoft.Excel.Range.GetLastRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLastRow Choreo.
 */
@interface TMBMicrosoft_Excel_Range_GetLastRow_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setRange:(NSString*)Range;
	-(void)setSelect:(NSString*)Select;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLastRow Choreo.
 */
@interface TMBMicrosoft_Excel_Range_GetLastRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the last row within a specified range.
 */
@interface TMBMicrosoft_Excel_Range_GetLastRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Range_GetLastRow_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Range_GetLastRow Choreo */


/*! group TMBMicrosoft.Excel.Range.GetRange Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetRange Choreo.
 */
@interface TMBMicrosoft_Excel_Range_GetRange_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setRange:(NSString*)Range;
	-(void)setSelect:(NSString*)Select;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRange Choreo.
 */
@interface TMBMicrosoft_Excel_Range_GetRange_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the properties and relationships of range object.
 */
@interface TMBMicrosoft_Excel_Range_GetRange : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Range_GetRange_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Range_GetRange Choreo */


/*! group TMBMicrosoft.Excel.Table.CreateTableRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateTableRow Choreo.
 */
@interface TMBMicrosoft_Excel_Table_CreateTableRow_Inputs : TMBChoreographyInputSet
	-(void)setValues:(NSString*)Values;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setIndex:(NSString*)Index;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setTable:(NSString*)Table;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateTableRow Choreo.
 */
@interface TMBMicrosoft_Excel_Table_CreateTableRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates new rows in a table.
 */
@interface TMBMicrosoft_Excel_Table_CreateTableRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Table_CreateTableRow_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Table_CreateTableRow Choreo */


/*! group TMBMicrosoft.Excel.Table.DataBodyRange Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DataBodyRange Choreo.
 */
@interface TMBMicrosoft_Excel_Table_DataBodyRange_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setSelect:(NSString*)Select;
	-(void)setTable:(NSString*)Table;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DataBodyRange Choreo.
 */
@interface TMBMicrosoft_Excel_Table_DataBodyRange_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets the range object associated with the data body of the table.
 */
@interface TMBMicrosoft_Excel_Table_DataBodyRange : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Table_DataBodyRange_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Table_DataBodyRange Choreo */


/*! group TMBMicrosoft.Excel.Table.DeleteRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRow Choreo.
 */
@interface TMBMicrosoft_Excel_Table_DeleteRow_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setIndex:(NSString*)Index;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setTable:(NSString*)Table;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRow Choreo.
 */
@interface TMBMicrosoft_Excel_Table_DeleteRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the row from the table.
 */
@interface TMBMicrosoft_Excel_Table_DeleteRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Table_DeleteRow_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Table_DeleteRow Choreo */


/*! group TMBMicrosoft.Excel.Table.GetRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetRow Choreo.
 */
@interface TMBMicrosoft_Excel_Table_GetRow_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setIndex:(NSString*)Index;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setSelect:(NSString*)Select;
	-(void)setTable:(NSString*)Table;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRow Choreo.
 */
@interface TMBMicrosoft_Excel_Table_GetRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve the properties and relationships of tablerow object.
 */
@interface TMBMicrosoft_Excel_Table_GetRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Table_GetRow_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Table_GetRow Choreo */


/*! group TMBMicrosoft.Excel.Table.ListColumns Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListColumns Choreo.
 */
@interface TMBMicrosoft_Excel_Table_ListColumns_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setSelect:(NSString*)Select;
	-(void)setSkip:(NSString*)Skip;
	-(void)setTable:(NSString*)Table;
	-(void)setTop:(NSString*)Top;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListColumns Choreo.
 */
@interface TMBMicrosoft_Excel_Table_ListColumns_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve a list of tablecolumn objects.
 */
@interface TMBMicrosoft_Excel_Table_ListColumns : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Table_ListColumns_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Table_ListColumns Choreo */


/*! group TMBMicrosoft.Excel.Table.ListRows Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListRows Choreo.
 */
@interface TMBMicrosoft_Excel_Table_ListRows_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setSelect:(NSString*)Select;
	-(void)setSkip:(NSString*)Skip;
	-(void)setTable:(NSString*)Table;
	-(void)setTop:(NSString*)Top;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListRows Choreo.
 */
@interface TMBMicrosoft_Excel_Table_ListRows_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve a list of tablerow objects.
 */
@interface TMBMicrosoft_Excel_Table_ListRows : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Table_ListRows_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Table_ListRows Choreo */


/*! group TMBMicrosoft.Excel.Table.ListTables Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListTables Choreo.
 */
@interface TMBMicrosoft_Excel_Table_ListTables_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setSelect:(NSString*)Select;
	-(void)setSkip:(NSString*)Skip;
	-(void)setTop:(NSString*)Top;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTables Choreo.
 */
@interface TMBMicrosoft_Excel_Table_ListTables_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of tables.
 */
@interface TMBMicrosoft_Excel_Table_ListTables : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Table_ListTables_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Table_ListTables Choreo */


/*! group TMBMicrosoft.Excel.Workbook.InvokeFunction Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InvokeFunction Choreo.
 */
@interface TMBMicrosoft_Excel_Workbook_InvokeFunction_Inputs : TMBChoreographyInputSet
	-(void)setArguments:(NSString*)Arguments;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFunction:(NSString*)Function;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InvokeFunction Choreo.
 */
@interface TMBMicrosoft_Excel_Workbook_InvokeFunction_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Invokes a workbook function.
 */
@interface TMBMicrosoft_Excel_Workbook_InvokeFunction : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Workbook_InvokeFunction_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Workbook_InvokeFunction Choreo */


/*! group TMBMicrosoft.Excel.Worksheet.AddWorksheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddWorksheet Choreo.
 */
@interface TMBMicrosoft_Excel_Worksheet_AddWorksheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddWorksheet Choreo.
 */
@interface TMBMicrosoft_Excel_Worksheet_AddWorksheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Adds a new worksheet to the workbook.
 */
@interface TMBMicrosoft_Excel_Worksheet_AddWorksheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Worksheet_AddWorksheet_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Worksheet_AddWorksheet Choreo */


/*! group TMBMicrosoft.Excel.Worksheet.GetWorksheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetWorksheet Choreo.
 */
@interface TMBMicrosoft_Excel_Worksheet_GetWorksheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheet:(NSString*)Worksheet;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetWorksheet Choreo.
 */
@interface TMBMicrosoft_Excel_Worksheet_GetWorksheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve the properties and relationships of worksheet object.
 */
@interface TMBMicrosoft_Excel_Worksheet_GetWorksheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Worksheet_GetWorksheet_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Worksheet_GetWorksheet Choreo */


/*! group TMBMicrosoft.Excel.Worksheet.ListWorksheets Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListWorksheets Choreo.
 */
@interface TMBMicrosoft_Excel_Worksheet_ListWorksheets_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setItemPath:(NSString*)ItemPath;
	-(void)setPassword:(NSString*)Password;
	-(void)setSelect:(NSString*)Select;
	-(void)setSkip:(NSString*)Skip;
	-(void)setTop:(NSString*)Top;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListWorksheets Choreo.
 */
@interface TMBMicrosoft_Excel_Worksheet_ListWorksheets_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve a list of worksheet objects.
 */
@interface TMBMicrosoft_Excel_Worksheet_ListWorksheets : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Excel_Worksheet_ListWorksheets_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Excel.Worksheet_ListWorksheets Choreo */


/*! group TMBMicrosoft.OAuth.FinalizeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FinalizeOAuth Choreo.
 */
@interface TMBMicrosoft_OAuth_FinalizeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setCallbackID:(NSString*)CallbackID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setResource:(NSString*)Resource;
	-(void)setSuppressErrors:(NSString*)SuppressErrors;
	-(void)setTimeout:(NSString*)Timeout;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FinalizeOAuth Choreo.
 */
@interface TMBMicrosoft_OAuth_FinalizeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getErrorMessage;
	-(NSString*)getExpires;
	-(NSString*)getRefreshToken;
	-(NSString*)getResponse;	
@end

/*!
 * Completes the OAuth process by retrieving Microsoft OAuth tokens for a user, after they have visited the authorization URL returned by the InitializeOAuth Choreo and clicked "allow."
 */
@interface TMBMicrosoft_OAuth_FinalizeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_OAuth_FinalizeOAuth_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.OAuth_FinalizeOAuth Choreo */


/*! group TMBMicrosoft.OAuth.InitializeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InitializeOAuth Choreo.
 */
@interface TMBMicrosoft_OAuth_InitializeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setClientID:(NSString*)ClientID;
	-(void)setCustomCallbackID:(NSString*)CustomCallbackID;
	-(void)setDomainHint:(NSString*)DomainHint;
	-(void)setForwardingURL:(NSString*)ForwardingURL;
	-(void)setLoginHint:(NSString*)LoginHint;
	-(void)setPrompt:(NSString*)Prompt;
	-(void)setResource:(NSString*)Resource;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InitializeOAuth Choreo.
 */
@interface TMBMicrosoft_OAuth_InitializeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAuthorizationURL;
	-(NSString*)getCallbackID;	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 */
@interface TMBMicrosoft_OAuth_InitializeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_OAuth_InitializeOAuth_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.OAuth_InitializeOAuth Choreo */


/*! group TMBMicrosoft.OAuth.RefreshToken Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RefreshToken Choreo.
 */
@interface TMBMicrosoft_OAuth_RefreshToken_Inputs : TMBChoreographyInputSet
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResource:(NSString*)Resource;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RefreshToken Choreo.
 */
@interface TMBMicrosoft_OAuth_RefreshToken_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpires;
	-(NSString*)getNewRefreshToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a new refresh token and access token by exchanging the refresh token that is associated with the expired access token.
 */
@interface TMBMicrosoft_OAuth_RefreshToken : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_OAuth_RefreshToken_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.OAuth_RefreshToken Choreo */


/*! group TMBMicrosoft.PowerBI.AddRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddRow Choreo.
 */
@interface TMBMicrosoft_PowerBI_AddRow_Inputs : TMBChoreographyInputSet
	-(void)setRows:(NSString*)Rows;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDatasetID:(NSString*)DatasetID;
	-(void)setPassword:(NSString*)Password;
	-(void)setTableName:(NSString*)TableName;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddRow Choreo.
 */
@interface TMBMicrosoft_PowerBI_AddRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseCode;
	-(NSString*)getResponse;	
@end

/*!
 * Adds rows to a table in a dataset
 */
@interface TMBMicrosoft_PowerBI_AddRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_PowerBI_AddRow_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.PowerBI_AddRow Choreo */


/*! group TMBMicrosoft.PowerBI.CreateDataset Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateDataset Choreo.
 */
@interface TMBMicrosoft_PowerBI_CreateDataset_Inputs : TMBChoreographyInputSet
	-(void)setSchemaDefinition:(NSString*)SchemaDefinition;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDefaultRetentionPolicy:(NSString*)DefaultRetentionPolicy;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateDataset Choreo.
 */
@interface TMBMicrosoft_PowerBI_CreateDataset_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseCode;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new Dataset from a JSON schema definition and returns the Dataset ID and the properties of the dataset created.
 */
@interface TMBMicrosoft_PowerBI_CreateDataset : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_PowerBI_CreateDataset_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.PowerBI_CreateDataset Choreo */


/*! group TMBMicrosoft.Translator.AddTranslation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddTranslation Choreo.
 */
@interface TMBMicrosoft_Translator_AddTranslation_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCategory:(NSString*)Category;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContentType:(NSString*)ContentType;
	-(void)setFrom:(NSString*)From;
	-(void)setOriginalText:(NSString*)OriginalText;
	-(void)setRating:(NSString*)Rating;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTo:(NSString*)To;
	-(void)setTranslatedText:(NSString*)TranslatedText;
	-(void)setURI:(NSString*)URI;
	-(void)setUser:(NSString*)User;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddTranslation Choreo.
 */
@interface TMBMicrosoft_Translator_AddTranslation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves an array of all translations for a given text.
 */
@interface TMBMicrosoft_Translator_AddTranslation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_AddTranslation_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_AddTranslation Choreo */


/*! group TMBMicrosoft.Translator.AddTranslationArray Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddTranslationArray Choreo.
 */
@interface TMBMicrosoft_Translator_AddTranslationArray_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCategory:(NSString*)Category;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContentType:(NSString*)ContentType;
	-(void)setFrom:(NSString*)From;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTo:(NSString*)To;
	-(void)setTranslations:(NSString*)Translations;
	-(void)setURI:(NSString*)URI;
	-(void)setUser:(NSString*)User;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddTranslationArray Choreo.
 */
@interface TMBMicrosoft_Translator_AddTranslationArray_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Adds an array of translations to add translation memory.
 */
@interface TMBMicrosoft_Translator_AddTranslationArray : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_AddTranslationArray_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_AddTranslationArray Choreo */


/*! group TMBMicrosoft.Translator.BreakSentences Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the BreakSentences Choreo.
 */
@interface TMBMicrosoft_Translator_BreakSentences_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLanguage:(NSString*)Language;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setText:(NSString*)Text;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the BreakSentences Choreo.
 */
@interface TMBMicrosoft_Translator_BreakSentences_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Breaks a piece of text into sentences and returns an array containing the lengths in each sentence.
 */
@interface TMBMicrosoft_Translator_BreakSentences : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_BreakSentences_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_BreakSentences Choreo */


/*! group TMBMicrosoft.Translator.Detect Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Detect Choreo.
 */
@interface TMBMicrosoft_Translator_Detect_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setText:(NSString*)Text;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Detect Choreo.
 */
@interface TMBMicrosoft_Translator_Detect_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Identifies the language of a selected piece of text.
 */
@interface TMBMicrosoft_Translator_Detect : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_Detect_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_Detect Choreo */


/*! group TMBMicrosoft.Translator.DetectArray Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DetectArray Choreo.
 */
@interface TMBMicrosoft_Translator_DetectArray_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTexts:(NSString*)Texts;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DetectArray Choreo.
 */
@interface TMBMicrosoft_Translator_DetectArray_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Identifies the language of an array of text strings.
 */
@interface TMBMicrosoft_Translator_DetectArray : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_DetectArray_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_DetectArray Choreo */


/*! group TMBMicrosoft.Translator.GetLanguageNames Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLanguageNames Choreo.
 */
@interface TMBMicrosoft_Translator_GetLanguageNames_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLanguageCodes:(NSString*)LanguageCodes;
	-(void)setLocale:(NSString*)Locale;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLanguageNames Choreo.
 */
@interface TMBMicrosoft_Translator_GetLanguageNames_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves friendly names for languages and localized using the specified locale language.
 */
@interface TMBMicrosoft_Translator_GetLanguageNames : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_GetLanguageNames_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_GetLanguageNames Choreo */


/*! group TMBMicrosoft.Translator.GetLanguagesForSpeak Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLanguagesForSpeak Choreo.
 */
@interface TMBMicrosoft_Translator_GetLanguagesForSpeak_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLanguagesForSpeak Choreo.
 */
@interface TMBMicrosoft_Translator_GetLanguagesForSpeak_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the languages available for speech synthesis.
 */
@interface TMBMicrosoft_Translator_GetLanguagesForSpeak : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_GetLanguagesForSpeak_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_GetLanguagesForSpeak Choreo */


/*! group TMBMicrosoft.Translator.GetLanguagesForTranslate Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLanguagesForTranslate Choreo.
 */
@interface TMBMicrosoft_Translator_GetLanguagesForTranslate_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLanguagesForTranslate Choreo.
 */
@interface TMBMicrosoft_Translator_GetLanguagesForTranslate_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of language codes representing languages that are supported by the Translation Service.
 */
@interface TMBMicrosoft_Translator_GetLanguagesForTranslate : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_GetLanguagesForTranslate_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_GetLanguagesForTranslate Choreo */


/*! group TMBMicrosoft.Translator.GetToken Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetToken Choreo.
 */
@interface TMBMicrosoft_Translator_GetToken_Inputs : TMBChoreographyInputSet
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetToken Choreo.
 */
@interface TMBMicrosoft_Translator_GetToken_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getExpiresIn;	
@end

/*!
 * Retrieves an access token that can be used to authenticate with the Microsoft Translator API.
 */
@interface TMBMicrosoft_Translator_GetToken : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_GetToken_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_GetToken Choreo */


/*! group TMBMicrosoft.Translator.GetTranslations Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetTranslations Choreo.
 */
@interface TMBMicrosoft_Translator_GetTranslations_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCategory:(NSString*)Category;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContentType:(NSString*)ContentType;
	-(void)setFrom:(NSString*)From;
	-(void)setMaxTranslations:(NSString*)MaxTranslations;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setState:(NSString*)State;
	-(void)setText:(NSString*)Text;
	-(void)setTo:(NSString*)To;
	-(void)setURI:(NSString*)URI;
	-(void)setUser:(NSString*)User;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetTranslations Choreo.
 */
@interface TMBMicrosoft_Translator_GetTranslations_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves an array of all translations for a given text.
 */
@interface TMBMicrosoft_Translator_GetTranslations : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_GetTranslations_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_GetTranslations Choreo */


/*! group TMBMicrosoft.Translator.GetTranslationsArray Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetTranslationsArray Choreo.
 */
@interface TMBMicrosoft_Translator_GetTranslationsArray_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCategory:(NSString*)Category;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContentType:(NSString*)ContentType;
	-(void)setFrom:(NSString*)From;
	-(void)setMaxTranslations:(NSString*)MaxTranslations;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setState:(NSString*)State;
	-(void)setTexts:(NSString*)Texts;
	-(void)setTo:(NSString*)To;
	-(void)setURI:(NSString*)URI;
	-(void)setUser:(NSString*)User;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetTranslationsArray Choreo.
 */
@interface TMBMicrosoft_Translator_GetTranslationsArray_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves multiple translation candidates for multiple source texts.
 */
@interface TMBMicrosoft_Translator_GetTranslationsArray : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_GetTranslationsArray_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_GetTranslationsArray Choreo */


/*! group TMBMicrosoft.Translator.Speak Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Speak Choreo.
 */
@interface TMBMicrosoft_Translator_Speak_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFormat:(NSString*)Format;
	-(void)setLanguage:(NSString*)Language;
	-(void)setOptions:(NSString*)Options;
	-(void)setText:(NSString*)Text;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Speak Choreo.
 */
@interface TMBMicrosoft_Translator_Speak_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAudioFile;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;	
@end

/*!
 * Returns a Base64 encoded wave or mp3 file of the passed-in text being spoken in the desired language.
 */
@interface TMBMicrosoft_Translator_Speak : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_Speak_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_Speak Choreo */


/*! group TMBMicrosoft.Translator.Translate Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Translate Choreo.
 */
@interface TMBMicrosoft_Translator_Translate_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCategory:(NSString*)Category;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContentType:(NSString*)ContentType;
	-(void)setFrom:(NSString*)From;
	-(void)setText:(NSString*)Text;
	-(void)setTo:(NSString*)To;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Translate Choreo.
 */
@interface TMBMicrosoft_Translator_Translate_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getTranslatedText;	
@end

/*!
 * Translates a text string from one language to another.
 */
@interface TMBMicrosoft_Translator_Translate : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_Translate_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_Translate Choreo */


/*! group TMBMicrosoft.Translator.TranslateArray Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TranslateArray Choreo.
 */
@interface TMBMicrosoft_Translator_TranslateArray_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCategory:(NSString*)Category;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContentType:(NSString*)ContentType;
	-(void)setFrom:(NSString*)From;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTexts:(NSString*)Texts;
	-(void)setTo:(NSString*)To;
	-(void)setURI:(NSString*)URI;
	-(void)setUser:(NSString*)User;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TranslateArray Choreo.
 */
@interface TMBMicrosoft_Translator_TranslateArray_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExpiresIn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Translates multiple source texts.
 */
@interface TMBMicrosoft_Translator_TranslateArray : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMicrosoft_Translator_TranslateArray_Inputs*)newInputSet;
@end

/*! group TMBMicrosoft.Translator_TranslateArray Choreo */
