/*!
 * @TMBHighrise.m
 *
 * Execute Choreographies from the Temboo Highrise bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBHighrise.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the CreatePeople Choreo.
 */
@implementation TMBHighrise_CreatePeople_Inputs

	/*!
	 * Set the value of the AccountName input for this Choreo.
	*(required, string) A valid Highrise account name. This is the first part of the account's URL.
	 */
	-(void)setAccountName:(NSString*)AccountName {
		[super setInput:@"AccountName" toValue:AccountName];
	}

	/*!
	 * Set the value of the Background input for this Choreo.
	*(optional, string) Corresponds to the background field in Highrise
	 */
	-(void)setBackground:(NSString*)Background {
		[super setInput:@"Background" toValue:Background];
	}

	/*!
	 * Set the value of the CompanyName input for this Choreo.
	*(optional, string) Corresponds to the company name field in Highrise.
	 */
	-(void)setCompanyName:(NSString*)CompanyName {
		[super setInput:@"CompanyName" toValue:CompanyName];
	}

	/*!
	 * Set the value of the EmailAddress input for this Choreo.
	*(optional, string) Corresponds to the email address field in Highrise.
	 */
	-(void)setEmailAddress:(NSString*)EmailAddress {
		[super setInput:@"EmailAddress" toValue:EmailAddress];
	}

	/*!
	 * Set the value of the FirstName input for this Choreo.
	*(required, string) Corresponds to the first name field in Highrise.
	 */
	-(void)setFirstName:(NSString*)FirstName {
		[super setInput:@"FirstName" toValue:FirstName];
	}

	/*!
	 * Set the value of the HomePhone input for this Choreo.
	*(optional, string) Corresponds to the home phone field in Highrise.
	 */
	-(void)setHomePhone:(NSString*)HomePhone {
		[super setInput:@"HomePhone" toValue:HomePhone];
	}

	/*!
	 * Set the value of the LastName input for this Choreo.
	*(optional, string) Corresponds to the last name field in Highrise.
	 */
	-(void)setLastName:(NSString*)LastName {
		[super setInput:@"LastName" toValue:LastName];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Highrise account password. Use the value 'X' when specifying an API Key for the Username input.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(optional, string) Corresponds to the title field in Highrise.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A Highrise account username or API Key.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the WorkPhone input for this Choreo.
	*(optional, string) Corresponds to the work phone field in Highrise.
	 */
	-(void)setWorkPhone:(NSString*)WorkPhone {
		[super setInput:@"WorkPhone" toValue:WorkPhone];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreatePeople Choreo.
 */
@implementation TMBHighrise_CreatePeople_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Highrise.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new contact record in your Highrise CRM.
 */
@implementation TMBHighrise_CreatePeople

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBHighrise_CreatePeople Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Highrise/CreatePeople"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBHighrise_CreatePeople_ResultSet *results = [[TMBHighrise_CreatePeople_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreatePeople Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBHighrise_CreatePeople_Inputs*)newInputSet {
		return [[TMBHighrise_CreatePeople_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeletePeople Choreo.
 */
@implementation TMBHighrise_DeletePeople_Inputs

	/*!
	 * Set the value of the AccountName input for this Choreo.
	*(required, string) A valid Highrise account name. This is the first part of the account's URL.
	 */
	-(void)setAccountName:(NSString*)AccountName {
		[super setInput:@"AccountName" toValue:AccountName];
	}

	/*!
	 * Set the value of the ContactID input for this Choreo.
	*(required, string) The ID number of the contact you want to delete. This is used to contruct the URL for the request.
	 */
	-(void)setContactID:(NSString*)ContactID {
		[super setInput:@"ContactID" toValue:ContactID];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Highrise account password. Use the value 'X' when specifying an API Key for the Username input.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A Highrise account username or API Key.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeletePeople Choreo.
 */
@implementation TMBHighrise_DeletePeople_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Highrise. The delete people API method returns no XML, so this variable will contain no data.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a specified contact from your Highrise CRM.
 */
@implementation TMBHighrise_DeletePeople

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBHighrise_DeletePeople Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Highrise/DeletePeople"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBHighrise_DeletePeople_ResultSet *results = [[TMBHighrise_DeletePeople_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeletePeople Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBHighrise_DeletePeople_Inputs*)newInputSet {
		return [[TMBHighrise_DeletePeople_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListAllPeople Choreo.
 */
@implementation TMBHighrise_ListAllPeople_Inputs

	/*!
	 * Set the value of the AccountName input for this Choreo.
	*(required, string) A valid Highrise account name. This is the first part of the account's URL.
	 */
	-(void)setAccountName:(NSString*)AccountName {
		[super setInput:@"AccountName" toValue:AccountName];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Highrise account password. Use the value 'X' when specifying an API Key for the Username input.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A Highrise account username or API Key.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAllPeople Choreo.
 */
@implementation TMBHighrise_ListAllPeople_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Highrise.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves contacts from your Highrise CRM.
 */
@implementation TMBHighrise_ListAllPeople

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBHighrise_ListAllPeople Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Highrise/ListAllPeople"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBHighrise_ListAllPeople_ResultSet *results = [[TMBHighrise_ListAllPeople_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListAllPeople Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBHighrise_ListAllPeople_Inputs*)newInputSet {
		return [[TMBHighrise_ListAllPeople_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the SearchPeople Choreo.
 */
@implementation TMBHighrise_SearchPeople_Inputs

	/*!
	 * Set the value of the AccountName input for this Choreo.
	*(required, string) A valid Highrise account name. This is the first part of the account's URL.
	 */
	-(void)setAccountName:(NSString*)AccountName {
		[super setInput:@"AccountName" toValue:AccountName];
	}

	/*!
	 * Set the value of the City input for this Choreo.
	*(optional, string) Allows you to search by the city field in Highrise.
	 */
	-(void)setCity:(NSString*)City {
		[super setInput:@"City" toValue:City];
	}

	/*!
	 * Set the value of the Country input for this Choreo.
	*(optional, string) Allows you to search by the country field in Highrise.
	 */
	-(void)setCountry:(NSString*)Country {
		[super setInput:@"Country" toValue:Country];
	}

	/*!
	 * Set the value of the EmailAddress input for this Choreo.
	*(optional, string) Allows you to search by the email address field in Highrise.
	 */
	-(void)setEmailAddress:(NSString*)EmailAddress {
		[super setInput:@"EmailAddress" toValue:EmailAddress];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Highrise account password. Use the value 'X' when specifying an API Key for the Username input.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Phone input for this Choreo.
	*(optional, string) Allows you to search by the phone field in Highrise.
	 */
	-(void)setPhone:(NSString*)Phone {
		[super setInput:@"Phone" toValue:Phone];
	}

	/*!
	 * Set the value of the State input for this Choreo.
	*(optional, string) Allows you to search by the state field in Highrise.
	 */
	-(void)setState:(NSString*)State {
		[super setInput:@"State" toValue:State];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A Highrise account username or API Key.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Zip input for this Choreo.
	*(optional, string) Allows you to search by the ZIP field in Highrise.
	 */
	-(void)setZip:(NSString*)Zip {
		[super setInput:@"Zip" toValue:Zip];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchPeople Choreo.
 */
@implementation TMBHighrise_SearchPeople_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Highrise.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lets you search your Highrise CRM by specifying an email search criteria.
 */
@implementation TMBHighrise_SearchPeople

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBHighrise_SearchPeople Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Highrise/SearchPeople"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBHighrise_SearchPeople_ResultSet *results = [[TMBHighrise_SearchPeople_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the SearchPeople Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBHighrise_SearchPeople_Inputs*)newInputSet {
		return [[TMBHighrise_SearchPeople_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ShowPeople Choreo.
 */
@implementation TMBHighrise_ShowPeople_Inputs

	/*!
	 * Set the value of the AccountName input for this Choreo.
	*(required, string) A Highrise account username or API Key.
	 */
	-(void)setAccountName:(NSString*)AccountName {
		[super setInput:@"AccountName" toValue:AccountName];
	}

	/*!
	 * Set the value of the ConactID input for this Choreo.
	*(required, integer) The ID of the contact you want to retrieve. This is used to construct the URL for the request.
	 */
	-(void)setConactID:(NSString*)ConactID {
		[super setInput:@"ConactID" toValue:ConactID];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Highrise account password. Use the value 'X' when specifying an API Key for the Username input.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A Highrise account username or API Key.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ShowPeople Choreo.
 */
@implementation TMBHighrise_ShowPeople_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Highrise.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves contacts from your Highrise CRM.
 */
@implementation TMBHighrise_ShowPeople

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBHighrise_ShowPeople Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Highrise/ShowPeople"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBHighrise_ShowPeople_ResultSet *results = [[TMBHighrise_ShowPeople_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ShowPeople Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBHighrise_ShowPeople_Inputs*)newInputSet {
		return [[TMBHighrise_ShowPeople_Inputs alloc] init];
	}
@end
	