/*!
 * @header Temboo iOS SDK Basecamp classes
 *
 * Execute Choreographies from the Temboo Basecamp bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBBasecamp.CompleteEntry Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CompleteEntry Choreo.
 */
@interface TMBBasecamp_CompleteEntry_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setEntryID:(NSString*)EntryID;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CompleteEntry Choreo.
 */
@interface TMBBasecamp_CompleteEntry_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Marks a specific calendar entry as completed.
 */
@interface TMBBasecamp_CompleteEntry : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_CompleteEntry_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_CompleteEntry Choreo */


/*! group TMBBasecamp.CompleteItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CompleteItem Choreo.
 */
@interface TMBBasecamp_CompleteItem_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CompleteItem Choreo.
 */
@interface TMBBasecamp_CompleteItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Marks a single, specified item in a To-do list as complete.
 */
@interface TMBBasecamp_CompleteItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_CompleteItem_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_CompleteItem Choreo */


/*! group TMBBasecamp.CreateEntry Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateEntry Choreo.
 */
@interface TMBBasecamp_CreateEntry_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setEndDate:(NSString*)EndDate;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setResponsibleParty:(NSString*)ResponsibleParty;
	-(void)setStartDate:(NSString*)StartDate;
	-(void)setTitle:(NSString*)Title;
	-(void)setType:(NSString*)Type;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateEntry Choreo.
 */
@interface TMBBasecamp_CreateEntry_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new calendar entry in a specified project.
 */
@interface TMBBasecamp_CreateEntry : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_CreateEntry_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_CreateEntry Choreo */


/*! group TMBBasecamp.CreateItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateItem Choreo.
 */
@interface TMBBasecamp_CreateItem_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setContent:(NSString*)Content;
	-(void)setListID:(NSString*)ListID;
	-(void)setPassword:(NSString*)Password;
	-(void)setResponsibleParty:(NSString*)ResponsibleParty;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateItem Choreo.
 */
@interface TMBBasecamp_CreateItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new item for a specified To-do list.
 */
@interface TMBBasecamp_CreateItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_CreateItem_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_CreateItem Choreo */


/*! group TMBBasecamp.CreateList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateList Choreo.
 */
@interface TMBBasecamp_CreateList_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setDescription:(NSString*)Description;
	-(void)setMilestoneID:(NSString*)MilestoneID;
	-(void)setName:(NSString*)Name;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateList Choreo.
 */
@interface TMBBasecamp_CreateList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new To-do list for a specified project.
 */
@interface TMBBasecamp_CreateList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_CreateList_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_CreateList Choreo */


/*! group TMBBasecamp.CreateMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateMessage Choreo.
 */
@interface TMBBasecamp_CreateMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setBody:(NSString*)Body;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectId:(NSString*)ProjectId;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateMessage Choreo.
 */
@interface TMBBasecamp_CreateMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new message under a specified project.
 */
@interface TMBBasecamp_CreateMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_CreateMessage_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_CreateMessage Choreo */


/*! group TMBBasecamp.CreateProject Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateProject Choreo.
 */
@interface TMBBasecamp_CreateProject_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectName:(NSString*)ProjectName;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateProject Choreo.
 */
@interface TMBBasecamp_CreateProject_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new Basecamp project.
 */
@interface TMBBasecamp_CreateProject : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_CreateProject_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_CreateProject Choreo */


/*! group TMBBasecamp.CurrentPerson Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CurrentPerson Choreo.
 */
@interface TMBBasecamp_CurrentPerson_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CurrentPerson Choreo.
 */
@interface TMBBasecamp_CurrentPerson_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information on the person who's credentials are specified.
 */
@interface TMBBasecamp_CurrentPerson : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_CurrentPerson_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_CurrentPerson Choreo */


/*! group TMBBasecamp.DeleteEntry Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteEntry Choreo.
 */
@interface TMBBasecamp_DeleteEntry_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setEntryID:(NSString*)EntryID;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteEntry Choreo.
 */
@interface TMBBasecamp_DeleteEntry_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specific calendar entry in a project you specify.
 */
@interface TMBBasecamp_DeleteEntry : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_DeleteEntry_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_DeleteEntry Choreo */


/*! group TMBBasecamp.DeleteItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteItem Choreo.
 */
@interface TMBBasecamp_DeleteItem_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteItem Choreo.
 */
@interface TMBBasecamp_DeleteItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specified item from a To-do list.
 */
@interface TMBBasecamp_DeleteItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_DeleteItem_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_DeleteItem Choreo */


/*! group TMBBasecamp.DeleteList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteList Choreo.
 */
@interface TMBBasecamp_DeleteList_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setListID:(NSString*)ListID;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteList Choreo.
 */
@interface TMBBasecamp_DeleteList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specified To-do list from a project
 */
@interface TMBBasecamp_DeleteList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_DeleteList_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_DeleteList Choreo */


/*! group TMBBasecamp.GetAllEntries Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllEntries Choreo.
 */
@interface TMBBasecamp_GetAllEntries_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllEntries Choreo.
 */
@interface TMBBasecamp_GetAllEntries_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all calendar entries from a specified project.
 */
@interface TMBBasecamp_GetAllEntries : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetAllEntries_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetAllEntries Choreo */


/*! group TMBBasecamp.GetAllEvents Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllEvents Choreo.
 */
@interface TMBBasecamp_GetAllEvents_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllEvents Choreo.
 */
@interface TMBBasecamp_GetAllEvents_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all calendar events from a specified project.
 */
@interface TMBBasecamp_GetAllEvents : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetAllEvents_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetAllEvents Choreo */


/*! group TMBBasecamp.GetAllListItems Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllListItems Choreo.
 */
@interface TMBBasecamp_GetAllListItems_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setListID:(NSString*)ListID;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllListItems Choreo.
 */
@interface TMBBasecamp_GetAllListItems_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all items in a specified To-do list.
 */
@interface TMBBasecamp_GetAllListItems : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetAllListItems_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetAllListItems Choreo */


/*! group TMBBasecamp.GetAllLists Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllLists Choreo.
 */
@interface TMBBasecamp_GetAllLists_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setResponsibleParty:(NSString*)ResponsibleParty;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllLists Choreo.
 */
@interface TMBBasecamp_GetAllLists_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all To-do lists assigned to a specified user or company.
 */
@interface TMBBasecamp_GetAllLists : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetAllLists_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetAllLists Choreo */


/*! group TMBBasecamp.GetAllMilestones Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllMilestones Choreo.
 */
@interface TMBBasecamp_GetAllMilestones_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllMilestones Choreo.
 */
@interface TMBBasecamp_GetAllMilestones_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all milestones for a specified project.
 */
@interface TMBBasecamp_GetAllMilestones : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetAllMilestones_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetAllMilestones Choreo */


/*! group TMBBasecamp.GetEntry Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetEntry Choreo.
 */
@interface TMBBasecamp_GetEntry_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setEntryID:(NSString*)EntryID;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetEntry Choreo.
 */
@interface TMBBasecamp_GetEntry_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a single calendar entry in a specified project.
 */
@interface TMBBasecamp_GetEntry : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetEntry_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetEntry Choreo */


/*! group TMBBasecamp.GetFiles Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetFiles Choreo.
 */
@interface TMBBasecamp_GetFiles_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFiles Choreo.
 */
@interface TMBBasecamp_GetFiles_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of files (attachments) in a specified project.
 */
@interface TMBBasecamp_GetFiles : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetFiles_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetFiles Choreo */


/*! group TMBBasecamp.GetItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetItem Choreo.
 */
@interface TMBBasecamp_GetItem_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetItem Choreo.
 */
@interface TMBBasecamp_GetItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a single, specified item in a To-do list.
 */
@interface TMBBasecamp_GetItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetItem_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetItem Choreo */


/*! group TMBBasecamp.GetList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetList Choreo.
 */
@interface TMBBasecamp_GetList_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setListID:(NSString*)ListID;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetList Choreo.
 */
@interface TMBBasecamp_GetList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a single To-do list specified by its ID.
 */
@interface TMBBasecamp_GetList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetList_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetList Choreo */


/*! group TMBBasecamp.GetListsInProject Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetListsInProject Choreo.
 */
@interface TMBBasecamp_GetListsInProject_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setFilter:(NSString*)Filter;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetListsInProject Choreo.
 */
@interface TMBBasecamp_GetListsInProject_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of To-do records that are in the given project.
 */
@interface TMBBasecamp_GetListsInProject : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetListsInProject_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetListsInProject Choreo */


/*! group TMBBasecamp.GetMessages Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetMessages Choreo.
 */
@interface TMBBasecamp_GetMessages_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMessages Choreo.
 */
@interface TMBBasecamp_GetMessages_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of messages associated with a specified project.
 */
@interface TMBBasecamp_GetMessages : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetMessages_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetMessages Choreo */


/*! group TMBBasecamp.GetPeopleAcrossProjects Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetPeopleAcrossProjects Choreo.
 */
@interface TMBBasecamp_GetPeopleAcrossProjects_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetPeopleAcrossProjects Choreo.
 */
@interface TMBBasecamp_GetPeopleAcrossProjects_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all people that the logged in user has permission to see.
 */
@interface TMBBasecamp_GetPeopleAcrossProjects : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetPeopleAcrossProjects_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetPeopleAcrossProjects Choreo */


/*! group TMBBasecamp.GetPeopleWithinProject Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetPeopleWithinProject Choreo.
 */
@interface TMBBasecamp_GetPeopleWithinProject_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectId:(NSString*)ProjectId;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetPeopleWithinProject Choreo.
 */
@interface TMBBasecamp_GetPeopleWithinProject_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all people that have access to a specified project.
 */
@interface TMBBasecamp_GetPeopleWithinProject : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetPeopleWithinProject_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetPeopleWithinProject Choreo */


/*! group TMBBasecamp.GetProject Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetProject Choreo.
 */
@interface TMBBasecamp_GetProject_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectId:(NSString*)ProjectId;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetProject Choreo.
 */
@interface TMBBasecamp_GetProject_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves an individual project using a project id that you specify.
 */
@interface TMBBasecamp_GetProject : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetProject_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetProject Choreo */


/*! group TMBBasecamp.GetProjects Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetProjects Choreo.
 */
@interface TMBBasecamp_GetProjects_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetProjects Choreo.
 */
@interface TMBBasecamp_GetProjects_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves active, inactive, and archived projects.
 */
@interface TMBBasecamp_GetProjects : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_GetProjects_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_GetProjects Choreo */


/*! group TMBBasecamp.ProjectCounts Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ProjectCounts Choreo.
 */
@interface TMBBasecamp_ProjectCounts_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ProjectCounts Choreo.
 */
@interface TMBBasecamp_ProjectCounts_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a count of all projects sorted by project status.
 */
@interface TMBBasecamp_ProjectCounts : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_ProjectCounts_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_ProjectCounts Choreo */


/*! group TMBBasecamp.ReorderItems Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ReorderItems Choreo.
 */
@interface TMBBasecamp_ReorderItems_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setFirstItemID:(NSString*)FirstItemID;
	-(void)setListID:(NSString*)ListID;
	-(void)setPassword:(NSString*)Password;
	-(void)setSecondItemID:(NSString*)SecondItemID;
	-(void)setThirdItemID:(NSString*)ThirdItemID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ReorderItems Choreo.
 */
@interface TMBBasecamp_ReorderItems_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Reorders the items in a specified To-do list.
 */
@interface TMBBasecamp_ReorderItems : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_ReorderItems_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_ReorderItems Choreo */


/*! group TMBBasecamp.ReorderLists Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ReorderLists Choreo.
 */
@interface TMBBasecamp_ReorderLists_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setFirstListID:(NSString*)FirstListID;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setSecondListID:(NSString*)SecondListID;
	-(void)setThirdListID:(NSString*)ThirdListID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ReorderLists Choreo.
 */
@interface TMBBasecamp_ReorderLists_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to reorder To-do lists in a specified project.
 */
@interface TMBBasecamp_ReorderLists : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_ReorderLists_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_ReorderLists Choreo */


/*! group TMBBasecamp.UncompleteEntry Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UncompleteEntry Choreo.
 */
@interface TMBBasecamp_UncompleteEntry_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setEntryID:(NSString*)EntryID;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UncompleteEntry Choreo.
 */
@interface TMBBasecamp_UncompleteEntry_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Marks a specific calendar entry as uncompleted.
 */
@interface TMBBasecamp_UncompleteEntry : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_UncompleteEntry_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_UncompleteEntry Choreo */


/*! group TMBBasecamp.UncompleteItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UncompleteItem Choreo.
 */
@interface TMBBasecamp_UncompleteItem_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UncompleteItem Choreo.
 */
@interface TMBBasecamp_UncompleteItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Marks a single, specified item in a To-do list as incomplete.
 */
@interface TMBBasecamp_UncompleteItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_UncompleteItem_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_UncompleteItem Choreo */


/*! group TMBBasecamp.UpdateEntry Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateEntry Choreo.
 */
@interface TMBBasecamp_UpdateEntry_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setEndDate:(NSString*)EndDate;
	-(void)setEntryID:(NSString*)EntryID;
	-(void)setPassword:(NSString*)Password;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setResponsibleParty:(NSString*)ResponsibleParty;
	-(void)setStartDate:(NSString*)StartDate;
	-(void)setTitle:(NSString*)Title;
	-(void)setType:(NSString*)Type;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateEntry Choreo.
 */
@interface TMBBasecamp_UpdateEntry_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getTemplateOutput;
	-(NSString*)getResponse;	
@end

/*!
 * Updates a calendar event or milestone in a project you specify. 
 */
@interface TMBBasecamp_UpdateEntry : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_UpdateEntry_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_UpdateEntry Choreo */


/*! group TMBBasecamp.UpdateItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateItem Choreo.
 */
@interface TMBBasecamp_UpdateItem_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setContent:(NSString*)Content;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setPassword:(NSString*)Password;
	-(void)setResponsibleParty:(NSString*)ResponsibleParty;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateItem Choreo.
 */
@interface TMBBasecamp_UpdateItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new item for a specified To-do list.
 */
@interface TMBBasecamp_UpdateItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_UpdateItem_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_UpdateItem Choreo */


/*! group TMBBasecamp.UpdateList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateList Choreo.
 */
@interface TMBBasecamp_UpdateList_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setDescription:(NSString*)Description;
	-(void)setListID:(NSString*)ListID;
	-(void)setMilestoneID:(NSString*)MilestoneID;
	-(void)setName:(NSString*)Name;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateList Choreo.
 */
@interface TMBBasecamp_UpdateList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Updates a specified To-do list record 
 */
@interface TMBBasecamp_UpdateList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBBasecamp_UpdateList_Inputs*)newInputSet;
@end

/*! group TMBBasecamp_UpdateList Choreo */
