/*!
 * @TMBWolframAlpha.m
 *
 * Execute Choreographies from the Temboo WolframAlpha bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBWolframAlpha.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the GetSearchResult Choreo.
 */
@implementation TMBWolframAlpha_GetSearchResult_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The App ID provided by Wolfram|Alpha.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the Input input for this Choreo.
	*(required, string) Specifies the input string (e.g., "5 largest countries").
	 */
	-(void)setInput:(NSString*)Input {
		[super setInput:@"Input" toValue:Input];
	}

	/*!
	 * Set the value of the Latitude input for this Choreo.
	*(optional, decimal) When query results depend on your location, use this parameter to specify a latitude point.
	 */
	-(void)setLatitude:(NSString*)Latitude {
		[super setInput:@"Latitude" toValue:Latitude];
	}

	/*!
	 * Set the value of the Location input for this Choreo.
	*(optional, string) When query results depend on your location, use this parameter to specify a location such as "Los Angeles, CA", or "Madrid".
	 */
	-(void)setLocation:(NSString*)Location {
		[super setInput:@"Location" toValue:Location];
	}

	/*!
	 * Set the value of the Longitude input for this Choreo.
	*(optional, decimal) When query results depend on your location, use this parameter to specify a longitude point.
	 */
	-(void)setLongitude:(NSString*)Longitude {
		[super setInput:@"Longitude" toValue:Longitude];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format for the response. Valid values are JSON and XML. This will be ignored when providng an XPath query because results are returned as a string or JSON depending on the Mode specified.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the Translation input for this Choreo.
	*(optional, boolean) Whether to allow Wolfram Alpha to try to translate simple queries into English. Defaults to true.
	 */
	-(void)setTranslation:(NSString*)Translation {
		[super setInput:@"Translation" toValue:Translation];
	}

	/*!
	 * Set the value of the Units input for this Choreo.
	*(optional, string) Lets you specify the preferred measurement system, either "metric" or "nonmetric" (U.S. customary units).
	 */
	-(void)setUnits:(NSString*)Units {
		[super setInput:@"Units" toValue:Units];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSearchResult Choreo.
 */
@implementation TMBWolframAlpha_GetSearchResult_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Result" output from an execution of this Choreo.
	 * @return - NSString* (string) The plain text result parsed from the Wolfram Alpha response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResult {
		return [super getOutputByName:@"Result"];
	}
	
@end

/*!
 * Allows your application to submit a query to Wolfram|Alpha and return only the plain text from the first result pod.
 */
@implementation TMBWolframAlpha_GetSearchResult

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBWolframAlpha_GetSearchResult Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/WolframAlpha/GetSearchResult"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBWolframAlpha_GetSearchResult_ResultSet *results = [[TMBWolframAlpha_GetSearchResult_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetSearchResult Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBWolframAlpha_GetSearchResult_Inputs*)newInputSet {
		return [[TMBWolframAlpha_GetSearchResult_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the Query Choreo.
 */
@implementation TMBWolframAlpha_Query_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The App ID provided by Wolfram|Alpha.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the Assumption input for this Choreo.
	*(optional, string) Up to 10 comma-seperated assumptions to narrow a query.  Wolfram|Alpha provides you with a list of assumptons in the response of a previous query.  Please consult the documentation for more details.
	 */
	-(void)setAssumption:(NSString*)Assumption {
		[super setInput:@"Assumption" toValue:Assumption];
	}

	/*!
	 * Set the value of the Async input for this Choreo.
	*(optional, boolean) Set to true to specify that asynchronous mode should be used. This allows partial results to come back before all the pods are computed.
	 */
	-(void)setAsync:(NSString*)Async {
		[super setInput:@"Async" toValue:Async];
	}

	/*!
	 * Set the value of the ExcludePodID input for this Choreo.
	*(optional, string) Specifies the IDs of the pod(s) to exlude from the response. All pod IDs are returned by default.
	 */
	-(void)setExcludePodID:(NSString*)ExcludePodID {
		[super setInput:@"ExcludePodID" toValue:ExcludePodID];
	}

	/*!
	 * Set the value of the Format input for this Choreo.
	*(optional, string) The desired result formats separated by commas. Valid values are image, plaintext, minput, moutput, cell, mathml, imagemap, sound, wav. Defaults to "plaintext,image".
	 */
	-(void)setFormat:(NSString*)Format {
		[super setInput:@"Format" toValue:Format];
	}

	/*!
	 * Set the value of the FormatTimeout input for this Choreo.
	*(optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "format" stage for the entire collection of pods. Default value is 8.0.
	 */
	-(void)setFormatTimeout:(NSString*)FormatTimeout {
		[super setInput:@"FormatTimeout" toValue:FormatTimeout];
	}

	/*!
	 * Set the value of the IgnoreCase input for this Choreo.
	*(optional, boolean) Whether to force Wolfram Alpha to ignore case in queries. Defaults to false.
	 */
	-(void)setIgnoreCase:(NSString*)IgnoreCase {
		[super setInput:@"IgnoreCase" toValue:IgnoreCase];
	}

	/*!
	 * Set the value of the IncludePodID input for this Choreo.
	*(optional, string) Specifies the IDs of the pod(s) to include in the response. All pod IDs are returned by default.
	 */
	-(void)setIncludePodID:(NSString*)IncludePodID {
		[super setInput:@"IncludePodID" toValue:IncludePodID];
	}

	/*!
	 * Set the value of the Input input for this Choreo.
	*(required, string) Specifies the input string (e.g., "5 largest countries").
	 */
	-(void)setInput:(NSString*)Input {
		[super setInput:@"Input" toValue:Input];
	}

	/*!
	 * Set the value of the Latitude input for this Choreo.
	*(optional, decimal) When query results depend on your location, use this parameter to specify a latitude point.
	 */
	-(void)setLatitude:(NSString*)Latitude {
		[super setInput:@"Latitude" toValue:Latitude];
	}

	/*!
	 * Set the value of the Location input for this Choreo.
	*(optional, string) When query results depend on your location, use this parameter to specify a location such as "Los Angeles, CA", or "Madrid".
	 */
	-(void)setLocation:(NSString*)Location {
		[super setInput:@"Location" toValue:Location];
	}

	/*!
	 * Set the value of the Longitude input for this Choreo.
	*(optional, decimal) When query results depend on your location, use this parameter to specify a longitude point.
	 */
	-(void)setLongitude:(NSString*)Longitude {
		[super setInput:@"Longitude" toValue:Longitude];
	}

	/*!
	 * Set the value of the Magnification input for this Choreo.
	*(optional, decimal) Controls the magnification of pod images. The default value is 1.0, indicating no magnification.
	 */
	-(void)setMagnification:(NSString*)Magnification {
		[super setInput:@"Magnification" toValue:Magnification];
	}

	/*!
	 * Set the value of the MaxWidth input for this Choreo.
	*(optional, integer) Used to change the default width of pod images. Width and MaxWidth apply to images of text and tables. This can be used to avoid undesirable line breaks if the value of Width is too small.
	 */
	-(void)setMaxWidth:(NSString*)MaxWidth {
		[super setInput:@"MaxWidth" toValue:MaxWidth];
	}

	/*!
	 * Set the value of the ParseTimeout input for this Choreo.
	*(optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "parsing" stage of processing. Default value is 5.0.
	 */
	-(void)setParseTimeout:(NSString*)ParseTimeout {
		[super setInput:@"ParseTimeout" toValue:ParseTimeout];
	}

	/*!
	 * Set the value of the PlotWidth input for this Choreo.
	*(optional, integer) Controls the width at which plots and graphics are rendered. The default value is 200 pixels.
	 */
	-(void)setPlotWidth:(NSString*)PlotWidth {
		[super setInput:@"PlotWidth" toValue:PlotWidth];
	}

	/*!
	 * Set the value of the PodIndex input for this Choreo.
	*(optional, string) Specifies the index of the pod(s) to return. This is an alternative to specifying pods by title or ID. You can give a single number or a sequence like "2,3,5".
	 */
	-(void)setPodIndex:(NSString*)PodIndex {
		[super setInput:@"PodIndex" toValue:PodIndex];
	}

	/*!
	 * Set the value of the PodState input for this Choreo.
	*(optional, string) Specifies a pod state change, which replaces a pod with a modified version, such as a switch from Imperial to metric units.
	 */
	-(void)setPodState:(NSString*)PodState {
		[super setInput:@"PodState" toValue:PodState];
	}

	/*!
	 * Set the value of the PodTimeout input for this Choreo.
	*(optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "format" stage for any one pod. Default value is 4.0.
	 */
	-(void)setPodTimeout:(NSString*)PodTimeout {
		[super setInput:@"PodTimeout" toValue:PodTimeout];
	}

	/*!
	 * Set the value of the PodTitle input for this Choreo.
	*(optional, string) Specifies the titles of the pod(s) to include in the response. All pod titles are returned by default. You can use * as a wildcard to match zero or more characters in pod titles.
	 */
	-(void)setPodTitle:(NSString*)PodTitle {
		[super setInput:@"PodTitle" toValue:PodTitle];
	}

	/*!
	 * Set the value of the Reinterpret input for this Choreo.
	*(optional, boolean) Whether to allow Wolfram Alpha to reinterpret queries that would otherwise not be understood. Defaults to false.
	 */
	-(void)setReinterpret:(NSString*)Reinterpret {
		[super setInput:@"Reinterpret" toValue:Reinterpret];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format for the response. Valid values are JSON and XML. This will be ignored when providng an XPath query because results are returned as a string or JSON depending on the Mode specified.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ScanTimeout input for this Choreo.
	*(optional, decimal) The number of seconds to allow Wolfram Alpha to compute results in the "scan" stage of processing. Default value is 3.0.
	 */
	-(void)setScanTimeout:(NSString*)ScanTimeout {
		[super setInput:@"ScanTimeout" toValue:ScanTimeout];
	}

	/*!
	 * Set the value of the Scanner input for this Choreo.
	*(optional, string) Specifies that only pods produced by the given scanner should be returned. (e.g. Numeric, Music).  Defaults to all pods.
	 */
	-(void)setScanner:(NSString*)Scanner {
		[super setInput:@"Scanner" toValue:Scanner];
	}

	/*!
	 * Set the value of the Translation input for this Choreo.
	*(optional, boolean) Whether to allow Wolfram Alpha to try to translate simple queries into English. Defaults to true.
	 */
	-(void)setTranslation:(NSString*)Translation {
		[super setInput:@"Translation" toValue:Translation];
	}

	/*!
	 * Set the value of the Units input for this Choreo.
	*(optional, string) Lets you specify the preferred measurement system, either "metric" or "nonmetric" (U.S. customary units).
	 */
	-(void)setUnits:(NSString*)Units {
		[super setInput:@"Units" toValue:Units];
	}

	/*!
	 * Set the value of the Width input for this Choreo.
	*(optional, integer) Used to change the default width of pod images. The default is 500 pixels. Width and MaxWidth apply to images of text and tables.
	 */
	-(void)setWidth:(NSString*)Width {
		[super setInput:@"Width" toValue:Width];
	}

	/*!
	 * Set the value of the XPath input for this Choreo.
	*(optional, string) An XPath query to apply to the API results.
	 */
	-(void)setXPath:(NSString*)XPath {
		[super setInput:@"XPath" toValue:XPath];
	}

	/*!
	 * Set the value of the XPathMode input for this Choreo.
	*(optional, string) Valid values are "select" (the default) or "recursive". Recursive mode will iterate using the provided XPath. Select mode will return the first match at the position indicated by the provided XPath.
	 */
	-(void)setXPathMode:(NSString*)XPathMode {
		[super setInput:@"XPathMode" toValue:XPathMode];
	}

	/*!
	 * Set the value of the XPathRegex input for this Choreo.
	*(optional, string) A regular expression that can be applied to the result of the XPath query provided.
	 */
	-(void)setXPathRegex:(NSString*)XPathRegex {
		[super setInput:@"XPathRegex" toValue:XPathRegex];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Query Choreo.
 */
@implementation TMBWolframAlpha_Query_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Wolfram Alpha.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows your application to submit free-form queries similar to the queries one might enter at the Wolfram|Alpha website.
 */
@implementation TMBWolframAlpha_Query

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBWolframAlpha_Query Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/WolframAlpha/Query"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBWolframAlpha_Query_ResultSet *results = [[TMBWolframAlpha_Query_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the Query Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBWolframAlpha_Query_Inputs*)newInputSet {
		return [[TMBWolframAlpha_Query_Inputs alloc] init];
	}
@end
	