/*!
 * @header Temboo iOS SDK WolframAlpha classes
 *
 * Execute Choreographies from the Temboo WolframAlpha bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBWolframAlpha.GetSearchResult Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetSearchResult Choreo.
 */
@interface TMBWolframAlpha_GetSearchResult_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setInput:(NSString*)Input;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLocation:(NSString*)Location;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTranslation:(NSString*)Translation;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSearchResult Choreo.
 */
@interface TMBWolframAlpha_GetSearchResult_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResult;	
@end

/*!
 * Allows your application to submit a query to Wolfram|Alpha and return only the plain text from the first result pod.
 */
@interface TMBWolframAlpha_GetSearchResult : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWolframAlpha_GetSearchResult_Inputs*)newInputSet;
@end

/*! group TMBWolframAlpha_GetSearchResult Choreo */


/*! group TMBWolframAlpha.Query Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Query Choreo.
 */
@interface TMBWolframAlpha_Query_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setAssumption:(NSString*)Assumption;
	-(void)setAsync:(NSString*)Async;
	-(void)setExcludePodID:(NSString*)ExcludePodID;
	-(void)setFormat:(NSString*)Format;
	-(void)setFormatTimeout:(NSString*)FormatTimeout;
	-(void)setIgnoreCase:(NSString*)IgnoreCase;
	-(void)setIncludePodID:(NSString*)IncludePodID;
	-(void)setInput:(NSString*)Input;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLocation:(NSString*)Location;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setMagnification:(NSString*)Magnification;
	-(void)setMaxWidth:(NSString*)MaxWidth;
	-(void)setParseTimeout:(NSString*)ParseTimeout;
	-(void)setPlotWidth:(NSString*)PlotWidth;
	-(void)setPodIndex:(NSString*)PodIndex;
	-(void)setPodState:(NSString*)PodState;
	-(void)setPodTimeout:(NSString*)PodTimeout;
	-(void)setPodTitle:(NSString*)PodTitle;
	-(void)setReinterpret:(NSString*)Reinterpret;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setScanTimeout:(NSString*)ScanTimeout;
	-(void)setScanner:(NSString*)Scanner;
	-(void)setTranslation:(NSString*)Translation;
	-(void)setUnits:(NSString*)Units;
	-(void)setWidth:(NSString*)Width;
	-(void)setXPath:(NSString*)XPath;
	-(void)setXPathMode:(NSString*)XPathMode;
	-(void)setXPathRegex:(NSString*)XPathRegex;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Query Choreo.
 */
@interface TMBWolframAlpha_Query_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows your application to submit free-form queries similar to the queries one might enter at the Wolfram|Alpha website.
 */
@interface TMBWolframAlpha_Query : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWolframAlpha_Query_Inputs*)newInputSet;
@end

/*! group TMBWolframAlpha_Query Choreo */
