/*!
 * @TMBMicrosoft.m
 *
 * Execute Choreographies from the Temboo Microsoft bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBMicrosoft.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRange Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_DeleteRange_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Range input for this Choreo.
	*(conditional, string) A cell ange to delete (e.g. A1:B2).
	 */
	-(void)setRange:(NSString*)Range {
		[super setInput:@"Range" toValue:Range];
	}

	/*!
	 * Set the value of the Shift input for this Choreo.
	*(required, string) Specifies which way to shift the cells.  Possible values are: Up, Left.
	 */
	-(void)setShift:(NSString*)Shift {
		[super setInput:@"Shift" toValue:Shift];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRange Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_DeleteRange_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ResponseCode" output from an execution of this Choreo.
	 * @return - NSString* (integer) The response status code. A 204 is returned for a successful deletion.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponseCode {
		return [super getOutputByName:@"ResponseCode"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the cells associated with the range.
 */
@implementation TMBMicrosoft_Excel_Range_DeleteRange

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Range_DeleteRange Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Range/DeleteRange"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Range_DeleteRange_ResultSet *results = [[TMBMicrosoft_Excel_Range_DeleteRange_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteRange Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Range_DeleteRange_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Range_DeleteRange_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLastCell Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_GetLastCell_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Range input for this Choreo.
	*(conditional, string) The cell range to consider (e.g. A1:C100).
	 */
	-(void)setRange:(NSString*)Range {
		[super setInput:@"Range" toValue:Range];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLastCell Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_GetLastCell_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the last cell within a specified range.
 */
@implementation TMBMicrosoft_Excel_Range_GetLastCell

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Range_GetLastCell Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Range/GetLastCell"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Range_GetLastCell_ResultSet *results = [[TMBMicrosoft_Excel_Range_GetLastCell_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLastCell Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Range_GetLastCell_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Range_GetLastCell_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLastColumn Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_GetLastColumn_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Range input for this Choreo.
	*(conditional, string) The cell range to consider (e.g. A1:C100).
	 */
	-(void)setRange:(NSString*)Range {
		[super setInput:@"Range" toValue:Range];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLastColumn Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_GetLastColumn_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the last column within a specified range.
 */
@implementation TMBMicrosoft_Excel_Range_GetLastColumn

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Range_GetLastColumn Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Range/GetLastColumn"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Range_GetLastColumn_ResultSet *results = [[TMBMicrosoft_Excel_Range_GetLastColumn_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLastColumn Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Range_GetLastColumn_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Range_GetLastColumn_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLastRow Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_GetLastRow_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Range input for this Choreo.
	*(conditional, string) The cell range to consider (e.g. A1:C100).
	 */
	-(void)setRange:(NSString*)Range {
		[super setInput:@"Range" toValue:Range];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLastRow Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_GetLastRow_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the last row within a specified range.
 */
@implementation TMBMicrosoft_Excel_Range_GetLastRow

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Range_GetLastRow Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Range/GetLastRow"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Range_GetLastRow_ResultSet *results = [[TMBMicrosoft_Excel_Range_GetLastRow_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLastRow Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Range_GetLastRow_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Range_GetLastRow_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetRange Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_GetRange_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Range input for this Choreo.
	*(conditional, string) A range to return (e.g. A1:B2).
	 */
	-(void)setRange:(NSString*)Range {
		[super setInput:@"Range" toValue:Range];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRange Choreo.
 */
@implementation TMBMicrosoft_Excel_Range_GetRange_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the properties and relationships of range object.
 */
@implementation TMBMicrosoft_Excel_Range_GetRange

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Range_GetRange Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Range/GetRange"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Range_GetRange_ResultSet *results = [[TMBMicrosoft_Excel_Range_GetRange_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetRange Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Range_GetRange_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Range_GetRange_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateTableRow Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_CreateTableRow_Inputs

	/*!
	 * Set the value of the Values input for this Choreo.
	*(required, json) This is an array of arrays. The outer array can represent one or more rows while the inner array can represent one or more cell values. See Choreo notes below for more details.
	 */
	-(void)setValues:(NSString*)Values {
		[super setInput:@"Values" toValue:Values];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Index input for this Choreo.
	*(optional, integer) Indicates that the row should be created at this index.
	 */
	-(void)setIndex:(NSString*)Index {
		[super setInput:@"Index" toValue:Index];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Table input for this Choreo.
	*(required, string) The name or id of the table to write to (e.g. Table1).
	 */
	-(void)setTable:(NSString*)Table {
		[super setInput:@"Table" toValue:Table];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet to write to (e.g. Sheet1).
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateTableRow Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_CreateTableRow_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates new rows in a table.
 */
@implementation TMBMicrosoft_Excel_Table_CreateTableRow

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Table_CreateTableRow Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Table/CreateTableRow"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Table_CreateTableRow_ResultSet *results = [[TMBMicrosoft_Excel_Table_CreateTableRow_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateTableRow Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Table_CreateTableRow_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Table_CreateTableRow_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DataBodyRange Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_DataBodyRange_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Table input for this Choreo.
	*(required, string) The name or id of the table.
	 */
	-(void)setTable:(NSString*)Table {
		[super setInput:@"Table" toValue:Table];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DataBodyRange Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_DataBodyRange_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Gets the range object associated with the data body of the table.
 */
@implementation TMBMicrosoft_Excel_Table_DataBodyRange

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Table_DataBodyRange Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Table/DataBodyRange"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Table_DataBodyRange_ResultSet *results = [[TMBMicrosoft_Excel_Table_DataBodyRange_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DataBodyRange Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Table_DataBodyRange_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Table_DataBodyRange_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRow Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_DeleteRow_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Index input for this Choreo.
	*(required, integer) The index of the row that should be deleted.
	 */
	-(void)setIndex:(NSString*)Index {
		[super setInput:@"Index" toValue:Index];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Table input for this Choreo.
	*(required, string) The name or id of the table.
	 */
	-(void)setTable:(NSString*)Table {
		[super setInput:@"Table" toValue:Table];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRow Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_DeleteRow_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ResponseCode" output from an execution of this Choreo.
	 * @return - NSString* (integer) The response status code. A 204 is returned for a successful deletion.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponseCode {
		return [super getOutputByName:@"ResponseCode"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the row from the table.
 */
@implementation TMBMicrosoft_Excel_Table_DeleteRow

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Table_DeleteRow Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Table/DeleteRow"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Table_DeleteRow_ResultSet *results = [[TMBMicrosoft_Excel_Table_DeleteRow_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteRow Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Table_DeleteRow_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Table_DeleteRow_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetRow Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_GetRow_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Index input for this Choreo.
	*(required, integer) The index of the row that should be returned. If left empty, the last row in the table will be returned.
	 */
	-(void)setIndex:(NSString*)Index {
		[super setInput:@"Index" toValue:Index];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Table input for this Choreo.
	*(required, string) The name or id of the table.
	 */
	-(void)setTable:(NSString*)Table {
		[super setInput:@"Table" toValue:Table];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRow Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_GetRow_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieve the properties and relationships of tablerow object.
 */
@implementation TMBMicrosoft_Excel_Table_GetRow

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Table_GetRow Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Table/GetRow"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Table_GetRow_ResultSet *results = [[TMBMicrosoft_Excel_Table_GetRow_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetRow Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Table_GetRow_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Table_GetRow_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListColumns Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_ListColumns_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Skip input for this Choreo.
	*(optional, integer) The number of items to skip in a result set.
	 */
	-(void)setSkip:(NSString*)Skip {
		[super setInput:@"Skip" toValue:Skip];
	}

	/*!
	 * Set the value of the Table input for this Choreo.
	*(required, string) The name or id of the table.
	 */
	-(void)setTable:(NSString*)Table {
		[super setInput:@"Table" toValue:Table];
	}

	/*!
	 * Set the value of the Top input for this Choreo.
	*(optional, integer) The number of items to return in a result set.
	 */
	-(void)setTop:(NSString*)Top {
		[super setInput:@"Top" toValue:Top];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListColumns Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_ListColumns_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieve a list of tablecolumn objects.
 */
@implementation TMBMicrosoft_Excel_Table_ListColumns

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Table_ListColumns Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Table/ListColumns"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Table_ListColumns_ResultSet *results = [[TMBMicrosoft_Excel_Table_ListColumns_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListColumns Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Table_ListColumns_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Table_ListColumns_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListRows Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_ListRows_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Skip input for this Choreo.
	*(optional, integer) The number of items to skip in a result set.
	 */
	-(void)setSkip:(NSString*)Skip {
		[super setInput:@"Skip" toValue:Skip];
	}

	/*!
	 * Set the value of the Table input for this Choreo.
	*(required, string) The name or id of the table.
	 */
	-(void)setTable:(NSString*)Table {
		[super setInput:@"Table" toValue:Table];
	}

	/*!
	 * Set the value of the Top input for this Choreo.
	*(optional, integer) The number of items to return in a result set.
	 */
	-(void)setTop:(NSString*)Top {
		[super setInput:@"Top" toValue:Top];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListRows Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_ListRows_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieve a list of tablerow objects.
 */
@implementation TMBMicrosoft_Excel_Table_ListRows

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Table_ListRows Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Table/ListRows"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Table_ListRows_ResultSet *results = [[TMBMicrosoft_Excel_Table_ListRows_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListRows Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Table_ListRows_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Table_ListRows_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListTables Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_ListTables_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Skip input for this Choreo.
	*(optional, integer) The number of items to skip in a result set.
	 */
	-(void)setSkip:(NSString*)Skip {
		[super setInput:@"Skip" toValue:Skip];
	}

	/*!
	 * Set the value of the Top input for this Choreo.
	*(optional, integer) The number of items to return in a result set.
	 */
	-(void)setTop:(NSString*)Top {
		[super setInput:@"Top" toValue:Top];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTables Choreo.
 */
@implementation TMBMicrosoft_Excel_Table_ListTables_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves a list of tables.
 */
@implementation TMBMicrosoft_Excel_Table_ListTables

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Table_ListTables Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Table/ListTables"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Table_ListTables_ResultSet *results = [[TMBMicrosoft_Excel_Table_ListTables_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListTables Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Table_ListTables_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Table_ListTables_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the InvokeFunction Choreo.
 */
@implementation TMBMicrosoft_Excel_Workbook_InvokeFunction_Inputs

	/*!
	 * Set the value of the Arguments input for this Choreo.
	*(required, json) A JSON object containing the function arguments. See Choreo notes for more details.
	 */
	-(void)setArguments:(NSString*)Arguments {
		[super setInput:@"Arguments" toValue:Arguments];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Function input for this Choreo.
	*(required, string) The name of the function (e.g. vlookup).
	 */
	-(void)setFunction:(NSString*)Function {
		[super setInput:@"Function" toValue:Function];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InvokeFunction Choreo.
 */
@implementation TMBMicrosoft_Excel_Workbook_InvokeFunction_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Invokes a workbook function.
 */
@implementation TMBMicrosoft_Excel_Workbook_InvokeFunction

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Workbook_InvokeFunction Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Workbook/InvokeFunction"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Workbook_InvokeFunction_ResultSet *results = [[TMBMicrosoft_Excel_Workbook_InvokeFunction_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the InvokeFunction Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Workbook_InvokeFunction_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Workbook_InvokeFunction_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddWorksheet Choreo.
 */
@implementation TMBMicrosoft_Excel_Worksheet_AddWorksheet_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name of the new worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddWorksheet Choreo.
 */
@implementation TMBMicrosoft_Excel_Worksheet_AddWorksheet_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds a new worksheet to the workbook.
 */
@implementation TMBMicrosoft_Excel_Worksheet_AddWorksheet

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Worksheet_AddWorksheet Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Worksheet/AddWorksheet"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Worksheet_AddWorksheet_ResultSet *results = [[TMBMicrosoft_Excel_Worksheet_AddWorksheet_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddWorksheet Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Worksheet_AddWorksheet_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Worksheet_AddWorksheet_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetWorksheet Choreo.
 */
@implementation TMBMicrosoft_Excel_Worksheet_GetWorksheet_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the Worksheet input for this Choreo.
	*(required, string) The name or id of the worksheet.
	 */
	-(void)setWorksheet:(NSString*)Worksheet {
		[super setInput:@"Worksheet" toValue:Worksheet];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetWorksheet Choreo.
 */
@implementation TMBMicrosoft_Excel_Worksheet_GetWorksheet_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieve the properties and relationships of worksheet object.
 */
@implementation TMBMicrosoft_Excel_Worksheet_GetWorksheet

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Worksheet_GetWorksheet Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Worksheet/GetWorksheet"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Worksheet_GetWorksheet_ResultSet *results = [[TMBMicrosoft_Excel_Worksheet_GetWorksheet_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetWorksheet Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Worksheet_GetWorksheet_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Worksheet_GetWorksheet_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListWorksheets Choreo.
 */
@implementation TMBMicrosoft_Excel_Worksheet_ListWorksheets_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ItemPath input for this Choreo.
	*(required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).
	 */
	-(void)setItemPath:(NSString*)ItemPath {
		[super setInput:@"ItemPath" toValue:ItemPath];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) Comma-separated list of properties to include in the response.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the Skip input for this Choreo.
	*(optional, integer) The number of items to skip in a result set.
	 */
	-(void)setSkip:(NSString*)Skip {
		[super setInput:@"Skip" toValue:Skip];
	}

	/*!
	 * Set the value of the Top input for this Choreo.
	*(optional, integer) The number of items to return in a result set.
	 */
	-(void)setTop:(NSString*)Top {
		[super setInput:@"Top" toValue:Top];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListWorksheets Choreo.
 */
@implementation TMBMicrosoft_Excel_Worksheet_ListWorksheets_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieve a list of worksheet objects.
 */
@implementation TMBMicrosoft_Excel_Worksheet_ListWorksheets

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Excel_Worksheet_ListWorksheets Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Excel/Worksheet/ListWorksheets"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Excel_Worksheet_ListWorksheets_ResultSet *results = [[TMBMicrosoft_Excel_Worksheet_ListWorksheets_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListWorksheets Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Excel_Worksheet_ListWorksheets_Inputs*)newInputSet {
		return [[TMBMicrosoft_Excel_Worksheet_ListWorksheets_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FinalizeOAuth Choreo.
 */
@implementation TMBMicrosoft_OAuth_FinalizeOAuth_Inputs

	/*!
	 * Set the value of the CallbackID input for this Choreo.
	*(required, string) The callback token returned by the InitializeOAuth Choreo. Used to retrieve the authorization code after the user authorizes.
	 */
	-(void)setCallbackID:(NSString*)CallbackID {
		[super setInput:@"CallbackID" toValue:CallbackID];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(required, string) The Client ID provided by Microsoft after registering your application.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(required, string) The Client Secret provided by Microsoft after registering your application.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Resource input for this Choreo.
	*(conditional, string) The App ID URI of the web API (secured resource). See Choreo notes for details.
	 */
	-(void)setResource:(NSString*)Resource {
		[super setInput:@"Resource" toValue:Resource];
	}

	/*!
	 * Set the value of the SuppressErrors input for this Choreo.
	*(optional, boolean) When set to true, errors received during the OAuth redirect process will be suppressed and returned in the ErrorMessage output.
	 */
	-(void)setSuppressErrors:(NSString*)SuppressErrors {
		[super setInput:@"SuppressErrors" toValue:SuppressErrors];
	}

	/*!
	 * Set the value of the Timeout input for this Choreo.
	*(optional, integer) The amount of time (in seconds) to poll your Temboo callback URL to see if your app's user has allowed or denied the request for access. Defaults to 20. Max is 60.
	 */
	-(void)setTimeout:(NSString*)Timeout {
		[super setInput:@"Timeout" toValue:Timeout];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FinalizeOAuth Choreo.
 */
@implementation TMBMicrosoft_OAuth_FinalizeOAuth_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ErrorMessage" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains an error message if an error occurs during the OAuth redirect process and if SuppressErrors is set to true.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getErrorMessage {
		return [super getOutputByName:@"ErrorMessage"];
	}

	/*!
	 * Retrieve the value of the "Expires" output from an execution of this Choreo.
	 * @return - NSString* (integer) The remaining lifetime of the short-lived access token.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpires {
		return [super getOutputByName:@"Expires"];
	}

	/*!
	 * Retrieve the value of the "RefreshToken" output from an execution of this Choreo.
	 * @return - NSString* (string) A token that may be used to obtain a new access token when the short-lived access token expires.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getRefreshToken {
		return [super getOutputByName:@"RefreshToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Completes the OAuth process by retrieving Microsoft OAuth tokens for a user, after they have visited the authorization URL returned by the InitializeOAuth Choreo and clicked "allow."
 */
@implementation TMBMicrosoft_OAuth_FinalizeOAuth

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_OAuth_FinalizeOAuth Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/OAuth/FinalizeOAuth"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_OAuth_FinalizeOAuth_ResultSet *results = [[TMBMicrosoft_OAuth_FinalizeOAuth_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FinalizeOAuth Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_OAuth_FinalizeOAuth_Inputs*)newInputSet {
		return [[TMBMicrosoft_OAuth_FinalizeOAuth_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the InitializeOAuth Choreo.
 */
@implementation TMBMicrosoft_OAuth_InitializeOAuth_Inputs

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(required, string) The Client ID provided by Microsoft after registering your application.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the CustomCallbackID input for this Choreo.
	*(optional, string) A unique identifier that you can pass to eliminate the need to wait for a Temboo generated CallbackID. Callback identifiers may only contain numbers, letters, periods, and hyphens.
	 */
	-(void)setCustomCallbackID:(NSString*)CustomCallbackID {
		[super setInput:@"CustomCallbackID" toValue:CustomCallbackID];
	}

	/*!
	 * Set the value of the DomainHint input for this Choreo.
	*(optional, string) Provides a hint about the tenant or domain that the user should use to sign in.
	 */
	-(void)setDomainHint:(NSString*)DomainHint {
		[super setInput:@"DomainHint" toValue:DomainHint];
	}

	/*!
	 * Set the value of the ForwardingURL input for this Choreo.
	*(optional, string) The URL that Temboo will redirect your users to after they grant access to your application. This should include the "https://" or "http://" prefix and be a fully qualified URL.
	 */
	-(void)setForwardingURL:(NSString*)ForwardingURL {
		[super setInput:@"ForwardingURL" toValue:ForwardingURL];
	}

	/*!
	 * Set the value of the LoginHint input for this Choreo.
	*(optional, string) Provides a hint to the user on the sign-in page.
	 */
	-(void)setLoginHint:(NSString*)LoginHint {
		[super setInput:@"LoginHint" toValue:LoginHint];
	}

	/*!
	 * Set the value of the Prompt input for this Choreo.
	*(optional, string) Indicate the type of user interaction that is required. Valid values are: login, consent, admin_consent.
	 */
	-(void)setPrompt:(NSString*)Prompt {
		[super setInput:@"Prompt" toValue:Prompt];
	}

	/*!
	 * Set the value of the Resource input for this Choreo.
	*(conditional, string) The App ID URI of the web API (secured resource). See Choreo notes for details.
	 */
	-(void)setResource:(NSString*)Resource {
		[super setInput:@"Resource" toValue:Resource];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InitializeOAuth Choreo.
 */
@implementation TMBMicrosoft_OAuth_InitializeOAuth_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "AuthorizationURL" output from an execution of this Choreo.
	 * @return - NSString* (string) The authorization URL that the application's user needs to go to in order to grant access to your application.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getAuthorizationURL {
		return [super getOutputByName:@"AuthorizationURL"];
	}

	/*!
	 * Retrieve the value of the "CallbackID" output from an execution of this Choreo.
	 * @return - NSString* (string) An ID used to retrieve the callback data that Temboo stores once your application's user authorizes.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getCallbackID {
		return [super getOutputByName:@"CallbackID"];
	}
	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 */
@implementation TMBMicrosoft_OAuth_InitializeOAuth

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_OAuth_InitializeOAuth Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/OAuth/InitializeOAuth"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_OAuth_InitializeOAuth_ResultSet *results = [[TMBMicrosoft_OAuth_InitializeOAuth_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the InitializeOAuth Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_OAuth_InitializeOAuth_Inputs*)newInputSet {
		return [[TMBMicrosoft_OAuth_InitializeOAuth_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RefreshToken Choreo.
 */
@implementation TMBMicrosoft_OAuth_RefreshToken_Inputs

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(required, string) The Client ID provided by Microsoft after registering your application.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(required, string) The Client Secret provided by Microsoft after registering your application.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(required, string) An OAuth Refresh Token used to generate a new access token when the original token is expired.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}

	/*!
	 * Set the value of the Resource input for this Choreo.
	*(conditional, string) The App ID URI of the web API (secured resource). See Choreo notes for details.
	 */
	-(void)setResource:(NSString*)Resource {
		[super setInput:@"Resource" toValue:Resource];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RefreshToken Choreo.
 */
@implementation TMBMicrosoft_OAuth_RefreshToken_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Expires" output from an execution of this Choreo.
	 * @return - NSString* (integer) The remaining lifetime of the short-lived access token.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpires {
		return [super getOutputByName:@"Expires"];
	}

	/*!
	 * Retrieve the value of the "NewRefreshToken" output from an execution of this Choreo.
	 * @return - NSString* (string) The new Refresh Token which can be used the next time your app needs to get a new Access Token.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewRefreshToken {
		return [super getOutputByName:@"NewRefreshToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves a new refresh token and access token by exchanging the refresh token that is associated with the expired access token.
 */
@implementation TMBMicrosoft_OAuth_RefreshToken

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_OAuth_RefreshToken Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/OAuth/RefreshToken"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_OAuth_RefreshToken_ResultSet *results = [[TMBMicrosoft_OAuth_RefreshToken_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RefreshToken Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_OAuth_RefreshToken_Inputs*)newInputSet {
		return [[TMBMicrosoft_OAuth_RefreshToken_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddRow Choreo.
 */
@implementation TMBMicrosoft_PowerBI_AddRow_Inputs

	/*!
	 * Set the value of the Rows input for this Choreo.
	*(required, json) A JSON object contain one or more rows to insert into a Power BI table. See Choreo notes for formatting details.
	 */
	-(void)setRows:(NSString*)Rows {
		[super setInput:@"Rows" toValue:Rows];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Power BI users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the DatasetID input for this Choreo.
	*(required, string) The ID of the dataset that your table belongs to.
	 */
	-(void)setDatasetID:(NSString*)DatasetID {
		[super setInput:@"DatasetID" toValue:DatasetID];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Power BI password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the Power BI table to insert a row into.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Power BI username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddRow Choreo.
 */
@implementation TMBMicrosoft_PowerBI_AddRow_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ResponseCode" output from an execution of this Choreo.
	 * @return - NSString* (integer) The response status code returned from Power BI.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponseCode {
		return [super getOutputByName:@"ResponseCode"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Power BI.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds rows to a table in a dataset
 */
@implementation TMBMicrosoft_PowerBI_AddRow

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_PowerBI_AddRow Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/PowerBI/AddRow"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_PowerBI_AddRow_ResultSet *results = [[TMBMicrosoft_PowerBI_AddRow_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddRow Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_PowerBI_AddRow_Inputs*)newInputSet {
		return [[TMBMicrosoft_PowerBI_AddRow_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateDataset Choreo.
 */
@implementation TMBMicrosoft_PowerBI_CreateDataset_Inputs

	/*!
	 * Set the value of the SchemaDefinition input for this Choreo.
	*(required, json) A JSON object containing information about the dataset table and columns. See Choreo notes for formatting details.
	 */
	-(void)setSchemaDefinition:(NSString*)SchemaDefinition {
		[super setInput:@"SchemaDefinition" toValue:SchemaDefinition];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Power BI users.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the DefaultRetentionPolicy input for this Choreo.
	*(optional, string) Enables a default retention policy to automatically clean up old data while keeping a constant flow of new data going into your dashboard. Valid values are: None (the default) or basicFIFO.
	 */
	-(void)setDefaultRetentionPolicy:(NSString*)DefaultRetentionPolicy {
		[super setInput:@"DefaultRetentionPolicy" toValue:DefaultRetentionPolicy];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(conditional, password) Your Power BI password. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(conditional, string) Your Power BI username. This is requried unless providing a valid AccessToken (see optional inputs).
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateDataset Choreo.
 */
@implementation TMBMicrosoft_PowerBI_CreateDataset_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ResponseCode" output from an execution of this Choreo.
	 * @return - NSString* (integer) The response status code returned from Power BI.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponseCode {
		return [super getOutputByName:@"ResponseCode"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Power BI.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new Dataset from a JSON schema definition and returns the Dataset ID and the properties of the dataset created.
 */
@implementation TMBMicrosoft_PowerBI_CreateDataset

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_PowerBI_CreateDataset Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/PowerBI/CreateDataset"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_PowerBI_CreateDataset_ResultSet *results = [[TMBMicrosoft_PowerBI_CreateDataset_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateDataset Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_PowerBI_CreateDataset_Inputs*)newInputSet {
		return [[TMBMicrosoft_PowerBI_CreateDataset_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddTranslation Choreo.
 */
@implementation TMBMicrosoft_Translator_AddTranslation_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the Category input for this Choreo.
	*(optional, string) A string containing the category (domain) of the translation. Defaults to "general".
	 */
	-(void)setCategory:(NSString*)Category {
		[super setInput:@"Category" toValue:Category];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ContentType input for this Choreo.
	*(optional, string) The format of the text being translated. The supported formats are "text/plain" and "text/html".
	 */
	-(void)setContentType:(NSString*)ContentType {
		[super setInput:@"ContentType" toValue:ContentType];
	}

	/*!
	 * Set the value of the From input for this Choreo.
	*(required, string) A string containing the ISO 639-1 language code of the source language. Must be one of the languages returned by the method GetLanguagesForTranslate.(e.g., en).
	 */
	-(void)setFrom:(NSString*)From {
		[super setInput:@"From" toValue:From];
	}

	/*!
	 * Set the value of the OriginalText input for this Choreo.
	*(required, string) A string containing the text to translate from. The string has a maximum length of 1000 characters.
	 */
	-(void)setOriginalText:(NSString*)OriginalText {
		[super setInput:@"OriginalText" toValue:OriginalText];
	}

	/*!
	 * Set the value of the Rating input for this Choreo.
	*(optional, integer) An integer representing the quality rating for this string. Value between -10 and 10. Defaults to 1.
	 */
	-(void)setRating:(NSString*)Rating {
		[super setInput:@"Rating" toValue:Rating];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the To input for this Choreo.
	*(required, string) A string containing the lISO 639-1 language code of the target language. Must be one of the languages returned by the method GetLanguagesForTranslate (e.g., es).
	 */
	-(void)setTo:(NSString*)To {
		[super setInput:@"To" toValue:To];
	}

	/*!
	 * Set the value of the TranslatedText input for this Choreo.
	*(required, string) A string containing translated text in the target language. The string has a maximum length of 2000 characters.
	 */
	-(void)setTranslatedText:(NSString*)TranslatedText {
		[super setInput:@"TranslatedText" toValue:TranslatedText];
	}

	/*!
	 * Set the value of the URI input for this Choreo.
	*(optional, string) A string containing the content location of this translation.
	 */
	-(void)setURI:(NSString*)URI {
		[super setInput:@"URI" toValue:URI];
	}

	/*!
	 * Set the value of the User input for this Choreo.
	*(required, string) A string used to track the originator of the submission.
	 */
	-(void)setUser:(NSString*)User {
		[super setInput:@"User" toValue:User];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddTranslation Choreo.
 */
@implementation TMBMicrosoft_Translator_AddTranslation_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves an array of all translations for a given text.
 */
@implementation TMBMicrosoft_Translator_AddTranslation

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_AddTranslation Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/AddTranslation"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_AddTranslation_ResultSet *results = [[TMBMicrosoft_Translator_AddTranslation_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddTranslation Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_AddTranslation_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_AddTranslation_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddTranslationArray Choreo.
 */
@implementation TMBMicrosoft_Translator_AddTranslationArray_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the Category input for this Choreo.
	*(optional, string) A string containing the category (domain) of the translation. Defaults to "general".
	 */
	-(void)setCategory:(NSString*)Category {
		[super setInput:@"Category" toValue:Category];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ContentType input for this Choreo.
	*(optional, string) The format of the text being translated. The supported formats are "text/plain" and "text/html".
	 */
	-(void)setContentType:(NSString*)ContentType {
		[super setInput:@"ContentType" toValue:ContentType];
	}

	/*!
	 * Set the value of the From input for this Choreo.
	*(required, string) A string containing the ISO 639-1 language code of the source language (e.g., en). Must be one of the languages returned by the method GetLanguagesForTranslate.
	 */
	-(void)setFrom:(NSString*)From {
		[super setInput:@"From" toValue:From];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the To input for this Choreo.
	*(required, string) A string containing the ISO 639-1 language code of the target language (e.g., es). Must be one of the languages returned by the method GetLanguagesForTranslate.
	 */
	-(void)setTo:(NSString*)To {
		[super setInput:@"To" toValue:To];
	}

	/*!
	 * Set the value of the Translations input for this Choreo.
	*(required, json) An array containing translations to add to translation memory. Each translation must contain: OriginalText, TranslatedText, and Rating. See Choreo description for formatting examples.
	 */
	-(void)setTranslations:(NSString*)Translations {
		[super setInput:@"Translations" toValue:Translations];
	}

	/*!
	 * Set the value of the URI input for this Choreo.
	*(optional, string) A string containing the content location of this translation.
	 */
	-(void)setURI:(NSString*)URI {
		[super setInput:@"URI" toValue:URI];
	}

	/*!
	 * Set the value of the User input for this Choreo.
	*(required, string) A string used to track the originator of the submission.
	 */
	-(void)setUser:(NSString*)User {
		[super setInput:@"User" toValue:User];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddTranslationArray Choreo.
 */
@implementation TMBMicrosoft_Translator_AddTranslationArray_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds an array of translations to add translation memory.
 */
@implementation TMBMicrosoft_Translator_AddTranslationArray

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_AddTranslationArray Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/AddTranslationArray"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_AddTranslationArray_ResultSet *results = [[TMBMicrosoft_Translator_AddTranslationArray_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddTranslationArray Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_AddTranslationArray_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_AddTranslationArray_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the BreakSentences Choreo.
 */
@implementation TMBMicrosoft_Translator_BreakSentences_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Language input for this Choreo.
	*(required, string) A string representing the ISO 639-1 language code of input text.
	 */
	-(void)setLanguage:(NSString*)Language {
		[super setInput:@"Language" toValue:Language];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the Text input for this Choreo.
	*(required, string) A string representing the text to split into sentences. The size of the text must not exceed 10000 characters.
	 */
	-(void)setText:(NSString*)Text {
		[super setInput:@"Text" toValue:Text];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the BreakSentences Choreo.
 */
@implementation TMBMicrosoft_Translator_BreakSentences_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Breaks a piece of text into sentences and returns an array containing the lengths in each sentence.
 */
@implementation TMBMicrosoft_Translator_BreakSentences

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_BreakSentences Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/BreakSentences"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_BreakSentences_ResultSet *results = [[TMBMicrosoft_Translator_BreakSentences_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the BreakSentences Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_BreakSentences_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_BreakSentences_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the Detect Choreo.
 */
@implementation TMBMicrosoft_Translator_Detect_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the Text input for this Choreo.
	*(required, string) A string containing some text whose language is to be identified. The size of the text must not exceed 10000 characters.
	 */
	-(void)setText:(NSString*)Text {
		[super setInput:@"Text" toValue:Text];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Detect Choreo.
 */
@implementation TMBMicrosoft_Translator_Detect_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Identifies the language of a selected piece of text.
 */
@implementation TMBMicrosoft_Translator_Detect

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_Detect Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/Detect"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_Detect_ResultSet *results = [[TMBMicrosoft_Translator_Detect_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the Detect Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_Detect_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_Detect_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DetectArray Choreo.
 */
@implementation TMBMicrosoft_Translator_DetectArray_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the Texts input for this Choreo.
	*(required, json) A JSON array representing the text from an unknown language. The size of the text must not exceed 10000 characters.
	 */
	-(void)setTexts:(NSString*)Texts {
		[super setInput:@"Texts" toValue:Texts];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DetectArray Choreo.
 */
@implementation TMBMicrosoft_Translator_DetectArray_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Identifies the language of an array of text strings.
 */
@implementation TMBMicrosoft_Translator_DetectArray

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_DetectArray Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/DetectArray"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_DetectArray_ResultSet *results = [[TMBMicrosoft_Translator_DetectArray_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DetectArray Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_DetectArray_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_DetectArray_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLanguageNames Choreo.
 */
@implementation TMBMicrosoft_Translator_GetLanguageNames_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the LanguageCodes input for this Choreo.
	*(required, json) An array of ISO 639-1 language codes to retrieve friendly names for.
	 */
	-(void)setLanguageCodes:(NSString*)LanguageCodes {
		[super setInput:@"LanguageCodes" toValue:LanguageCodes];
	}

	/*!
	 * Set the value of the Locale input for this Choreo.
	*(required, string) The ISO 639-1 language code associated with the language you wish to return results in.
	 */
	-(void)setLocale:(NSString*)Locale {
		[super setInput:@"Locale" toValue:Locale];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLanguageNames Choreo.
 */
@implementation TMBMicrosoft_Translator_GetLanguageNames_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves friendly names for languages and localized using the specified locale language.
 */
@implementation TMBMicrosoft_Translator_GetLanguageNames

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_GetLanguageNames Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/GetLanguageNames"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_GetLanguageNames_ResultSet *results = [[TMBMicrosoft_Translator_GetLanguageNames_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLanguageNames Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_GetLanguageNames_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_GetLanguageNames_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLanguagesForSpeak Choreo.
 */
@implementation TMBMicrosoft_Translator_GetLanguagesForSpeak_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLanguagesForSpeak Choreo.
 */
@implementation TMBMicrosoft_Translator_GetLanguagesForSpeak_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the languages available for speech synthesis.
 */
@implementation TMBMicrosoft_Translator_GetLanguagesForSpeak

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_GetLanguagesForSpeak Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/GetLanguagesForSpeak"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_GetLanguagesForSpeak_ResultSet *results = [[TMBMicrosoft_Translator_GetLanguagesForSpeak_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLanguagesForSpeak Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_GetLanguagesForSpeak_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_GetLanguagesForSpeak_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLanguagesForTranslate Choreo.
 */
@implementation TMBMicrosoft_Translator_GetLanguagesForTranslate_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLanguagesForTranslate Choreo.
 */
@implementation TMBMicrosoft_Translator_GetLanguagesForTranslate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves a list of language codes representing languages that are supported by the Translation Service.
 */
@implementation TMBMicrosoft_Translator_GetLanguagesForTranslate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_GetLanguagesForTranslate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/GetLanguagesForTranslate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_GetLanguagesForTranslate_ResultSet *results = [[TMBMicrosoft_Translator_GetLanguagesForTranslate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLanguagesForTranslate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_GetLanguagesForTranslate_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_GetLanguagesForTranslate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetToken Choreo.
 */
@implementation TMBMicrosoft_Translator_GetToken_Inputs

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(required, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(required, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetToken Choreo.
 */
@implementation TMBMicrosoft_Translator_GetToken_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "AccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) The access token returned from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getAccessToken {
		return [super getOutputByName:@"AccessToken"];
	}

	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) The number of seconds for which the access token is valid.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}
	
@end

/*!
 * Retrieves an access token that can be used to authenticate with the Microsoft Translator API.
 */
@implementation TMBMicrosoft_Translator_GetToken

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_GetToken Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/GetToken"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_GetToken_ResultSet *results = [[TMBMicrosoft_Translator_GetToken_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetToken Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_GetToken_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_GetToken_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetTranslations Choreo.
 */
@implementation TMBMicrosoft_Translator_GetTranslations_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the Category input for this Choreo.
	*(optional, string) A string containing the category (domain) of the translation. Defaults to "general".
	 */
	-(void)setCategory:(NSString*)Category {
		[super setInput:@"Category" toValue:Category];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ContentType input for this Choreo.
	*(optional, string) The format of the text being translated. The only supported, and the default, option is "text/plain".
	 */
	-(void)setContentType:(NSString*)ContentType {
		[super setInput:@"ContentType" toValue:ContentType];
	}

	/*!
	 * Set the value of the From input for this Choreo.
	*(required, string) A string representing the ISO 639-1 language code of the translation text (e.g., en).
	 */
	-(void)setFrom:(NSString*)From {
		[super setInput:@"From" toValue:From];
	}

	/*!
	 * Set the value of the MaxTranslations input for this Choreo.
	*(required, integer) An integer representing the maximum number of translations to return.
	 */
	-(void)setMaxTranslations:(NSString*)MaxTranslations {
		[super setInput:@"MaxTranslations" toValue:MaxTranslations];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the State input for this Choreo.
	*(optional, string) User state to help correlate request and response. The same contents will be returned in the response.
	 */
	-(void)setState:(NSString*)State {
		[super setInput:@"State" toValue:State];
	}

	/*!
	 * Set the value of the Text input for this Choreo.
	*(required, string) A string representing the text to translate. The size of the text must not exceed 10000 characters.
	 */
	-(void)setText:(NSString*)Text {
		[super setInput:@"Text" toValue:Text];
	}

	/*!
	 * Set the value of the To input for this Choreo.
	*(required, string) A string representing the ISO 639-1 language code to translate the text into (e.g., es).
	 */
	-(void)setTo:(NSString*)To {
		[super setInput:@"To" toValue:To];
	}

	/*!
	 * Set the value of the URI input for this Choreo.
	*(optional, string) Filter results by this URI. Default: all
	 */
	-(void)setURI:(NSString*)URI {
		[super setInput:@"URI" toValue:URI];
	}

	/*!
	 * Set the value of the User input for this Choreo.
	*(optional, string) Filter results by this user. Default: all
	 */
	-(void)setUser:(NSString*)User {
		[super setInput:@"User" toValue:User];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetTranslations Choreo.
 */
@implementation TMBMicrosoft_Translator_GetTranslations_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves an array of all translations for a given text.
 */
@implementation TMBMicrosoft_Translator_GetTranslations

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_GetTranslations Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/GetTranslations"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_GetTranslations_ResultSet *results = [[TMBMicrosoft_Translator_GetTranslations_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetTranslations Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_GetTranslations_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_GetTranslations_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetTranslationsArray Choreo.
 */
@implementation TMBMicrosoft_Translator_GetTranslationsArray_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the Category input for this Choreo.
	*(optional, string) A string containing the category (domain) of the translation. Defaults to "general".
	 */
	-(void)setCategory:(NSString*)Category {
		[super setInput:@"Category" toValue:Category];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ContentType input for this Choreo.
	*(optional, string) The format of the text being translated. The only supported, and the default, option is "text/plain".
	 */
	-(void)setContentType:(NSString*)ContentType {
		[super setInput:@"ContentType" toValue:ContentType];
	}

	/*!
	 * Set the value of the From input for this Choreo.
	*(required, string) A string representing the ISO 639-1 language code of the translation text (e.g., en).
	 */
	-(void)setFrom:(NSString*)From {
		[super setInput:@"From" toValue:From];
	}

	/*!
	 * Set the value of the MaxTranslations input for this Choreo.
	*(required, integer) An integer representing the maximum number of translations to return.
	 */
	-(void)setMaxTranslations:(NSString*)MaxTranslations {
		[super setInput:@"MaxTranslations" toValue:MaxTranslations];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the State input for this Choreo.
	*(optional, string) User state to help correlate request and response. The same contents will be returned in the response.
	 */
	-(void)setState:(NSString*)State {
		[super setInput:@"State" toValue:State];
	}

	/*!
	 * Set the value of the Texts input for this Choreo.
	*(required, json) An array containing the texts for translation. All strings must be of the same language. The total of all texts must not exceed 10000 characters. The max number of array items is 2000.
	 */
	-(void)setTexts:(NSString*)Texts {
		[super setInput:@"Texts" toValue:Texts];
	}

	/*!
	 * Set the value of the To input for this Choreo.
	*(required, string) A string representing the ISO 639-1 language code to translate the text into (e.g., es).
	 */
	-(void)setTo:(NSString*)To {
		[super setInput:@"To" toValue:To];
	}

	/*!
	 * Set the value of the URI input for this Choreo.
	*(optional, string) Filter results by this URI. Default: all
	 */
	-(void)setURI:(NSString*)URI {
		[super setInput:@"URI" toValue:URI];
	}

	/*!
	 * Set the value of the User input for this Choreo.
	*(optional, string) Filter results by this user. Default: all
	 */
	-(void)setUser:(NSString*)User {
		[super setInput:@"User" toValue:User];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetTranslationsArray Choreo.
 */
@implementation TMBMicrosoft_Translator_GetTranslationsArray_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves multiple translation candidates for multiple source texts.
 */
@implementation TMBMicrosoft_Translator_GetTranslationsArray

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_GetTranslationsArray Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/GetTranslationsArray"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_GetTranslationsArray_ResultSet *results = [[TMBMicrosoft_Translator_GetTranslationsArray_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetTranslationsArray Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_GetTranslationsArray_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_GetTranslationsArray_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the Speak Choreo.
 */
@implementation TMBMicrosoft_Translator_Speak_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Format input for this Choreo.
	*(optional, string) A string specifying the content-type. Currently, "audio/wav" and "audio/mp3" are available. The default value is "audio/wav".
	 */
	-(void)setFormat:(NSString*)Format {
		[super setInput:@"Format" toValue:Format];
	}

	/*!
	 * Set the value of the Language input for this Choreo.
	*(required, string) A string representing the supported ISO 639-1 language code to speak the text in (e.g., es). The code must be present in the list of codes returned from the method GetLanguagesForSpeak.
	 */
	-(void)setLanguage:(NSString*)Language {
		[super setInput:@"Language" toValue:Language];
	}

	/*!
	 * Set the value of the Options input for this Choreo.
	*(optional, string) A string specifying the quality of the audio signals. Valid values are: MaxQuality or MinQuality (the default).
	 */
	-(void)setOptions:(NSString*)Options {
		[super setInput:@"Options" toValue:Options];
	}

	/*!
	 * Set the value of the Text input for this Choreo.
	*(required, string) A string representing the text to translate. The size of the text must not exceed 10000 characters.
	 */
	-(void)setText:(NSString*)Text {
		[super setInput:@"Text" toValue:Text];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Speak Choreo.
 */
@implementation TMBMicrosoft_Translator_Speak_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "AudioFile" output from an execution of this Choreo.
	 * @return - NSString* (string) The Base64 encoded audio file in mp3 or wav format.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getAudioFile {
		return [super getOutputByName:@"AudioFile"];
	}

	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}
	
@end

/*!
 * Returns a Base64 encoded wave or mp3 file of the passed-in text being spoken in the desired language.
 */
@implementation TMBMicrosoft_Translator_Speak

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_Speak Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/Speak"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_Speak_ResultSet *results = [[TMBMicrosoft_Translator_Speak_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the Speak Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_Speak_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_Speak_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the Translate Choreo.
 */
@implementation TMBMicrosoft_Translator_Translate_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the Category input for this Choreo.
	*(optional, string) A string containing the category (domain) of the translation. Defaults to "general".
	 */
	-(void)setCategory:(NSString*)Category {
		[super setInput:@"Category" toValue:Category];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ContentType input for this Choreo.
	*(optional, string) The format of the text being translated. The supported formats are "text/plain" (the default) and "text/html".
	 */
	-(void)setContentType:(NSString*)ContentType {
		[super setInput:@"ContentType" toValue:ContentType];
	}

	/*!
	 * Set the value of the From input for this Choreo.
	*(required, string) A string representing the ISO 639-1 language code of the translation text (e.g., en).
	 */
	-(void)setFrom:(NSString*)From {
		[super setInput:@"From" toValue:From];
	}

	/*!
	 * Set the value of the Text input for this Choreo.
	*(required, string) A string representing the text to translate. The size of the text must not exceed 10000 characters.
	 */
	-(void)setText:(NSString*)Text {
		[super setInput:@"Text" toValue:Text];
	}

	/*!
	 * Set the value of the To input for this Choreo.
	*(required, string) A string representing the ISO 639-1 language codee to translate the text into (e.g., es).
	 */
	-(void)setTo:(NSString*)To {
		[super setInput:@"To" toValue:To];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Translate Choreo.
 */
@implementation TMBMicrosoft_Translator_Translate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "TranslatedText" output from an execution of this Choreo.
	 * @return - NSString* (string) The translated text parsed from the Microsoft response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getTranslatedText {
		return [super getOutputByName:@"TranslatedText"];
	}
	
@end

/*!
 * Translates a text string from one language to another.
 */
@implementation TMBMicrosoft_Translator_Translate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_Translate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/Translate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_Translate_ResultSet *results = [[TMBMicrosoft_Translator_Translate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the Translate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_Translate_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_Translate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the TranslateArray Choreo.
 */
@implementation TMBMicrosoft_Translator_TranslateArray_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the Category input for this Choreo.
	*(optional, string) A string containing the category (domain) of the translation. Defaults to "general".
	 */
	-(void)setCategory:(NSString*)Category {
		[super setInput:@"Category" toValue:Category];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ContentType input for this Choreo.
	*(optional, string) The format of the text being translated. The supported formats are "text/plain" (the default) and "text/html".
	 */
	-(void)setContentType:(NSString*)ContentType {
		[super setInput:@"ContentType" toValue:ContentType];
	}

	/*!
	 * Set the value of the From input for this Choreo.
	*(optional, string) A string representing the language code of the translation text (e.g., en). If not provided auto-detection is used.
	 */
	-(void)setFrom:(NSString*)From {
		[super setInput:@"From" toValue:From];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the Texts input for this Choreo.
	*(required, json) An array containing the texts for translation. All strings must be of the same language. The total of all texts must not exceed 10000 characters. The max number of array items is 2000.
	 */
	-(void)setTexts:(NSString*)Texts {
		[super setInput:@"Texts" toValue:Texts];
	}

	/*!
	 * Set the value of the To input for this Choreo.
	*(required, string) A string representing the ISO 639-1 language code to translate the text into (e.g., es).
	 */
	-(void)setTo:(NSString*)To {
		[super setInput:@"To" toValue:To];
	}

	/*!
	 * Set the value of the URI input for this Choreo.
	*(optional, string) Filter results by this URI. Default: all
	 */
	-(void)setURI:(NSString*)URI {
		[super setInput:@"URI" toValue:URI];
	}

	/*!
	 * Set the value of the User input for this Choreo.
	*(optional, multiline) Filter results by this user. Default: all
	 */
	-(void)setUser:(NSString*)User {
		[super setInput:@"User" toValue:User];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TranslateArray Choreo.
 */
@implementation TMBMicrosoft_Translator_TranslateArray_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ExpiresIn" output from an execution of this Choreo.
	 * @return - NSString* (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpiresIn {
		return [super getOutputByName:@"ExpiresIn"];
	}

	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Microsoft.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Translates multiple source texts.
 */
@implementation TMBMicrosoft_Translator_TranslateArray

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBMicrosoft_Translator_TranslateArray Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Microsoft/Translator/TranslateArray"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBMicrosoft_Translator_TranslateArray_ResultSet *results = [[TMBMicrosoft_Translator_TranslateArray_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the TranslateArray Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBMicrosoft_Translator_TranslateArray_Inputs*)newInputSet {
		return [[TMBMicrosoft_Translator_TranslateArray_Inputs alloc] init];
	}
@end
	