/*!
 * @TMBAmazon.m
 *
 * Execute Choreographies from the Temboo Amazon bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBAmazon.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the GetAccountInfo Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_GetAccountInfo_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAccountInfo Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_GetAccountInfo_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves account information for the authenticated user.
 */
@implementation TMBAmazon_CloudDrive_Account_GetAccountInfo

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Account_GetAccountInfo Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Account/GetAccountInfo"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Account_GetAccountInfo_ResultSet *results = [[TMBAmazon_CloudDrive_Account_GetAccountInfo_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetAccountInfo Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Account_GetAccountInfo_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Account_GetAccountInfo_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetEndpoint Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_GetEndpoint_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetEndpoint Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_GetEndpoint_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the customer end-point against which requests can be executed.
 */
@implementation TMBAmazon_CloudDrive_Account_GetEndpoint

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Account_GetEndpoint Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Account/GetEndpoint"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Account_GetEndpoint_ResultSet *results = [[TMBAmazon_CloudDrive_Account_GetEndpoint_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetEndpoint Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Account_GetEndpoint_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Account_GetEndpoint_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetQuota Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_GetQuota_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetQuota Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_GetQuota_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves account quota and storage availability information.
 */
@implementation TMBAmazon_CloudDrive_Account_GetQuota

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Account_GetQuota Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Account/GetQuota"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Account_GetQuota_ResultSet *results = [[TMBAmazon_CloudDrive_Account_GetQuota_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetQuota Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Account_GetQuota_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Account_GetQuota_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetUsage Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_GetUsage_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUsage Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_GetUsage_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves account usage information broken down by content category.
 */
@implementation TMBAmazon_CloudDrive_Account_GetUsage

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Account_GetUsage Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Account/GetUsage"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Account_GetUsage_ResultSet *results = [[TMBAmazon_CloudDrive_Account_GetUsage_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetUsage Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Account_GetUsage_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Account_GetUsage_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the SetupAccount Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_SetupAccount_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}

	/*!
	 * Set the value of the TermsOfUse input for this Choreo.
	*(optional, decimal) The terms of use version. Defaults to 1.0.0.
	 */
	-(void)setTermsOfUse:(NSString*)TermsOfUse {
		[super setInput:@"TermsOfUse" toValue:TermsOfUse];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SetupAccount Choreo.
 */
@implementation TMBAmazon_CloudDrive_Account_SetupAccount_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "ResponseStatusCode" output from an execution of this Choreo.
	 * @return - NSString* (integer) The response status code returned from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponseStatusCode {
		return [super getOutputByName:@"ResponseStatusCode"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates an account with a given terms of use parameter.
 */
@implementation TMBAmazon_CloudDrive_Account_SetupAccount

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Account_SetupAccount Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Account/SetupAccount"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Account_SetupAccount_ResultSet *results = [[TMBAmazon_CloudDrive_Account_SetupAccount_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the SetupAccount Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Account_SetupAccount_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Account_SetupAccount_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddChild Choreo.
 */
@implementation TMBAmazon_CloudDrive_Children_AddChild_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ChildID input for this Choreo.
	*(required, string) The ID of the folder that is being moved within a parent folder.
	 */
	-(void)setChildID:(NSString*)ChildID {
		[super setInput:@"ChildID" toValue:ChildID];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the ParentID input for this Choreo.
	*(required, string) The ID of the parent folder that will contain the child folder that's being moved.
	 */
	-(void)setParentID:(NSString*)ParentID {
		[super setInput:@"ParentID" toValue:ParentID];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddChild Choreo.
 */
@implementation TMBAmazon_CloudDrive_Children_AddChild_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Moves a specified folder into a parent folder.
 */
@implementation TMBAmazon_CloudDrive_Children_AddChild

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Children_AddChild Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Children/AddChild"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Children_AddChild_ResultSet *results = [[TMBAmazon_CloudDrive_Children_AddChild_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddChild Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Children_AddChild_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Children_AddChild_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListChildren Choreo.
 */
@implementation TMBAmazon_CloudDrive_Children_ListChildren_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Fields input for this Choreo.
	*(optional, string) A comma-separated list of additional fields to include in the response.
	 */
	-(void)setFields:(NSString*)Fields {
		[super setInput:@"Fields" toValue:Fields];
	}

	/*!
	 * Set the value of the Filters input for this Choreo.
	*(optional, string) A filter used to narrow the result set (e.g., name:Documents). The default value is "kind:FOLDER". To a make a request using no filters, you can pass "none".
	 */
	-(void)setFilters:(NSString*)Filters {
		[super setInput:@"Filters" toValue:Filters];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, string) The maximum number of records to be returned.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the ParentID input for this Choreo.
	*(required, string) The ID of the parent that contains the list of children to retrieve.
	 */
	-(void)setParentID:(NSString*)ParentID {
		[super setInput:@"ParentID" toValue:ParentID];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}

	/*!
	 * Set the value of the Sort input for this Choreo.
	*(optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).
	 */
	-(void)setSort:(NSString*)Sort {
		[super setInput:@"Sort" toValue:Sort];
	}

	/*!
	 * Set the value of the StartToken input for this Choreo.
	*(optional, string) The nextToken returned from a previous request. Used to paginate through results.
	 */
	-(void)setStartToken:(NSString*)StartToken {
		[super setInput:@"StartToken" toValue:StartToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListChildren Choreo.
 */
@implementation TMBAmazon_CloudDrive_Children_ListChildren_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the children of a specified parent folder.
 */
@implementation TMBAmazon_CloudDrive_Children_ListChildren

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Children_ListChildren Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Children/ListChildren"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Children_ListChildren_ResultSet *results = [[TMBAmazon_CloudDrive_Children_ListChildren_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListChildren Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Children_ListChildren_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Children_ListChildren_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RemoveChild Choreo.
 */
@implementation TMBAmazon_CloudDrive_Children_RemoveChild_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ChildID input for this Choreo.
	*(required, string) The ID of the folder that is being removed from a parent folder.
	 */
	-(void)setChildID:(NSString*)ChildID {
		[super setInput:@"ChildID" toValue:ChildID];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the ParentID input for this Choreo.
	*(required, string) The ID of the parent folder that contains the child folder that's being removed.
	 */
	-(void)setParentID:(NSString*)ParentID {
		[super setInput:@"ParentID" toValue:ParentID];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RemoveChild Choreo.
 */
@implementation TMBAmazon_CloudDrive_Children_RemoveChild_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Removes a specified folder from a parent folder.
 */
@implementation TMBAmazon_CloudDrive_Children_RemoveChild

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Children_RemoveChild Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Children/RemoveChild"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Children_RemoveChild_ResultSet *results = [[TMBAmazon_CloudDrive_Children_RemoveChild_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RemoveChild Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Children_RemoveChild_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Children_RemoveChild_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DownloadFile Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_DownloadFile_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ContentURL input for this Choreo.
	*(optional, string) The appropriate contentUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setContentURL:(NSString*)ContentURL {
		[super setInput:@"ContentURL" toValue:ContentURL];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the file to return content for.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DownloadFile Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_DownloadFile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (string) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon Cloud Drive API to retrieve the content for a specific file.
 */
@implementation TMBAmazon_CloudDrive_Files_DownloadFile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Files_DownloadFile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Files/DownloadFile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Files_DownloadFile_ResultSet *results = [[TMBAmazon_CloudDrive_Files_DownloadFile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DownloadFile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Files_DownloadFile_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Files_DownloadFile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetFileMetadata Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_GetFileMetadata_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Fields input for this Choreo.
	*(optional, string) A comma-separated list of additional fields to include in the response.
	 */
	-(void)setFields:(NSString*)Fields {
		[super setInput:@"Fields" toValue:Fields];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the file to return metadata for.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}

	/*!
	 * Set the value of the TempLink input for this Choreo.
	*(optional, boolean) Set true to include tempLink in response. Defaults to false.
	 */
	-(void)setTempLink:(NSString*)TempLink {
		[super setInput:@"TempLink" toValue:TempLink];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFileMetadata Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_GetFileMetadata_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon Cloud Drive API to retrieve metadata for a specific file.
 */
@implementation TMBAmazon_CloudDrive_Files_GetFileMetadata

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Files_GetFileMetadata Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Files/GetFileMetadata"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Files_GetFileMetadata_ResultSet *results = [[TMBAmazon_CloudDrive_Files_GetFileMetadata_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetFileMetadata Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Files_GetFileMetadata_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Files_GetFileMetadata_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListFiles Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_ListFiles_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Fields input for this Choreo.
	*(optional, string) A comma-separated list of additional fields to include in the response.
	 */
	-(void)setFields:(NSString*)Fields {
		[super setInput:@"Fields" toValue:Fields];
	}

	/*!
	 * Set the value of the Filters input for this Choreo.
	*(optional, string) A filter used to narrow the result set (e.g., name:MyFile.txt). The default value is "kind:FILE". To a make a request using no filters, you can pass "none".
	 */
	-(void)setFilters:(NSString*)Filters {
		[super setInput:@"Filters" toValue:Filters];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, string) The maximum number of records to be returned.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}

	/*!
	 * Set the value of the Sort input for this Choreo.
	*(optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).
	 */
	-(void)setSort:(NSString*)Sort {
		[super setInput:@"Sort" toValue:Sort];
	}

	/*!
	 * Set the value of the StartToken input for this Choreo.
	*(optional, string) The nextToken returned from a previous request. Used to paginate through results.
	 */
	-(void)setStartToken:(NSString*)StartToken {
		[super setInput:@"StartToken" toValue:StartToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListFiles Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_ListFiles_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon Cloud Drive API to return a list of files.
 */
@implementation TMBAmazon_CloudDrive_Files_ListFiles

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Files_ListFiles Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Files/ListFiles"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Files_ListFiles_ResultSet *results = [[TMBAmazon_CloudDrive_Files_ListFiles_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListFiles Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Files_ListFiles_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Files_ListFiles_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the OverwriteFile Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_OverwriteFile_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ContentURL input for this Choreo.
	*(optional, string) The appropriate contentUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setContentURL:(NSString*)ContentURL {
		[super setInput:@"ContentURL" toValue:ContentURL];
	}

	/*!
	 * Set the value of the FileContent input for this Choreo.
	*(conditional, string) The Base64 encoded contents of the file to upload.
	 */
	-(void)setFileContent:(NSString*)FileContent {
		[super setInput:@"FileContent" toValue:FileContent];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the file to update.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}

	/*!
	 * Set the value of the VaultFile input for this Choreo.
	*
	 */
	-(void)setVaultFile:(NSString*)VaultFile {
		[super setInput:@"VaultFile" toValue:VaultFile];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the OverwriteFile Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_OverwriteFile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon Cloud Drive API to overwrite the content of an existing file.
 */
@implementation TMBAmazon_CloudDrive_Files_OverwriteFile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Files_OverwriteFile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Files/OverwriteFile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Files_OverwriteFile_ResultSet *results = [[TMBAmazon_CloudDrive_Files_OverwriteFile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the OverwriteFile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Files_OverwriteFile_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Files_OverwriteFile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UploadFile Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_UploadFile_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the ContentType input for this Choreo.
	*(required, string) The Content-Type of the file that is being uploaded (e.g., image/jpeg, text/plain, etc.) Defaults to application/octet-stream.
	 */
	-(void)setContentType:(NSString*)ContentType {
		[super setInput:@"ContentType" toValue:ContentType];
	}

	/*!
	 * Set the value of the ContentURL input for this Choreo.
	*(optional, string) The appropriate contentUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setContentURL:(NSString*)ContentURL {
		[super setInput:@"ContentURL" toValue:ContentURL];
	}

	/*!
	 * Set the value of the FileContent input for this Choreo.
	*(conditional, string) The Base64 encoded contents of the file to upload.
	 */
	-(void)setFileContent:(NSString*)FileContent {
		[super setInput:@"FileContent" toValue:FileContent];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the Labels input for this Choreo.
	*(optional, json) A JSON array containing labels to apply to the file.
	 */
	-(void)setLabels:(NSString*)Labels {
		[super setInput:@"Labels" toValue:Labels];
	}

	/*!
	 * Set the value of the LocalID input for this Choreo.
	*(optional, string) A unique ID within the application. Multiple POSTs with the same localId from the same application will result in the same node-id. If not provided the server will generate a node-id.
	 */
	-(void)setLocalID:(NSString*)LocalID {
		[super setInput:@"LocalID" toValue:LocalID];
	}

	/*!
	 * Set the value of the Name input for this Choreo.
	*(required, string) The name of the file being uploaded.
	 */
	-(void)setName:(NSString*)Name {
		[super setInput:@"Name" toValue:Name];
	}

	/*!
	 * Set the value of the Parents input for this Choreo.
	*(optional, json) A JSON array containing parent IDs associated with the new folder.
	 */
	-(void)setParents:(NSString*)Parents {
		[super setInput:@"Parents" toValue:Parents];
	}

	/*!
	 * Set the value of the Properties input for this Choreo.
	*(optional, json) A JSON object containing properties to be applied to the file.
	 */
	-(void)setProperties:(NSString*)Properties {
		[super setInput:@"Properties" toValue:Properties];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}

	/*!
	 * Set the value of the Supress input for this Choreo.
	*(optional, string) Valid values are: "deduplication" (disables checking for duplicates when uploading) and "process" (disables any processing Amazon may do on the file).
	 */
	-(void)setSupress:(NSString*)Supress {
		[super setInput:@"Supress" toValue:Supress];
	}

	/*!
	 * Set the value of the VaultFile input for this Choreo.
	*
	 */
	-(void)setVaultFile:(NSString*)VaultFile {
		[super setInput:@"VaultFile" toValue:VaultFile];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UploadFile Choreo.
 */
@implementation TMBAmazon_CloudDrive_Files_UploadFile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon Cloud Drive API to upload a file to Amazon Cloud Drive.
 */
@implementation TMBAmazon_CloudDrive_Files_UploadFile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Files_UploadFile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Files/UploadFile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Files_UploadFile_ResultSet *results = [[TMBAmazon_CloudDrive_Files_UploadFile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UploadFile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Files_UploadFile_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Files_UploadFile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateFolder Choreo.
 */
@implementation TMBAmazon_CloudDrive_Folders_CreateFolder_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the Labels input for this Choreo.
	*(optional, json) A JSON array containing labels to apply to the folder.
	 */
	-(void)setLabels:(NSString*)Labels {
		[super setInput:@"Labels" toValue:Labels];
	}

	/*!
	 * Set the value of the LocalID input for this Choreo.
	*(optional, string) Globally unique client local Id for the customer.
	 */
	-(void)setLocalID:(NSString*)LocalID {
		[super setInput:@"LocalID" toValue:LocalID];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the Name input for this Choreo.
	*(required, string) The name of the new folder.
	 */
	-(void)setName:(NSString*)Name {
		[super setInput:@"Name" toValue:Name];
	}

	/*!
	 * Set the value of the Parents input for this Choreo.
	*(optional, json) A JSON array containing parent names associated with the new folder.
	 */
	-(void)setParents:(NSString*)Parents {
		[super setInput:@"Parents" toValue:Parents];
	}

	/*!
	 * Set the value of the Properties input for this Choreo.
	*(optional, json) A JSON object containing properties to be applied to the folder.
	 */
	-(void)setProperties:(NSString*)Properties {
		[super setInput:@"Properties" toValue:Properties];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateFolder Choreo.
 */
@implementation TMBAmazon_CloudDrive_Folders_CreateFolder_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new folder using the Amazon Cloud Drive API.
 */
@implementation TMBAmazon_CloudDrive_Folders_CreateFolder

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Folders_CreateFolder Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Folders/CreateFolder"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Folders_CreateFolder_ResultSet *results = [[TMBAmazon_CloudDrive_Folders_CreateFolder_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateFolder Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Folders_CreateFolder_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Folders_CreateFolder_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetFolderMetadata Choreo.
 */
@implementation TMBAmazon_CloudDrive_Folders_GetFolderMetadata_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Fields input for this Choreo.
	*(optional, string) A comma-separated list of additional fields to include in the response.
	 */
	-(void)setFields:(NSString*)Fields {
		[super setInput:@"Fields" toValue:Fields];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the folder to return metadata for.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFolderMetadata Choreo.
 */
@implementation TMBAmazon_CloudDrive_Folders_GetFolderMetadata_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves metadata for a specific folder using the Amazon Cloud Drive API.
 */
@implementation TMBAmazon_CloudDrive_Folders_GetFolderMetadata

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Folders_GetFolderMetadata Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Folders/GetFolderMetadata"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Folders_GetFolderMetadata_ResultSet *results = [[TMBAmazon_CloudDrive_Folders_GetFolderMetadata_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetFolderMetadata Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Folders_GetFolderMetadata_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Folders_GetFolderMetadata_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListFolders Choreo.
 */
@implementation TMBAmazon_CloudDrive_Folders_ListFolders_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Fields input for this Choreo.
	*(optional, string) A comma-separated list of additional fields to include in the response.
	 */
	-(void)setFields:(NSString*)Fields {
		[super setInput:@"Fields" toValue:Fields];
	}

	/*!
	 * Set the value of the Filters input for this Choreo.
	*(optional, string) A filter used to narrow the result set (e.g., name:Documents). The default value is "kind:FOLDER". To a make a request using no filters, you can pass "none".
	 */
	-(void)setFilters:(NSString*)Filters {
		[super setInput:@"Filters" toValue:Filters];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, string) The maximum number of records to be returned.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}

	/*!
	 * Set the value of the Sort input for this Choreo.
	*(optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).
	 */
	-(void)setSort:(NSString*)Sort {
		[super setInput:@"Sort" toValue:Sort];
	}

	/*!
	 * Set the value of the StartToken input for this Choreo.
	*(optional, string) The nextToken returned from a previous request. Used to paginate through results.
	 */
	-(void)setStartToken:(NSString*)StartToken {
		[super setInput:@"StartToken" toValue:StartToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListFolders Choreo.
 */
@implementation TMBAmazon_CloudDrive_Folders_ListFolders_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon Cloud Drive API to return a list of folders.
 */
@implementation TMBAmazon_CloudDrive_Folders_ListFolders

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Folders_ListFolders Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Folders/ListFolders"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Folders_ListFolders_ResultSet *results = [[TMBAmazon_CloudDrive_Folders_ListFolders_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListFolders Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Folders_ListFolders_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Folders_ListFolders_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddProperty Choreo.
 */
@implementation TMBAmazon_CloudDrive_Properties_AddProperty_Inputs

	/*!
	 * Set the value of the Value input for this Choreo.
	*(required, string) The value of the property. Max length 500 characters.
	 */
	-(void)setValue:(NSString*)Value {
		[super setInput:@"Value" toValue:Value];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the file or folder to which the properties needs to be added.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the Key input for this Choreo.
	*(required, string) The key of the properties which needs to be added. The key should just contain alphanumeric and "_". Max length is 50 characters.
	 */
	-(void)setKey:(NSString*)Key {
		[super setInput:@"Key" toValue:Key];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the Owner input for this Choreo.
	*(required, string) The "owner" of property.
	 */
	-(void)setOwner:(NSString*)Owner {
		[super setInput:@"Owner" toValue:Owner];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddProperty Choreo.
 */
@implementation TMBAmazon_CloudDrive_Properties_AddProperty_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds a property to a file or folder using the Amazon Cloud Drive API.
 */
@implementation TMBAmazon_CloudDrive_Properties_AddProperty

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Properties_AddProperty Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Properties/AddProperty"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Properties_AddProperty_ResultSet *results = [[TMBAmazon_CloudDrive_Properties_AddProperty_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddProperty Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Properties_AddProperty_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Properties_AddProperty_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteProperty Choreo.
 */
@implementation TMBAmazon_CloudDrive_Properties_DeleteProperty_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the file or folder associated with the property being deleted.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the Key input for this Choreo.
	*(required, string) The key of the properties which needs to be deleted.
	 */
	-(void)setKey:(NSString*)Key {
		[super setInput:@"Key" toValue:Key];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the Owner input for this Choreo.
	*(required, string) The "owner" of property.
	 */
	-(void)setOwner:(NSString*)Owner {
		[super setInput:@"Owner" toValue:Owner];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteProperty Choreo.
 */
@implementation TMBAmazon_CloudDrive_Properties_DeleteProperty_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "ResponseStatusCode" output from an execution of this Choreo.
	 * @return - NSString* (integer) The response status code returned from Amazon. A 204 is returned for a successful delete operation.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponseStatusCode {
		return [super getOutputByName:@"ResponseStatusCode"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon. An empty result object is returned for a successful delete operation.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Uses the Amazon Cloud Drive API to delete a specific property by key.
 */
@implementation TMBAmazon_CloudDrive_Properties_DeleteProperty

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Properties_DeleteProperty Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Properties/DeleteProperty"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Properties_DeleteProperty_ResultSet *results = [[TMBAmazon_CloudDrive_Properties_DeleteProperty_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteProperty Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Properties_DeleteProperty_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Properties_DeleteProperty_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetProperty Choreo.
 */
@implementation TMBAmazon_CloudDrive_Properties_GetProperty_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the file or folder associated with the property being retrieved.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the Key input for this Choreo.
	*(required, string) The key of the properties which needs to be retrieved.
	 */
	-(void)setKey:(NSString*)Key {
		[super setInput:@"Key" toValue:Key];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the Owner input for this Choreo.
	*(required, string) The "owner" of property.
	 */
	-(void)setOwner:(NSString*)Owner {
		[super setInput:@"Owner" toValue:Owner];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetProperty Choreo.
 */
@implementation TMBAmazon_CloudDrive_Properties_GetProperty_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon Cloud Drive API to retrieve a specific property by key.
 */
@implementation TMBAmazon_CloudDrive_Properties_GetProperty

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Properties_GetProperty Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Properties/GetProperty"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Properties_GetProperty_ResultSet *results = [[TMBAmazon_CloudDrive_Properties_GetProperty_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetProperty Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Properties_GetProperty_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Properties_GetProperty_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListProperties Choreo.
 */
@implementation TMBAmazon_CloudDrive_Properties_ListProperties_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, integer) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the file or folder to list properties for.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the Owner input for this Choreo.
	*(required, string) The "owner" of properties to list.
	 */
	-(void)setOwner:(NSString*)Owner {
		[super setInput:@"Owner" toValue:Owner];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListProperties Choreo.
 */
@implementation TMBAmazon_CloudDrive_Properties_ListProperties_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon Cloud Drive API to return a list of properties for a specified file or folder.
 */
@implementation TMBAmazon_CloudDrive_Properties_ListProperties

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Properties_ListProperties Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Properties/ListProperties"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Properties_ListProperties_ResultSet *results = [[TMBAmazon_CloudDrive_Properties_ListProperties_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListProperties Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Properties_ListProperties_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Properties_ListProperties_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddToTrash Choreo.
 */
@implementation TMBAmazon_CloudDrive_Trash_AddToTrash_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the folder to put in the trash.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddToTrash Choreo.
 */
@implementation TMBAmazon_CloudDrive_Trash_AddToTrash_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Uses the Amazon Cloud Drive API to move a specific file or folder to the trash.
 */
@implementation TMBAmazon_CloudDrive_Trash_AddToTrash

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Trash_AddToTrash Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Trash/AddToTrash"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Trash_AddToTrash_ResultSet *results = [[TMBAmazon_CloudDrive_Trash_AddToTrash_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddToTrash Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Trash_AddToTrash_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Trash_AddToTrash_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListTrash Choreo.
 */
@implementation TMBAmazon_CloudDrive_Trash_ListTrash_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the Fields input for this Choreo.
	*(optional, string) A comma-separated list of additional fields to include in the response.
	 */
	-(void)setFields:(NSString*)Fields {
		[super setInput:@"Fields" toValue:Fields];
	}

	/*!
	 * Set the value of the Filters input for this Choreo.
	*(optional, string) A filter used to narrow the result set (e.g., name:Documents). The default value is "kind:FOLDER". To a make a request using no filters, you can pass "none".
	 */
	-(void)setFilters:(NSString*)Filters {
		[super setInput:@"Filters" toValue:Filters];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, string) The maximum number of records to be returned.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}

	/*!
	 * Set the value of the Sort input for this Choreo.
	*(optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).
	 */
	-(void)setSort:(NSString*)Sort {
		[super setInput:@"Sort" toValue:Sort];
	}

	/*!
	 * Set the value of the StartToken input for this Choreo.
	*(optional, string) The nextToken returned from a previous request. Used to paginate through results.
	 */
	-(void)setStartToken:(NSString*)StartToken {
		[super setInput:@"StartToken" toValue:StartToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTrash Choreo.
 */
@implementation TMBAmazon_CloudDrive_Trash_ListTrash_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon Cloud Drive API to return metadata for items in the trash.
 */
@implementation TMBAmazon_CloudDrive_Trash_ListTrash

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Trash_ListTrash Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Trash/ListTrash"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Trash_ListTrash_ResultSet *results = [[TMBAmazon_CloudDrive_Trash_ListTrash_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListTrash Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Trash_ListTrash_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Trash_ListTrash_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the Restore Choreo.
 */
@implementation TMBAmazon_CloudDrive_Trash_Restore_Inputs

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the HandleRequestThrottling input for this Choreo.
	*(optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
	 */
	-(void)setHandleRequestThrottling:(NSString*)HandleRequestThrottling {
		[super setInput:@"HandleRequestThrottling" toValue:HandleRequestThrottling];
	}

	/*!
	 * Set the value of the ID input for this Choreo.
	*(required, string) The ID of the file or folder to restore.
	 */
	-(void)setID:(NSString*)ID {
		[super setInput:@"ID" toValue:ID];
	}

	/*!
	 * Set the value of the MetaDataURL input for this Choreo.
	*(optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
	 */
	-(void)setMetaDataURL:(NSString*)MetaDataURL {
		[super setInput:@"MetaDataURL" toValue:MetaDataURL];
	}

	/*!
	 * Set the value of the RefreshToken input for this Choreo.
	*(conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
	 */
	-(void)setRefreshToken:(NSString*)RefreshToken {
		[super setInput:@"RefreshToken" toValue:RefreshToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Restore Choreo.
 */
@implementation TMBAmazon_CloudDrive_Trash_Restore_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NewAccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains a new AccessToken when the RefreshToken is provided.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNewAccessToken {
		return [super getOutputByName:@"NewAccessToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon Cloud Drive API to restore a folder or file that has been moved to the trash.
 */
@implementation TMBAmazon_CloudDrive_Trash_Restore

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_CloudDrive_Trash_Restore Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/CloudDrive/Trash/Restore"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_CloudDrive_Trash_Restore_ResultSet *results = [[TMBAmazon_CloudDrive_Trash_Restore_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the Restore Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_CloudDrive_Trash_Restore_Inputs*)newInputSet {
		return [[TMBAmazon_CloudDrive_Trash_Restore_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the BatchGetItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_BatchGetItem_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the RequestItems input for this Choreo.
	*(required, json) A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. See choreo notes for more details.
	 */
	-(void)setRequestItems:(NSString*)RequestItems {
		[super setInput:@"RequestItems" toValue:RequestItems];
	}

	/*!
	 * Set the value of the ReturnConsumedCapacity input for this Choreo.
	*(optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
	 */
	-(void)setReturnConsumedCapacity:(NSString*)ReturnConsumedCapacity {
		[super setInput:@"ReturnConsumedCapacity" toValue:ReturnConsumedCapacity];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the BatchGetItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_BatchGetItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the attributes of one or more items from one or more tables
 */
@implementation TMBAmazon_DynamoDB_BatchGetItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_BatchGetItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/BatchGetItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_BatchGetItem_ResultSet *results = [[TMBAmazon_DynamoDB_BatchGetItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the BatchGetItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_BatchGetItem_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_BatchGetItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the BatchWriteItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_BatchWriteItem_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the RequestItems input for this Choreo.
	*(required, json) A map of one or more table names and, for each table, a list of operations to be performed (DeleteRequest or PutRequest). See choreo notes for more details.
	 */
	-(void)setRequestItems:(NSString*)RequestItems {
		[super setInput:@"RequestItems" toValue:RequestItems];
	}

	/*!
	 * Set the value of the ReturnConsumedCapacity input for this Choreo.
	*(optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
	 */
	-(void)setReturnConsumedCapacity:(NSString*)ReturnConsumedCapacity {
		[super setInput:@"ReturnConsumedCapacity" toValue:ReturnConsumedCapacity];
	}

	/*!
	 * Set the value of the ReturnItemCollectionMetrics input for this Choreo.
	*(optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.
	 */
	-(void)setReturnItemCollectionMetrics:(NSString*)ReturnItemCollectionMetrics {
		[super setInput:@"ReturnItemCollectionMetrics" toValue:ReturnItemCollectionMetrics];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the BatchWriteItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_BatchWriteItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Puts or deletes multiple items in one or more tables.
 */
@implementation TMBAmazon_DynamoDB_BatchWriteItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_BatchWriteItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/BatchWriteItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_BatchWriteItem_ResultSet *results = [[TMBAmazon_DynamoDB_BatchWriteItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the BatchWriteItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_BatchWriteItem_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_BatchWriteItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateTable Choreo.
 */
@implementation TMBAmazon_DynamoDB_CreateTable_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AttributeDefinitions input for this Choreo.
	*(required, json) An array of attributes that describe the key schema for the table and indexes.
	 */
	-(void)setAttributeDefinitions:(NSString*)AttributeDefinitions {
		[super setInput:@"AttributeDefinitions" toValue:AttributeDefinitions];
	}

	/*!
	 * Set the value of the GlobalSecondaryIndexes input for this Choreo.
	*(optional, json) One or more global secondary indexes (the maximum is five) to be created on the table.
	 */
	-(void)setGlobalSecondaryIndexes:(NSString*)GlobalSecondaryIndexes {
		[super setInput:@"GlobalSecondaryIndexes" toValue:GlobalSecondaryIndexes];
	}

	/*!
	 * Set the value of the KeySchema input for this Choreo.
	*(required, json) Specifies the attributes that make up the primary key for a table or an index. This is a JSON array of objects containing properties for AttributeName and KeyType. 
	 */
	-(void)setKeySchema:(NSString*)KeySchema {
		[super setInput:@"KeySchema" toValue:KeySchema];
	}

	/*!
	 * Set the value of the LocalSecondaryIndexes input for this Choreo.
	*(optional, json) One or more local secondary indexes (the maximum is five) to be created on the table.
	 */
	-(void)setLocalSecondaryIndexes:(NSString*)LocalSecondaryIndexes {
		[super setInput:@"LocalSecondaryIndexes" toValue:LocalSecondaryIndexes];
	}

	/*!
	 * Set the value of the ProvisionedThroughput input for this Choreo.
	*(required, json) Represents the provisioned throughput settings for a specified table or index.
	 */
	-(void)setProvisionedThroughput:(NSString*)ProvisionedThroughput {
		[super setInput:@"ProvisionedThroughput" toValue:ProvisionedThroughput];
	}

	/*!
	 * Set the value of the StreamSpecification input for this Choreo.
	*(optional, json) The settings for DynamoDB Streams on the table.
	 */
	-(void)setStreamSpecification:(NSString*)StreamSpecification {
		[super setInput:@"StreamSpecification" toValue:StreamSpecification];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table to create.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateTable Choreo.
 */
@implementation TMBAmazon_DynamoDB_CreateTable_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds a new table to your account.
 */
@implementation TMBAmazon_DynamoDB_CreateTable

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_CreateTable Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/CreateTable"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_CreateTable_ResultSet *results = [[TMBAmazon_DynamoDB_CreateTable_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateTable Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_CreateTable_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_CreateTable_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_DeleteItem_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ConditionExpression input for this Choreo.
	*(optional, string) A condition that must be satisfied in order for a conditional DeleteItem to succeed.
	 */
	-(void)setConditionExpression:(NSString*)ConditionExpression {
		[super setInput:@"ConditionExpression" toValue:ConditionExpression];
	}

	/*!
	 * Set the value of the ExpressionAttributeNames input for this Choreo.
	*(optional, json) One or more substitution tokens for attribute names in an expression.
	 */
	-(void)setExpressionAttributeNames:(NSString*)ExpressionAttributeNames {
		[super setInput:@"ExpressionAttributeNames" toValue:ExpressionAttributeNames];
	}

	/*!
	 * Set the value of the ExpressionAttributeValues input for this Choreo.
	*(optional, json) One or more values that can be substituted in an expression.
	 */
	-(void)setExpressionAttributeValues:(NSString*)ExpressionAttributeValues {
		[super setInput:@"ExpressionAttributeValues" toValue:ExpressionAttributeValues];
	}

	/*!
	 * Set the value of the Key input for this Choreo.
	*(required, json) A map of attribute names to AttributeValue objects, representing the primary key of the item to delete.
	 */
	-(void)setKey:(NSString*)Key {
		[super setInput:@"Key" toValue:Key];
	}

	/*!
	 * Set the value of the ReturnConsumedCapacity input for this Choreo.
	*(optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
	 */
	-(void)setReturnConsumedCapacity:(NSString*)ReturnConsumedCapacity {
		[super setInput:@"ReturnConsumedCapacity" toValue:ReturnConsumedCapacity];
	}

	/*!
	 * Set the value of the ReturnItemCollectionMetrics input for this Choreo.
	*(optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.
	 */
	-(void)setReturnItemCollectionMetrics:(NSString*)ReturnItemCollectionMetrics {
		[super setInput:@"ReturnItemCollectionMetrics" toValue:ReturnItemCollectionMetrics];
	}

	/*!
	 * Set the value of the ReturnValues input for this Choreo.
	*(optional, string) Use ReturnValues if you want to get the item attributes as they appeared before they were deleted. Valid values are NONE and ALL_OLD.
	 */
	-(void)setReturnValues:(NSString*)ReturnValues {
		[super setInput:@"ReturnValues" toValue:ReturnValues];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table from which to delete the item.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_DeleteItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a single item in a table by primary key.
 */
@implementation TMBAmazon_DynamoDB_DeleteItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_DeleteItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/DeleteItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_DeleteItem_ResultSet *results = [[TMBAmazon_DynamoDB_DeleteItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_DeleteItem_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_DeleteItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteTable Choreo.
 */
@implementation TMBAmazon_DynamoDB_DeleteTable_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table to delete.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteTable Choreo.
 */
@implementation TMBAmazon_DynamoDB_DeleteTable_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a table and all of its items.
 */
@implementation TMBAmazon_DynamoDB_DeleteTable

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_DeleteTable Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/DeleteTable"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_DeleteTable_ResultSet *results = [[TMBAmazon_DynamoDB_DeleteTable_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteTable Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_DeleteTable_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_DeleteTable_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeLimits Choreo.
 */
@implementation TMBAmazon_DynamoDB_DescribeLimits_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeLimits Choreo.
 */
@implementation TMBAmazon_DynamoDB_DescribeLimits_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the current provisioned-capacity limits for your AWS account in a region, both for the region as a whole and for any one DynamoDB table that you create there.
 */
@implementation TMBAmazon_DynamoDB_DescribeLimits

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_DescribeLimits Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/DescribeLimits"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_DescribeLimits_ResultSet *results = [[TMBAmazon_DynamoDB_DescribeLimits_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeLimits Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_DescribeLimits_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_DescribeLimits_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeTable Choreo.
 */
@implementation TMBAmazon_DynamoDB_DescribeTable_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table to describe.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeTable Choreo.
 */
@implementation TMBAmazon_DynamoDB_DescribeTable_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns information about the table.
 */
@implementation TMBAmazon_DynamoDB_DescribeTable

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_DescribeTable Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/DescribeTable"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_DescribeTable_ResultSet *results = [[TMBAmazon_DynamoDB_DescribeTable_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeTable Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_DescribeTable_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_DescribeTable_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_GetItem_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ConsistentRead input for this Choreo.
	*(optional, boolean) Determines the read consistency model: If set to true, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
	 */
	-(void)setConsistentRead:(NSString*)ConsistentRead {
		[super setInput:@"ConsistentRead" toValue:ConsistentRead];
	}

	/*!
	 * Set the value of the ExpressionAttributeNames input for this Choreo.
	*(optional, json) One or more substitution tokens for attribute names in an expression.
	 */
	-(void)setExpressionAttributeNames:(NSString*)ExpressionAttributeNames {
		[super setInput:@"ExpressionAttributeNames" toValue:ExpressionAttributeNames];
	}

	/*!
	 * Set the value of the Key input for this Choreo.
	*(required, json) A map of attribute names to AttributeValue objects, representing the primary key of the item to retrieve.
	 */
	-(void)setKey:(NSString*)Key {
		[super setInput:@"Key" toValue:Key];
	}

	/*!
	 * Set the value of the ProjectionExpression input for this Choreo.
	*(optional, string) A string that identifies one or more attributes to retrieve from the table.
	 */
	-(void)setProjectionExpression:(NSString*)ProjectionExpression {
		[super setInput:@"ProjectionExpression" toValue:ProjectionExpression];
	}

	/*!
	 * Set the value of the ReturnConsumedCapacity input for this Choreo.
	*(optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
	 */
	-(void)setReturnConsumedCapacity:(NSString*)ReturnConsumedCapacity {
		[super setInput:@"ReturnConsumedCapacity" toValue:ReturnConsumedCapacity];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table containing the requested items.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_GetItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a set of attributes for the item with the given primary key.
 */
@implementation TMBAmazon_DynamoDB_GetItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_GetItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/GetItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_GetItem_ResultSet *results = [[TMBAmazon_DynamoDB_GetItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_GetItem_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_GetItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListTables Choreo.
 */
@implementation TMBAmazon_DynamoDB_ListTables_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ExclusiveStartTableName input for this Choreo.
	*(optional, string) The first table name that this operation will evaluate. Use the value that was returned for LastEvaluatedTableName in a previous request to retrieve the next page of results.
	 */
	-(void)setExclusiveStartTableName:(NSString*)ExclusiveStartTableName {
		[super setInput:@"ExclusiveStartTableName" toValue:ExclusiveStartTableName];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) A maximum number of table names to return. Defaults to 100.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTables Choreo.
 */
@implementation TMBAmazon_DynamoDB_ListTables_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns an array of table names associated with the current account and endpoint.
 */
@implementation TMBAmazon_DynamoDB_ListTables

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_ListTables Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/ListTables"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_ListTables_ResultSet *results = [[TMBAmazon_DynamoDB_ListTables_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListTables Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_ListTables_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_ListTables_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PutItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_PutItem_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ConditionExpression input for this Choreo.
	*(optional, string) A condition that must be satisfied in order for a conditional PutItem operation to succeed.
	 */
	-(void)setConditionExpression:(NSString*)ConditionExpression {
		[super setInput:@"ConditionExpression" toValue:ConditionExpression];
	}

	/*!
	 * Set the value of the ExpressionAttributeNames input for this Choreo.
	*(optional, json) One or more substitution tokens for attribute names in an expression.
	 */
	-(void)setExpressionAttributeNames:(NSString*)ExpressionAttributeNames {
		[super setInput:@"ExpressionAttributeNames" toValue:ExpressionAttributeNames];
	}

	/*!
	 * Set the value of the ExpressionAttributeValues input for this Choreo.
	*(optional, json) One or more values that can be substituted in an expression.
	 */
	-(void)setExpressionAttributeValues:(NSString*)ExpressionAttributeValues {
		[super setInput:@"ExpressionAttributeValues" toValue:ExpressionAttributeValues];
	}

	/*!
	 * Set the value of the Item input for this Choreo.
	*(required, json) A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required.
	 */
	-(void)setItem:(NSString*)Item {
		[super setInput:@"Item" toValue:Item];
	}

	/*!
	 * Set the value of the ReturnConsumedCapacity input for this Choreo.
	*(optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
	 */
	-(void)setReturnConsumedCapacity:(NSString*)ReturnConsumedCapacity {
		[super setInput:@"ReturnConsumedCapacity" toValue:ReturnConsumedCapacity];
	}

	/*!
	 * Set the value of the ReturnItemCollectionMetrics input for this Choreo.
	*(optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.
	 */
	-(void)setReturnItemCollectionMetrics:(NSString*)ReturnItemCollectionMetrics {
		[super setInput:@"ReturnItemCollectionMetrics" toValue:ReturnItemCollectionMetrics];
	}

	/*!
	 * Set the value of the ReturnValues input for this Choreo.
	*(optional, string) Use ReturnValues if you want to get the item attributes as they appeared before they were updated with the PutItem request. Valid values are NONE and ALL_OLD.
	 */
	-(void)setReturnValues:(NSString*)ReturnValues {
		[super setInput:@"ReturnValues" toValue:ReturnValues];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table to contain the item.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PutItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_PutItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new item, or replaces an old item with a new item.
 */
@implementation TMBAmazon_DynamoDB_PutItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_PutItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/PutItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_PutItem_ResultSet *results = [[TMBAmazon_DynamoDB_PutItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PutItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_PutItem_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_PutItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the Query Choreo.
 */
@implementation TMBAmazon_DynamoDB_Query_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ConsistentRead input for this Choreo.
	*(optional, boolean) Determines the read consistency model: If set to true, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
	 */
	-(void)setConsistentRead:(NSString*)ConsistentRead {
		[super setInput:@"ConsistentRead" toValue:ConsistentRead];
	}

	/*!
	 * Set the value of the ExclusiveStartKey input for this Choreo.
	*(optional, json) The primary key of the first item that this operation will evaluate. Use the value that was returned for LastEvaluatedKey in the previous operation.
	 */
	-(void)setExclusiveStartKey:(NSString*)ExclusiveStartKey {
		[super setInput:@"ExclusiveStartKey" toValue:ExclusiveStartKey];
	}

	/*!
	 * Set the value of the ExpressionAttributeNames input for this Choreo.
	*(optional, json) One or more substitution tokens for attribute names in an expression.
	 */
	-(void)setExpressionAttributeNames:(NSString*)ExpressionAttributeNames {
		[super setInput:@"ExpressionAttributeNames" toValue:ExpressionAttributeNames];
	}

	/*!
	 * Set the value of the ExpressionAttributeValues input for this Choreo.
	*(conditional, json) One or more values that can be substituted in an expression.
	 */
	-(void)setExpressionAttributeValues:(NSString*)ExpressionAttributeValues {
		[super setInput:@"ExpressionAttributeValues" toValue:ExpressionAttributeValues];
	}

	/*!
	 * Set the value of the FilterExpression input for this Choreo.
	*(optional, string) A string that contains conditions that DynamoDB applies after the Query operation, but before the data is returned to you.
	 */
	-(void)setFilterExpression:(NSString*)FilterExpression {
		[super setInput:@"FilterExpression" toValue:FilterExpression];
	}

	/*!
	 * Set the value of the IndexName input for this Choreo.
	*(optional, string) The name of an index to query. This index can be any local secondary index or global secondary index on the table.
	 */
	-(void)setIndexName:(NSString*)IndexName {
		[super setInput:@"IndexName" toValue:IndexName];
	}

	/*!
	 * Set the value of the KeyConditionExpression input for this Choreo.
	*(conditional, string) The condition that specifies the key value(s) for items to be retrieved by the Query action.
	 */
	-(void)setKeyConditionExpression:(NSString*)KeyConditionExpression {
		[super setInput:@"KeyConditionExpression" toValue:KeyConditionExpression];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) The maximum number of items to evaluate (not necessarily the number of matching items).
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the ProjectionExpression input for this Choreo.
	*(optional, string) A string that identifies one or more attributes to retrieve from the table.
	 */
	-(void)setProjectionExpression:(NSString*)ProjectionExpression {
		[super setInput:@"ProjectionExpression" toValue:ProjectionExpression];
	}

	/*!
	 * Set the value of the ReturnConsumedCapacity input for this Choreo.
	*(optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
	 */
	-(void)setReturnConsumedCapacity:(NSString*)ReturnConsumedCapacity {
		[super setInput:@"ReturnConsumedCapacity" toValue:ReturnConsumedCapacity];
	}

	/*!
	 * Set the value of the ScanIndexForward input for this Choreo.
	*(optional, boolean) Specifies the order for index traversal: If true (default), the traversal is performed in ascending order; if false, the traversal is performed in descending order.
	 */
	-(void)setScanIndexForward:(NSString*)ScanIndexForward {
		[super setInput:@"ScanIndexForward" toValue:ScanIndexForward];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) The attributes to be returned in the result. Valid values are: ALL_ATTRIBUTES, ALL_PROJECTED_ATTRIBUTES, SPECIFIC_ATTRIBUTES, and COUNT.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table containing the requested items.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Query Choreo.
 */
@implementation TMBAmazon_DynamoDB_Query_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries a table using the primary key or a secondary index.
 */
@implementation TMBAmazon_DynamoDB_Query

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_Query Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/Query"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_Query_ResultSet *results = [[TMBAmazon_DynamoDB_Query_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the Query Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_Query_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_Query_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the Scan Choreo.
 */
@implementation TMBAmazon_DynamoDB_Scan_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ConsistentRead input for this Choreo.
	*(optional, boolean) A Boolean value that determines the read consistency model during the scan.
	 */
	-(void)setConsistentRead:(NSString*)ConsistentRead {
		[super setInput:@"ConsistentRead" toValue:ConsistentRead];
	}

	/*!
	 * Set the value of the ExclusiveStartKey input for this Choreo.
	*(optional, json) The primary key of the first item that this operation will evaluate. Use the value that was returned for LastEvaluatedKey in the previous operation.
	 */
	-(void)setExclusiveStartKey:(NSString*)ExclusiveStartKey {
		[super setInput:@"ExclusiveStartKey" toValue:ExclusiveStartKey];
	}

	/*!
	 * Set the value of the ExpressionAttributeNames input for this Choreo.
	*(optional, json) One or more substitution tokens for attribute names in an expression.
	 */
	-(void)setExpressionAttributeNames:(NSString*)ExpressionAttributeNames {
		[super setInput:@"ExpressionAttributeNames" toValue:ExpressionAttributeNames];
	}

	/*!
	 * Set the value of the ExpressionAttributeValues input for this Choreo.
	*(optional, json) One or more values that can be substituted in an expression.
	 */
	-(void)setExpressionAttributeValues:(NSString*)ExpressionAttributeValues {
		[super setInput:@"ExpressionAttributeValues" toValue:ExpressionAttributeValues];
	}

	/*!
	 * Set the value of the FilterExpression input for this Choreo.
	*(optional, string) A string that contains conditions that DynamoDB applies after the Scan operation, but before the data is returned to you.
	 */
	-(void)setFilterExpression:(NSString*)FilterExpression {
		[super setInput:@"FilterExpression" toValue:FilterExpression];
	}

	/*!
	 * Set the value of the IndexName input for this Choreo.
	*(optional, string) The name of an index to scan. This index can be any local secondary index or global secondary index on the table.
	 */
	-(void)setIndexName:(NSString*)IndexName {
		[super setInput:@"IndexName" toValue:IndexName];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) The maximum number of items to evaluate (not necessarily the number of matching items).
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the ProjectionExpression input for this Choreo.
	*(optional, string) A string that identifies one or more attributes to retrieve from the table.
	 */
	-(void)setProjectionExpression:(NSString*)ProjectionExpression {
		[super setInput:@"ProjectionExpression" toValue:ProjectionExpression];
	}

	/*!
	 * Set the value of the ReturnConsumedCapacity input for this Choreo.
	*(optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
	 */
	-(void)setReturnConsumedCapacity:(NSString*)ReturnConsumedCapacity {
		[super setInput:@"ReturnConsumedCapacity" toValue:ReturnConsumedCapacity];
	}

	/*!
	 * Set the value of the Segment input for this Choreo.
	*(optional, integer) For a parallel Scan request, Segment identifies an individual segment to be scanned by an application worker.
	 */
	-(void)setSegment:(NSString*)Segment {
		[super setInput:@"Segment" toValue:Segment];
	}

	/*!
	 * Set the value of the Select input for this Choreo.
	*(optional, string) The attributes to be returned in the result. Valid values are: ALL_ATTRIBUTES, ALL_PROJECTED_ATTRIBUTES, SPECIFIC_ATTRIBUTES, and COUNT.
	 */
	-(void)setSelect:(NSString*)Select {
		[super setInput:@"Select" toValue:Select];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table containing the requested items.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the TotalSegments input for this Choreo.
	*(optional, integer) Specifies the order for index traversal: If true (default), the traversal is performed in ascending order; if false, the traversal is performed in descending order.
	 */
	-(void)setTotalSegments:(NSString*)TotalSegments {
		[super setInput:@"TotalSegments" toValue:TotalSegments];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Scan Choreo.
 */
@implementation TMBAmazon_DynamoDB_Scan_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns one or more items and item attributes by accessing every item in a table or a secondary index.
 */
@implementation TMBAmazon_DynamoDB_Scan

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_Scan Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/Scan"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_Scan_ResultSet *results = [[TMBAmazon_DynamoDB_Scan_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the Scan Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_Scan_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_Scan_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_UpdateItem_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ConditionExpression input for this Choreo.
	*(optional, string) A condition that must be satisfied in order for a conditional update to succeed.
	 */
	-(void)setConditionExpression:(NSString*)ConditionExpression {
		[super setInput:@"ConditionExpression" toValue:ConditionExpression];
	}

	/*!
	 * Set the value of the ExpressionAttributeNames input for this Choreo.
	*(optional, json) One or more substitution tokens for attribute names in an expression.
	 */
	-(void)setExpressionAttributeNames:(NSString*)ExpressionAttributeNames {
		[super setInput:@"ExpressionAttributeNames" toValue:ExpressionAttributeNames];
	}

	/*!
	 * Set the value of the ExpressionAttributeValues input for this Choreo.
	*(optional, json) One or more values that can be substituted in an expression.
	 */
	-(void)setExpressionAttributeValues:(NSString*)ExpressionAttributeValues {
		[super setInput:@"ExpressionAttributeValues" toValue:ExpressionAttributeValues];
	}

	/*!
	 * Set the value of the Key input for this Choreo.
	*(required, json) The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.
	 */
	-(void)setKey:(NSString*)Key {
		[super setInput:@"Key" toValue:Key];
	}

	/*!
	 * Set the value of the ReturnConsumedCapacity input for this Choreo.
	*(optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
	 */
	-(void)setReturnConsumedCapacity:(NSString*)ReturnConsumedCapacity {
		[super setInput:@"ReturnConsumedCapacity" toValue:ReturnConsumedCapacity];
	}

	/*!
	 * Set the value of the ReturnItemCollectionMetrics input for this Choreo.
	*(optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.
	 */
	-(void)setReturnItemCollectionMetrics:(NSString*)ReturnItemCollectionMetrics {
		[super setInput:@"ReturnItemCollectionMetrics" toValue:ReturnItemCollectionMetrics];
	}

	/*!
	 * Set the value of the ReturnValues input for this Choreo.
	*(optional, string) Use ReturnValues if you want to get the item attributes as they appeared either before or after they were updated. Valid values are NONE and ALL_OLD.
	 */
	-(void)setReturnValues:(NSString*)ReturnValues {
		[super setInput:@"ReturnValues" toValue:ReturnValues];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table to contain the item.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the UpdateExpression input for this Choreo.
	*(optional, string) An expression that defines one or more attributes to be updated, the action to be performed on them, and new value(s) for them.
	 */
	-(void)setUpdateExpression:(NSString*)UpdateExpression {
		[super setInput:@"UpdateExpression" toValue:UpdateExpression];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateItem Choreo.
 */
@implementation TMBAmazon_DynamoDB_UpdateItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Edits an existing item's attributes, or adds a new item to the table if it does not already exist.
 */
@implementation TMBAmazon_DynamoDB_UpdateItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_UpdateItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/UpdateItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_UpdateItem_ResultSet *results = [[TMBAmazon_DynamoDB_UpdateItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_UpdateItem_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_UpdateItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateTable Choreo.
 */
@implementation TMBAmazon_DynamoDB_UpdateTable_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AttributeDefinitions input for this Choreo.
	*(optional, json) An array of attributes that describe the key schema for the table and indexes.
	 */
	-(void)setAttributeDefinitions:(NSString*)AttributeDefinitions {
		[super setInput:@"AttributeDefinitions" toValue:AttributeDefinitions];
	}

	/*!
	 * Set the value of the GlobalSecondaryIndexUpdates input for this Choreo.
	*(conditional, json) One or more global secondary indexes (the maximum is five) to be created on the table.
	 */
	-(void)setGlobalSecondaryIndexUpdates:(NSString*)GlobalSecondaryIndexUpdates {
		[super setInput:@"GlobalSecondaryIndexUpdates" toValue:GlobalSecondaryIndexUpdates];
	}

	/*!
	 * Set the value of the ProvisionedThroughput input for this Choreo.
	*(conditional, json) Represents the provisioned throughput settings for a specified table or index.
	 */
	-(void)setProvisionedThroughput:(NSString*)ProvisionedThroughput {
		[super setInput:@"ProvisionedThroughput" toValue:ProvisionedThroughput];
	}

	/*!
	 * Set the value of the StreamSpecification input for this Choreo.
	*(conditional, json) The settings for DynamoDB Streams on the table.
	 */
	-(void)setStreamSpecification:(NSString*)StreamSpecification {
		[super setInput:@"StreamSpecification" toValue:StreamSpecification];
	}

	/*!
	 * Set the value of the TableName input for this Choreo.
	*(required, string) The name of the table to create.
	 */
	-(void)setTableName:(NSString*)TableName {
		[super setInput:@"TableName" toValue:TableName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateTable Choreo.
 */
@implementation TMBAmazon_DynamoDB_UpdateTable_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.
 */
@implementation TMBAmazon_DynamoDB_UpdateTable

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_DynamoDB_UpdateTable Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/DynamoDB/UpdateTable"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_DynamoDB_UpdateTable_ResultSet *results = [[TMBAmazon_DynamoDB_UpdateTable_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateTable Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_DynamoDB_UpdateTable_Inputs*)newInputSet {
		return [[TMBAmazon_DynamoDB_UpdateTable_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AllocateAddress Choreo.
 */
@implementation TMBAmazon_EC2_AllocateAddress_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Domain input for this Choreo.
	*(conditional, string) Set to "vpc" to allocate the address for use with instances in a VPC.
	 */
	-(void)setDomain:(NSString*)Domain {
		[super setInput:@"Domain" toValue:Domain];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AllocateAddress Choreo.
 */
@implementation TMBAmazon_EC2_AllocateAddress_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to acquire an Elastic IP address for use with your AWS account.
 */
@implementation TMBAmazon_EC2_AllocateAddress

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_AllocateAddress Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/AllocateAddress"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_AllocateAddress_ResultSet *results = [[TMBAmazon_EC2_AllocateAddress_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AllocateAddress Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_AllocateAddress_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_AllocateAddress_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AssociateAddress Choreo.
 */
@implementation TMBAmazon_EC2_AssociateAddress_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AllocationId input for this Choreo.
	*(optional, string) [EC2-VPC] The allocation ID.  Required for a VPC.
	 */
	-(void)setAllocationId:(NSString*)AllocationId {
		[super setInput:@"AllocationId" toValue:AllocationId];
	}

	/*!
	 * Set the value of the AllowReassociation input for this Choreo.
	*(optional, string) [EC2-VPC] Allows an Elastic IP address that is already associated with an instance or network interface to be re-associated with the specified instance or network interface. False if not specified.
	 */
	-(void)setAllowReassociation:(NSString*)AllowReassociation {
		[super setInput:@"AllowReassociation" toValue:AllowReassociation];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(conditional, string) The ID of the instance.  Required for EC2-Classic. For a VPC, you can specify either an instance ID or a network interface ID, but not both.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the NetworkInterfaceId input for this Choreo.
	*(optional, string) [EC2-VPC] The ID of the network interface. Association fails when specifying an instance ID unless exactly one interface is attached.
	 */
	-(void)setNetworkInterfaceId:(NSString*)NetworkInterfaceId {
		[super setInput:@"NetworkInterfaceId" toValue:NetworkInterfaceId];
	}

	/*!
	 * Set the value of the PrivateIpAddress input for this Choreo.
	*(optional, string) [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If nothing is specified, the Elastic IP address is associated with the primary private IP address.
	 */
	-(void)setPrivateIpAddress:(NSString*)PrivateIpAddress {
		[super setInput:@"PrivateIpAddress" toValue:PrivateIpAddress];
	}

	/*!
	 * Set the value of the PublicIp input for this Choreo.
	*(conditional, string) The Elastic IP address.
	 */
	-(void)setPublicIp:(NSString*)PublicIp {
		[super setInput:@"PublicIp" toValue:PublicIp];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AssociateAddress Choreo.
 */
@implementation TMBAmazon_EC2_AssociateAddress_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Associates an Elastic IP address with an instance or a network interface using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_AssociateAddress

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_AssociateAddress Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/AssociateAddress"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_AssociateAddress_ResultSet *results = [[TMBAmazon_EC2_AssociateAddress_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AssociateAddress Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_AssociateAddress_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_AssociateAddress_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AttachVolume Choreo.
 */
@implementation TMBAmazon_EC2_AttachVolume_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Device input for this Choreo.
	*(required, string) How the device is exposed to the instance (i.e. " /dev/sdh" or "xvdh").
	 */
	-(void)setDevice:(NSString*)Device {
		[super setInput:@"Device" toValue:Device];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(required, string) The ID of the instance to which the volume attaches. The volume and instance must be within the same Availability Zone and the instance must be running.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VolumeId input for this Choreo.
	*(required, string) The ID of the Amazon EBS volume. The volume and instance must be within the same Availability Zone and the instance must be running.
	 */
	-(void)setVolumeId:(NSString*)VolumeId {
		[super setInput:@"VolumeId" toValue:VolumeId];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AttachVolume Choreo.
 */
@implementation TMBAmazon_EC2_AttachVolume_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Attaches an Amazon EBS volume to a running instance and exposes it as the specified device using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_AttachVolume

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_AttachVolume Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/AttachVolume"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_AttachVolume_ResultSet *results = [[TMBAmazon_EC2_AttachVolume_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AttachVolume Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_AttachVolume_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_AttachVolume_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AuthorizeSecurityGroupIngress Choreo.
 */
@implementation TMBAmazon_EC2_AuthorizeSecurityGroupIngress_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupId input for this Choreo.
	*(conditional, string) The ID of the security group to modify. Can be used instead of GroupName.
	 */
	-(void)setGroupId:(NSString*)GroupId {
		[super setInput:@"GroupId" toValue:GroupId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(conditional, string) The name of the security group to modify. Can be used instead of GroupId.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the IpPermissionsCidrIp input for this Choreo.
	*(optional, string) The CIDR range. Cannot be used when specifying a source security group.
	 */
	-(void)setIpPermissionsCidrIp:(NSString*)IpPermissionsCidrIp {
		[super setInput:@"IpPermissionsCidrIp" toValue:IpPermissionsCidrIp];
	}

	/*!
	 * Set the value of the IpPermissionsFromPort input for this Choreo.
	*(optional, integer) The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, you can use -1 to specify all ICMP types.
	 */
	-(void)setIpPermissionsFromPort:(NSString*)IpPermissionsFromPort {
		[super setInput:@"IpPermissionsFromPort" toValue:IpPermissionsFromPort];
	}

	/*!
	 * Set the value of the IpPermissionsGroupId input for this Choreo.
	*(optional, string) The ID of the source security group. Cannot be used when specifying a CIDR IP address.
	 */
	-(void)setIpPermissionsGroupId:(NSString*)IpPermissionsGroupId {
		[super setInput:@"IpPermissionsGroupId" toValue:IpPermissionsGroupId];
	}

	/*!
	 * Set the value of the IpPermissionsGroupName input for this Choreo.
	*(optional, string) The name of the source security group. Cannot be used when specifying a CIDR IP address.
	 */
	-(void)setIpPermissionsGroupName:(NSString*)IpPermissionsGroupName {
		[super setInput:@"IpPermissionsGroupName" toValue:IpPermissionsGroupName];
	}

	/*!
	 * Set the value of the IpPermissionsIpProtocol input for this Choreo.
	*(required, string) The IP protocol name or number. Valid values for EC2-Classic: tcp, udp, icmp (or 6, 17, 1). Valid values for EC2-VPC: tcp, udp, icmp, any valid protocol number (0-254), or -1 (to specify all).
	 */
	-(void)setIpPermissionsIpProtocol:(NSString*)IpPermissionsIpProtocol {
		[super setInput:@"IpPermissionsIpProtocol" toValue:IpPermissionsIpProtocol];
	}

	/*!
	 * Set the value of the IpPermissionsToPort input for this Choreo.
	*(optional, integer) The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, you can use -1 to specify all ICMP codes for the given ICMP type.
	 */
	-(void)setIpPermissionsToPort:(NSString*)IpPermissionsToPort {
		[super setInput:@"IpPermissionsToPort" toValue:IpPermissionsToPort];
	}

	/*!
	 * Set the value of the IpPermissionsUserId input for this Choreo.
	*(optional, string) The AWS account ID that owns the source security group. Cannot be used when specifying a CIDR IP address.
	 */
	-(void)setIpPermissionsUserId:(NSString*)IpPermissionsUserId {
		[super setInput:@"IpPermissionsUserId" toValue:IpPermissionsUserId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AuthorizeSecurityGroupIngress Choreo.
 */
@implementation TMBAmazon_EC2_AuthorizeSecurityGroupIngress_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds an ingress rule to a security group using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_AuthorizeSecurityGroupIngress

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_AuthorizeSecurityGroupIngress Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/AuthorizeSecurityGroupIngress"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_AuthorizeSecurityGroupIngress_ResultSet *results = [[TMBAmazon_EC2_AuthorizeSecurityGroupIngress_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AuthorizeSecurityGroupIngress Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_AuthorizeSecurityGroupIngress_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_AuthorizeSecurityGroupIngress_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateImage Choreo.
 */
@implementation TMBAmazon_EC2_CreateImage_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DeleteOnTermination input for this Choreo.
	*(optional, boolean) Whether the volume is deleted on instance termination. Defaults to "true".
	 */
	-(void)setDeleteOnTermination:(NSString*)DeleteOnTermination {
		[super setInput:@"DeleteOnTermination" toValue:DeleteOnTermination];
	}

	/*!
	 * Set the value of the Description input for this Choreo.
	*(optional, string) A description for the image you want to create.
	 */
	-(void)setDescription:(NSString*)Description {
		[super setInput:@"Description" toValue:Description];
	}

	/*!
	 * Set the value of the DeviceName input for this Choreo.
	*(conditional, string) The device name exposed to the instance (i.e. /dev/sdh or xvdh). When registering an AMI from a snapshot, DiviceName is required as well as SnapshotId.
	 */
	-(void)setDeviceName:(NSString*)DeviceName {
		[super setInput:@"DeviceName" toValue:DeviceName];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(required, string) The ID of the instance to create the image on.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the Iops input for this Choreo.
	*(conditional, integer) The number of I/O operations per second (IOPS) that the volume supports. Valid range is 100 to 2000.
	 */
	-(void)setIops:(NSString*)Iops {
		[super setInput:@"Iops" toValue:Iops];
	}

	/*!
	 * Set the value of the Name input for this Choreo.
	*(required, string) The name for the image you are creating.
	 */
	-(void)setName:(NSString*)Name {
		[super setInput:@"Name" toValue:Name];
	}

	/*!
	 * Set the value of the NoDevice input for this Choreo.
	*(optional, boolean) Suppresses a device mapping. Defaults to "true".
	 */
	-(void)setNoDevice:(NSString*)NoDevice {
		[super setInput:@"NoDevice" toValue:NoDevice];
	}

	/*!
	 * Set the value of the NoReboot input for this Choreo.
	*(optional, boolean) Defaults to "false". Amazon EC2 will attempt to shut down the instance before and after creating the image. Set to "true" for NoReboot.
	 */
	-(void)setNoReboot:(NSString*)NoReboot {
		[super setInput:@"NoReboot" toValue:NoReboot];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SnapshotId input for this Choreo.
	*(conditional, string) The ID of the snapshot. Required when registering from a snapshot. You must also specify DeviceName with the root device name.
	 */
	-(void)setSnapshotId:(NSString*)SnapshotId {
		[super setInput:@"SnapshotId" toValue:SnapshotId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VirtualName input for this Choreo.
	*(optional, string) The name of the virtual device.
	 */
	-(void)setVirtualName:(NSString*)VirtualName {
		[super setInput:@"VirtualName" toValue:VirtualName];
	}

	/*!
	 * Set the value of the VolumeSize input for this Choreo.
	*(conditional, string) The size of the volume, in GiBs. Required unless you're creating the volume from a snapshot which indicates that the size will be the size of the snapshot.
	 */
	-(void)setVolumeSize:(NSString*)VolumeSize {
		[super setInput:@"VolumeSize" toValue:VolumeSize];
	}

	/*!
	 * Set the value of the VolumeType input for this Choreo.
	*(optional, string) The volume type. Valid values are: standard (the default) and io1.
	 */
	-(void)setVolumeType:(NSString*)VolumeType {
		[super setInput:@"VolumeType" toValue:VolumeType];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateImage Choreo.
 */
@implementation TMBAmazon_EC2_CreateImage_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates an Amazon Machine Image from an Amazon EBS-backed instance using the Amazon EC2 API. The image can be used later to launch other identical servers.
 */
@implementation TMBAmazon_EC2_CreateImage

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_CreateImage Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/CreateImage"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_CreateImage_ResultSet *results = [[TMBAmazon_EC2_CreateImage_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateImage Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_CreateImage_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_CreateImage_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateKeyPair Choreo.
 */
@implementation TMBAmazon_EC2_CreateKeyPair_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the KeyName input for this Choreo.
	*(required, string) A unique name for the key pair.
	 */
	-(void)setKeyName:(NSString*)KeyName {
		[super setInput:@"KeyName" toValue:KeyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateKeyPair Choreo.
 */
@implementation TMBAmazon_EC2_CreateKeyPair_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new 2048-bit RSA key pair with the specified name using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_CreateKeyPair

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_CreateKeyPair Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/CreateKeyPair"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_CreateKeyPair_ResultSet *results = [[TMBAmazon_EC2_CreateKeyPair_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateKeyPair Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_CreateKeyPair_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_CreateKeyPair_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateSecurityGroup Choreo.
 */
@implementation TMBAmazon_EC2_CreateSecurityGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupDescription input for this Choreo.
	*(required, string) A description for the security group that that you want to create.
	 */
	-(void)setGroupDescription:(NSString*)GroupDescription {
		[super setInput:@"GroupDescription" toValue:GroupDescription];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) A name for the security group to create.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VpcId input for this Choreo.
	*(optional, string) The ID of the VPC. Required for EC2-VPC.
	 */
	-(void)setVpcId:(NSString*)VpcId {
		[super setInput:@"VpcId" toValue:VpcId];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateSecurityGroup Choreo.
 */
@implementation TMBAmazon_EC2_CreateSecurityGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new EC2 security group using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_CreateSecurityGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_CreateSecurityGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/CreateSecurityGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_CreateSecurityGroup_ResultSet *results = [[TMBAmazon_EC2_CreateSecurityGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateSecurityGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_CreateSecurityGroup_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_CreateSecurityGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateSnapshot Choreo.
 */
@implementation TMBAmazon_EC2_CreateSnapshot_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Description input for this Choreo.
	*(optional, string) A description for the volume that you want to create.
	 */
	-(void)setDescription:(NSString*)Description {
		[super setInput:@"Description" toValue:Description];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VolumeId input for this Choreo.
	*(required, string) The id of the EBS volume to snapshot.
	 */
	-(void)setVolumeId:(NSString*)VolumeId {
		[super setInput:@"VolumeId" toValue:VolumeId];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateSnapshot Choreo.
 */
@implementation TMBAmazon_EC2_CreateSnapshot_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Create a snapshot from a specified EBS volume using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_CreateSnapshot

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_CreateSnapshot Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/CreateSnapshot"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_CreateSnapshot_ResultSet *results = [[TMBAmazon_EC2_CreateSnapshot_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateSnapshot Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_CreateSnapshot_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_CreateSnapshot_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateTags Choreo.
 */
@implementation TMBAmazon_EC2_CreateTags_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResourceId input for this Choreo.
	*(required, string) The ID of a resource to tag. This can be a comma-separated list of up to 10  Resource IDs.
	 */
	-(void)setResourceId:(NSString*)ResourceId {
		[super setInput:@"ResourceId" toValue:ResourceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the TagKey input for this Choreo.
	*(required, string) The key for a tag.
	 */
	-(void)setTagKey:(NSString*)TagKey {
		[super setInput:@"TagKey" toValue:TagKey];
	}

	/*!
	 * Set the value of the TagValue input for this Choreo.
	*(conditional, string) The value for a tag. If empty, the value will be set to be an empty string.
	 */
	-(void)setTagValue:(NSString*)TagValue {
		[super setInput:@"TagValue" toValue:TagValue];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateTags Choreo.
 */
@implementation TMBAmazon_EC2_CreateTags_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds or overwrites one or more tags for the specified EC2 resource or resources using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_CreateTags

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_CreateTags Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/CreateTags"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_CreateTags_ResultSet *results = [[TMBAmazon_EC2_CreateTags_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateTags Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_CreateTags_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_CreateTags_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateVolume Choreo.
 */
@implementation TMBAmazon_EC2_CreateVolume_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AvailabilityZone input for this Choreo.
	*(required, string) The Availability Zone to use when creating thew new volume (i.e us-east-1a).
	 */
	-(void)setAvailabilityZone:(NSString*)AvailabilityZone {
		[super setInput:@"AvailabilityZone" toValue:AvailabilityZone];
	}

	/*!
	 * Set the value of the Iops input for this Choreo.
	*(optional, integer) The number of I/O operations per second (IOPS) that the volume supports. Valid range is 100 to 2000. Required when the volume type is io1.
	 */
	-(void)setIops:(NSString*)Iops {
		[super setInput:@"Iops" toValue:Iops];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the Size input for this Choreo.
	*(conditional, integer) The size for the volume (in gigabytes) that you are creating. Valid Values are 1-1024. Required if you're not creating a volume from a snapshot. If the volume type is io1, the min size is 10 GiB.
	 */
	-(void)setSize:(NSString*)Size {
		[super setInput:@"Size" toValue:Size];
	}

	/*!
	 * Set the value of the SnapshotId input for this Choreo.
	*(conditional, string) The snapshot from which to create the new volume. Required if you are creating a volume from a snapshot.
	 */
	-(void)setSnapshotId:(NSString*)SnapshotId {
		[super setInput:@"SnapshotId" toValue:SnapshotId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VolumeType input for this Choreo.
	*(optional, string) The volume type.Valid values are: "standard" (the default) and "io1".
	 */
	-(void)setVolumeType:(NSString*)VolumeType {
		[super setInput:@"VolumeType" toValue:VolumeType];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateVolume Choreo.
 */
@implementation TMBAmazon_EC2_CreateVolume_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to create a new EBS volume that your EC2 instance can attach to.
 */
@implementation TMBAmazon_EC2_CreateVolume

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_CreateVolume Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/CreateVolume"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_CreateVolume_ResultSet *results = [[TMBAmazon_EC2_CreateVolume_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateVolume Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_CreateVolume_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_CreateVolume_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteKeyPair Choreo.
 */
@implementation TMBAmazon_EC2_DeleteKeyPair_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the KeyName input for this Choreo.
	*(required, string) A unique name for the key pair.
	 */
	-(void)setKeyName:(NSString*)KeyName {
		[super setInput:@"KeyName" toValue:KeyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteKeyPair Choreo.
 */
@implementation TMBAmazon_EC2_DeleteKeyPair_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified key pair by removing the public key from Amazon EC2 using the Amazon EC2 API. You must own the key pair.
 */
@implementation TMBAmazon_EC2_DeleteKeyPair

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DeleteKeyPair Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DeleteKeyPair"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DeleteKeyPair_ResultSet *results = [[TMBAmazon_EC2_DeleteKeyPair_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteKeyPair Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DeleteKeyPair_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DeleteKeyPair_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteSecurityGroup Choreo.
 */
@implementation TMBAmazon_EC2_DeleteSecurityGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupId input for this Choreo.
	*(conditional, string) The id of the security group to delete. Required unless providing the GroupName.
	 */
	-(void)setGroupId:(NSString*)GroupId {
		[super setInput:@"GroupId" toValue:GroupId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(conditional, string) The name of the security group to delete.Required unless providing the GroupId.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, any) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteSecurityGroup Choreo.
 */
@implementation TMBAmazon_EC2_DeleteSecurityGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to delete a security group using the group name you specify.
 */
@implementation TMBAmazon_EC2_DeleteSecurityGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DeleteSecurityGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DeleteSecurityGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DeleteSecurityGroup_ResultSet *results = [[TMBAmazon_EC2_DeleteSecurityGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteSecurityGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DeleteSecurityGroup_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DeleteSecurityGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteSnapshot Choreo.
 */
@implementation TMBAmazon_EC2_DeleteSnapshot_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SnapshotId input for this Choreo.
	*(required, string) The id of the snapshot to delete.
	 */
	-(void)setSnapshotId:(NSString*)SnapshotId {
		[super setInput:@"SnapshotId" toValue:SnapshotId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteSnapshot Choreo.
 */
@implementation TMBAmazon_EC2_DeleteSnapshot_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to delete a snapshot using a snapshot id that you specify.
 */
@implementation TMBAmazon_EC2_DeleteSnapshot

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DeleteSnapshot Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DeleteSnapshot"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DeleteSnapshot_ResultSet *results = [[TMBAmazon_EC2_DeleteSnapshot_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteSnapshot Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DeleteSnapshot_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DeleteSnapshot_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteTags Choreo.
 */
@implementation TMBAmazon_EC2_DeleteTags_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResourceId input for this Choreo.
	*(required, string) The ID of a resource to tag. This can be a comma-separated list of up to 10  Resource IDs.
	 */
	-(void)setResourceId:(NSString*)ResourceId {
		[super setInput:@"ResourceId" toValue:ResourceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the TagKey input for this Choreo.
	*(required, string) The key for a tag.
	 */
	-(void)setTagKey:(NSString*)TagKey {
		[super setInput:@"TagKey" toValue:TagKey];
	}

	/*!
	 * Set the value of the TagValue input for this Choreo.
	*(optional, string) Indicates a tag should be deleted only if the value matches.To delete a tag regardless of its value, leave this blank. To delete a tag with an empty string value (""), pass the string value "null".
	 */
	-(void)setTagValue:(NSString*)TagValue {
		[super setInput:@"TagValue" toValue:TagValue];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteTags Choreo.
 */
@implementation TMBAmazon_EC2_DeleteTags_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a specific set of tags from a specific set of resources using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_DeleteTags

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DeleteTags Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DeleteTags"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DeleteTags_ResultSet *results = [[TMBAmazon_EC2_DeleteTags_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteTags Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DeleteTags_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DeleteTags_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteVolume Choreo.
 */
@implementation TMBAmazon_EC2_DeleteVolume_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VolumeId input for this Choreo.
	*(required, string) The id of the volume to delete.
	 */
	-(void)setVolumeId:(NSString*)VolumeId {
		[super setInput:@"VolumeId" toValue:VolumeId];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteVolume Choreo.
 */
@implementation TMBAmazon_EC2_DeleteVolume_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to delete a volume using a volume id that you specify.
 */
@implementation TMBAmazon_EC2_DeleteVolume

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DeleteVolume Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DeleteVolume"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DeleteVolume_ResultSet *results = [[TMBAmazon_EC2_DeleteVolume_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteVolume Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DeleteVolume_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DeleteVolume_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeregisterImage Choreo.
 */
@implementation TMBAmazon_EC2_DeregisterImage_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ImageId input for this Choreo.
	*(required, string) The AMI ID.
	 */
	-(void)setImageId:(NSString*)ImageId {
		[super setInput:@"ImageId" toValue:ImageId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeregisterImage Choreo.
 */
@implementation TMBAmazon_EC2_DeregisterImage_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to deregister the specified AMI.
 */
@implementation TMBAmazon_EC2_DeregisterImage

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DeregisterImage Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DeregisterImage"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DeregisterImage_ResultSet *results = [[TMBAmazon_EC2_DeregisterImage_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeregisterImage Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DeregisterImage_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DeregisterImage_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeAddresses Choreo.
 */
@implementation TMBAmazon_EC2_DescribeAddresses_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AllocationId input for this Choreo.
	*(optional, string) One or more allocation IDs corresponding to the address or addresses to describe (VPC addresses only). This can be a comma-separated list of up to 10 Allocation Ids.
	 */
	-(void)setAllocationId:(NSString*)AllocationId {
		[super setInput:@"AllocationId" toValue:AllocationId];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow the results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the PublicIp input for this Choreo.
	*(optional, string) One or more EC2 Elastic IP addresses.  This can be a comma-separated list of up to 10 IP addresses.
	 */
	-(void)setPublicIp:(NSString*)PublicIp {
		[super setInput:@"PublicIp" toValue:PublicIp];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeAddresses Choreo.
 */
@implementation TMBAmazon_EC2_DescribeAddresses_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to describe one or more of your Elastic IP addresses.
 */
@implementation TMBAmazon_EC2_DescribeAddresses

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeAddresses Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeAddresses"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeAddresses_ResultSet *results = [[TMBAmazon_EC2_DescribeAddresses_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeAddresses Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeAddresses_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeAddresses_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeAvailabilityZones Choreo.
 */
@implementation TMBAmazon_EC2_DescribeAvailabilityZones_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the ZoneName input for this Choreo.
	*(optional, string) One or more Availability Zones.  This can be a comma-separated list of up to 10 instance Zones.
	 */
	-(void)setZoneName:(NSString*)ZoneName {
		[super setInput:@"ZoneName" toValue:ZoneName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeAvailabilityZones Choreo.
 */
@implementation TMBAmazon_EC2_DescribeAvailabilityZones_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to return Availability Zones that are available for your EC2 account.
 */
@implementation TMBAmazon_EC2_DescribeAvailabilityZones

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeAvailabilityZones Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeAvailabilityZones"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeAvailabilityZones_ResultSet *results = [[TMBAmazon_EC2_DescribeAvailabilityZones_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeAvailabilityZones Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeAvailabilityZones_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeAvailabilityZones_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeImageAttribute Choreo.
 */
@implementation TMBAmazon_EC2_DescribeImageAttribute_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Attribute input for this Choreo.
	*(required, string) The AMI attribute to get. Valid Values are: description | kernel | ramdisk | launchPermission | productCodes | blockDeviceMapping.
	 */
	-(void)setAttribute:(NSString*)Attribute {
		[super setInput:@"Attribute" toValue:Attribute];
	}

	/*!
	 * Set the value of the ImageId input for this Choreo.
	*(required, string) The AMI ID.
	 */
	-(void)setImageId:(NSString*)ImageId {
		[super setInput:@"ImageId" toValue:ImageId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeImageAttribute Choreo.
 */
@implementation TMBAmazon_EC2_DescribeImageAttribute_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to retrieve information about an attribute of an AMI.
 */
@implementation TMBAmazon_EC2_DescribeImageAttribute

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeImageAttribute Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeImageAttribute"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeImageAttribute_ResultSet *results = [[TMBAmazon_EC2_DescribeImageAttribute_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeImageAttribute Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeImageAttribute_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeImageAttribute_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeImages Choreo.
 */
@implementation TMBAmazon_EC2_DescribeImages_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ExecutableBy input for this Choreo.
	*(optional, string) The user ID that has explicit launch permissions. The user ID can be an AWS account ID, "self", or "all" to return AMIs with public launch permissions.
	 */
	-(void)setExecutableBy:(NSString*)ExecutableBy {
		[super setInput:@"ExecutableBy" toValue:ExecutableBy];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the ImageId input for this Choreo.
	*(conditional, string) The ID of the AMI that you want to return. Returns all AMIs when this parameter is not specified.
	 */
	-(void)setImageId:(NSString*)ImageId {
		[super setInput:@"ImageId" toValue:ImageId];
	}

	/*!
	 * Set the value of the Owner input for this Choreo.
	*(conditional, string) The IDs "amazon", "aws-marketplace", and "self" can be used to include AMIs owned by Amazon, AWS Marketplace, or AMIs owned by you, respectively.
	 */
	-(void)setOwner:(NSString*)Owner {
		[super setInput:@"Owner" toValue:Owner];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeImages Choreo.
 */
@implementation TMBAmazon_EC2_DescribeImages_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to return information about Amazon Machine Image(s) that are available to you.
 */
@implementation TMBAmazon_EC2_DescribeImages

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeImages Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeImages"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeImages_ResultSet *results = [[TMBAmazon_EC2_DescribeImages_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeImages Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeImages_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeImages_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeInstances Choreo.
 */
@implementation TMBAmazon_EC2_DescribeInstances_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(optional, string) The ID(s) of the instance(s) you want to monitor. This can be a comma-separated list of up to 10 instance IDs.  Returns all instances if this parameter is not specified.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeInstances Choreo.
 */
@implementation TMBAmazon_EC2_DescribeInstances_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to return information on EC2 instances associated with your AWS account.
 */
@implementation TMBAmazon_EC2_DescribeInstances

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeInstances Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeInstances"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeInstances_ResultSet *results = [[TMBAmazon_EC2_DescribeInstances_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeInstances Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeInstances_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeInstances_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeKeyPairs Choreo.
 */
@implementation TMBAmazon_EC2_DescribeKeyPairs_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow the results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the KeyName input for this Choreo.
	*(optional, string) One or more key pair names to return. This can be a comma-separated list of up to 10 key pair namess.
	 */
	-(void)setKeyName:(NSString*)KeyName {
		[super setInput:@"KeyName" toValue:KeyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeKeyPairs Choreo.
 */
@implementation TMBAmazon_EC2_DescribeKeyPairs_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to describe one or more of your key pairs.
 */
@implementation TMBAmazon_EC2_DescribeKeyPairs

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeKeyPairs Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeKeyPairs"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeKeyPairs_ResultSet *results = [[TMBAmazon_EC2_DescribeKeyPairs_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeKeyPairs Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeKeyPairs_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeKeyPairs_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeRegions Choreo.
 */
@implementation TMBAmazon_EC2_DescribeRegions_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the RegionName input for this Choreo.
	*(optional, string) One or more region names. This can be a comma-separated list of up to 10 region names.
	 */
	-(void)setRegionName:(NSString*)RegionName {
		[super setInput:@"RegionName" toValue:RegionName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeRegions Choreo.
 */
@implementation TMBAmazon_EC2_DescribeRegions_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to describe one or more regions that are currently available to you.
 */
@implementation TMBAmazon_EC2_DescribeRegions

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeRegions Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeRegions"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeRegions_ResultSet *results = [[TMBAmazon_EC2_DescribeRegions_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeRegions Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeRegions_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeRegions_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeSecurityGroups Choreo.
 */
@implementation TMBAmazon_EC2_DescribeSecurityGroups_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the GroupId input for this Choreo.
	*(optional, string) One or more security group IDs.  This can be a comma-separated list of up to 10 GroupIDs.  If no group names nor group IDs supplied, returns all groups.
	 */
	-(void)setGroupId:(NSString*)GroupId {
		[super setInput:@"GroupId" toValue:GroupId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(optional, string) One or more security group names. This can be a comma-separated list of up to 10 group names.  If no group names nor group IDs supplied, returns all groups.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeSecurityGroups Choreo.
 */
@implementation TMBAmazon_EC2_DescribeSecurityGroups_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to return security group information associated with your AWS Account.
 */
@implementation TMBAmazon_EC2_DescribeSecurityGroups

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeSecurityGroups Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeSecurityGroups"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeSecurityGroups_ResultSet *results = [[TMBAmazon_EC2_DescribeSecurityGroups_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeSecurityGroups Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeSecurityGroups_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeSecurityGroups_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeSnapshots Choreo.
 */
@implementation TMBAmazon_EC2_DescribeSnapshots_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the Owner input for this Choreo.
	*(conditional, string) Returns the snapshots owned by the specified owner. Valid values are: "self" (the default), "amazon", or an AWS Account ID.
	 */
	-(void)setOwner:(NSString*)Owner {
		[super setInput:@"Owner" toValue:Owner];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RestorableBy input for this Choreo.
	*(optional, string) AWS accounts ID that can create volumes from the snapshot.
	 */
	-(void)setRestorableBy:(NSString*)RestorableBy {
		[super setInput:@"RestorableBy" toValue:RestorableBy];
	}

	/*!
	 * Set the value of the SnapshotId input for this Choreo.
	*(optional, string) The ID of the snapshot you want to retrieve. Returns all snapshots if not specified.
	 */
	-(void)setSnapshotId:(NSString*)SnapshotId {
		[super setInput:@"SnapshotId" toValue:SnapshotId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeSnapshots Choreo.
 */
@implementation TMBAmazon_EC2_DescribeSnapshots_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to return information on available Amazon EBS snapshots.
 */
@implementation TMBAmazon_EC2_DescribeSnapshots

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeSnapshots Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeSnapshots"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeSnapshots_ResultSet *results = [[TMBAmazon_EC2_DescribeSnapshots_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeSnapshots Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeSnapshots_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeSnapshots_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeTags Choreo.
 */
@implementation TMBAmazon_EC2_DescribeTags_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeTags Choreo.
 */
@implementation TMBAmazon_EC2_DescribeTags_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to describe one or more of the tags for your EC2 resources. 
 */
@implementation TMBAmazon_EC2_DescribeTags

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeTags Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeTags"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeTags_ResultSet *results = [[TMBAmazon_EC2_DescribeTags_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeTags Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeTags_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeTags_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeVolumes Choreo.
 */
@implementation TMBAmazon_EC2_DescribeVolumes_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the FilterName input for this Choreo.
	*(optional, string) The name of a supported filter to narrow results with.
	 */
	-(void)setFilterName:(NSString*)FilterName {
		[super setInput:@"FilterName" toValue:FilterName];
	}

	/*!
	 * Set the value of the FilterValue input for this Choreo.
	*(optional, string) A value for the specified filter.
	 */
	-(void)setFilterValue:(NSString*)FilterValue {
		[super setInput:@"FilterValue" toValue:FilterValue];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VolumeId input for this Choreo.
	*(conditional, string) The ID of the volume to return. This can be a comma-separated list of up to 10 volume IDs.
	 */
	-(void)setVolumeId:(NSString*)VolumeId {
		[super setInput:@"VolumeId" toValue:VolumeId];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeVolumes Choreo.
 */
@implementation TMBAmazon_EC2_DescribeVolumes_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Queries the Amazon EC2 API to return information for one or more of your Amazon EBS volumes.
 */
@implementation TMBAmazon_EC2_DescribeVolumes

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DescribeVolumes Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DescribeVolumes"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DescribeVolumes_ResultSet *results = [[TMBAmazon_EC2_DescribeVolumes_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeVolumes Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DescribeVolumes_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DescribeVolumes_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DetachVolume Choreo.
 */
@implementation TMBAmazon_EC2_DetachVolume_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Device input for this Choreo.
	*(optional, string) The device name.
	 */
	-(void)setDevice:(NSString*)Device {
		[super setInput:@"Device" toValue:Device];
	}

	/*!
	 * Set the value of the Force input for this Choreo.
	*(required, boolean) Forces detachment if the previous detachment attempt did not occur cleanly. Use this option only as a last resort to detach a volume from a failed instance. Defaults to false.
	 */
	-(void)setForce:(NSString*)Force {
		[super setInput:@"Force" toValue:Force];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(optional, string) The ID of the instance.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VolumeId input for this Choreo.
	*(required, string) The ID of the volume.
	 */
	-(void)setVolumeId:(NSString*)VolumeId {
		[super setInput:@"VolumeId" toValue:VolumeId];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DetachVolume Choreo.
 */
@implementation TMBAmazon_EC2_DetachVolume_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Detaches an Amazon EBS volume from an instance using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_DetachVolume

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DetachVolume Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DetachVolume"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DetachVolume_ResultSet *results = [[TMBAmazon_EC2_DetachVolume_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DetachVolume Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DetachVolume_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DetachVolume_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DisassociateAddress Choreo.
 */
@implementation TMBAmazon_EC2_DisassociateAddress_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AssociationId input for this Choreo.
	*(conditional, string) [EC2-VPC] The association ID corresponding to the Elastic IP address.
	 */
	-(void)setAssociationId:(NSString*)AssociationId {
		[super setInput:@"AssociationId" toValue:AssociationId];
	}

	/*!
	 * Set the value of the PublicIp input for this Choreo.
	*(conditional, string) [EC2-Classic] The Elastic IP address.
	 */
	-(void)setPublicIp:(NSString*)PublicIp {
		[super setInput:@"PublicIp" toValue:PublicIp];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DisassociateAddress Choreo.
 */
@implementation TMBAmazon_EC2_DisassociateAddress_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Disassociates an Elastic IP address from the instance or network interface it's associated with using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_DisassociateAddress

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_DisassociateAddress Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/DisassociateAddress"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_DisassociateAddress_ResultSet *results = [[TMBAmazon_EC2_DisassociateAddress_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DisassociateAddress Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_DisassociateAddress_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_DisassociateAddress_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ImportKeyPair Choreo.
 */
@implementation TMBAmazon_EC2_ImportKeyPair_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the KeyName input for this Choreo.
	*(required, string) A unique name for the key pair.
	 */
	-(void)setKeyName:(NSString*)KeyName {
		[super setInput:@"KeyName" toValue:KeyName];
	}

	/*!
	 * Set the value of the PublicKeyMaterial input for this Choreo.
	*(required, string) The public key. You must Base64-encode the public key material before sending it to AWS.
	 */
	-(void)setPublicKeyMaterial:(NSString*)PublicKeyMaterial {
		[super setInput:@"PublicKeyMaterial" toValue:PublicKeyMaterial];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ImportKeyPair Choreo.
 */
@implementation TMBAmazon_EC2_ImportKeyPair_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to import the public key from an RSA key pair that you created with a third-party tool.
 */
@implementation TMBAmazon_EC2_ImportKeyPair

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_ImportKeyPair Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/ImportKeyPair"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_ImportKeyPair_ResultSet *results = [[TMBAmazon_EC2_ImportKeyPair_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ImportKeyPair Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_ImportKeyPair_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_ImportKeyPair_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ModifyImageAttribute Choreo.
 */
@implementation TMBAmazon_EC2_ModifyImageAttribute_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AddGroup input for this Choreo.
	*(optional, string) Adds the specified group to the image's list of launch permissions. The only valid value is "all".
	 */
	-(void)setAddGroup:(NSString*)AddGroup {
		[super setInput:@"AddGroup" toValue:AddGroup];
	}

	/*!
	 * Set the value of the AddUserId input for this Choreo.
	*(optional, string) Adds the specified AWS account ID to the AMI's list of launch permissions.
	 */
	-(void)setAddUserId:(NSString*)AddUserId {
		[super setInput:@"AddUserId" toValue:AddUserId];
	}

	/*!
	 * Set the value of the Description input for this Choreo.
	*(optional, string) Changes the AMI's description to the specified value.
	 */
	-(void)setDescription:(NSString*)Description {
		[super setInput:@"Description" toValue:Description];
	}

	/*!
	 * Set the value of the ImageId input for this Choreo.
	*(required, string) The AMI ID.
	 */
	-(void)setImageId:(NSString*)ImageId {
		[super setInput:@"ImageId" toValue:ImageId];
	}

	/*!
	 * Set the value of the ProductCode input for this Choreo.
	*(optional, string) Adds the specified product code to the specified Amazon S3-backed AMI. Once you add a product code to an AMI, it can't be removed.
	 */
	-(void)setProductCode:(NSString*)ProductCode {
		[super setInput:@"ProductCode" toValue:ProductCode];
	}

	/*!
	 * Set the value of the RemoveGroup input for this Choreo.
	*(optional, string) Removes the specified group from the image's list of launch permissions. The only valid value is "all".
	 */
	-(void)setRemoveGroup:(NSString*)RemoveGroup {
		[super setInput:@"RemoveGroup" toValue:RemoveGroup];
	}

	/*!
	 * Set the value of the RemoveUserId input for this Choreo.
	*(optional, string) Removes the specified AWS account ID from the AMI's list of launch permissions.
	 */
	-(void)setRemoveUserId:(NSString*)RemoveUserId {
		[super setInput:@"RemoveUserId" toValue:RemoveUserId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ModifyImageAttribute Choreo.
 */
@implementation TMBAmazon_EC2_ModifyImageAttribute_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Modifies an attribute of an AMI using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_ModifyImageAttribute

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_ModifyImageAttribute Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/ModifyImageAttribute"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_ModifyImageAttribute_ResultSet *results = [[TMBAmazon_EC2_ModifyImageAttribute_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ModifyImageAttribute Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_ModifyImageAttribute_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_ModifyImageAttribute_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the MonitorInstances Choreo.
 */
@implementation TMBAmazon_EC2_MonitorInstances_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(required, string) The ID(s) of the instance(s) you want to monitor. This can be a comma-separated list of up to 10 instance IDs.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the MonitorInstances Choreo.
 */
@implementation TMBAmazon_EC2_MonitorInstances_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Enables monitoring for a specified instance using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_MonitorInstances

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_MonitorInstances Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/MonitorInstances"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_MonitorInstances_ResultSet *results = [[TMBAmazon_EC2_MonitorInstances_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the MonitorInstances Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_MonitorInstances_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_MonitorInstances_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RebootInstances Choreo.
 */
@implementation TMBAmazon_EC2_RebootInstances_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(required, string) The ID of the instance to reboot. This can be a comma-separated list of up to 10 instance IDs.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RebootInstances Choreo.
 */
@implementation TMBAmazon_EC2_RebootInstances_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to reboot an instance by specifying the instance ID.
 */
@implementation TMBAmazon_EC2_RebootInstances

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_RebootInstances Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/RebootInstances"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_RebootInstances_ResultSet *results = [[TMBAmazon_EC2_RebootInstances_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RebootInstances Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_RebootInstances_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_RebootInstances_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RegisterImage Choreo.
 */
@implementation TMBAmazon_EC2_RegisterImage_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Architecture input for this Choreo.
	*(optional, string) The architecture of the image. Valid values are: i386 or x86_64. Defaults to i386.
	 */
	-(void)setArchitecture:(NSString*)Architecture {
		[super setInput:@"Architecture" toValue:Architecture];
	}

	/*!
	 * Set the value of the DeleteOnTermination input for this Choreo.
	*(optional, boolean) Whether the Amazon EBS volume is deleted on instance termination. Defaults to true.
	 */
	-(void)setDeleteOnTermination:(NSString*)DeleteOnTermination {
		[super setInput:@"DeleteOnTermination" toValue:DeleteOnTermination];
	}

	/*!
	 * Set the value of the Description input for this Choreo.
	*(optional, string) The description of the AMI.
	 */
	-(void)setDescription:(NSString*)Description {
		[super setInput:@"Description" toValue:Description];
	}

	/*!
	 * Set the value of the DeviceName input for this Choreo.
	*(conditional, string) If registering an Amazon EBS-backed AMI from a snapshot, specify this input with the root device name (e.g., /dev/sda1, or xvda), and SnapshotId.
	 */
	-(void)setDeviceName:(NSString*)DeviceName {
		[super setInput:@"DeviceName" toValue:DeviceName];
	}

	/*!
	 * Set the value of the ImageLocation input for this Choreo.
	*(conditional, string) Full path to your AMI manifest in Amazon S3 storage. Required if registering an Amazon-S3 backed AMI.
	 */
	-(void)setImageLocation:(NSString*)ImageLocation {
		[super setInput:@"ImageLocation" toValue:ImageLocation];
	}

	/*!
	 * Set the value of the Iops input for this Choreo.
	*(conditional, integer) The number of I/O operations per second (IOPS) that the volume supports. A valid range is: 100 to 2000.
	 */
	-(void)setIops:(NSString*)Iops {
		[super setInput:@"Iops" toValue:Iops];
	}

	/*!
	 * Set the value of the KernelId input for this Choreo.
	*(optional, string) The ID of the kernel to select.
	 */
	-(void)setKernelId:(NSString*)KernelId {
		[super setInput:@"KernelId" toValue:KernelId];
	}

	/*!
	 * Set the value of the Name input for this Choreo.
	*(required, string) A name for your AMI.
	 */
	-(void)setName:(NSString*)Name {
		[super setInput:@"Name" toValue:Name];
	}

	/*!
	 * Set the value of the NoDevice input for this Choreo.
	*(optional, boolean) Specifies that no device should be mapped. Defaults to 1 (true).
	 */
	-(void)setNoDevice:(NSString*)NoDevice {
		[super setInput:@"NoDevice" toValue:NoDevice];
	}

	/*!
	 * Set the value of the RamdiskId input for this Choreo.
	*(optional, string) The ID of the RAM disk to select.
	 */
	-(void)setRamdiskId:(NSString*)RamdiskId {
		[super setInput:@"RamdiskId" toValue:RamdiskId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RootDeviceName input for this Choreo.
	*(conditional, string) The root device name (e.g., /dev/sda1, or xvda). Required if registering an Amazon EBS-backed AMI.
	 */
	-(void)setRootDeviceName:(NSString*)RootDeviceName {
		[super setInput:@"RootDeviceName" toValue:RootDeviceName];
	}

	/*!
	 * Set the value of the SnapshotId input for this Choreo.
	*(conditional, string) If registering an Amazon EBS-backed AMI from a snapshot, you must at least specify this input with the snapshot ID, and DeviceName with the root device name.
	 */
	-(void)setSnapshotId:(NSString*)SnapshotId {
		[super setInput:@"SnapshotId" toValue:SnapshotId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VirtualName input for this Choreo.
	*(optional, string) The virtual device name.
	 */
	-(void)setVirtualName:(NSString*)VirtualName {
		[super setInput:@"VirtualName" toValue:VirtualName];
	}

	/*!
	 * Set the value of the VolumeSize input for this Choreo.
	*(conditional, integer) The size of the volume, in GiBs. Required if you are not creating a volume from a snapshot.
	 */
	-(void)setVolumeSize:(NSString*)VolumeSize {
		[super setInput:@"VolumeSize" toValue:VolumeSize];
	}

	/*!
	 * Set the value of the VolumeType input for this Choreo.
	*(optional, string) The volume type. Valid values are: standard and io.
	 */
	-(void)setVolumeType:(NSString*)VolumeType {
		[super setInput:@"VolumeType" toValue:VolumeType];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RegisterImage Choreo.
 */
@implementation TMBAmazon_EC2_RegisterImage_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Registers a new AMI with Amazon EC2 using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_RegisterImage

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_RegisterImage Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/RegisterImage"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_RegisterImage_ResultSet *results = [[TMBAmazon_EC2_RegisterImage_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RegisterImage Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_RegisterImage_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_RegisterImage_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ReleaseAddress Choreo.
 */
@implementation TMBAmazon_EC2_ReleaseAddress_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AllocationId input for this Choreo.
	*(conditional, string) [EC2-VPC] The allocation ID that AWS provided when you allocated the address for use with a VPC.
	 */
	-(void)setAllocationId:(NSString*)AllocationId {
		[super setInput:@"AllocationId" toValue:AllocationId];
	}

	/*!
	 * Set the value of the PublicIp input for this Choreo.
	*(conditional, string) [EC2-Classic] The Elastic IP address.
	 */
	-(void)setPublicIp:(NSString*)PublicIp {
		[super setInput:@"PublicIp" toValue:PublicIp];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ReleaseAddress Choreo.
 */
@implementation TMBAmazon_EC2_ReleaseAddress_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to release an Elastic IP address allocated to your account.
 */
@implementation TMBAmazon_EC2_ReleaseAddress

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_ReleaseAddress Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/ReleaseAddress"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_ReleaseAddress_ResultSet *results = [[TMBAmazon_EC2_ReleaseAddress_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ReleaseAddress Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_ReleaseAddress_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_ReleaseAddress_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RevokeSecurityGroupIngress Choreo.
 */
@implementation TMBAmazon_EC2_RevokeSecurityGroupIngress_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupId input for this Choreo.
	*(conditional, string) The ID of the security group to modify. Can be used instead of GroupName.
	 */
	-(void)setGroupId:(NSString*)GroupId {
		[super setInput:@"GroupId" toValue:GroupId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(conditional, string) The name of the security group to modify. Can be used instead of GroupId.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the IpPermissionsCidrIp input for this Choreo.
	*(optional, string) The CIDR range. Cannot be used when specifying a source security group.
	 */
	-(void)setIpPermissionsCidrIp:(NSString*)IpPermissionsCidrIp {
		[super setInput:@"IpPermissionsCidrIp" toValue:IpPermissionsCidrIp];
	}

	/*!
	 * Set the value of the IpPermissionsFromPort input for this Choreo.
	*(optional, integer) The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, you can use -1 to specify all ICMP types.
	 */
	-(void)setIpPermissionsFromPort:(NSString*)IpPermissionsFromPort {
		[super setInput:@"IpPermissionsFromPort" toValue:IpPermissionsFromPort];
	}

	/*!
	 * Set the value of the IpPermissionsGroupId input for this Choreo.
	*(optional, string) The ID of the source security group. Cannot be used when specifying a CIDR IP address.
	 */
	-(void)setIpPermissionsGroupId:(NSString*)IpPermissionsGroupId {
		[super setInput:@"IpPermissionsGroupId" toValue:IpPermissionsGroupId];
	}

	/*!
	 * Set the value of the IpPermissionsGroupName input for this Choreo.
	*(optional, string) The name of the source security group. Cannot be used when specifying a CIDR IP address.
	 */
	-(void)setIpPermissionsGroupName:(NSString*)IpPermissionsGroupName {
		[super setInput:@"IpPermissionsGroupName" toValue:IpPermissionsGroupName];
	}

	/*!
	 * Set the value of the IpPermissionsIpProtocol input for this Choreo.
	*(required, string) The IP protocol name or number. Valid values for EC2-Classic: tcp, udp, icmp (or 6, 17, 1). Valid values for EC2-VPC: tcp, udp, icmp, any valid protocol number (0-254), or -1 (to specify all).
	 */
	-(void)setIpPermissionsIpProtocol:(NSString*)IpPermissionsIpProtocol {
		[super setInput:@"IpPermissionsIpProtocol" toValue:IpPermissionsIpProtocol];
	}

	/*!
	 * Set the value of the IpPermissionsToPort input for this Choreo.
	*(optional, integer) The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, you can use -1 to specify all ICMP codes for the given ICMP type.
	 */
	-(void)setIpPermissionsToPort:(NSString*)IpPermissionsToPort {
		[super setInput:@"IpPermissionsToPort" toValue:IpPermissionsToPort];
	}

	/*!
	 * Set the value of the IpPermissionsUserId input for this Choreo.
	*(optional, string) The AWS account ID that owns the source security group. Cannot be used when specifying a CIDR IP address.
	 */
	-(void)setIpPermissionsUserId:(NSString*)IpPermissionsUserId {
		[super setInput:@"IpPermissionsUserId" toValue:IpPermissionsUserId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RevokeSecurityGroupIngress Choreo.
 */
@implementation TMBAmazon_EC2_RevokeSecurityGroupIngress_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Removes one or more ingress rules from a security group using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_RevokeSecurityGroupIngress

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_RevokeSecurityGroupIngress Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/RevokeSecurityGroupIngress"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_RevokeSecurityGroupIngress_ResultSet *results = [[TMBAmazon_EC2_RevokeSecurityGroupIngress_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RevokeSecurityGroupIngress Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_RevokeSecurityGroupIngress_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_RevokeSecurityGroupIngress_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RunInstances Choreo.
 */
@implementation TMBAmazon_EC2_RunInstances_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DeleteOnTermination input for this Choreo.
	*(optional, boolean) Sets whether the volume is deleted on instance termination. Defaults to "true". This is a Block Device Mapping parameter.
	 */
	-(void)setDeleteOnTermination:(NSString*)DeleteOnTermination {
		[super setInput:@"DeleteOnTermination" toValue:DeleteOnTermination];
	}

	/*!
	 * Set the value of the DeviceName input for this Choreo.
	*(optional, string) The device name exposed to the instance (i.e. /dev/sdh or xvdh). This is a Block Device Mapping parameter.
	 */
	-(void)setDeviceName:(NSString*)DeviceName {
		[super setInput:@"DeviceName" toValue:DeviceName];
	}

	/*!
	 * Set the value of the ImageId input for this Choreo.
	*(required, string) The ID of the AMI.
	 */
	-(void)setImageId:(NSString*)ImageId {
		[super setInput:@"ImageId" toValue:ImageId];
	}

	/*!
	 * Set the value of the InstanceType input for this Choreo.
	*(optional, string) The instance type (i.e. t1.micro, m1.small, m1.medium, m1.large, m1.xlarge). Default is m1.small.
	 */
	-(void)setInstanceType:(NSString*)InstanceType {
		[super setInput:@"InstanceType" toValue:InstanceType];
	}

	/*!
	 * Set the value of the Iops input for this Choreo.
	*(optional, integer) The number of I/O operations per second (IOPS) that the volume supports. Valid range is 100 to 2000. This is a Block Device Mapping parameter.
	 */
	-(void)setIops:(NSString*)Iops {
		[super setInput:@"Iops" toValue:Iops];
	}

	/*!
	 * Set the value of the KernelId input for this Choreo.
	*(optional, string) The ID of the kernel with which to launch the instance.
	 */
	-(void)setKernelId:(NSString*)KernelId {
		[super setInput:@"KernelId" toValue:KernelId];
	}

	/*!
	 * Set the value of the KeyName input for this Choreo.
	*(optional, string) The name of the key pair to use.
	 */
	-(void)setKeyName:(NSString*)KeyName {
		[super setInput:@"KeyName" toValue:KeyName];
	}

	/*!
	 * Set the value of the MaxCount input for this Choreo.
	*(required, integer) The maximum number of instances to launch. If the value is more than Amazon EC2 can launch, the largest possible number above MinCount will be launched instead.
	 */
	-(void)setMaxCount:(NSString*)MaxCount {
		[super setInput:@"MaxCount" toValue:MaxCount];
	}

	/*!
	 * Set the value of the MinCount input for this Choreo.
	*(required, integer) The minimum number of instances to launch. If the value is more than Amazon EC2 can launch, no instances are launched at all.
	 */
	-(void)setMinCount:(NSString*)MinCount {
		[super setInput:@"MinCount" toValue:MinCount];
	}

	/*!
	 * Set the value of the MonitoringEnabled input for this Choreo.
	*(optional, boolean) Enables monitoring for the instance. Defaults to false.
	 */
	-(void)setMonitoringEnabled:(NSString*)MonitoringEnabled {
		[super setInput:@"MonitoringEnabled" toValue:MonitoringEnabled];
	}

	/*!
	 * Set the value of the NoDevice input for this Choreo.
	*(optional, boolean) Suppresses a device mapping. This is a Block Device Mapping parameter.
	 */
	-(void)setNoDevice:(NSString*)NoDevice {
		[super setInput:@"NoDevice" toValue:NoDevice];
	}

	/*!
	 * Set the value of the PlacementAvailabilityZone input for this Choreo.
	*(optional, string) The Availability Zone to launch the instance into.
	 */
	-(void)setPlacementAvailabilityZone:(NSString*)PlacementAvailabilityZone {
		[super setInput:@"PlacementAvailabilityZone" toValue:PlacementAvailabilityZone];
	}

	/*!
	 * Set the value of the PlacementGroupName input for this Choreo.
	*(optional, string) The name of an existing placement group you want to launch the instance into (for cluster instances).
	 */
	-(void)setPlacementGroupName:(NSString*)PlacementGroupName {
		[super setInput:@"PlacementGroupName" toValue:PlacementGroupName];
	}

	/*!
	 * Set the value of the PlacementTenancy input for this Choreo.
	*(optional, string) The tenancy of the instance. When set to "dedicated", the instance will run on single-tenant hardware and can only be launched into a VPC.
	 */
	-(void)setPlacementTenancy:(NSString*)PlacementTenancy {
		[super setInput:@"PlacementTenancy" toValue:PlacementTenancy];
	}

	/*!
	 * Set the value of the RamdiskId input for this Choreo.
	*(optional, string) The ID of the RAM disk.
	 */
	-(void)setRamdiskId:(NSString*)RamdiskId {
		[super setInput:@"RamdiskId" toValue:RamdiskId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecurityGroup input for this Choreo.
	*(optional, string) One or more security group names. This can be a comma-separated list of up to 10 security group names.
	 */
	-(void)setSecurityGroup:(NSString*)SecurityGroup {
		[super setInput:@"SecurityGroup" toValue:SecurityGroup];
	}

	/*!
	 * Set the value of the SecurityGroupId input for this Choreo.
	*(optional, string) One or more security group IDs. This can be a comma-separated list of up to 10 security group ids.
	 */
	-(void)setSecurityGroupId:(NSString*)SecurityGroupId {
		[super setInput:@"SecurityGroupId" toValue:SecurityGroupId];
	}

	/*!
	 * Set the value of the ShutdownBehavior input for this Choreo.
	*(optional, string) Whether the instance stops or terminates on instance-initiated shutdown. Valid values are: stop and terminate.
	 */
	-(void)setShutdownBehavior:(NSString*)ShutdownBehavior {
		[super setInput:@"ShutdownBehavior" toValue:ShutdownBehavior];
	}

	/*!
	 * Set the value of the SnapshotId input for this Choreo.
	*(optional, string) The ID of the snapshot. This is a Block Device Mapping parameter.
	 */
	-(void)setSnapshotId:(NSString*)SnapshotId {
		[super setInput:@"SnapshotId" toValue:SnapshotId];
	}

	/*!
	 * Set the value of the SubnetId input for this Choreo.
	*(optional, string) The ID of the subnet to launch the instance into (i.e. subnet-dea63cb7).
	 */
	-(void)setSubnetId:(NSString*)SubnetId {
		[super setInput:@"SubnetId" toValue:SubnetId];
	}

	/*!
	 * Set the value of the UserData input for this Choreo.
	*(optional, string) The Base64-encoded MIME user data to be made available to the instance(s).
	 */
	-(void)setUserData:(NSString*)UserData {
		[super setInput:@"UserData" toValue:UserData];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VirtualName input for this Choreo.
	*(optional, string) The name of the virtual device. This is a Block Device Mapping parameter.
	 */
	-(void)setVirtualName:(NSString*)VirtualName {
		[super setInput:@"VirtualName" toValue:VirtualName];
	}

	/*!
	 * Set the value of the VolumeSize input for this Choreo.
	*(optional, string) The size of the volume, in GiBs. Required unless you're creating the volume from a snapshot which indicates that the size will be the size of the snapshot. This is a Block Device Mapping parameter.
	 */
	-(void)setVolumeSize:(NSString*)VolumeSize {
		[super setInput:@"VolumeSize" toValue:VolumeSize];
	}

	/*!
	 * Set the value of the VolumeType input for this Choreo.
	*(optional, string) The volume type. Valid values are: standard (the default) and io1. This is a Block Device Mapping parameter.
	 */
	-(void)setVolumeType:(NSString*)VolumeType {
		[super setInput:@"VolumeType" toValue:VolumeType];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RunInstances Choreo.
 */
@implementation TMBAmazon_EC2_RunInstances_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to launch the specified number of instances of an AMI for which you have permissions.
 */
@implementation TMBAmazon_EC2_RunInstances

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_RunInstances Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/RunInstances"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_RunInstances_ResultSet *results = [[TMBAmazon_EC2_RunInstances_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RunInstances Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_RunInstances_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_RunInstances_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the StartInstances Choreo.
 */
@implementation TMBAmazon_EC2_StartInstances_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(required, string) The instance ID to start. This can be a comma-separated list of up to 10 instance IDs.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the StartInstances Choreo.
 */
@implementation TMBAmazon_EC2_StartInstances_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows you to start an Amazon Machine Image by specifying its instance ID using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_StartInstances

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_StartInstances Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/StartInstances"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_StartInstances_ResultSet *results = [[TMBAmazon_EC2_StartInstances_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the StartInstances Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_StartInstances_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_StartInstances_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the StopInstances Choreo.
 */
@implementation TMBAmazon_EC2_StopInstances_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(required, string) The instance ID to stop. This can be a comma-separated list of up to 10 instance IDs.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the StopInstances Choreo.
 */
@implementation TMBAmazon_EC2_StopInstances_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to stop an Amazon EBS-backed instance.
 */
@implementation TMBAmazon_EC2_StopInstances

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_StopInstances Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/StopInstances"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_StopInstances_ResultSet *results = [[TMBAmazon_EC2_StopInstances_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the StopInstances Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_StopInstances_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_StopInstances_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the TerminateInstances Choreo.
 */
@implementation TMBAmazon_EC2_TerminateInstances_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(required, string) The instance ID to terminate. This can be a comma-separated list of up to 10 instance IDs.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TerminateInstances Choreo.
 */
@implementation TMBAmazon_EC2_TerminateInstances_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Shuts down one or more instances using the Amazon EC2 API.
 */
@implementation TMBAmazon_EC2_TerminateInstances

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_TerminateInstances Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/TerminateInstances"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_TerminateInstances_ResultSet *results = [[TMBAmazon_EC2_TerminateInstances_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the TerminateInstances Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_TerminateInstances_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_TerminateInstances_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UnmonitorInstances Choreo.
 */
@implementation TMBAmazon_EC2_UnmonitorInstances_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceId input for this Choreo.
	*(required, string) The ID(s) of the instance(s) you want to stop monitoring. This can be a comma-separated list of up to 10 instance IDs.
	 */
	-(void)setInstanceId:(NSString*)InstanceId {
		[super setInput:@"InstanceId" toValue:InstanceId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UnmonitorInstances Choreo.
 */
@implementation TMBAmazon_EC2_UnmonitorInstances_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Calls the Amazon EC2 API to disable monitoring for a specified instance.
 */
@implementation TMBAmazon_EC2_UnmonitorInstances

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_EC2_UnmonitorInstances Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/EC2/UnmonitorInstances"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_EC2_UnmonitorInstances_ResultSet *results = [[TMBAmazon_EC2_UnmonitorInstances_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UnmonitorInstances Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_EC2_UnmonitorInstances_Inputs*)newInputSet {
		return [[TMBAmazon_EC2_UnmonitorInstances_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddRoleToInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_AddRoleToInstanceProfile_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceProfileName input for this Choreo.
	*(required, string) Name of the instance profile to update.
	 */
	-(void)setInstanceProfileName:(NSString*)InstanceProfileName {
		[super setInput:@"InstanceProfileName" toValue:InstanceProfileName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RoleName input for this Choreo.
	*(required, string) Name of the role to add.
	 */
	-(void)setRoleName:(NSString*)RoleName {
		[super setInput:@"RoleName" toValue:RoleName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddRoleToInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_AddRoleToInstanceProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds the specified role to the specified instance profile.
 */
@implementation TMBAmazon_IAM_AddRoleToInstanceProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_AddRoleToInstanceProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/AddRoleToInstanceProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_AddRoleToInstanceProfile_ResultSet *results = [[TMBAmazon_IAM_AddRoleToInstanceProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddRoleToInstanceProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_AddRoleToInstanceProfile_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_AddRoleToInstanceProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddUserToGroup Choreo.
 */
@implementation TMBAmazon_IAM_AddUserToGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) The name of the group that the user will be added to.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) The name of the user to add.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddUserToGroup Choreo.
 */
@implementation TMBAmazon_IAM_AddUserToGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds a specified user to a specified group.
 */
@implementation TMBAmazon_IAM_AddUserToGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_AddUserToGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/AddUserToGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_AddUserToGroup_ResultSet *results = [[TMBAmazon_IAM_AddUserToGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddUserToGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_AddUserToGroup_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_AddUserToGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ChangePassword Choreo.
 */
@implementation TMBAmazon_IAM_ChangePassword_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The user's Access Key ID.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The user's Secret Key ID.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the NewPassword input for this Choreo.
	*(required, string) The new password.
	 */
	-(void)setNewPassword:(NSString*)NewPassword {
		[super setInput:@"NewPassword" toValue:NewPassword];
	}

	/*!
	 * Set the value of the OldPassword input for this Choreo.
	*(required, string) The old password.
	 */
	-(void)setOldPassword:(NSString*)OldPassword {
		[super setInput:@"OldPassword" toValue:OldPassword];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ChangePassword Choreo.
 */
@implementation TMBAmazon_IAM_ChangePassword_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows the authenticating user to change their password.
 */
@implementation TMBAmazon_IAM_ChangePassword

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ChangePassword Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ChangePassword"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ChangePassword_ResultSet *results = [[TMBAmazon_IAM_ChangePassword_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ChangePassword Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ChangePassword_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ChangePassword_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateAccessKey Choreo.
 */
@implementation TMBAmazon_IAM_CreateAccessKey_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(conditional, string) The user name that the new key will belong to.  If you do not specify a user name, IAM determines the user name implicitly based on the AWS Access Key ID signing the request. 
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateAccessKey Choreo.
 */
@implementation TMBAmazon_IAM_CreateAccessKey_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new AWS Secret Access Key and corresponding AWS Access Key ID for a specified user.
 */
@implementation TMBAmazon_IAM_CreateAccessKey

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_CreateAccessKey Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/CreateAccessKey"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_CreateAccessKey_ResultSet *results = [[TMBAmazon_IAM_CreateAccessKey_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateAccessKey Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_CreateAccessKey_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_CreateAccessKey_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateAccountAlias Choreo.
 */
@implementation TMBAmazon_IAM_CreateAccountAlias_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AccountAlias input for this Choreo.
	*(required, string) Name of the account alias to create. Must contain only digits, lowercase letters, and hyphens (-), but cannot begin or end with a hyphen. Ex.: alias-account-name.
	 */
	-(void)setAccountAlias:(NSString*)AccountAlias {
		[super setInput:@"AccountAlias" toValue:AccountAlias];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateAccountAlias Choreo.
 */
@implementation TMBAmazon_IAM_CreateAccountAlias_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates an alias for your AWS account.
 */
@implementation TMBAmazon_IAM_CreateAccountAlias

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_CreateAccountAlias Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/CreateAccountAlias"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_CreateAccountAlias_ResultSet *results = [[TMBAmazon_IAM_CreateAccountAlias_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateAccountAlias Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_CreateAccountAlias_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_CreateAccountAlias_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateGroup Choreo.
 */
@implementation TMBAmazon_IAM_CreateGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) The name of the group to create.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the Path input for this Choreo.
	*(optional, string) The path to the group. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPath:(NSString*)Path {
		[super setInput:@"Path" toValue:Path];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateGroup Choreo.
 */
@implementation TMBAmazon_IAM_CreateGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new group in your AWS account.
 */
@implementation TMBAmazon_IAM_CreateGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_CreateGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/CreateGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_CreateGroup_ResultSet *results = [[TMBAmazon_IAM_CreateGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_CreateGroup_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_CreateGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_CreateInstanceProfile_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceProfileName input for this Choreo.
	*(required, string) Name of the instance profile to create.
	 */
	-(void)setInstanceProfileName:(NSString*)InstanceProfileName {
		[super setInput:@"InstanceProfileName" toValue:InstanceProfileName];
	}

	/*!
	 * Set the value of the Path input for this Choreo.
	*(optional, string) The path for the user name. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPath:(NSString*)Path {
		[super setInput:@"Path" toValue:Path];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_CreateInstanceProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new instance profile.
 */
@implementation TMBAmazon_IAM_CreateInstanceProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_CreateInstanceProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/CreateInstanceProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_CreateInstanceProfile_ResultSet *results = [[TMBAmazon_IAM_CreateInstanceProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateInstanceProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_CreateInstanceProfile_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_CreateInstanceProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateLoginProfile Choreo.
 */
@implementation TMBAmazon_IAM_CreateLoginProfile_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the MustChangePassword input for this Choreo.
	*(optional, boolean) Whether or not the user is required to change their password immediately.  Valid values are true/false or 1/0.
	 */
	-(void)setMustChangePassword:(NSString*)MustChangePassword {
		[super setInput:@"MustChangePassword" toValue:MustChangePassword];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, string) The new password for the user.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) The name of the user to create a password for.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateLoginProfile Choreo.
 */
@implementation TMBAmazon_IAM_CreateLoginProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a password for the specified user, which gives the user the ability to access AWS services through the AWS Management Console.
 */
@implementation TMBAmazon_IAM_CreateLoginProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_CreateLoginProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/CreateLoginProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_CreateLoginProfile_ResultSet *results = [[TMBAmazon_IAM_CreateLoginProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateLoginProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_CreateLoginProfile_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_CreateLoginProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateUser Choreo.
 */
@implementation TMBAmazon_IAM_CreateUser_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Path input for this Choreo.
	*(optional, string) The path for the user name. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPath:(NSString*)Path {
		[super setInput:@"Path" toValue:Path];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) The name of the user to create.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateUser Choreo.
 */
@implementation TMBAmazon_IAM_CreateUser_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new user for your AWS account.
 */
@implementation TMBAmazon_IAM_CreateUser

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_CreateUser Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/CreateUser"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_CreateUser_ResultSet *results = [[TMBAmazon_IAM_CreateUser_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateUser Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_CreateUser_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_CreateUser_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateVirtualMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_CreateVirtualMFADevice_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Path input for this Choreo.
	*(optional, string) The path for the virtual MFA device. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPath:(NSString*)Path {
		[super setInput:@"Path" toValue:Path];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the VirtualMFADeviceName input for this Choreo.
	*(required, string) The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA device.
	 */
	-(void)setVirtualMFADeviceName:(NSString*)VirtualMFADeviceName {
		[super setInput:@"VirtualMFADeviceName" toValue:VirtualMFADeviceName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateVirtualMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_CreateVirtualMFADevice_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new virtual MFA device for the AWS account.
 */
@implementation TMBAmazon_IAM_CreateVirtualMFADevice

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_CreateVirtualMFADevice Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/CreateVirtualMFADevice"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_CreateVirtualMFADevice_ResultSet *results = [[TMBAmazon_IAM_CreateVirtualMFADevice_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateVirtualMFADevice Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_CreateVirtualMFADevice_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_CreateVirtualMFADevice_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeactivateMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_DeactivateMFADevice_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SerialNumber input for this Choreo.
	*(required, string) The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.
	 */
	-(void)setSerialNumber:(NSString*)SerialNumber {
		[super setInput:@"SerialNumber" toValue:SerialNumber];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) Name of the user whose MFA device you want to deactivate.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeactivateMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_DeactivateMFADevice_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deactivates the specified MFA device and removes it from association with the user name for which it was originally enabled.
 */
@implementation TMBAmazon_IAM_DeactivateMFADevice

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeactivateMFADevice Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeactivateMFADevice"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeactivateMFADevice_ResultSet *results = [[TMBAmazon_IAM_DeactivateMFADevice_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeactivateMFADevice Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeactivateMFADevice_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeactivateMFADevice_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteAccessKey Choreo.
 */
@implementation TMBAmazon_IAM_DeleteAccessKey_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) An AWS Access Key ID with sufficient permissions to delete the specified AccessKeyId.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID associated with the AWS AccessKey ID with sufficient permissions to delete the AccessKeyId.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AccessKeyId input for this Choreo.
	*(conditional, string) The Access Key ID for the Access Key ID and Secret Access Key you want to delete.
	 */
	-(void)setAccessKeyId:(NSString*)AccessKeyId {
		[super setInput:@"AccessKeyId" toValue:AccessKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(conditional, string) Name of the user whose key you want to delete.  If you do not specify a user name, IAM determines the user name implicitly based on the AWS Access Key ID signing the request.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteAccessKey Choreo.
 */
@implementation TMBAmazon_IAM_DeleteAccessKey_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the access key associated with the specified user.
 */
@implementation TMBAmazon_IAM_DeleteAccessKey

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteAccessKey Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteAccessKey"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteAccessKey_ResultSet *results = [[TMBAmazon_IAM_DeleteAccessKey_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteAccessKey Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteAccessKey_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteAccessKey_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteAccountAlias Choreo.
 */
@implementation TMBAmazon_IAM_DeleteAccountAlias_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AccountAlias input for this Choreo.
	*(required, string) Name of the account alias to delete.
	 */
	-(void)setAccountAlias:(NSString*)AccountAlias {
		[super setInput:@"AccountAlias" toValue:AccountAlias];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteAccountAlias Choreo.
 */
@implementation TMBAmazon_IAM_DeleteAccountAlias_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified AWS account alias.
 */
@implementation TMBAmazon_IAM_DeleteAccountAlias

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteAccountAlias Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteAccountAlias"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteAccountAlias_ResultSet *results = [[TMBAmazon_IAM_DeleteAccountAlias_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteAccountAlias Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteAccountAlias_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteAccountAlias_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteAccountPasswordPolicy Choreo.
 */
@implementation TMBAmazon_IAM_DeleteAccountPasswordPolicy_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteAccountPasswordPolicy Choreo.
 */
@implementation TMBAmazon_IAM_DeleteAccountPasswordPolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the password policy for the AWS account.
 */
@implementation TMBAmazon_IAM_DeleteAccountPasswordPolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteAccountPasswordPolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteAccountPasswordPolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteAccountPasswordPolicy_ResultSet *results = [[TMBAmazon_IAM_DeleteAccountPasswordPolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteAccountPasswordPolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteAccountPasswordPolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteAccountPasswordPolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteGroup Choreo.
 */
@implementation TMBAmazon_IAM_DeleteGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) The name of the group to delete.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteGroup Choreo.
 */
@implementation TMBAmazon_IAM_DeleteGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a specified group.
 */
@implementation TMBAmazon_IAM_DeleteGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteGroup_ResultSet *results = [[TMBAmazon_IAM_DeleteGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteGroup_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteGroupPolicy Choreo.
 */
@implementation TMBAmazon_IAM_DeleteGroupPolicy_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) Name of the group the policy is associated with.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the PolicyName input for this Choreo.
	*(required, string) Name of the policy document.
	 */
	-(void)setPolicyName:(NSString*)PolicyName {
		[super setInput:@"PolicyName" toValue:PolicyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteGroupPolicy Choreo.
 */
@implementation TMBAmazon_IAM_DeleteGroupPolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified policy that is associated with the specified group.
 */
@implementation TMBAmazon_IAM_DeleteGroupPolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteGroupPolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteGroupPolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteGroupPolicy_ResultSet *results = [[TMBAmazon_IAM_DeleteGroupPolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteGroupPolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteGroupPolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteGroupPolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_DeleteInstanceProfile_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceProfileName input for this Choreo.
	*(required, string) Name of the instance profile to delete.
	 */
	-(void)setInstanceProfileName:(NSString*)InstanceProfileName {
		[super setInput:@"InstanceProfileName" toValue:InstanceProfileName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_DeleteInstanceProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified instance profile. 
 */
@implementation TMBAmazon_IAM_DeleteInstanceProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteInstanceProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteInstanceProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteInstanceProfile_ResultSet *results = [[TMBAmazon_IAM_DeleteInstanceProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteInstanceProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteInstanceProfile_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteInstanceProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteLoginProfile Choreo.
 */
@implementation TMBAmazon_IAM_DeleteLoginProfile_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) Name of the user whose login profile you want to delete.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteLoginProfile Choreo.
 */
@implementation TMBAmazon_IAM_DeleteLoginProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the password for the specified user, which terminates the user's ability to access AWS services through the AWS Management Console.
 */
@implementation TMBAmazon_IAM_DeleteLoginProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteLoginProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteLoginProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteLoginProfile_ResultSet *results = [[TMBAmazon_IAM_DeleteLoginProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteLoginProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteLoginProfile_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteLoginProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRole Choreo.
 */
@implementation TMBAmazon_IAM_DeleteRole_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RoleName input for this Choreo.
	*(required, string) Name of the role to delete.
	 */
	-(void)setRoleName:(NSString*)RoleName {
		[super setInput:@"RoleName" toValue:RoleName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRole Choreo.
 */
@implementation TMBAmazon_IAM_DeleteRole_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified role.
 */
@implementation TMBAmazon_IAM_DeleteRole

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteRole Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteRole"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteRole_ResultSet *results = [[TMBAmazon_IAM_DeleteRole_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteRole Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteRole_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteRole_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRolePolicy Choreo.
 */
@implementation TMBAmazon_IAM_DeleteRolePolicy_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the PolicyName input for this Choreo.
	*(required, string) Name of the policy document.
	 */
	-(void)setPolicyName:(NSString*)PolicyName {
		[super setInput:@"PolicyName" toValue:PolicyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RoleName input for this Choreo.
	*(required, string) Name of the role the associated with the policy.
	 */
	-(void)setRoleName:(NSString*)RoleName {
		[super setInput:@"RoleName" toValue:RoleName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRolePolicy Choreo.
 */
@implementation TMBAmazon_IAM_DeleteRolePolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified policy associated with the specified role.
 */
@implementation TMBAmazon_IAM_DeleteRolePolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteRolePolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteRolePolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteRolePolicy_ResultSet *results = [[TMBAmazon_IAM_DeleteRolePolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteRolePolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteRolePolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteRolePolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteServerCertificate Choreo.
 */
@implementation TMBAmazon_IAM_DeleteServerCertificate_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ServerCertificateName input for this Choreo.
	*(required, string) The name of the server certificate you want to delete.
	 */
	-(void)setServerCertificateName:(NSString*)ServerCertificateName {
		[super setInput:@"ServerCertificateName" toValue:ServerCertificateName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteServerCertificate Choreo.
 */
@implementation TMBAmazon_IAM_DeleteServerCertificate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified server certificate.
 */
@implementation TMBAmazon_IAM_DeleteServerCertificate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteServerCertificate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteServerCertificate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteServerCertificate_ResultSet *results = [[TMBAmazon_IAM_DeleteServerCertificate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteServerCertificate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteServerCertificate_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteServerCertificate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteSigningCertificate Choreo.
 */
@implementation TMBAmazon_IAM_DeleteSigningCertificate_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the CertificateId input for this Choreo.
	*(required, string) ID of the signing certificate to delete.
	 */
	-(void)setCertificateId:(NSString*)CertificateId {
		[super setInput:@"CertificateId" toValue:CertificateId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(optional, string) Name of the user the signing certificate belongs to.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteSigningCertificate Choreo.
 */
@implementation TMBAmazon_IAM_DeleteSigningCertificate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified signing certificate associated with the specified user.
 */
@implementation TMBAmazon_IAM_DeleteSigningCertificate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteSigningCertificate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteSigningCertificate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteSigningCertificate_ResultSet *results = [[TMBAmazon_IAM_DeleteSigningCertificate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteSigningCertificate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteSigningCertificate_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteSigningCertificate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteUser Choreo.
 */
@implementation TMBAmazon_IAM_DeleteUser_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) The name of the user to delete.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteUser Choreo.
 */
@implementation TMBAmazon_IAM_DeleteUser_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a specified user. The user must not belong to any groups, have any keys or signing certificates, or have any attached policies.
 */
@implementation TMBAmazon_IAM_DeleteUser

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteUser Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteUser"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteUser_ResultSet *results = [[TMBAmazon_IAM_DeleteUser_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteUser Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteUser_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteUser_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteUserPolicy Choreo.
 */
@implementation TMBAmazon_IAM_DeleteUserPolicy_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the PolicyName input for this Choreo.
	*(required, string) Name of the user policy document you would like to delete.
	 */
	-(void)setPolicyName:(NSString*)PolicyName {
		[super setInput:@"PolicyName" toValue:PolicyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) Name of the user to delete the specified policy for.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteUserPolicy Choreo.
 */
@implementation TMBAmazon_IAM_DeleteUserPolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified policy associated with the specified user.
 */
@implementation TMBAmazon_IAM_DeleteUserPolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteUserPolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteUserPolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteUserPolicy_ResultSet *results = [[TMBAmazon_IAM_DeleteUserPolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteUserPolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteUserPolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteUserPolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteVirtualMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_DeleteVirtualMFADevice_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SerialNumber input for this Choreo.
	*(required, string) The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the same as the ARN.
	 */
	-(void)setSerialNumber:(NSString*)SerialNumber {
		[super setInput:@"SerialNumber" toValue:SerialNumber];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteVirtualMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_DeleteVirtualMFADevice_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a virtual MFA device.  You must deactivate a user's virtual MFA device before you can delete it.
 */
@implementation TMBAmazon_IAM_DeleteVirtualMFADevice

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_DeleteVirtualMFADevice Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/DeleteVirtualMFADevice"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_DeleteVirtualMFADevice_ResultSet *results = [[TMBAmazon_IAM_DeleteVirtualMFADevice_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteVirtualMFADevice Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_DeleteVirtualMFADevice_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_DeleteVirtualMFADevice_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the EnableMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_EnableMFADevice_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AuthenticationCode1 input for this Choreo.
	*(required, string) An authentication code emitted by the device.
	 */
	-(void)setAuthenticationCode1:(NSString*)AuthenticationCode1 {
		[super setInput:@"AuthenticationCode1" toValue:AuthenticationCode1];
	}

	/*!
	 * Set the value of the AuthenticationCode2 input for this Choreo.
	*(required, string) A subsequent authentication code emitted by the device.
	 */
	-(void)setAuthenticationCode2:(NSString*)AuthenticationCode2 {
		[super setInput:@"AuthenticationCode2" toValue:AuthenticationCode2];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SerialNumber input for this Choreo.
	*(required, string) The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the same as the ARN.
	 */
	-(void)setSerialNumber:(NSString*)SerialNumber {
		[super setInput:@"SerialNumber" toValue:SerialNumber];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) Name of the user for whom you want to enable the MFA device.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the EnableMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_EnableMFADevice_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Enables the specified MFA device and associates it with the specified user name. When enabled, the MFA device is required for every subsequent login by the user name associated with the device.
 */
@implementation TMBAmazon_IAM_EnableMFADevice

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_EnableMFADevice Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/EnableMFADevice"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_EnableMFADevice_ResultSet *results = [[TMBAmazon_IAM_EnableMFADevice_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the EnableMFADevice Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_EnableMFADevice_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_EnableMFADevice_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetAccountPasswordPolicy Choreo.
 */
@implementation TMBAmazon_IAM_GetAccountPasswordPolicy_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAccountPasswordPolicy Choreo.
 */
@implementation TMBAmazon_IAM_GetAccountPasswordPolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the password policy for the AWS account.
 */
@implementation TMBAmazon_IAM_GetAccountPasswordPolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetAccountPasswordPolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetAccountPasswordPolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetAccountPasswordPolicy_ResultSet *results = [[TMBAmazon_IAM_GetAccountPasswordPolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetAccountPasswordPolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetAccountPasswordPolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetAccountPasswordPolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetAccountSummary Choreo.
 */
@implementation TMBAmazon_IAM_GetAccountSummary_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAccountSummary Choreo.
 */
@implementation TMBAmazon_IAM_GetAccountSummary_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves account level information about account entity usage and IAM quotas.
 */
@implementation TMBAmazon_IAM_GetAccountSummary

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetAccountSummary Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetAccountSummary"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetAccountSummary_ResultSet *results = [[TMBAmazon_IAM_GetAccountSummary_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetAccountSummary Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetAccountSummary_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetAccountSummary_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetGroup Choreo.
 */
@implementation TMBAmazon_IAM_GetGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) The name of the group to return.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetGroup Choreo.
 */
@implementation TMBAmazon_IAM_GetGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of users that are in the specified group.
 */
@implementation TMBAmazon_IAM_GetGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetGroup_ResultSet *results = [[TMBAmazon_IAM_GetGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetGroup_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetGroupPolicy Choreo.
 */
@implementation TMBAmazon_IAM_GetGroupPolicy_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) The name of the group to return.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the PolicyName input for this Choreo.
	*(required, string) Name of the policy document to get.
	 */
	-(void)setPolicyName:(NSString*)PolicyName {
		[super setInput:@"PolicyName" toValue:PolicyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetGroupPolicy Choreo.
 */
@implementation TMBAmazon_IAM_GetGroupPolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the specified policy document for the specified group.
 */
@implementation TMBAmazon_IAM_GetGroupPolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetGroupPolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetGroupPolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetGroupPolicy_ResultSet *results = [[TMBAmazon_IAM_GetGroupPolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetGroupPolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetGroupPolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetGroupPolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_GetInstanceProfile_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceProfileName input for this Choreo.
	*(required, string) Name of the instance profile to get information about.
	 */
	-(void)setInstanceProfileName:(NSString*)InstanceProfileName {
		[super setInput:@"InstanceProfileName" toValue:InstanceProfileName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_GetInstanceProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves information about the specified instance profile, including the instance profile's path, ARN, and RoleId.
 */
@implementation TMBAmazon_IAM_GetInstanceProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetInstanceProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetInstanceProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetInstanceProfile_ResultSet *results = [[TMBAmazon_IAM_GetInstanceProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetInstanceProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetInstanceProfile_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetInstanceProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLoginProfile Choreo.
 */
@implementation TMBAmazon_IAM_GetLoginProfile_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) Name of the user whose login profile you want to retrieve.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLoginProfile Choreo.
 */
@implementation TMBAmazon_IAM_GetLoginProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the user name and password create date for the specified user.
 */
@implementation TMBAmazon_IAM_GetLoginProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetLoginProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetLoginProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetLoginProfile_ResultSet *results = [[TMBAmazon_IAM_GetLoginProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLoginProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetLoginProfile_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetLoginProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetRole Choreo.
 */
@implementation TMBAmazon_IAM_GetRole_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RoleName input for this Choreo.
	*(required, string) Name of the role to get information about.
	 */
	-(void)setRoleName:(NSString*)RoleName {
		[super setInput:@"RoleName" toValue:RoleName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRole Choreo.
 */
@implementation TMBAmazon_IAM_GetRole_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves information about the specified role, including the role's path, ARN, RoleId, and the policy granting permission to EC2 to assume the role.
 */
@implementation TMBAmazon_IAM_GetRole

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetRole Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetRole"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetRole_ResultSet *results = [[TMBAmazon_IAM_GetRole_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetRole Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetRole_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetRole_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetRolePolicy Choreo.
 */
@implementation TMBAmazon_IAM_GetRolePolicy_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the PolicyName input for this Choreo.
	*(required, string) Name of the policy document to get.
	 */
	-(void)setPolicyName:(NSString*)PolicyName {
		[super setInput:@"PolicyName" toValue:PolicyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RoleName input for this Choreo.
	*(required, string) Name of the role associated with the policy.
	 */
	-(void)setRoleName:(NSString*)RoleName {
		[super setInput:@"RoleName" toValue:RoleName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRolePolicy Choreo.
 */
@implementation TMBAmazon_IAM_GetRolePolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the specified policy document for the specified role.
 */
@implementation TMBAmazon_IAM_GetRolePolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetRolePolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetRolePolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetRolePolicy_ResultSet *results = [[TMBAmazon_IAM_GetRolePolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetRolePolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetRolePolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetRolePolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetServerCertificate Choreo.
 */
@implementation TMBAmazon_IAM_GetServerCertificate_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ServerCertificateName input for this Choreo.
	*(required, string) The name of the server certificate you want to retrieve information about.
	 */
	-(void)setServerCertificateName:(NSString*)ServerCertificateName {
		[super setInput:@"ServerCertificateName" toValue:ServerCertificateName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetServerCertificate Choreo.
 */
@implementation TMBAmazon_IAM_GetServerCertificate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves information about the specified server certificate.
 */
@implementation TMBAmazon_IAM_GetServerCertificate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetServerCertificate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetServerCertificate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetServerCertificate_ResultSet *results = [[TMBAmazon_IAM_GetServerCertificate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetServerCertificate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetServerCertificate_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetServerCertificate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetUser Choreo.
 */
@implementation TMBAmazon_IAM_GetUser_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(conditional, string) The name of the user to retrieve. If you do not specify a user name, IAM determines the user name implicitly based on the AWS Access Key ID signing the request.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUser Choreo.
 */
@implementation TMBAmazon_IAM_GetUser_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves details about a specified user, including the user's path, GUID, and ARN.
 */
@implementation TMBAmazon_IAM_GetUser

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetUser Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetUser"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetUser_ResultSet *results = [[TMBAmazon_IAM_GetUser_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetUser Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetUser_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetUser_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetUserPolicy Choreo.
 */
@implementation TMBAmazon_IAM_GetUserPolicy_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the PolicyName input for this Choreo.
	*(required, string) Name of the policy document to get.
	 */
	-(void)setPolicyName:(NSString*)PolicyName {
		[super setInput:@"PolicyName" toValue:PolicyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) The name of the user to retrieve.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUserPolicy Choreo.
 */
@implementation TMBAmazon_IAM_GetUserPolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the specified policy document for the specified user.
 */
@implementation TMBAmazon_IAM_GetUserPolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_GetUserPolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/GetUserPolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_GetUserPolicy_ResultSet *results = [[TMBAmazon_IAM_GetUserPolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetUserPolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_GetUserPolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_GetUserPolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListAccessKeys Choreo.
 */
@implementation TMBAmazon_IAM_ListAccessKeys_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(conditional, string) Name of the user.  If the UserName field is not specified, the UserName is determined implicitly based on the AWS Access Key ID used to sign the request.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAccessKeys Choreo.
 */
@implementation TMBAmazon_IAM_ListAccessKeys_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns information about the Access Key IDs associated with the specified user.
 */
@implementation TMBAmazon_IAM_ListAccessKeys

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListAccessKeys Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListAccessKeys"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListAccessKeys_ResultSet *results = [[TMBAmazon_IAM_ListAccessKeys_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListAccessKeys Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListAccessKeys_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListAccessKeys_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListAccountAliases Choreo.
 */
@implementation TMBAmazon_IAM_ListAccountAliases_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAccountAliases Choreo.
 */
@implementation TMBAmazon_IAM_ListAccountAliases_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the account aliases associated with the account. 
 */
@implementation TMBAmazon_IAM_ListAccountAliases

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListAccountAliases Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListAccountAliases"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListAccountAliases_ResultSet *results = [[TMBAmazon_IAM_ListAccountAliases_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListAccountAliases Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListAccountAliases_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListAccountAliases_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListGroupPolicies Choreo.
 */
@implementation TMBAmazon_IAM_ListGroupPolicies_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) The name of the group to list policies for.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListGroupPolicies Choreo.
 */
@implementation TMBAmazon_IAM_ListGroupPolicies_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the names of the policies associated with the specified group.
 */
@implementation TMBAmazon_IAM_ListGroupPolicies

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListGroupPolicies Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListGroupPolicies"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListGroupPolicies_ResultSet *results = [[TMBAmazon_IAM_ListGroupPolicies_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListGroupPolicies Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListGroupPolicies_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListGroupPolicies_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListGroups Choreo.
 */
@implementation TMBAmazon_IAM_ListGroups_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the PathPrefix input for this Choreo.
	*(optional, string) The path prefix for filtering the results. For example, "/division_abc/subdivision_xyz/" retrieves all groups whose path starts with that string. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPathPrefix:(NSString*)PathPrefix {
		[super setInput:@"PathPrefix" toValue:PathPrefix];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListGroups Choreo.
 */
@implementation TMBAmazon_IAM_ListGroups_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of groups and allows you to filter the results with a specific path prefix.
 */
@implementation TMBAmazon_IAM_ListGroups

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListGroups Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListGroups"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListGroups_ResultSet *results = [[TMBAmazon_IAM_ListGroups_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListGroups Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListGroups_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListGroups_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListGroupsForUser Choreo.
 */
@implementation TMBAmazon_IAM_ListGroupsForUser_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the PathPrefix input for this Choreo.
	*(optional, string) The path prefix for filtering the results. For example, "/division_abc/subdivision_xyz/" retrieves all groups whose path starts with that string. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPathPrefix:(NSString*)PathPrefix {
		[super setInput:@"PathPrefix" toValue:PathPrefix];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) Lists the groups the specified user belongs to.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListGroupsForUser Choreo.
 */
@implementation TMBAmazon_IAM_ListGroupsForUser_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the groups the specified user belongs to.
 */
@implementation TMBAmazon_IAM_ListGroupsForUser

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListGroupsForUser Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListGroupsForUser"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListGroupsForUser_ResultSet *results = [[TMBAmazon_IAM_ListGroupsForUser_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListGroupsForUser Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListGroupsForUser_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListGroupsForUser_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListInstanceProfiles Choreo.
 */
@implementation TMBAmazon_IAM_ListInstanceProfiles_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the PathPrefix input for this Choreo.
	*(optional, string) The path prefix for filtering the results. For example, "/division_abc/subdivision_xyz/" retrieves all groups whose path starts with that string. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPathPrefix:(NSString*)PathPrefix {
		[super setInput:@"PathPrefix" toValue:PathPrefix];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListInstanceProfiles Choreo.
 */
@implementation TMBAmazon_IAM_ListInstanceProfiles_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the instance profiles that have the specified path prefix.
 */
@implementation TMBAmazon_IAM_ListInstanceProfiles

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListInstanceProfiles Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListInstanceProfiles"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListInstanceProfiles_ResultSet *results = [[TMBAmazon_IAM_ListInstanceProfiles_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListInstanceProfiles Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListInstanceProfiles_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListInstanceProfiles_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListInstanceProfilesForRole Choreo.
 */
@implementation TMBAmazon_IAM_ListInstanceProfilesForRole_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RoleName input for this Choreo.
	*(required, string) The name of the role to list instance profiles for.
	 */
	-(void)setRoleName:(NSString*)RoleName {
		[super setInput:@"RoleName" toValue:RoleName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListInstanceProfilesForRole Choreo.
 */
@implementation TMBAmazon_IAM_ListInstanceProfilesForRole_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the names of the policies associated with the specified role. 
 */
@implementation TMBAmazon_IAM_ListInstanceProfilesForRole

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListInstanceProfilesForRole Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListInstanceProfilesForRole"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListInstanceProfilesForRole_ResultSet *results = [[TMBAmazon_IAM_ListInstanceProfilesForRole_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListInstanceProfilesForRole Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListInstanceProfilesForRole_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListInstanceProfilesForRole_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListMFADevices Choreo.
 */
@implementation TMBAmazon_IAM_ListMFADevices_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(optional, string) Name of the user whose MFA devices you want to list.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListMFADevices Choreo.
 */
@implementation TMBAmazon_IAM_ListMFADevices_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the MFA devices. If the request includes the user name, then this action lists all the MFA devices associated with the specified user name. If you do not specify a user name, IAM determines the user name implicitly based on the AWS Access Key ID signing the request.
 */
@implementation TMBAmazon_IAM_ListMFADevices

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListMFADevices Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListMFADevices"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListMFADevices_ResultSet *results = [[TMBAmazon_IAM_ListMFADevices_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListMFADevices Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListMFADevices_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListMFADevices_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListRolePolicies Choreo.
 */
@implementation TMBAmazon_IAM_ListRolePolicies_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RoleName input for this Choreo.
	*(required, string) Name of the Role that you would like to retrieve policies for.
	 */
	-(void)setRoleName:(NSString*)RoleName {
		[super setInput:@"RoleName" toValue:RoleName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListRolePolicies Choreo.
 */
@implementation TMBAmazon_IAM_ListRolePolicies_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the names of the policies associated with the specified role. 
 */
@implementation TMBAmazon_IAM_ListRolePolicies

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListRolePolicies Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListRolePolicies"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListRolePolicies_ResultSet *results = [[TMBAmazon_IAM_ListRolePolicies_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListRolePolicies Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListRolePolicies_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListRolePolicies_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListRoles Choreo.
 */
@implementation TMBAmazon_IAM_ListRoles_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the PathPrefix input for this Choreo.
	*(optional, string) The path prefix for filtering the results. For example, "/division_abc/subdivision_xyz/" retrieves all groups whose path starts with that string. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPathPrefix:(NSString*)PathPrefix {
		[super setInput:@"PathPrefix" toValue:PathPrefix];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListRoles Choreo.
 */
@implementation TMBAmazon_IAM_ListRoles_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the roles that have the specified path prefix. If there are none, the action returns an empty list.
 */
@implementation TMBAmazon_IAM_ListRoles

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListRoles Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListRoles"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListRoles_ResultSet *results = [[TMBAmazon_IAM_ListRoles_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListRoles Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListRoles_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListRoles_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListServerCertificates Choreo.
 */
@implementation TMBAmazon_IAM_ListServerCertificates_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the PathPrefix input for this Choreo.
	*(optional, string) The path prefix for filtering the results. For example, "/division_abc/subdivision_xyz/" retrieves all groups whose path starts with that string. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPathPrefix:(NSString*)PathPrefix {
		[super setInput:@"PathPrefix" toValue:PathPrefix];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListServerCertificates Choreo.
 */
@implementation TMBAmazon_IAM_ListServerCertificates_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the server certificates that have the specified path prefix. If none exist, the action returns an empty list.
 */
@implementation TMBAmazon_IAM_ListServerCertificates

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListServerCertificates Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListServerCertificates"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListServerCertificates_ResultSet *results = [[TMBAmazon_IAM_ListServerCertificates_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListServerCertificates Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListServerCertificates_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListServerCertificates_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListSigningCertificates Choreo.
 */
@implementation TMBAmazon_IAM_ListSigningCertificates_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(optional, string) The name of the user.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListSigningCertificates Choreo.
 */
@implementation TMBAmazon_IAM_ListSigningCertificates_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns information about the signing certificates associated with the specified user. If there are none, the action returns an empty list.
 */
@implementation TMBAmazon_IAM_ListSigningCertificates

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListSigningCertificates Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListSigningCertificates"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListSigningCertificates_ResultSet *results = [[TMBAmazon_IAM_ListSigningCertificates_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListSigningCertificates Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListSigningCertificates_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListSigningCertificates_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListUserPolicies Choreo.
 */
@implementation TMBAmazon_IAM_ListUserPolicies_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) The name of the user to list policies for.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListUserPolicies Choreo.
 */
@implementation TMBAmazon_IAM_ListUserPolicies_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the names of the policies associated with the specified user.
 */
@implementation TMBAmazon_IAM_ListUserPolicies

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListUserPolicies Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListUserPolicies"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListUserPolicies_ResultSet *results = [[TMBAmazon_IAM_ListUserPolicies_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListUserPolicies Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListUserPolicies_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListUserPolicies_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListUsers Choreo.
 */
@implementation TMBAmazon_IAM_ListUsers_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the PathPrefix input for this Choreo.
	*(conditional, string) The path prefix for filtering the results. For example, "/division_abc/subdivision_xyz/" retrieves all users whose path starts with that string. If it is not included, it defaults to a slash (/).
	 */
	-(void)setPathPrefix:(NSString*)PathPrefix {
		[super setInput:@"PathPrefix" toValue:PathPrefix];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListUsers Choreo.
 */
@implementation TMBAmazon_IAM_ListUsers_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the users that have the specified path prefix. If there are none, the action returns an empty list.
 */
@implementation TMBAmazon_IAM_ListUsers

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListUsers Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListUsers"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListUsers_ResultSet *results = [[TMBAmazon_IAM_ListUsers_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListUsers Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListUsers_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListUsers_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListVirtualMFADevices Choreo.
 */
@implementation TMBAmazon_IAM_ListVirtualMFADevices_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AssignmentStatus input for this Choreo.
	*(optional, string) Filters by the whether the device is assigned or unassigned to a specific user. Valid values: "Unassigned", "Assigned" or "Any" (default - both assigned and unassigned devices).
	 */
	-(void)setAssignmentStatus:(NSString*)AssignmentStatus {
		[super setInput:@"AssignmentStatus" toValue:AssignmentStatus];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, string) Used for pagination to indicate the starting point of the results to return.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxItems input for this Choreo.
	*(optional, integer) Used for pagination to limit the number of results returned. Defaults to 100.
	 */
	-(void)setMaxItems:(NSString*)MaxItems {
		[super setInput:@"MaxItems" toValue:MaxItems];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListVirtualMFADevices Choreo.
 */
@implementation TMBAmazon_IAM_ListVirtualMFADevices_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists the virtual MFA devices under the AWS account.
 */
@implementation TMBAmazon_IAM_ListVirtualMFADevices

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ListVirtualMFADevices Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ListVirtualMFADevices"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ListVirtualMFADevices_ResultSet *results = [[TMBAmazon_IAM_ListVirtualMFADevices_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListVirtualMFADevices Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ListVirtualMFADevices_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ListVirtualMFADevices_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PutGroupPolicy Choreo.
 */
@implementation TMBAmazon_IAM_PutGroupPolicy_Inputs

	/*!
	 * Set the value of the PolicyDocument input for this Choreo.
	*(required, json) The policy document. See documentation for formatting examples.
	 */
	-(void)setPolicyDocument:(NSString*)PolicyDocument {
		[super setInput:@"PolicyDocument" toValue:PolicyDocument];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) The name of the group to associate the policy with.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the PolicyName input for this Choreo.
	*(required, string) The name of the policy document.
	 */
	-(void)setPolicyName:(NSString*)PolicyName {
		[super setInput:@"PolicyName" toValue:PolicyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PutGroupPolicy Choreo.
 */
@implementation TMBAmazon_IAM_PutGroupPolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds or updates a policy document associated with a specified group.
 */
@implementation TMBAmazon_IAM_PutGroupPolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_PutGroupPolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/PutGroupPolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_PutGroupPolicy_ResultSet *results = [[TMBAmazon_IAM_PutGroupPolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PutGroupPolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_PutGroupPolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_PutGroupPolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PutRolePolicy Choreo.
 */
@implementation TMBAmazon_IAM_PutRolePolicy_Inputs

	/*!
	 * Set the value of the PolicyDocument input for this Choreo.
	*(required, json) The policy document. See documentation for formatting examples.
	 */
	-(void)setPolicyDocument:(NSString*)PolicyDocument {
		[super setInput:@"PolicyDocument" toValue:PolicyDocument];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the PolicyName input for this Choreo.
	*(required, string) The name of the policy document.
	 */
	-(void)setPolicyName:(NSString*)PolicyName {
		[super setInput:@"PolicyName" toValue:PolicyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RoleName input for this Choreo.
	*(required, string) The name of the role to associate the policy with.
	 */
	-(void)setRoleName:(NSString*)RoleName {
		[super setInput:@"RoleName" toValue:RoleName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PutRolePolicy Choreo.
 */
@implementation TMBAmazon_IAM_PutRolePolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds or updates a policy document associated with a specified role.
 */
@implementation TMBAmazon_IAM_PutRolePolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_PutRolePolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/PutRolePolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_PutRolePolicy_ResultSet *results = [[TMBAmazon_IAM_PutRolePolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PutRolePolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_PutRolePolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_PutRolePolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PutUserPolicy Choreo.
 */
@implementation TMBAmazon_IAM_PutUserPolicy_Inputs

	/*!
	 * Set the value of the PolicyDocument input for this Choreo.
	*(required, json) The policy document. See documentation for formatting examples.
	 */
	-(void)setPolicyDocument:(NSString*)PolicyDocument {
		[super setInput:@"PolicyDocument" toValue:PolicyDocument];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the PolicyName input for this Choreo.
	*(required, string) The name of the policy document.
	 */
	-(void)setPolicyName:(NSString*)PolicyName {
		[super setInput:@"PolicyName" toValue:PolicyName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) The name of the user to associate the policy with.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PutUserPolicy Choreo.
 */
@implementation TMBAmazon_IAM_PutUserPolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds or updates a policy document associated with a specified user.
 */
@implementation TMBAmazon_IAM_PutUserPolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_PutUserPolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/PutUserPolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_PutUserPolicy_ResultSet *results = [[TMBAmazon_IAM_PutUserPolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PutUserPolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_PutUserPolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_PutUserPolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RemoveRoleFromInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_RemoveRoleFromInstanceProfile_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InstanceProfileName input for this Choreo.
	*(required, string) Name of the instance profile to update.
	 */
	-(void)setInstanceProfileName:(NSString*)InstanceProfileName {
		[super setInput:@"InstanceProfileName" toValue:InstanceProfileName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RoleName input for this Choreo.
	*(required, string) Name of the role to remove.
	 */
	-(void)setRoleName:(NSString*)RoleName {
		[super setInput:@"RoleName" toValue:RoleName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RemoveRoleFromInstanceProfile Choreo.
 */
@implementation TMBAmazon_IAM_RemoveRoleFromInstanceProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Removes the specified Role from the specified Instance Profile.
 */
@implementation TMBAmazon_IAM_RemoveRoleFromInstanceProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_RemoveRoleFromInstanceProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/RemoveRoleFromInstanceProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_RemoveRoleFromInstanceProfile_ResultSet *results = [[TMBAmazon_IAM_RemoveRoleFromInstanceProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RemoveRoleFromInstanceProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_RemoveRoleFromInstanceProfile_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_RemoveRoleFromInstanceProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RemoveUserFromGroup Choreo.
 */
@implementation TMBAmazon_IAM_RemoveUserFromGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) Name of the group to update.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) Name of the user to remove.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RemoveUserFromGroup Choreo.
 */
@implementation TMBAmazon_IAM_RemoveUserFromGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Removes the specified user from the specified group.
 */
@implementation TMBAmazon_IAM_RemoveUserFromGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_RemoveUserFromGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/RemoveUserFromGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_RemoveUserFromGroup_ResultSet *results = [[TMBAmazon_IAM_RemoveUserFromGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RemoveUserFromGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_RemoveUserFromGroup_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_RemoveUserFromGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ResyncMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_ResyncMFADevice_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AuthenticationCode1 input for this Choreo.
	*(required, string) An authentication code emitted by the device.
	 */
	-(void)setAuthenticationCode1:(NSString*)AuthenticationCode1 {
		[super setInput:@"AuthenticationCode1" toValue:AuthenticationCode1];
	}

	/*!
	 * Set the value of the AuthenticationCode2 input for this Choreo.
	*(required, string) A subsequent authentication code emitted by the device.
	 */
	-(void)setAuthenticationCode2:(NSString*)AuthenticationCode2 {
		[super setInput:@"AuthenticationCode2" toValue:AuthenticationCode2];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SerialNumber input for this Choreo.
	*(required, string) The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the same as the ARN.
	 */
	-(void)setSerialNumber:(NSString*)SerialNumber {
		[super setInput:@"SerialNumber" toValue:SerialNumber];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) Name of the user for whom you want to enable the MFA device.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ResyncMFADevice Choreo.
 */
@implementation TMBAmazon_IAM_ResyncMFADevice_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Synchronizes the specified MFA device with AWS servers.
 */
@implementation TMBAmazon_IAM_ResyncMFADevice

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_ResyncMFADevice Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/ResyncMFADevice"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_ResyncMFADevice_ResultSet *results = [[TMBAmazon_IAM_ResyncMFADevice_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ResyncMFADevice Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_ResyncMFADevice_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_ResyncMFADevice_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateAccessKey Choreo.
 */
@implementation TMBAmazon_IAM_UpdateAccessKey_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AccessKeyId input for this Choreo.
	*(conditional, string) The Access Key ID for the Access Key ID and Secret Access Key you want to delete.
	 */
	-(void)setAccessKeyId:(NSString*)AccessKeyId {
		[super setInput:@"AccessKeyId" toValue:AccessKeyId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the Status input for this Choreo.
	*(required, string) The status you want to assign to the Secret Access Key. Active means the key can be used for API calls to AWS, while Inactive means the key cannot be used.
	 */
	-(void)setStatus:(NSString*)Status {
		[super setInput:@"Status" toValue:Status];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(conditional, string) Name of the user whose key you want to update.  If the UserName field is not specified, the UserName is determined implicitly based on the AWS Access Key ID used to sign the request.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateAccessKey Choreo.
 */
@implementation TMBAmazon_IAM_UpdateAccessKey_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Changes the status of the specified access key from Active to Inactive, or vice versa. This action can be used to disable a user's key as part of a key rotation workflow.
 */
@implementation TMBAmazon_IAM_UpdateAccessKey

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_UpdateAccessKey Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/UpdateAccessKey"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_UpdateAccessKey_ResultSet *results = [[TMBAmazon_IAM_UpdateAccessKey_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateAccessKey Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_UpdateAccessKey_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_UpdateAccessKey_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateAccountPasswordPolicy Choreo.
 */
@implementation TMBAmazon_IAM_UpdateAccountPasswordPolicy_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AllowUsersToChangePassword input for this Choreo.
	*(optional, boolean) Determines whether users can set/change their own passwords. Valid values: "true" or "false" (the default).
	 */
	-(void)setAllowUsersToChangePassword:(NSString*)AllowUsersToChangePassword {
		[super setInput:@"AllowUsersToChangePassword" toValue:AllowUsersToChangePassword];
	}

	/*!
	 * Set the value of the ExpirePasswords input for this Choreo.
	*(optional, boolean) Determines whether the passwords expire. Valid values: "true" or "false" (the default).
	 */
	-(void)setExpirePasswords:(NSString*)ExpirePasswords {
		[super setInput:@"ExpirePasswords" toValue:ExpirePasswords];
	}

	/*!
	 * Set the value of the MaxPasswordsAge input for this Choreo.
	*(optional, integer) Maximum age of the passwords before they expire.
	 */
	-(void)setMaxPasswordsAge:(NSString*)MaxPasswordsAge {
		[super setInput:@"MaxPasswordsAge" toValue:MaxPasswordsAge];
	}

	/*!
	 * Set the value of the MinimumPasswordLength input for this Choreo.
	*(optional, integer) Mininum length of the password. Defaults to none.
	 */
	-(void)setMinimumPasswordLength:(NSString*)MinimumPasswordLength {
		[super setInput:@"MinimumPasswordLength" toValue:MinimumPasswordLength];
	}

	/*!
	 * Set the value of the RequireLowercaseCharacters input for this Choreo.
	*(optional, boolean) Determines whether at least one lower-case character is required in the password. Valid values: "true" or "false" (the default).
	 */
	-(void)setRequireLowercaseCharacters:(NSString*)RequireLowercaseCharacters {
		[super setInput:@"RequireLowercaseCharacters" toValue:RequireLowercaseCharacters];
	}

	/*!
	 * Set the value of the RequireNumbers input for this Choreo.
	*(optional, boolean) Determines whether numbers are required in the password. Valid values: "true" or "false" (the default).
	 */
	-(void)setRequireNumbers:(NSString*)RequireNumbers {
		[super setInput:@"RequireNumbers" toValue:RequireNumbers];
	}

	/*!
	 * Set the value of the RequireSymbols input for this Choreo.
	*(optional, boolean) Determines whether symbols are required in the password. Valid values: "true" or "false" (the default).
	 */
	-(void)setRequireSymbols:(NSString*)RequireSymbols {
		[super setInput:@"RequireSymbols" toValue:RequireSymbols];
	}

	/*!
	 * Set the value of the RequireUppercaseCharacters input for this Choreo.
	*(optional, boolean) Determines whether at least one upper-case character is required in the password. Valid values: "true" or "false" (the default).
	 */
	-(void)setRequireUppercaseCharacters:(NSString*)RequireUppercaseCharacters {
		[super setInput:@"RequireUppercaseCharacters" toValue:RequireUppercaseCharacters];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateAccountPasswordPolicy Choreo.
 */
@implementation TMBAmazon_IAM_UpdateAccountPasswordPolicy_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the password policy settings for the account.
 */
@implementation TMBAmazon_IAM_UpdateAccountPasswordPolicy

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_UpdateAccountPasswordPolicy Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/UpdateAccountPasswordPolicy"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_UpdateAccountPasswordPolicy_ResultSet *results = [[TMBAmazon_IAM_UpdateAccountPasswordPolicy_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateAccountPasswordPolicy Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_UpdateAccountPasswordPolicy_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_UpdateAccountPasswordPolicy_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateGroup Choreo.
 */
@implementation TMBAmazon_IAM_UpdateGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the GroupName input for this Choreo.
	*(required, string) The name of the group to update.
	 */
	-(void)setGroupName:(NSString*)GroupName {
		[super setInput:@"GroupName" toValue:GroupName];
	}

	/*!
	 * Set the value of the NewGroupName input for this Choreo.
	*(optional, string) The new name of the group. Include a value here only if you are updating the group's name.
	 */
	-(void)setNewGroupName:(NSString*)NewGroupName {
		[super setInput:@"NewGroupName" toValue:NewGroupName];
	}

	/*!
	 * Set the value of the NewPath input for this Choreo.
	*(optional, string) The new path for the group. Include a value here only if you are changing the user's existing path.
	 */
	-(void)setNewPath:(NSString*)NewPath {
		[super setInput:@"NewPath" toValue:NewPath];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateGroup Choreo.
 */
@implementation TMBAmazon_IAM_UpdateGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the name and/or the path of a specified group.
 */
@implementation TMBAmazon_IAM_UpdateGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_UpdateGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/UpdateGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_UpdateGroup_ResultSet *results = [[TMBAmazon_IAM_UpdateGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_UpdateGroup_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_UpdateGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateLoginProfile Choreo.
 */
@implementation TMBAmazon_IAM_UpdateLoginProfile_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the MustChangePassword input for this Choreo.
	*(optional, boolean) Specifies whether or not the user should be required to change their password immediately.  Valid values are true/false or 1/0.
	 */
	-(void)setMustChangePassword:(NSString*)MustChangePassword {
		[super setInput:@"MustChangePassword" toValue:MustChangePassword];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, string) The new password for the user name.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) The name of the user to update.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateLoginProfile Choreo.
 */
@implementation TMBAmazon_IAM_UpdateLoginProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Changes the password for the specified user.
 */
@implementation TMBAmazon_IAM_UpdateLoginProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_UpdateLoginProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/UpdateLoginProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_UpdateLoginProfile_ResultSet *results = [[TMBAmazon_IAM_UpdateLoginProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateLoginProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_UpdateLoginProfile_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_UpdateLoginProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateServerCertificate Choreo.
 */
@implementation TMBAmazon_IAM_UpdateServerCertificate_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the NewPath input for this Choreo.
	*(conditional, string) The new path for the server certificate. Include this only if you are updating the server certificate's path.
	 */
	-(void)setNewPath:(NSString*)NewPath {
		[super setInput:@"NewPath" toValue:NewPath];
	}

	/*!
	 * Set the value of the NewServerCertificateName input for this Choreo.
	*(conditional, string) The new name for the server certificate. Include this only if you are updating the server certificate's name.
	 */
	-(void)setNewServerCertificateName:(NSString*)NewServerCertificateName {
		[super setInput:@"NewServerCertificateName" toValue:NewServerCertificateName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ServerCertificateName input for this Choreo.
	*(required, string) The name for the server certificate. Do not include the path in this value.
	 */
	-(void)setServerCertificateName:(NSString*)ServerCertificateName {
		[super setInput:@"ServerCertificateName" toValue:ServerCertificateName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateServerCertificate Choreo.
 */
@implementation TMBAmazon_IAM_UpdateServerCertificate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the name and/or the path of the specified server certificate.
 */
@implementation TMBAmazon_IAM_UpdateServerCertificate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_UpdateServerCertificate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/UpdateServerCertificate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_UpdateServerCertificate_ResultSet *results = [[TMBAmazon_IAM_UpdateServerCertificate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateServerCertificate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_UpdateServerCertificate_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_UpdateServerCertificate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateSigningCertificate Choreo.
 */
@implementation TMBAmazon_IAM_UpdateSigningCertificate_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the CertificateId input for this Choreo.
	*(required, string) The ID of the signing certificate you want to update.
	 */
	-(void)setCertificateId:(NSString*)CertificateId {
		[super setInput:@"CertificateId" toValue:CertificateId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the Status input for this Choreo.
	*(required, string) The status you want to assign to the certificate. Active means the certificate can be used for API calls to AWS, while Inactive means the certificate cannot be used.
	 */
	-(void)setStatus:(NSString*)Status {
		[super setInput:@"Status" toValue:Status];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(optional, string) Name of the user the signing certificate belongs to.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateSigningCertificate Choreo.
 */
@implementation TMBAmazon_IAM_UpdateSigningCertificate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Changes the status of the specified signing certificate from active to disabled, or vice versa. This action can be used to disable a user's signing certificate as part of a certificate rotation workflow.
 */
@implementation TMBAmazon_IAM_UpdateSigningCertificate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_UpdateSigningCertificate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/UpdateSigningCertificate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_UpdateSigningCertificate_ResultSet *results = [[TMBAmazon_IAM_UpdateSigningCertificate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateSigningCertificate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_UpdateSigningCertificate_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_UpdateSigningCertificate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateUser Choreo.
 */
@implementation TMBAmazon_IAM_UpdateUser_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the NewPath input for this Choreo.
	*(optional, string) The new path for the user. Include a value here only if you are changing the user's existing path. The path needs to start with and end with a slash(/).  For example, "/Division/HR/".
	 */
	-(void)setNewPath:(NSString*)NewPath {
		[super setInput:@"NewPath" toValue:NewPath];
	}

	/*!
	 * Set the value of the NewUserName input for this Choreo.
	*(optional, string) The new name of the user. Include a value here only if you are updating the user's name.
	 */
	-(void)setNewUserName:(NSString*)NewUserName {
		[super setInput:@"NewUserName" toValue:NewUserName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(required, string) The name of the user to update.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateUser Choreo.
 */
@implementation TMBAmazon_IAM_UpdateUser_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the name and/or the path of a specified user.
 */
@implementation TMBAmazon_IAM_UpdateUser

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_UpdateUser Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/UpdateUser"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_UpdateUser_ResultSet *results = [[TMBAmazon_IAM_UpdateUser_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateUser Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_UpdateUser_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_UpdateUser_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UploadServerCertificate Choreo.
 */
@implementation TMBAmazon_IAM_UploadServerCertificate_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the CertificateBody input for this Choreo.
	*(required, multiline) The contents of the signing certificate.
	 */
	-(void)setCertificateBody:(NSString*)CertificateBody {
		[super setInput:@"CertificateBody" toValue:CertificateBody];
	}

	/*!
	 * Set the value of the CertificateChain input for this Choreo.
	*(optional, multiline) The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key certificates of the chain.
	 */
	-(void)setCertificateChain:(NSString*)CertificateChain {
		[super setInput:@"CertificateChain" toValue:CertificateChain];
	}

	/*!
	 * Set the value of the Path input for this Choreo.
	*(optional, string) The path for the server certificate.
	 */
	-(void)setPath:(NSString*)Path {
		[super setInput:@"Path" toValue:Path];
	}

	/*!
	 * Set the value of the PrivateKey input for this Choreo.
	*(required, multiline) The contents of the private key in PEM-encoded format.
	 */
	-(void)setPrivateKey:(NSString*)PrivateKey {
		[super setInput:@"PrivateKey" toValue:PrivateKey];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ServerCertificateName input for this Choreo.
	*(required, string) The name for the server certificate. Do not include the path in this value.
	 */
	-(void)setServerCertificateName:(NSString*)ServerCertificateName {
		[super setInput:@"ServerCertificateName" toValue:ServerCertificateName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UploadServerCertificate Choreo.
 */
@implementation TMBAmazon_IAM_UploadServerCertificate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Uploads a server certificate entity for the AWS account. The server certificate entity includes a public key certificate, a private key, and an optional certificate chain, which should all be PEM-encoded.
 */
@implementation TMBAmazon_IAM_UploadServerCertificate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_UploadServerCertificate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/UploadServerCertificate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_UploadServerCertificate_ResultSet *results = [[TMBAmazon_IAM_UploadServerCertificate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UploadServerCertificate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_UploadServerCertificate_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_UploadServerCertificate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UploadSigningCertificate Choreo.
 */
@implementation TMBAmazon_IAM_UploadSigningCertificate_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the CertificateBody input for this Choreo.
	*(required, multiline) The contents of the signing certificate.
	 */
	-(void)setCertificateBody:(NSString*)CertificateBody {
		[super setInput:@"CertificateBody" toValue:CertificateBody];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the UserName input for this Choreo.
	*(optional, string) The name of the user.
	 */
	-(void)setUserName:(NSString*)UserName {
		[super setInput:@"UserName" toValue:UserName];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UploadSigningCertificate Choreo.
 */
@implementation TMBAmazon_IAM_UploadSigningCertificate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Uploads an X.509 signing certificate and associates it with the specified user.
 */
@implementation TMBAmazon_IAM_UploadSigningCertificate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_IAM_UploadSigningCertificate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/IAM/UploadSigningCertificate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_IAM_UploadSigningCertificate_ResultSet *results = [[TMBAmazon_IAM_UploadSigningCertificate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UploadSigningCertificate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_IAM_UploadSigningCertificate_Inputs*)newInputSet {
		return [[TMBAmazon_IAM_UploadSigningCertificate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PostText Choreo.
 */
@implementation TMBAmazon_Lex_RuntimeService_PostText_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the InputString input for this Choreo.
	*(required, string) 
	 */
	-(void)setInputString:(NSString*)InputString {
		[super setInput:@"InputString" toValue:InputString];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PostText Choreo.
 */
@implementation TMBAmazon_Lex_RuntimeService_PostText_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a DataSource that includes metadata and data file information, as well as the current status of the DataSource.
 */
@implementation TMBAmazon_Lex_RuntimeService_PostText

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Lex_RuntimeService_PostText Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Lex/RuntimeService/PostText"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Lex_RuntimeService_PostText_ResultSet *results = [[TMBAmazon_Lex_RuntimeService_PostText_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PostText Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Lex_RuntimeService_PostText_Inputs*)newInputSet {
		return [[TMBAmazon_Lex_RuntimeService_PostText_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FinalizeOAuth Choreo.
 */
@implementation TMBAmazon_LoginWithAmazon_FinalizeOAuth_Inputs

	/*!
	 * Set the value of the CallbackID input for this Choreo.
	*(required, string) The callback token returned by the InitializeOAuth Choreo. Used to retrieve the authorization code after the user authorizes.
	 */
	-(void)setCallbackID:(NSString*)CallbackID {
		[super setInput:@"CallbackID" toValue:CallbackID];
	}

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(required, string) The Client ID provided by Amazon.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the ClientSecret input for this Choreo.
	*(required, string) The Client Secret provided by Amazon.
	 */
	-(void)setClientSecret:(NSString*)ClientSecret {
		[super setInput:@"ClientSecret" toValue:ClientSecret];
	}

	/*!
	 * Set the value of the SuppressErrors input for this Choreo.
	*(optional, boolean) When set to true, errors received during the OAuth redirect process will be suppressed and returned in the ErrorMessage output.
	 */
	-(void)setSuppressErrors:(NSString*)SuppressErrors {
		[super setInput:@"SuppressErrors" toValue:SuppressErrors];
	}

	/*!
	 * Set the value of the Timeout input for this Choreo.
	*(optional, integer) The amount of time (in seconds) to poll your Temboo callback URL to see if your app's user has allowed or denied the request for access. Defaults to 20. Max is 60.
	 */
	-(void)setTimeout:(NSString*)Timeout {
		[super setInput:@"Timeout" toValue:Timeout];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FinalizeOAuth Choreo.
 */
@implementation TMBAmazon_LoginWithAmazon_FinalizeOAuth_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "AccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) The access token for the user that has granted access to your application.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getAccessToken {
		return [super getOutputByName:@"AccessToken"];
	}

	/*!
	 * Retrieve the value of the "ErrorMessage" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains an error message if an error occurs during the OAuth redirect process and if SuppressErrors is set to true.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getErrorMessage {
		return [super getOutputByName:@"ErrorMessage"];
	}

	/*!
	 * Retrieve the value of the "Expires" output from an execution of this Choreo.
	 * @return - NSString* (integer) The expiration time of the access_token retrieved.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpires {
		return [super getOutputByName:@"Expires"];
	}

	/*!
	 * Retrieve the value of the "RefreshToken" output from an execution of this Choreo.
	 * @return - NSString* (string) A token that may be used to obtain a new access token when the short-lived access token expires.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getRefreshToken {
		return [super getOutputByName:@"RefreshToken"];
	}
	
@end

/*!
 * Completes the OAuth process by retrieving an Amazon access token for a user, after they have visited the authorization URL returned by the InitializeOAuth Choreo and clicked "allow."
 */
@implementation TMBAmazon_LoginWithAmazon_FinalizeOAuth

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_LoginWithAmazon_FinalizeOAuth Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/LoginWithAmazon/FinalizeOAuth"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_LoginWithAmazon_FinalizeOAuth_ResultSet *results = [[TMBAmazon_LoginWithAmazon_FinalizeOAuth_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FinalizeOAuth Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_LoginWithAmazon_FinalizeOAuth_Inputs*)newInputSet {
		return [[TMBAmazon_LoginWithAmazon_FinalizeOAuth_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the InitializeOAuth Choreo.
 */
@implementation TMBAmazon_LoginWithAmazon_InitializeOAuth_Inputs

	/*!
	 * Set the value of the ClientID input for this Choreo.
	*(required, string) The Client ID provided by Amazon.
	 */
	-(void)setClientID:(NSString*)ClientID {
		[super setInput:@"ClientID" toValue:ClientID];
	}

	/*!
	 * Set the value of the CustomCallbackID input for this Choreo.
	*(optional, string) A unique identifier that you can pass to eliminate the need to wait for a Temboo generated CallbackID. Callback identifiers may only contain numbers, letters, periods, and hyphens.
	 */
	-(void)setCustomCallbackID:(NSString*)CustomCallbackID {
		[super setInput:@"CustomCallbackID" toValue:CustomCallbackID];
	}

	/*!
	 * Set the value of the ForwardingURL input for this Choreo.
	*(optional, string) The URL that Temboo will redirect your users to after they grant access to your application. This should include the "https://" or "http://" prefix and be a fully qualified URL.
	 */
	-(void)setForwardingURL:(NSString*)ForwardingURL {
		[super setInput:@"ForwardingURL" toValue:ForwardingURL];
	}

	/*!
	 * Set the value of the Scope input for this Choreo.
	*(conditional, string) A space-delimited list of permissions to request access for (e.g., clouddrive:read clouddrive:write).
	 */
	-(void)setScope:(NSString*)Scope {
		[super setInput:@"Scope" toValue:Scope];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InitializeOAuth Choreo.
 */
@implementation TMBAmazon_LoginWithAmazon_InitializeOAuth_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "AuthorizationURL" output from an execution of this Choreo.
	 * @return - NSString* (string) The authorization URL to send your user to in order for them to grant access to your application.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getAuthorizationURL {
		return [super getOutputByName:@"AuthorizationURL"];
	}

	/*!
	 * Retrieve the value of the "CallbackID" output from an execution of this Choreo.
	 * @return - NSString* (string) An ID used to retrieve the callback data that Temboo stores once your application's user authorizes.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getCallbackID {
		return [super getOutputByName:@"CallbackID"];
	}
	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 */
@implementation TMBAmazon_LoginWithAmazon_InitializeOAuth

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_LoginWithAmazon_InitializeOAuth Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/LoginWithAmazon/InitializeOAuth"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_LoginWithAmazon_InitializeOAuth_ResultSet *results = [[TMBAmazon_LoginWithAmazon_InitializeOAuth_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the InitializeOAuth Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_LoginWithAmazon_InitializeOAuth_Inputs*)newInputSet {
		return [[TMBAmazon_LoginWithAmazon_InitializeOAuth_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddTags Choreo.
 */
@implementation TMBAmazon_MachineLearning_AddTags_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResourceId input for this Choreo.
	*(required, string) The ID of the ML object to tag.
	 */
	-(void)setResourceId:(NSString*)ResourceId {
		[super setInput:@"ResourceId" toValue:ResourceId];
	}

	/*!
	 * Set the value of the ResourceType input for this Choreo.
	*(required, string) The type of the ML object to tag. Valid values are: BatchPrediction, DataSource, Evaluation, MLModel.
	 */
	-(void)setResourceType:(NSString*)ResourceType {
		[super setInput:@"ResourceType" toValue:ResourceType];
	}

	/*!
	 * Set the value of the Tags input for this Choreo.
	*(required, json) An array of tag objects in a key-value pair format.
	 */
	-(void)setTags:(NSString*)Tags {
		[super setInput:@"Tags" toValue:Tags];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddTags Choreo.
 */
@implementation TMBAmazon_MachineLearning_AddTags_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds one or more tags to an object, up to a limit of 10. 
 */
@implementation TMBAmazon_MachineLearning_AddTags

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_AddTags Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/AddTags"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_AddTags_ResultSet *results = [[TMBAmazon_MachineLearning_AddTags_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddTags Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_AddTags_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_AddTags_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateBatchPrediction Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateBatchPrediction_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the BatchPredictionDataSourceId input for this Choreo.
	*(required, string) The ID of the DataSource that points to the group of observations to predict.
	 */
	-(void)setBatchPredictionDataSourceId:(NSString*)BatchPredictionDataSourceId {
		[super setInput:@"BatchPredictionDataSourceId" toValue:BatchPredictionDataSourceId];
	}

	/*!
	 * Set the value of the BatchPredictionId input for this Choreo.
	*(required, string) A user-supplied ID that uniquely identifies the BatchPrediction.
	 */
	-(void)setBatchPredictionId:(NSString*)BatchPredictionId {
		[super setInput:@"BatchPredictionId" toValue:BatchPredictionId];
	}

	/*!
	 * Set the value of the BatchPredictionName input for this Choreo.
	*(optional, string) A user-supplied name or description of the BatchPrediction.
	 */
	-(void)setBatchPredictionName:(NSString*)BatchPredictionName {
		[super setInput:@"BatchPredictionName" toValue:BatchPredictionName];
	}

	/*!
	 * Set the value of the MLModelId input for this Choreo.
	*(required, string) The ID of the MLModel that will generate predictions for the group of observations.
	 */
	-(void)setMLModelId:(NSString*)MLModelId {
		[super setInput:@"MLModelId" toValue:MLModelId];
	}

	/*!
	 * Set the value of the OutputUri input for this Choreo.
	*(required, string) The location of an Amazon S3 bucket or directory to store the batch prediction results.
	 */
	-(void)setOutputUri:(NSString*)OutputUri {
		[super setInput:@"OutputUri" toValue:OutputUri];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateBatchPrediction Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateBatchPrediction_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Generates predictions for a group of observations.
 */
@implementation TMBAmazon_MachineLearning_CreateBatchPrediction

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_CreateBatchPrediction Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/CreateBatchPrediction"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_CreateBatchPrediction_ResultSet *results = [[TMBAmazon_MachineLearning_CreateBatchPrediction_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateBatchPrediction Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_CreateBatchPrediction_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_CreateBatchPrediction_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateDataSourceFromS3 Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateDataSourceFromS3_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ComputeStatistics input for this Choreo.
	*(optional, boolean) The compute statistics for a DataSource. This parameter must be set to true if the DataSource needs to be used for MLModel training. Defaults to false.
	 */
	-(void)setComputeStatistics:(NSString*)ComputeStatistics {
		[super setInput:@"ComputeStatistics" toValue:ComputeStatistics];
	}

	/*!
	 * Set the value of the DataLocationS3 input for this Choreo.
	*(required, string) The location of the data file(s) used by a DataSource. The URI specifies a data file or an Amazon Simple Storage Service (Amazon S3) directory or bucket containing data files.
	 */
	-(void)setDataLocationS3:(NSString*)DataLocationS3 {
		[super setInput:@"DataLocationS3" toValue:DataLocationS3];
	}

	/*!
	 * Set the value of the DataRearrangement input for this Choreo.
	*(optional, json) A JSON string that represents the splitting and rearrangement requirements for the Datasource.
	 */
	-(void)setDataRearrangement:(NSString*)DataRearrangement {
		[super setInput:@"DataRearrangement" toValue:DataRearrangement];
	}

	/*!
	 * Set the value of the DataSchema input for this Choreo.
	*(optional, json) A JSON string representing the schema. This is required unless specifying a valid URI for DataSchemaLocationS3.
	 */
	-(void)setDataSchema:(NSString*)DataSchema {
		[super setInput:@"DataSchema" toValue:DataSchema];
	}

	/*!
	 * Set the value of the DataSchemaLocationS3 input for this Choreo.
	*(conditional, string) The Amazon S3 location of the DataSchema. This is required unless specifying a valid JSON schema file for DataSchema (see optional inputs).
	 */
	-(void)setDataSchemaLocationS3:(NSString*)DataSchemaLocationS3 {
		[super setInput:@"DataSchemaLocationS3" toValue:DataSchemaLocationS3];
	}

	/*!
	 * Set the value of the DataSourceId input for this Choreo.
	*(required, string) A user-supplied identifier that uniquely identifies the DataSource.
	 */
	-(void)setDataSourceId:(NSString*)DataSourceId {
		[super setInput:@"DataSourceId" toValue:DataSourceId];
	}

	/*!
	 * Set the value of the DataSourceName input for this Choreo.
	*(optional, string) A user-supplied name or description of the DataSource.
	 */
	-(void)setDataSourceName:(NSString*)DataSourceName {
		[super setInput:@"DataSourceName" toValue:DataSourceName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateDataSourceFromS3 Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateDataSourceFromS3_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a DataSource object.
 */
@implementation TMBAmazon_MachineLearning_CreateDataSourceFromS3

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_CreateDataSourceFromS3 Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/CreateDataSourceFromS3"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_CreateDataSourceFromS3_ResultSet *results = [[TMBAmazon_MachineLearning_CreateDataSourceFromS3_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateDataSourceFromS3 Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_CreateDataSourceFromS3_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_CreateDataSourceFromS3_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateEvaluation Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateEvaluation_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EvaluationDataSourceId input for this Choreo.
	*(required, string) The DataSource that points to the training data.
	 */
	-(void)setEvaluationDataSourceId:(NSString*)EvaluationDataSourceId {
		[super setInput:@"EvaluationDataSourceId" toValue:EvaluationDataSourceId];
	}

	/*!
	 * Set the value of the EvaluationId input for this Choreo.
	*(required, string) A user-supplied identifier that uniquely identifies the MLModel.
	 */
	-(void)setEvaluationId:(NSString*)EvaluationId {
		[super setInput:@"EvaluationId" toValue:EvaluationId];
	}

	/*!
	 * Set the value of the EvaluationName input for this Choreo.
	*(optional, string) A user-supplied name or description of the MLModel.
	 */
	-(void)setEvaluationName:(NSString*)EvaluationName {
		[super setInput:@"EvaluationName" toValue:EvaluationName];
	}

	/*!
	 * Set the value of the MLModelId input for this Choreo.
	*(required, string) The ID of the MLModel to evaluate.
	 */
	-(void)setMLModelId:(NSString*)MLModelId {
		[super setInput:@"MLModelId" toValue:MLModelId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateEvaluation Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateEvaluation_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new Evaluation of an MLModel.
 */
@implementation TMBAmazon_MachineLearning_CreateEvaluation

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_CreateEvaluation Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/CreateEvaluation"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_CreateEvaluation_ResultSet *results = [[TMBAmazon_MachineLearning_CreateEvaluation_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateEvaluation Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_CreateEvaluation_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_CreateEvaluation_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateMLModel Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateMLModel_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the MLModelId input for this Choreo.
	*(required, string) A user-supplied identifier that uniquely identifies the MLModel.
	 */
	-(void)setMLModelId:(NSString*)MLModelId {
		[super setInput:@"MLModelId" toValue:MLModelId];
	}

	/*!
	 * Set the value of the MLModelName input for this Choreo.
	*(optional, string) A user-supplied name or description of the MLModel.
	 */
	-(void)setMLModelName:(NSString*)MLModelName {
		[super setInput:@"MLModelName" toValue:MLModelName];
	}

	/*!
	 * Set the value of the MLModelType input for this Choreo.
	*(required, string) The category of supervised learning that this MLModel will address. Choose from the following types: REGRESSION, BINARY, MULTICLASS.
	 */
	-(void)setMLModelType:(NSString*)MLModelType {
		[super setInput:@"MLModelType" toValue:MLModelType];
	}

	/*!
	 * Set the value of the Parameters input for this Choreo.
	*(optional, json) A list of the training parameters in the MLModel. The list is implemented as a map of key-value pairs.
	 */
	-(void)setParameters:(NSString*)Parameters {
		[super setInput:@"Parameters" toValue:Parameters];
	}

	/*!
	 * Set the value of the Recipe input for this Choreo.
	*(optional, string) The data recipe for creating the MLModel. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
	 */
	-(void)setRecipe:(NSString*)Recipe {
		[super setInput:@"Recipe" toValue:Recipe];
	}

	/*!
	 * Set the value of the RecipeUri input for this Choreo.
	*(optional, string) The Amazon S3 location and file name that contains the MLModel recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
	 */
	-(void)setRecipeUri:(NSString*)RecipeUri {
		[super setInput:@"RecipeUri" toValue:RecipeUri];
	}

	/*!
	 * Set the value of the TrainingDataSourceId input for this Choreo.
	*(required, string) The DataSource that points to the training data.
	 */
	-(void)setTrainingDataSourceId:(NSString*)TrainingDataSourceId {
		[super setInput:@"TrainingDataSourceId" toValue:TrainingDataSourceId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateMLModel Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateMLModel_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new MLModel using the DataSource and the recipe as information sources.
 */
@implementation TMBAmazon_MachineLearning_CreateMLModel

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_CreateMLModel Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/CreateMLModel"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_CreateMLModel_ResultSet *results = [[TMBAmazon_MachineLearning_CreateMLModel_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateMLModel Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_CreateMLModel_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_CreateMLModel_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateRealtimeEndpoint Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateRealtimeEndpoint_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the MLModelId input for this Choreo.
	*(required, string) The ID assigned to the MLModelId at creation.
	 */
	-(void)setMLModelId:(NSString*)MLModelId {
		[super setInput:@"MLModelId" toValue:MLModelId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateRealtimeEndpoint Choreo.
 */
@implementation TMBAmazon_MachineLearning_CreateRealtimeEndpoint_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * This Choreo creates a real-time endpoint for the MLModel. The endpoint contains the URI of the MLModel which is the location to send real-time prediction requests for the specified MLModel.
 */
@implementation TMBAmazon_MachineLearning_CreateRealtimeEndpoint

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_CreateRealtimeEndpoint Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/CreateRealtimeEndpoint"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_CreateRealtimeEndpoint_ResultSet *results = [[TMBAmazon_MachineLearning_CreateRealtimeEndpoint_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateRealtimeEndpoint Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_CreateRealtimeEndpoint_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_CreateRealtimeEndpoint_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteBatchPrediction Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteBatchPrediction_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the BatchPredictionId input for this Choreo.
	*(required, string) A user-supplied ID that uniquely identifies the BatchPrediction.
	 */
	-(void)setBatchPredictionId:(NSString*)BatchPredictionId {
		[super setInput:@"BatchPredictionId" toValue:BatchPredictionId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the Verbose input for this Choreo.
	*(optional, boolean) Specifies whether the GetDataSource operation should return DataSourceSchema. Defaults to true.
	 */
	-(void)setVerbose:(NSString*)Verbose {
		[super setInput:@"Verbose" toValue:Verbose];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteBatchPrediction Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteBatchPrediction_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Assigns the DELETED status to a BatchPrediction, rendering it unusable.
 */
@implementation TMBAmazon_MachineLearning_DeleteBatchPrediction

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DeleteBatchPrediction Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DeleteBatchPrediction"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DeleteBatchPrediction_ResultSet *results = [[TMBAmazon_MachineLearning_DeleteBatchPrediction_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteBatchPrediction Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DeleteBatchPrediction_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DeleteBatchPrediction_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteDataSource Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteDataSource_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DataSourceId input for this Choreo.
	*(required, string) A user-supplied ID that uniquely identifies the DataSource.
	 */
	-(void)setDataSourceId:(NSString*)DataSourceId {
		[super setInput:@"DataSourceId" toValue:DataSourceId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the Verbose input for this Choreo.
	*(optional, boolean) Specifies whether the GetDataSource operation should return DataSourceSchema. Defaults to true.
	 */
	-(void)setVerbose:(NSString*)Verbose {
		[super setInput:@"Verbose" toValue:Verbose];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteDataSource Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteDataSource_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Assigns the DELETED status to a DataSource, rendering it unusable.
 */
@implementation TMBAmazon_MachineLearning_DeleteDataSource

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DeleteDataSource Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DeleteDataSource"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DeleteDataSource_ResultSet *results = [[TMBAmazon_MachineLearning_DeleteDataSource_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteDataSource Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DeleteDataSource_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DeleteDataSource_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteEvaluation Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteEvaluation_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EvaluationId input for this Choreo.
	*(required, string) A user-supplied ID that uniquely identifies the Evaluation to delete.
	 */
	-(void)setEvaluationId:(NSString*)EvaluationId {
		[super setInput:@"EvaluationId" toValue:EvaluationId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteEvaluation Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteEvaluation_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Assigns the DELETED status to an Evaluation, rendering it unusable.
 */
@implementation TMBAmazon_MachineLearning_DeleteEvaluation

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DeleteEvaluation Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DeleteEvaluation"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DeleteEvaluation_ResultSet *results = [[TMBAmazon_MachineLearning_DeleteEvaluation_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteEvaluation Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DeleteEvaluation_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DeleteEvaluation_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteMLModel Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteMLModel_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the MLModelId input for this Choreo.
	*(required, string) The ID assigned to the MLModelId at creation.
	 */
	-(void)setMLModelId:(NSString*)MLModelId {
		[super setInput:@"MLModelId" toValue:MLModelId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteMLModel Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteMLModel_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Assigns the DELETED status to an MLModel, rendering it unusable.
 */
@implementation TMBAmazon_MachineLearning_DeleteMLModel

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DeleteMLModel Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DeleteMLModel"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DeleteMLModel_ResultSet *results = [[TMBAmazon_MachineLearning_DeleteMLModel_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteMLModel Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DeleteMLModel_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DeleteMLModel_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRealtimeEndpoint Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteRealtimeEndpoint_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the MLModelId input for this Choreo.
	*(required, string) The ID assigned to the MLModelId at creation.
	 */
	-(void)setMLModelId:(NSString*)MLModelId {
		[super setInput:@"MLModelId" toValue:MLModelId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the Verbose input for this Choreo.
	*(optional, boolean) Specifies whether the GetMLModel operation should return Recipe. Defaults to false.
	 */
	-(void)setVerbose:(NSString*)Verbose {
		[super setInput:@"Verbose" toValue:Verbose];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRealtimeEndpoint Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteRealtimeEndpoint_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a real time endpoint of an MLModel.
 */
@implementation TMBAmazon_MachineLearning_DeleteRealtimeEndpoint

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DeleteRealtimeEndpoint Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DeleteRealtimeEndpoint"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DeleteRealtimeEndpoint_ResultSet *results = [[TMBAmazon_MachineLearning_DeleteRealtimeEndpoint_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteRealtimeEndpoint Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DeleteRealtimeEndpoint_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DeleteRealtimeEndpoint_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteTags Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteTags_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResourceId input for this Choreo.
	*(required, string) The ID of the ML object to tag.
	 */
	-(void)setResourceId:(NSString*)ResourceId {
		[super setInput:@"ResourceId" toValue:ResourceId];
	}

	/*!
	 * Set the value of the ResourceType input for this Choreo.
	*(required, string) The type of the ML object to tag. Valid values are: BatchPrediction, DataSource, Evaluation, MLModel.
	 */
	-(void)setResourceType:(NSString*)ResourceType {
		[super setInput:@"ResourceType" toValue:ResourceType];
	}

	/*!
	 * Set the value of the TagKeys input for this Choreo.
	*(required, json) One or more tags to delete.
	 */
	-(void)setTagKeys:(NSString*)TagKeys {
		[super setInput:@"TagKeys" toValue:TagKeys];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteTags Choreo.
 */
@implementation TMBAmazon_MachineLearning_DeleteTags_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes the specified tags associated with an ML object.
 */
@implementation TMBAmazon_MachineLearning_DeleteTags

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DeleteTags Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DeleteTags"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DeleteTags_ResultSet *results = [[TMBAmazon_MachineLearning_DeleteTags_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteTags Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DeleteTags_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DeleteTags_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeDataSources Choreo.
 */
@implementation TMBAmazon_MachineLearning_DescribeDataSources_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EQ input for this Choreo.
	*(optional, string) The equal to operator. The DataSource results will have FilterVariable values that exactly match the value specified with EQ.
	 */
	-(void)setEQ:(NSString*)EQ {
		[super setInput:@"EQ" toValue:EQ];
	}

	/*!
	 * Set the value of the FilterVariable input for this Choreo.
	*(optional, string) Use one of the following variables to filter a list of DataSource: CreatedAt, Status, Name, DataUri, IAMUser.
	 */
	-(void)setFilterVariable:(NSString*)FilterVariable {
		[super setInput:@"FilterVariable" toValue:FilterVariable];
	}

	/*!
	 * Set the value of the GE input for this Choreo.
	*(optional, string) The greater than or equal to operator. The DataSource results will have FilterVariable values that are greater than or equal to the value specified with GE.
	 */
	-(void)setGE:(NSString*)GE {
		[super setInput:@"GE" toValue:GE];
	}

	/*!
	 * Set the value of the GT input for this Choreo.
	*(optional, string) The greater than operator. The DataSource results will have FilterVariable values that are greater than the value specified with GT.
	 */
	-(void)setGT:(NSString*)GT {
		[super setInput:@"GT" toValue:GT];
	}

	/*!
	 * Set the value of the LE input for this Choreo.
	*(optional, string) The less than or equal to operator. The DataSource results will have FilterVariable values that are less than or equal to the value specified with LE.
	 */
	-(void)setLE:(NSString*)LE {
		[super setInput:@"LE" toValue:LE];
	}

	/*!
	 * Set the value of the LT input for this Choreo.
	*(optional, string) The less than operator. The DataSource results will have FilterVariable values that are less than the value specified with LT.
	 */
	-(void)setLT:(NSString*)LT {
		[super setInput:@"LT" toValue:LT];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) The maximum number of DataSource to include in the result.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the NE input for this Choreo.
	*(optional, string) The not equal to operator. The DataSource results will have FilterVariable values not equal to the value specified with NE.
	 */
	-(void)setNE:(NSString*)NE {
		[super setInput:@"NE" toValue:NE];
	}

	/*!
	 * Set the value of the NextToken input for this Choreo.
	*(optional, string) The ID of the page in the paginated results.
	 */
	-(void)setNextToken:(NSString*)NextToken {
		[super setInput:@"NextToken" toValue:NextToken];
	}

	/*!
	 * Set the value of the Prefix input for this Choreo.
	*(optional, string) A string that is found at the beginning of a variable, such as Name or Id.
	 */
	-(void)setPrefix:(NSString*)Prefix {
		[super setInput:@"Prefix" toValue:Prefix];
	}

	/*!
	 * Set the value of the SortOrder input for this Choreo.
	*(optional, string) Determines the sequence of the resulting list of DataSource. Valid values are: asc, dsc.
	 */
	-(void)setSortOrder:(NSString*)SortOrder {
		[super setInput:@"SortOrder" toValue:SortOrder];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeDataSources Choreo.
 */
@implementation TMBAmazon_MachineLearning_DescribeDataSources_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of DataSources that match the search criteria in the request.
 */
@implementation TMBAmazon_MachineLearning_DescribeDataSources

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DescribeDataSources Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DescribeDataSources"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DescribeDataSources_ResultSet *results = [[TMBAmazon_MachineLearning_DescribeDataSources_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeDataSources Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DescribeDataSources_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DescribeDataSources_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeEvaluations Choreo.
 */
@implementation TMBAmazon_MachineLearning_DescribeEvaluations_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EQ input for this Choreo.
	*(optional, string) The equal to operator. The Evaluation results will have FilterVariable values that exactly match the value specified with EQ.
	 */
	-(void)setEQ:(NSString*)EQ {
		[super setInput:@"EQ" toValue:EQ];
	}

	/*!
	 * Set the value of the FilterVariable input for this Choreo.
	*(optional, string) Use one of the following variables to filter a list of Evaluation: CreatedAt, Status, Name, IAMUser, MLModelId, DataSourceId, DataUri.
	 */
	-(void)setFilterVariable:(NSString*)FilterVariable {
		[super setInput:@"FilterVariable" toValue:FilterVariable];
	}

	/*!
	 * Set the value of the GE input for this Choreo.
	*(optional, string) The greater than or equal to operator. The Evaluation results will have FilterVariable values that are greater than or equal to the value specified with GE.
	 */
	-(void)setGE:(NSString*)GE {
		[super setInput:@"GE" toValue:GE];
	}

	/*!
	 * Set the value of the GT input for this Choreo.
	*(optional, string) The greater than operator. The Evaluation results will have FilterVariable values that are greater than the value specified with GT.
	 */
	-(void)setGT:(NSString*)GT {
		[super setInput:@"GT" toValue:GT];
	}

	/*!
	 * Set the value of the LE input for this Choreo.
	*(optional, string) The less than or equal to operator. The Evaluation results will have FilterVariable values that are less than or equal to the value specified with LE.
	 */
	-(void)setLE:(NSString*)LE {
		[super setInput:@"LE" toValue:LE];
	}

	/*!
	 * Set the value of the LT input for this Choreo.
	*(optional, string) The less than operator. The Evaluation results will have FilterVariable values that are less than the value specified with LT.
	 */
	-(void)setLT:(NSString*)LT {
		[super setInput:@"LT" toValue:LT];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) The maximum number of Evaluation to include in the result.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the NE input for this Choreo.
	*(optional, string) The not equal to operator. The Evaluation results will have FilterVariable values not equal to the value specified with NE.
	 */
	-(void)setNE:(NSString*)NE {
		[super setInput:@"NE" toValue:NE];
	}

	/*!
	 * Set the value of the NextToken input for this Choreo.
	*(optional, string) The ID of the page in the paginated results.
	 */
	-(void)setNextToken:(NSString*)NextToken {
		[super setInput:@"NextToken" toValue:NextToken];
	}

	/*!
	 * Set the value of the Prefix input for this Choreo.
	*(optional, string) A string that is found at the beginning of a variable, such as Name or Id.
	 */
	-(void)setPrefix:(NSString*)Prefix {
		[super setInput:@"Prefix" toValue:Prefix];
	}

	/*!
	 * Set the value of the SortOrder input for this Choreo.
	*(optional, string) Determines the sequence of the resulting list of Evaluation. Valid values are: asc, dsc.
	 */
	-(void)setSortOrder:(NSString*)SortOrder {
		[super setInput:@"SortOrder" toValue:SortOrder];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeEvaluations Choreo.
 */
@implementation TMBAmazon_MachineLearning_DescribeEvaluations_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of Evaluations that match the search criteria in the request.
 */
@implementation TMBAmazon_MachineLearning_DescribeEvaluations

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DescribeEvaluations Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DescribeEvaluations"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DescribeEvaluations_ResultSet *results = [[TMBAmazon_MachineLearning_DescribeEvaluations_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeEvaluations Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DescribeEvaluations_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DescribeEvaluations_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeMLModels Choreo.
 */
@implementation TMBAmazon_MachineLearning_DescribeMLModels_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EQ input for this Choreo.
	*(optional, string) The equal to operator. The MLModel results will have FilterVariable values that exactly match the value specified with EQ.
	 */
	-(void)setEQ:(NSString*)EQ {
		[super setInput:@"EQ" toValue:EQ];
	}

	/*!
	 * Set the value of the FilterVariable input for this Choreo.
	*(optional, string) Use one of the following variables to filter a list of MLModel: CreatedAt, Status, Name, IAMUser, TrainingDataSourceId, RealtimeEndpointStatus, MLModelType, Algorithm, TrainingDataURI.
	 */
	-(void)setFilterVariable:(NSString*)FilterVariable {
		[super setInput:@"FilterVariable" toValue:FilterVariable];
	}

	/*!
	 * Set the value of the GE input for this Choreo.
	*(optional, string) The greater than or equal to operator. The MLModel results will have FilterVariable values that are greater than or equal to the value specified with GE.
	 */
	-(void)setGE:(NSString*)GE {
		[super setInput:@"GE" toValue:GE];
	}

	/*!
	 * Set the value of the GT input for this Choreo.
	*(optional, string) The greater than operator. The MLModel results will have FilterVariable values that are greater than the value specified with GT.
	 */
	-(void)setGT:(NSString*)GT {
		[super setInput:@"GT" toValue:GT];
	}

	/*!
	 * Set the value of the LE input for this Choreo.
	*(optional, string) The less than or equal to operator. The MLModel results will have FilterVariable values that are less than or equal to the value specified with LE.
	 */
	-(void)setLE:(NSString*)LE {
		[super setInput:@"LE" toValue:LE];
	}

	/*!
	 * Set the value of the LT input for this Choreo.
	*(optional, string) The less than operator. The MLModel results will have FilterVariable values that are less than the value specified with LT.
	 */
	-(void)setLT:(NSString*)LT {
		[super setInput:@"LT" toValue:LT];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) The maximum number of MLModel to include in the result.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the NE input for this Choreo.
	*(optional, string) The not equal to operator. The MLModel results will have FilterVariable values not equal to the value specified with NE.
	 */
	-(void)setNE:(NSString*)NE {
		[super setInput:@"NE" toValue:NE];
	}

	/*!
	 * Set the value of the NextToken input for this Choreo.
	*(optional, string) The ID of the page in the paginated results.
	 */
	-(void)setNextToken:(NSString*)NextToken {
		[super setInput:@"NextToken" toValue:NextToken];
	}

	/*!
	 * Set the value of the Prefix input for this Choreo.
	*(optional, string) A string that is found at the beginning of a variable, such as Name or Id.
	 */
	-(void)setPrefix:(NSString*)Prefix {
		[super setInput:@"Prefix" toValue:Prefix];
	}

	/*!
	 * Set the value of the SortOrder input for this Choreo.
	*(optional, string) Determines the sequence of the resulting list of MLModel. Valid values are: asc, dsc.
	 */
	-(void)setSortOrder:(NSString*)SortOrder {
		[super setInput:@"SortOrder" toValue:SortOrder];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeMLModels Choreo.
 */
@implementation TMBAmazon_MachineLearning_DescribeMLModels_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of MLModels that match the search criteria in the request.
 */
@implementation TMBAmazon_MachineLearning_DescribeMLModels

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DescribeMLModels Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DescribeMLModels"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DescribeMLModels_ResultSet *results = [[TMBAmazon_MachineLearning_DescribeMLModels_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeMLModels Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DescribeMLModels_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DescribeMLModels_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeTags Choreo.
 */
@implementation TMBAmazon_MachineLearning_DescribeTags_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the ResourceId input for this Choreo.
	*(required, string) The ID of the ML object.
	 */
	-(void)setResourceId:(NSString*)ResourceId {
		[super setInput:@"ResourceId" toValue:ResourceId];
	}

	/*!
	 * Set the value of the ResourceType input for this Choreo.
	*(required, string) The type of the ML object. Valid values are: BatchPrediction, DataSource, Evaluation, MLModel.
	 */
	-(void)setResourceType:(NSString*)ResourceType {
		[super setInput:@"ResourceType" toValue:ResourceType];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeTags Choreo.
 */
@implementation TMBAmazon_MachineLearning_DescribeTags_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Describes one or more of the tags for your Amazon ML object.
 */
@implementation TMBAmazon_MachineLearning_DescribeTags

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_DescribeTags Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/DescribeTags"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_DescribeTags_ResultSet *results = [[TMBAmazon_MachineLearning_DescribeTags_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DescribeTags Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_DescribeTags_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_DescribeTags_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetDataSource Choreo.
 */
@implementation TMBAmazon_MachineLearning_GetDataSource_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DataSourceId input for this Choreo.
	*(required, string) The ID assigned to the DataSource at creation.
	 */
	-(void)setDataSourceId:(NSString*)DataSourceId {
		[super setInput:@"DataSourceId" toValue:DataSourceId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the Verbose input for this Choreo.
	*(optional, boolean) Specifies whether the GetDataSource operation should return DataSourceSchema. Defaults to true.
	 */
	-(void)setVerbose:(NSString*)Verbose {
		[super setInput:@"Verbose" toValue:Verbose];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetDataSource Choreo.
 */
@implementation TMBAmazon_MachineLearning_GetDataSource_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a DataSource that includes metadata and data file information, as well as the current status of the DataSource.
 */
@implementation TMBAmazon_MachineLearning_GetDataSource

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_GetDataSource Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/GetDataSource"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_GetDataSource_ResultSet *results = [[TMBAmazon_MachineLearning_GetDataSource_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetDataSource Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_GetDataSource_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_GetDataSource_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetEvaluation Choreo.
 */
@implementation TMBAmazon_MachineLearning_GetEvaluation_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EvaluationId input for this Choreo.
	*(required, string) The ID of the Evaluation to retrieve.
	 */
	-(void)setEvaluationId:(NSString*)EvaluationId {
		[super setInput:@"EvaluationId" toValue:EvaluationId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetEvaluation Choreo.
 */
@implementation TMBAmazon_MachineLearning_GetEvaluation_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns an Evaluation that includes metadata as well as the current status of the Evaluation.
 */
@implementation TMBAmazon_MachineLearning_GetEvaluation

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_GetEvaluation Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/GetEvaluation"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_GetEvaluation_ResultSet *results = [[TMBAmazon_MachineLearning_GetEvaluation_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetEvaluation Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_GetEvaluation_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_GetEvaluation_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetMLModel Choreo.
 */
@implementation TMBAmazon_MachineLearning_GetMLModel_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the MLModelId input for this Choreo.
	*(required, string) The ID assigned to the MLModelId at creation.
	 */
	-(void)setMLModelId:(NSString*)MLModelId {
		[super setInput:@"MLModelId" toValue:MLModelId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the Verbose input for this Choreo.
	*(optional, boolean) Specifies whether the GetMLModel operation should return Recipe. Defaults to false.
	 */
	-(void)setVerbose:(NSString*)Verbose {
		[super setInput:@"Verbose" toValue:Verbose];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMLModel Choreo.
 */
@implementation TMBAmazon_MachineLearning_GetMLModel_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns an MLModel that includes detailed metadata, data source information, and the current status of the MLModel.
 */
@implementation TMBAmazon_MachineLearning_GetMLModel

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_GetMLModel Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/GetMLModel"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_GetMLModel_ResultSet *results = [[TMBAmazon_MachineLearning_GetMLModel_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetMLModel Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_GetMLModel_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_GetMLModel_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the Predict Choreo.
 */
@implementation TMBAmazon_MachineLearning_Predict_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the MLModelId input for this Choreo.
	*(required, string) A unique identifier of the MLModel.
	 */
	-(void)setMLModelId:(NSString*)MLModelId {
		[super setInput:@"MLModelId" toValue:MLModelId];
	}

	/*!
	 * Set the value of the PredictEndpoint input for this Choreo.
	*(required, string) The realtime endpoint to use for the prediction.
	 */
	-(void)setPredictEndpoint:(NSString*)PredictEndpoint {
		[super setInput:@"PredictEndpoint" toValue:PredictEndpoint];
	}

	/*!
	 * Set the value of the Record input for this Choreo.
	*(required, json) A map of variable name-value pairs that represent an observation.
	 */
	-(void)setRecord:(NSString*)Record {
		[super setInput:@"Record" toValue:Record];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Predict Choreo.
 */
@implementation TMBAmazon_MachineLearning_Predict_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Generates a prediction for the observation using the specified ML Model.
 */
@implementation TMBAmazon_MachineLearning_Predict

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_Predict Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/Predict"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_Predict_ResultSet *results = [[TMBAmazon_MachineLearning_Predict_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the Predict Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_Predict_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_Predict_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateBatchPrediction Choreo.
 */
@implementation TMBAmazon_MachineLearning_UpdateBatchPrediction_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the BatchPredictionId input for this Choreo.
	*(required, string) The ID assigned to the BatchPrediction during creation.
	 */
	-(void)setBatchPredictionId:(NSString*)BatchPredictionId {
		[super setInput:@"BatchPredictionId" toValue:BatchPredictionId];
	}

	/*!
	 * Set the value of the BatchPredictionName input for this Choreo.
	*(required, string) A new user-supplied name or description of the BatchPrediction.
	 */
	-(void)setBatchPredictionName:(NSString*)BatchPredictionName {
		[super setInput:@"BatchPredictionName" toValue:BatchPredictionName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateBatchPrediction Choreo.
 */
@implementation TMBAmazon_MachineLearning_UpdateBatchPrediction_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the BatchPredictionName of a BatchPrediction.
 */
@implementation TMBAmazon_MachineLearning_UpdateBatchPrediction

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_UpdateBatchPrediction Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/UpdateBatchPrediction"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_UpdateBatchPrediction_ResultSet *results = [[TMBAmazon_MachineLearning_UpdateBatchPrediction_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateBatchPrediction Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_UpdateBatchPrediction_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_UpdateBatchPrediction_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateDataSource Choreo.
 */
@implementation TMBAmazon_MachineLearning_UpdateDataSource_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DataSourceId input for this Choreo.
	*(required, string) The ID assigned to the DataSource at creation.
	 */
	-(void)setDataSourceId:(NSString*)DataSourceId {
		[super setInput:@"DataSourceId" toValue:DataSourceId];
	}

	/*!
	 * Set the value of the DataSourceName input for this Choreo.
	*(required, string) A new user-supplied name or description of the DataSource that will replace the current description.
	 */
	-(void)setDataSourceName:(NSString*)DataSourceName {
		[super setInput:@"DataSourceName" toValue:DataSourceName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateDataSource Choreo.
 */
@implementation TMBAmazon_MachineLearning_UpdateDataSource_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the DataSourceName of a DataSource.
 */
@implementation TMBAmazon_MachineLearning_UpdateDataSource

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_UpdateDataSource Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/UpdateDataSource"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_UpdateDataSource_ResultSet *results = [[TMBAmazon_MachineLearning_UpdateDataSource_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateDataSource Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_UpdateDataSource_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_UpdateDataSource_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateEvaluation Choreo.
 */
@implementation TMBAmazon_MachineLearning_UpdateEvaluation_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EvaluationId input for this Choreo.
	*(required, string) The ID assigned to the Evaluation during creation.
	 */
	-(void)setEvaluationId:(NSString*)EvaluationId {
		[super setInput:@"EvaluationId" toValue:EvaluationId];
	}

	/*!
	 * Set the value of the EvaluationName input for this Choreo.
	*(required, string) A new user-supplied name or description of the Evaluation that will replace the current content.
	 */
	-(void)setEvaluationName:(NSString*)EvaluationName {
		[super setInput:@"EvaluationName" toValue:EvaluationName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateEvaluation Choreo.
 */
@implementation TMBAmazon_MachineLearning_UpdateEvaluation_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the EvaluationName of an Evaluation.
 */
@implementation TMBAmazon_MachineLearning_UpdateEvaluation

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_UpdateEvaluation Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/UpdateEvaluation"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_UpdateEvaluation_ResultSet *results = [[TMBAmazon_MachineLearning_UpdateEvaluation_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateEvaluation Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_UpdateEvaluation_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_UpdateEvaluation_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateMLModel Choreo.
 */
@implementation TMBAmazon_MachineLearning_UpdateMLModel_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the MLModelId input for this Choreo.
	*(required, string) The ID assigned to the MLModelId at creation.
	 */
	-(void)setMLModelId:(NSString*)MLModelId {
		[super setInput:@"MLModelId" toValue:MLModelId];
	}

	/*!
	 * Set the value of the MLModelName input for this Choreo.
	*(required, string) A user-supplied name or description of the MLModel.
	 */
	-(void)setMLModelName:(NSString*)MLModelName {
		[super setInput:@"MLModelName" toValue:MLModelName];
	}

	/*!
	 * Set the value of the ScoreThreshold input for this Choreo.
	*(optional, decimal) The ScoreThreshold used in binary classification MLModel that marks the boundary between a positive prediction and a negative prediction.
	 */
	-(void)setScoreThreshold:(NSString*)ScoreThreshold {
		[super setInput:@"ScoreThreshold" toValue:ScoreThreshold];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateMLModel Choreo.
 */
@implementation TMBAmazon_MachineLearning_UpdateMLModel_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the MLModelName and the ScoreThreshold of an MLModel.
 */
@implementation TMBAmazon_MachineLearning_UpdateMLModel

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_MachineLearning_UpdateMLModel Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/MachineLearning/UpdateMLModel"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_MachineLearning_UpdateMLModel_ResultSet *results = [[TMBAmazon_MachineLearning_UpdateMLModel_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateMLModel Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_MachineLearning_UpdateMLModel_Inputs*)newInputSet {
		return [[TMBAmazon_MachineLearning_UpdateMLModel_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddOrUpdateInventoryItem Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItem_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the ExpeditedShipping input for this Choreo.
	*(optional, string) The expedited shipping options that you offer for this item. Valid values: 3 = UK Only; N = None, no express delivery offered.
	 */
	-(void)setExpeditedShipping:(NSString*)ExpeditedShipping {
		[super setInput:@"ExpeditedShipping" toValue:ExpeditedShipping];
	}

	/*!
	 * Set the value of the FulfillmentCenterId input for this Choreo.
	*(conditional, string) For those merchants using Amazon fulfillment services, this designates which fulfillment network will be used. Required when using Amazon fulfillment services. Valid values are: AMAZON_EU, DEFAULT.
	 */
	-(void)setFulfillmentCenterId:(NSString*)FulfillmentCenterId {
		[super setInput:@"FulfillmentCenterId" toValue:FulfillmentCenterId];
	}

	/*!
	 * Set the value of the ItemCondition input for this Choreo.
	*(conditional, integer) A numerical entry that indicates the condition of the item. Required for new listings. Valid values are: 1-11. See documentation for description of item condition numeric values.
	 */
	-(void)setItemCondition:(NSString*)ItemCondition {
		[super setInput:@"ItemCondition" toValue:ItemCondition];
	}

	/*!
	 * Set the value of the ItemNote input for this Choreo.
	*(optional, string) A description or note for the item you're adding or updating.
	 */
	-(void)setItemNote:(NSString*)ItemNote {
		[super setInput:@"ItemNote" toValue:ItemNote];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the Price input for this Choreo.
	*(conditional, decimal) The price at which the merchant offers the product for sale. Required if ProductId is provided.
	 */
	-(void)setPrice:(NSString*)Price {
		[super setInput:@"Price" toValue:Price];
	}

	/*!
	 * Set the value of the ProductId input for this Choreo.
	*(conditional, string) A standard, alphanumeric string that uniquely identifies the product. This could be a UPC, EAN or ISBN.  This is a required field if product-id-type is provided.
	 */
	-(void)setProductId:(NSString*)ProductId {
		[super setInput:@"ProductId" toValue:ProductId];
	}

	/*!
	 * Set the value of the ProductIdType input for this Choreo.
	*(conditional, integer) The type of standard, unique identifier entered in the product-id field. This is a required field if product-id is provided. Valid values are: 1 (ASIN), 2 (ISBN), 3 (UPC), 4  (EAN).
	 */
	-(void)setProductIdType:(NSString*)ProductIdType {
		[super setInput:@"ProductIdType" toValue:ProductIdType];
	}

	/*!
	 * Set the value of the Quantity input for this Choreo.
	*(conditional, integer) Enter the quantity of the item you are making available for sale. Required for merchant-fulfilled items. Leave blank for amazon-fullfilled items.
	 */
	-(void)setQuantity:(NSString*)Quantity {
		[super setInput:@"Quantity" toValue:Quantity];
	}

	/*!
	 * Set the value of the SKU input for this Choreo.
	*(required, string) A unique identifier for the product, assigned by the merchant. The SKU must be unique for each product listed.
	 */
	-(void)setSKU:(NSString*)SKU {
		[super setInput:@"SKU" toValue:SKU];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}

	/*!
	 * Set the value of the WillShipInternationally input for this Choreo.
	*(optional, integer) Specify your international shipping options. Valid values are: 3 = UK Only; 4 = UK and Europe; 5 = UK, Europe, and North America; 6 = Worldwide
	 */
	-(void)setWillShipInternationally:(NSString*)WillShipInternationally {
		[super setInput:@"WillShipInternationally" toValue:WillShipInternationally];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddOrUpdateInventoryItem Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The processing status of the product submission which is parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getProcessingStatus {
		return [super getOutputByName:@"ProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "SubmissionId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The submission id parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionId {
		return [super getOutputByName:@"SubmissionId"];
	}

	/*!
	 * Retrieve the value of the "SubmissionResult" output from an execution of this Choreo.
	 * @return - NSString* (string) The submission result returned from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionResult {
		return [super getOutputByName:@"SubmissionResult"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon after submitting the feed.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Add or update an individual inventory listing.
 */
@implementation TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Feeds/AddOrUpdateInventoryItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItem_ResultSet *results = [[TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddOrUpdateInventoryItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItem_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddOrUpdateInventoryItems Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItems_Inputs

	/*!
	 * Set the value of the FeedData input for this Choreo.
	*(conditional, multiline) The feed data to sumbit to Amazon Marketplace.
	 */
	-(void)setFeedData:(NSString*)FeedData {
		[super setInput:@"FeedData" toValue:FeedData];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}

	/*!
	 * Set the value of the VaultFile input for this Choreo.
	*The path to the vault file you want to submit. Required unless you using the FeedData input.
	 */
	-(void)setVaultFile:(NSString*)VaultFile {
		[super setInput:@"VaultFile" toValue:VaultFile];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddOrUpdateInventoryItems Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItems_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The processing status of the feed submission which is parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getProcessingStatus {
		return [super getOutputByName:@"ProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "SubmissionId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The submission id parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionId {
		return [super getOutputByName:@"SubmissionId"];
	}

	/*!
	 * Retrieve the value of the "SubmissionResult" output from an execution of this Choreo.
	 * @return - NSString* (string) The submission result returned from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionResult {
		return [super getOutputByName:@"SubmissionResult"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon after submitting the feed.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds or updates one or more inventory listings in your Seller Central account with a given flat flile.
 */
@implementation TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItems

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItems Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Feeds/AddOrUpdateInventoryItems"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItems_ResultSet *results = [[TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItems_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddOrUpdateInventoryItems Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItems_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Feeds_AddOrUpdateInventoryItems_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddOrUpdateProductImage Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_AddOrUpdateProductImage_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the ImageLocation input for this Choreo.
	*(required, string) The URL for the image location.
	 */
	-(void)setImageLocation:(NSString*)ImageLocation {
		[super setInput:@"ImageLocation" toValue:ImageLocation];
	}

	/*!
	 * Set the value of the ImageType input for this Choreo.
	*(optional, string) The type of image (Main, Alternate, or Swatch). Defaults to "Main".
	 */
	-(void)setImageType:(NSString*)ImageType {
		[super setInput:@"ImageType" toValue:ImageType];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the SKU input for this Choreo.
	*(required, string) A SKU is a "Stock Keeping Unit" which you can assign to your products to track your inventory. Provide the SKU for the product that is associated with the image you are uploading.
	 */
	-(void)setSKU:(NSString*)SKU {
		[super setInput:@"SKU" toValue:SKU];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddOrUpdateProductImage Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_AddOrUpdateProductImage_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The processing status of the feed submission which is parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getProcessingStatus {
		return [super getOutputByName:@"ProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "SubmissionId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The submission id parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionId {
		return [super getOutputByName:@"SubmissionId"];
	}

	/*!
	 * Retrieve the value of the "SubmissionResult" output from an execution of this Choreo.
	 * @return - NSString* (string) The submission result returned from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionResult {
		return [super getOutputByName:@"SubmissionResult"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon after submitting the feed.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds or updates a product image with a given image location and SKU.
 */
@implementation TMBAmazon_Marketplace_Feeds_AddOrUpdateProductImage

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Feeds_AddOrUpdateProductImage Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Feeds/AddOrUpdateProductImage"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Feeds_AddOrUpdateProductImage_ResultSet *results = [[TMBAmazon_Marketplace_Feeds_AddOrUpdateProductImage_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddOrUpdateProductImage Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Feeds_AddOrUpdateProductImage_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Feeds_AddOrUpdateProductImage_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteInventoryItem Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_DeleteInventoryItem_Inputs

	/*!
	 * Set the value of the SKU input for this Choreo.
	*(required, string) A individual SKU associating with the product to delete.
	 */
	-(void)setSKU:(NSString*)SKU {
		[super setInput:@"SKU" toValue:SKU];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DeleteOptions input for this Choreo.
	*(optional, string) Use 'd' to reduce the listings inventory to 0 and keep details in the system. Use 'x'  to completely delete listings from your current inventory. Defaults to "d".
	 */
	-(void)setDeleteOptions:(NSString*)DeleteOptions {
		[super setInput:@"DeleteOptions" toValue:DeleteOptions];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}

	/*!
	 * Set the value of the VaultFile input for this Choreo.
	*The path to the vault file you want to submit.
	 */
	-(void)setVaultFile:(NSString*)VaultFile {
		[super setInput:@"VaultFile" toValue:VaultFile];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteInventoryItem Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_DeleteInventoryItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The processing status of the feed submission which is parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getProcessingStatus {
		return [super getOutputByName:@"ProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "SubmissionId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The submission id parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionId {
		return [super getOutputByName:@"SubmissionId"];
	}

	/*!
	 * Retrieve the value of the "SubmissionResult" output from an execution of this Choreo.
	 * @return - NSString* (string) The submission result returned from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionResult {
		return [super getOutputByName:@"SubmissionResult"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon after submitting the feed.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes an individual inventory listings from a Seller Central account with a given SKU.
 */
@implementation TMBAmazon_Marketplace_Feeds_DeleteInventoryItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Feeds_DeleteInventoryItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Feeds/DeleteInventoryItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Feeds_DeleteInventoryItem_ResultSet *results = [[TMBAmazon_Marketplace_Feeds_DeleteInventoryItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteInventoryItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Feeds_DeleteInventoryItem_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Feeds_DeleteInventoryItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteInventoryItems Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_DeleteInventoryItems_Inputs

	/*!
	 * Set the value of the SKUs input for this Choreo.
	*(conditional, multiline) The list of SKUs associating with the products to delete. SKUs are provided as Tab Delimited values (do not include a sku column name).
	 */
	-(void)setSKUs:(NSString*)SKUs {
		[super setInput:@"SKUs" toValue:SKUs];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DeleteOptions input for this Choreo.
	*(optional, string) Use 'd' to reduce the listings inventory to 0 and keep details in the system. Use 'x'  to completely delete listings from your current inventory. Defaults to "d".
	 */
	-(void)setDeleteOptions:(NSString*)DeleteOptions {
		[super setInput:@"DeleteOptions" toValue:DeleteOptions];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}

	/*!
	 * Set the value of the VaultFile input for this Choreo.
	*The path to the vault file you want to submit.
	 */
	-(void)setVaultFile:(NSString*)VaultFile {
		[super setInput:@"VaultFile" toValue:VaultFile];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteInventoryItems Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_DeleteInventoryItems_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The processing status of the feed submission which is parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getProcessingStatus {
		return [super getOutputByName:@"ProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "SubmissionId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The submission id parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionId {
		return [super getOutputByName:@"SubmissionId"];
	}

	/*!
	 * Retrieve the value of the "SubmissionResult" output from an execution of this Choreo.
	 * @return - NSString* (string) The submission result returned from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionResult {
		return [super getOutputByName:@"SubmissionResult"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon after submitting the feed.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes inventory listings from a Seller Central account with a given flat file of SKUs.
 */
@implementation TMBAmazon_Marketplace_Feeds_DeleteInventoryItems

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Feeds_DeleteInventoryItems Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Feeds/DeleteInventoryItems"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Feeds_DeleteInventoryItems_ResultSet *results = [[TMBAmazon_Marketplace_Feeds_DeleteInventoryItems_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteInventoryItems Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Feeds_DeleteInventoryItems_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Feeds_DeleteInventoryItems_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetFeedSubmissionList Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_GetFeedSubmissionList_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the FeedProcessingStatusList input for this Choreo.
	*(optional, string) A comma separated list of one or more feed processing statuses by which to filter the list of feed submissions.
	 */
	-(void)setFeedProcessingStatusList:(NSString*)FeedProcessingStatusList {
		[super setInput:@"FeedProcessingStatusList" toValue:FeedProcessingStatusList];
	}

	/*!
	 * Set the value of the FeedSubmissionIdList input for this Choreo.
	*(optional, string) A comma separated list of FeedSubmmissionId values. If you pass in FeedSubmmissionId values in a request, other query conditions are ignored.
	 */
	-(void)setFeedSubmissionIdList:(NSString*)FeedSubmissionIdList {
		[super setInput:@"FeedSubmissionIdList" toValue:FeedSubmissionIdList];
	}

	/*!
	 * Set the value of the FeedTypeList input for this Choreo.
	*(optional, string) A comma separated list of one or more FeedType enumeration values by which to filter the list of feed submissions.
	 */
	-(void)setFeedTypeList:(NSString*)FeedTypeList {
		[super setInput:@"FeedTypeList" toValue:FeedTypeList];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the MaxCount input for this Choreo.
	*(optional, integer) A non-negative integer that indicates the maximum number of feed submissions to return in the list. Defaults to 10. Max is 100.
	 */
	-(void)setMaxCount:(NSString*)MaxCount {
		[super setInput:@"MaxCount" toValue:MaxCount];
	}

	/*!
	 * Set the value of the SubmittedFromDate input for this Choreo.
	*(optional, date) The earliest submission date that you are looking for, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setSubmittedFromDate:(NSString*)SubmittedFromDate {
		[super setInput:@"SubmittedFromDate" toValue:SubmittedFromDate];
	}

	/*!
	 * Set the value of the SubmittedToDate input for this Choreo.
	*(optional, date) The latest submission date that you are looking for, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setSubmittedToDate:(NSString*)SubmittedToDate {
		[super setInput:@"SubmittedToDate" toValue:SubmittedToDate];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFeedSubmissionList Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_GetFeedSubmissionList_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "FeedProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The FeedProcessingStatus parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getFeedProcessingStatus {
		return [super getOutputByName:@"FeedProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "FeedSubmissionId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The FeedSubmissionId parsed from the Amazon response. If multiple records are returned, this output variable will contain the first id in the list.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getFeedSubmissionId {
		return [super getOutputByName:@"FeedSubmissionId"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of all feed submissions submitted in the previous 90 days.
 */
@implementation TMBAmazon_Marketplace_Feeds_GetFeedSubmissionList

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Feeds_GetFeedSubmissionList Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Feeds/GetFeedSubmissionList"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Feeds_GetFeedSubmissionList_ResultSet *results = [[TMBAmazon_Marketplace_Feeds_GetFeedSubmissionList_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetFeedSubmissionList Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Feeds_GetFeedSubmissionList_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Feeds_GetFeedSubmissionList_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetFeedSubmissionResult Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_GetFeedSubmissionResult_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the FeedSubmissionId input for this Choreo.
	*(required, string) A FeedSubmmissionId value.
	 */
	-(void)setFeedSubmissionId:(NSString*)FeedSubmissionId {
		[super setInput:@"FeedSubmissionId" toValue:FeedSubmissionId];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFeedSubmissionResult Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_GetFeedSubmissionResult_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ContentMD5Header" output from an execution of this Choreo.
	 * @return - NSString* (string) The Content MD5 header returned from Amazon. This can used to check against an MD5 hash that you generate before submitting the feed to verify that the feed was submitted correctly.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getContentMD5Header {
		return [super getOutputByName:@"ContentMD5Header"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the feed processing report and the Content-MD5 header.
 */
@implementation TMBAmazon_Marketplace_Feeds_GetFeedSubmissionResult

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Feeds_GetFeedSubmissionResult Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Feeds/GetFeedSubmissionResult"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Feeds_GetFeedSubmissionResult_ResultSet *results = [[TMBAmazon_Marketplace_Feeds_GetFeedSubmissionResult_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetFeedSubmissionResult Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Feeds_GetFeedSubmissionResult_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Feeds_GetFeedSubmissionResult_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the SubmitFeed Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_SubmitFeed_Inputs

	/*!
	 * Set the value of the FeedData input for this Choreo.
	*(conditional, multiline) The feed data to submit to Amazon Marketplace.
	 */
	-(void)setFeedData:(NSString*)FeedData {
		[super setInput:@"FeedData" toValue:FeedData];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the FeedType input for this Choreo.
	*(optional, string) The type of feed being submitted.  Default value is set to  _POST_FLAT_FILE_INVLOADER_DATA_).
	 */
	-(void)setFeedType:(NSString*)FeedType {
		[super setInput:@"FeedType" toValue:FeedType];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}

	/*!
	 * Set the value of the VaultFile input for this Choreo.
	*The path to the vault file you want to submit. Required unless you using the FeedData input.
	 */
	-(void)setVaultFile:(NSString*)VaultFile {
		[super setInput:@"VaultFile" toValue:VaultFile];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SubmitFeed Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_SubmitFeed_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The processing status of the feed submission which is parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getProcessingStatus {
		return [super getOutputByName:@"ProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "SubmissionId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The submission id parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionId {
		return [super getOutputByName:@"SubmissionId"];
	}

	/*!
	 * Retrieve the value of the "SubmissionResult" output from an execution of this Choreo.
	 * @return - NSString* (string) The submission result returned from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionResult {
		return [super getOutputByName:@"SubmissionResult"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon after submitting the feed.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Submits a feed, of the specified type, to Amazon Marketplace.
 */
@implementation TMBAmazon_Marketplace_Feeds_SubmitFeed

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Feeds_SubmitFeed Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Feeds/SubmitFeed"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Feeds_SubmitFeed_ResultSet *results = [[TMBAmazon_Marketplace_Feeds_SubmitFeed_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the SubmitFeed Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Feeds_SubmitFeed_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Feeds_SubmitFeed_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdatePriceAndQuantity Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_UpdatePriceAndQuantity_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the Price input for this Choreo.
	*(required, decimal) Enter the unit price for this product. The price must be greater than 0.00. Do NOT include the currency symbol (e.g. $).
	 */
	-(void)setPrice:(NSString*)Price {
		[super setInput:@"Price" toValue:Price];
	}

	/*!
	 * Set the value of the Quantity input for this Choreo.
	*(required, integer) Enter the quantity of the product you have for sale. The quantity must be a whole number, and should be greater than zero.
	 */
	-(void)setQuantity:(NSString*)Quantity {
		[super setInput:@"Quantity" toValue:Quantity];
	}

	/*!
	 * Set the value of the SKU input for this Choreo.
	*(required, string) A SKU is a "Stock Keeping Unit" which you can assign to your products to track your inventory. Provide the SKU that you want to modify.
	 */
	-(void)setSKU:(NSString*)SKU {
		[super setInput:@"SKU" toValue:SKU];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdatePriceAndQuantity Choreo.
 */
@implementation TMBAmazon_Marketplace_Feeds_UpdatePriceAndQuantity_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The processing status of the feed submission which is parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getProcessingStatus {
		return [super getOutputByName:@"ProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "SubmissionId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The submission id parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionId {
		return [super getOutputByName:@"SubmissionId"];
	}

	/*!
	 * Retrieve the value of the "SubmissionResult" output from an execution of this Choreo.
	 * @return - NSString* (string) The submission result returned from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSubmissionResult {
		return [super getOutputByName:@"SubmissionResult"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon after submitting the feed.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates only the price and quantity of a particular product with a given product SKU.
 */
@implementation TMBAmazon_Marketplace_Feeds_UpdatePriceAndQuantity

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Feeds_UpdatePriceAndQuantity Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Feeds/UpdatePriceAndQuantity"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Feeds_UpdatePriceAndQuantity_ResultSet *results = [[TMBAmazon_Marketplace_Feeds_UpdatePriceAndQuantity_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdatePriceAndQuantity Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Feeds_UpdatePriceAndQuantity_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Feeds_UpdatePriceAndQuantity_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListInventorySupplyByDateRange Choreo.
 */
@implementation TMBAmazon_Marketplace_Inventory_ListInventorySupplyByDateRange_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the PageToken input for this Choreo.
	*(conditional, string) The value returned in the NextPageToken output of this Choreo when there are multiple pages of inventory items to retrieve. Required unless providing QueryStartDateTime.
	 */
	-(void)setPageToken:(NSString*)PageToken {
		[super setInput:@"PageToken" toValue:PageToken];
	}

	/*!
	 * Set the value of the QueryStartDateTime input for this Choreo.
	*(conditional, date) A date used for selecting items that have had changes in inventory availability after (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01). Required unless providing PageToken.
	 */
	-(void)setQueryStartDateTime:(NSString*)QueryStartDateTime {
		[super setInput:@"QueryStartDateTime" toValue:QueryStartDateTime];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ResponseGroup input for this Choreo.
	*(optional, string) Indicates whether or not to return the SupplyDetail element in the response. Valid values are: "Basic" (does not include SupplyDetail), and "Detailed" (includes SupplyDetail). Defaults to "Basic".
	 */
	-(void)setResponseGroup:(NSString*)ResponseGroup {
		[super setInput:@"ResponseGroup" toValue:ResponseGroup];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListInventorySupplyByDateRange Choreo.
 */
@implementation TMBAmazon_Marketplace_Inventory_ListInventorySupplyByDateRange_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NextPageToken" output from an execution of this Choreo.
	 * @return - NSString* (string) A token used to retrieve the next page of results. If a token is not returned, there are no more results to retrieve. This token can be passed to the PageToken input of this Choreo.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNextPageToken {
		return [super getOutputByName:@"NextPageToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns information about the availability of a seller's inventory using a given date range.
 */
@implementation TMBAmazon_Marketplace_Inventory_ListInventorySupplyByDateRange

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Inventory_ListInventorySupplyByDateRange Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Inventory/ListInventorySupplyByDateRange"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Inventory_ListInventorySupplyByDateRange_ResultSet *results = [[TMBAmazon_Marketplace_Inventory_ListInventorySupplyByDateRange_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListInventorySupplyByDateRange Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Inventory_ListInventorySupplyByDateRange_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Inventory_ListInventorySupplyByDateRange_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListInventorySupplyBySKU Choreo.
 */
@implementation TMBAmazon_Marketplace_Inventory_ListInventorySupplyBySKU_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ResponseGroup input for this Choreo.
	*(optional, string) Indicates whether or not to return the SupplyDetail element in the response. Valid values are: "Basic" (does not include SupplyDetail), and "Detailed" (includes SupplyDetail). Defaults to "Basic".
	 */
	-(void)setResponseGroup:(NSString*)ResponseGroup {
		[super setInput:@"ResponseGroup" toValue:ResponseGroup];
	}

	/*!
	 * Set the value of the SellerSKU input for this Choreo.
	*(required, string) A seller SKU for an item that you want inventory availability information about.
	 */
	-(void)setSellerSKU:(NSString*)SellerSKU {
		[super setInput:@"SellerSKU" toValue:SellerSKU];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListInventorySupplyBySKU Choreo.
 */
@implementation TMBAmazon_Marketplace_Inventory_ListInventorySupplyBySKU_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns information about the availability of a seller's inventory using a given SellerSKU.
 */
@implementation TMBAmazon_Marketplace_Inventory_ListInventorySupplyBySKU

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Inventory_ListInventorySupplyBySKU Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Inventory/ListInventorySupplyBySKU"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Inventory_ListInventorySupplyBySKU_ResultSet *results = [[TMBAmazon_Marketplace_Inventory_ListInventorySupplyBySKU_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListInventorySupplyBySKU Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Inventory_ListInventorySupplyBySKU_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Inventory_ListInventorySupplyBySKU_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetOrder Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_GetOrder_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AmazonOrderId input for this Choreo.
	*(required, string) One or more AmazonOrderId values separated by commas used to retrieve orders.
	 */
	-(void)setAmazonOrderId:(NSString*)AmazonOrderId {
		[super setInput:@"AmazonOrderId" toValue:AmazonOrderId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetOrder Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_GetOrder_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns orders based on the AmazonOrderId values that you specify.
 */
@implementation TMBAmazon_Marketplace_Orders_GetOrder

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Orders_GetOrder Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Orders/GetOrder"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Orders_GetOrder_ResultSet *results = [[TMBAmazon_Marketplace_Orders_GetOrder_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetOrder Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Orders_GetOrder_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Orders_GetOrder_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetServiceStatus Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_GetServiceStatus_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetServiceStatus Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_GetServiceStatus_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the operational status of the Orders API section.
 */
@implementation TMBAmazon_Marketplace_Orders_GetServiceStatus

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Orders_GetServiceStatus Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Orders/GetServiceStatus"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Orders_GetServiceStatus_ResultSet *results = [[TMBAmazon_Marketplace_Orders_GetServiceStatus_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetServiceStatus Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Orders_GetServiceStatus_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Orders_GetServiceStatus_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListOrderItems Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrderItems_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AmazonOrderId input for this Choreo.
	*(required, string) An Amazon-defined order identifier.
	 */
	-(void)setAmazonOrderId:(NSString*)AmazonOrderId {
		[super setInput:@"AmazonOrderId" toValue:AmazonOrderId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the PageToken input for this Choreo.
	*(optional, string) The value returned in the NextPageToken output of this Choreo when there are multiple pages of order items to retrieve.
	 */
	-(void)setPageToken:(NSString*)PageToken {
		[super setInput:@"PageToken" toValue:PageToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListOrderItems Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrderItems_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NextPageToken" output from an execution of this Choreo.
	 * @return - NSString* (string) A token used to retrieve the next page of results. If a token is not returned, there are no more results to retrieve. This token can be passed to the PageToken input of this Choreo.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNextPageToken {
		return [super getOutputByName:@"NextPageToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns order items based on a specified AmazonOrderId.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrderItems

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Orders_ListOrderItems Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Orders/ListOrderItems"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Orders_ListOrderItems_ResultSet *results = [[TMBAmazon_Marketplace_Orders_ListOrderItems_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListOrderItems Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Orders_ListOrderItems_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Orders_ListOrderItems_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListOrders Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrders_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the CreatedAfter input for this Choreo.
	*(optional, date) A date used for selecting orders created after (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01). Defaults to today's date if not provided.
	 */
	-(void)setCreatedAfter:(NSString*)CreatedAfter {
		[super setInput:@"CreatedAfter" toValue:CreatedAfter];
	}

	/*!
	 * Set the value of the CreatedBefore input for this Choreo.
	*(optional, date) A date used for selecting orders created before (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01).
	 */
	-(void)setCreatedBefore:(NSString*)CreatedBefore {
		[super setInput:@"CreatedBefore" toValue:CreatedBefore];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the FullfillmentChannel input for this Choreo.
	*(optional, string) A string indicating how an order was fulfilled. Use "AFN" for Amazon fulfilled orders, and "MFN" for seller fulfilled orders.
	 */
	-(void)setFullfillmentChannel:(NSString*)FullfillmentChannel {
		[super setInput:@"FullfillmentChannel" toValue:FullfillmentChannel];
	}

	/*!
	 * Set the value of the LastUpdatedAfter input for this Choreo.
	*(optional, date) A date used for selecting orders that were last updated after (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01). Cannot be specified if CreatedAfter is specified.
	 */
	-(void)setLastUpdatedAfter:(NSString*)LastUpdatedAfter {
		[super setInput:@"LastUpdatedAfter" toValue:LastUpdatedAfter];
	}

	/*!
	 * Set the value of the LastUpdatedBefore input for this Choreo.
	*(optional, date) A date used for selecting orders that were last updated before (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01). Cannot be specified if CreatedAfter is specified.
	 */
	-(void)setLastUpdatedBefore:(NSString*)LastUpdatedBefore {
		[super setInput:@"LastUpdatedBefore" toValue:LastUpdatedBefore];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the MaxResultsPerPage input for this Choreo.
	*(optional, integer) A number that indicates the maximum number of orders that can be returned per page. Valid values are: 1-100.
	 */
	-(void)setMaxResultsPerPage:(NSString*)MaxResultsPerPage {
		[super setInput:@"MaxResultsPerPage" toValue:MaxResultsPerPage];
	}

	/*!
	 * Set the value of the OrderStatus input for this Choreo.
	*(optional, string) One or more OrderStatus values separated by commas. This options selects only orders with a certain status (e.g. Pending, Unshipped, PartiallyShipped, Shipped, Canceled, Unfulfillable, etc).
	 */
	-(void)setOrderStatus:(NSString*)OrderStatus {
		[super setInput:@"OrderStatus" toValue:OrderStatus];
	}

	/*!
	 * Set the value of the PageToken input for this Choreo.
	*(optional, string) The value returned in the NextPageToken output of this Choreo when there are multiple pages of orders to retrieve.
	 */
	-(void)setPageToken:(NSString*)PageToken {
		[super setInput:@"PageToken" toValue:PageToken];
	}

	/*!
	 * Set the value of the PaymentMethod input for this Choreo.
	*(optional, string) Used to select only orders of a certain payment type. Valid values are: COD (cash on delivery), CVS (convenience store payment), or Other (Any payment method other than COD or CVS).
	 */
	-(void)setPaymentMethod:(NSString*)PaymentMethod {
		[super setInput:@"PaymentMethod" toValue:PaymentMethod];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListOrders Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrders_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NextPageToken" output from an execution of this Choreo.
	 * @return - NSString* (string) A token used to retrieve the next page of results. If a token is not returned, there are no more results to retrieve. This token can be passed to the PageToken input of this Choreo.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNextPageToken {
		return [super getOutputByName:@"NextPageToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns orders created during a time frame that you specify.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrders

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Orders_ListOrders Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Orders/ListOrders"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Orders_ListOrders_ResultSet *results = [[TMBAmazon_Marketplace_Orders_ListOrders_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListOrders Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Orders_ListOrders_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Orders_ListOrders_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListOrdersWithBuyerEmail Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrdersWithBuyerEmail_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the BuyerEmail input for this Choreo.
	*(required, string) The e-mail address of a buyer. Used to select only the orders that contain the specified e-mail address.
	 */
	-(void)setBuyerEmail:(NSString*)BuyerEmail {
		[super setInput:@"BuyerEmail" toValue:BuyerEmail];
	}

	/*!
	 * Set the value of the CreatedAfter input for this Choreo.
	*(optional, date) A date used for selecting orders created after (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01). Defaults to today's date if not provided.
	 */
	-(void)setCreatedAfter:(NSString*)CreatedAfter {
		[super setInput:@"CreatedAfter" toValue:CreatedAfter];
	}

	/*!
	 * Set the value of the CreatedBefore input for this Choreo.
	*(optional, date) A date used for selecting orders created before (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01).
	 */
	-(void)setCreatedBefore:(NSString*)CreatedBefore {
		[super setInput:@"CreatedBefore" toValue:CreatedBefore];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the MaxResultsPerPage input for this Choreo.
	*(optional, integer) A number that indicates the maximum number of orders that can be returned per page. Valid values are: 1-100.
	 */
	-(void)setMaxResultsPerPage:(NSString*)MaxResultsPerPage {
		[super setInput:@"MaxResultsPerPage" toValue:MaxResultsPerPage];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListOrdersWithBuyerEmail Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrdersWithBuyerEmail_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns orders associated with a buyer's email address that you specify.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrdersWithBuyerEmail

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Orders_ListOrdersWithBuyerEmail Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Orders/ListOrdersWithBuyerEmail"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Orders_ListOrdersWithBuyerEmail_ResultSet *results = [[TMBAmazon_Marketplace_Orders_ListOrdersWithBuyerEmail_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListOrdersWithBuyerEmail Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Orders_ListOrdersWithBuyerEmail_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Orders_ListOrdersWithBuyerEmail_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListOrdersWithSellerOrderId Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrdersWithSellerOrderId_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the CreatedAfter input for this Choreo.
	*(optional, date) A date used for selecting orders created after (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01). Defaults to today's date if not provided.
	 */
	-(void)setCreatedAfter:(NSString*)CreatedAfter {
		[super setInput:@"CreatedAfter" toValue:CreatedAfter];
	}

	/*!
	 * Set the value of the CreatedBefore input for this Choreo.
	*(optional, date) A date used for selecting orders created before (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01).
	 */
	-(void)setCreatedBefore:(NSString*)CreatedBefore {
		[super setInput:@"CreatedBefore" toValue:CreatedBefore];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the MaxResultsPerPage input for this Choreo.
	*(optional, integer) A number that indicates the maximum number of orders that can be returned per page. Valid values are: 1-100.
	 */
	-(void)setMaxResultsPerPage:(NSString*)MaxResultsPerPage {
		[super setInput:@"MaxResultsPerPage" toValue:MaxResultsPerPage];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SellerOrderId input for this Choreo.
	*(required, string) An order identifier that is specified by the seller.
	 */
	-(void)setSellerOrderId:(NSString*)SellerOrderId {
		[super setInput:@"SellerOrderId" toValue:SellerOrderId];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListOrdersWithSellerOrderId Choreo.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrdersWithSellerOrderId_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns orders associated with a seller order id that you specify.
 */
@implementation TMBAmazon_Marketplace_Orders_ListOrdersWithSellerOrderId

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Orders_ListOrdersWithSellerOrderId Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Orders/ListOrdersWithSellerOrderId"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Orders_ListOrdersWithSellerOrderId_ResultSet *results = [[TMBAmazon_Marketplace_Orders_ListOrdersWithSellerOrderId_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListOrdersWithSellerOrderId Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Orders_ListOrdersWithSellerOrderId_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Orders_ListOrdersWithSellerOrderId_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CancelFulfillmentOrder Choreo.
 */
@implementation TMBAmazon_Marketplace_OutboundShipments_CancelFulfillmentOrder_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SellerFulfillmentOrderId input for this Choreo.
	*(required, string) The fulfillment order id that you submitted when creating the order.
	 */
	-(void)setSellerFulfillmentOrderId:(NSString*)SellerFulfillmentOrderId {
		[super setInput:@"SellerFulfillmentOrderId" toValue:SellerFulfillmentOrderId];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CancelFulfillmentOrder Choreo.
 */
@implementation TMBAmazon_Marketplace_OutboundShipments_CancelFulfillmentOrder_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Makes a requests to Amazon to cancel an existing fulfillment order.
 */
@implementation TMBAmazon_Marketplace_OutboundShipments_CancelFulfillmentOrder

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_OutboundShipments_CancelFulfillmentOrder Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/OutboundShipments/CancelFulfillmentOrder"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_OutboundShipments_CancelFulfillmentOrder_ResultSet *results = [[TMBAmazon_Marketplace_OutboundShipments_CancelFulfillmentOrder_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CancelFulfillmentOrder Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_OutboundShipments_CancelFulfillmentOrder_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_OutboundShipments_CancelFulfillmentOrder_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListAllFulfillmentOrders Choreo.
 */
@implementation TMBAmazon_Marketplace_OutboundShipments_ListAllFulfillmentOrders_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the FulfillmentMethod input for this Choreo.
	*(optional, string) A value used for selecting fulfillment orders based on their fulfillment method. "Consumer" indicates a customer order, and "Removal" indicates that the inventory should be returned to the specified.
	 */
	-(void)setFulfillmentMethod:(NSString*)FulfillmentMethod {
		[super setInput:@"FulfillmentMethod" toValue:FulfillmentMethod];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the PageToken input for this Choreo.
	*(optional, string) The value returned in the NextPageToken output of this Choreo when there are multiple pages of orders to retrieve.
	 */
	-(void)setPageToken:(NSString*)PageToken {
		[super setInput:@"PageToken" toValue:PageToken];
	}

	/*!
	 * Set the value of the QueryStartDateTime input for this Choreo.
	*(optional, date) A date used for selecting items that have had changes in inventory availability after (or at) a specified time, in ISO 8601 date format (i.e. 2012-01-01).
	 */
	-(void)setQueryStartDateTime:(NSString*)QueryStartDateTime {
		[super setInput:@"QueryStartDateTime" toValue:QueryStartDateTime];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAllFulfillmentOrders Choreo.
 */
@implementation TMBAmazon_Marketplace_OutboundShipments_ListAllFulfillmentOrders_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "NextPageToken" output from an execution of this Choreo.
	 * @return - NSString* (string) A token used to retrieve the next page of results. If a token is not returned, there are no more results to retrieve. This token can be passed to the PageToken input of this Choreo.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getNextPageToken {
		return [super getOutputByName:@"NextPageToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of fulfillment orders fulfilled after (or at) a specified date or by fulfillment method.
 */
@implementation TMBAmazon_Marketplace_OutboundShipments_ListAllFulfillmentOrders

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_OutboundShipments_ListAllFulfillmentOrders Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/OutboundShipments/ListAllFulfillmentOrders"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_OutboundShipments_ListAllFulfillmentOrders_ResultSet *results = [[TMBAmazon_Marketplace_OutboundShipments_ListAllFulfillmentOrders_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListAllFulfillmentOrders Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_OutboundShipments_ListAllFulfillmentOrders_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_OutboundShipments_ListAllFulfillmentOrders_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetCompetitivePricingForASIN Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetCompetitivePricingForASIN_Inputs

	/*!
	 * Set the value of the ASIN input for this Choreo.
	*(required, string) A comma-separated list of up to 20 ASIN values used to identify products in the given marketplace.
	 */
	-(void)setASIN:(NSString*)ASIN {
		[super setInput:@"ASIN" toValue:ASIN];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCompetitivePricingForASIN Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetCompetitivePricingForASIN_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the current competitive pricing of products, based on  ASIN values and the MarketplaceId that you specify.
 */
@implementation TMBAmazon_Marketplace_Products_GetCompetitivePricingForASIN

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Products_GetCompetitivePricingForASIN Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Products/GetCompetitivePricingForASIN"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Products_GetCompetitivePricingForASIN_ResultSet *results = [[TMBAmazon_Marketplace_Products_GetCompetitivePricingForASIN_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetCompetitivePricingForASIN Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Products_GetCompetitivePricingForASIN_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Products_GetCompetitivePricingForASIN_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetCompetitivePricingForSKU Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetCompetitivePricingForSKU_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SellerSKU input for this Choreo.
	*(required, string) A comma-separated list of up to 20 SellerSKU values used to identify products in the given marketplace.
	 */
	-(void)setSellerSKU:(NSString*)SellerSKU {
		[super setInput:@"SellerSKU" toValue:SellerSKU];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCompetitivePricingForSKU Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetCompetitivePricingForSKU_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the current competitive pricing of products, based on SellerSKU values and the MarketplaceId that you specify.
 */
@implementation TMBAmazon_Marketplace_Products_GetCompetitivePricingForSKU

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Products_GetCompetitivePricingForSKU Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Products/GetCompetitivePricingForSKU"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Products_GetCompetitivePricingForSKU_ResultSet *results = [[TMBAmazon_Marketplace_Products_GetCompetitivePricingForSKU_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetCompetitivePricingForSKU Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Products_GetCompetitivePricingForSKU_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Products_GetCompetitivePricingForSKU_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLowestOfferListingsForASIN Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetLowestOfferListingsForASIN_Inputs

	/*!
	 * Set the value of the ASIN input for this Choreo.
	*(required, string) A comma-separated list of up to 20 ASIN values used to identify products in the given marketplace.
	 */
	-(void)setASIN:(NSString*)ASIN {
		[super setInput:@"ASIN" toValue:ASIN];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the ItemCondition input for this Choreo.
	*(optional, string) Filters the offer listings to be considered based on item condition. Valid values: New, Used, Collectible, Refurbished, Club.
	 */
	-(void)setItemCondition:(NSString*)ItemCondition {
		[super setInput:@"ItemCondition" toValue:ItemCondition];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLowestOfferListingsForASIN Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetLowestOfferListingsForASIN_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the lowest price offer listings for specific products by item condition. This method uses a MarketplaceId and ASIN values to uniquely identify products.
 */
@implementation TMBAmazon_Marketplace_Products_GetLowestOfferListingsForASIN

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Products_GetLowestOfferListingsForASIN Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Products/GetLowestOfferListingsForASIN"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Products_GetLowestOfferListingsForASIN_ResultSet *results = [[TMBAmazon_Marketplace_Products_GetLowestOfferListingsForASIN_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLowestOfferListingsForASIN Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Products_GetLowestOfferListingsForASIN_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Products_GetLowestOfferListingsForASIN_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLowestOfferListingsForSKU Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetLowestOfferListingsForSKU_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the ExcludeMe input for this Choreo.
	*(optional, boolean) Excludes your own offer listings from the offer listings that are returned. Set to "true" to exclude your own offer listings from the results. Defaults to "false".
	 */
	-(void)setExcludeMe:(NSString*)ExcludeMe {
		[super setInput:@"ExcludeMe" toValue:ExcludeMe];
	}

	/*!
	 * Set the value of the ItemCondition input for this Choreo.
	*(optional, string) Filters the offer listings to be considered based on item condition. Valid values: New, Used, Collectible, Refurbished, Club.
	 */
	-(void)setItemCondition:(NSString*)ItemCondition {
		[super setInput:@"ItemCondition" toValue:ItemCondition];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SellerSKU input for this Choreo.
	*(required, string) A comma-separated list of up to 20 SellerSKU values used to identify products in the given marketplace.
	 */
	-(void)setSellerSKU:(NSString*)SellerSKU {
		[super setInput:@"SellerSKU" toValue:SellerSKU];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLowestOfferListingsForSKU Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetLowestOfferListingsForSKU_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the lowest price offer listings for specific products by item condition. This method uses a MarketplaceId and SellerSKU values to uniquely identify products.
 */
@implementation TMBAmazon_Marketplace_Products_GetLowestOfferListingsForSKU

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Products_GetLowestOfferListingsForSKU Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Products/GetLowestOfferListingsForSKU"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Products_GetLowestOfferListingsForSKU_ResultSet *results = [[TMBAmazon_Marketplace_Products_GetLowestOfferListingsForSKU_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLowestOfferListingsForSKU Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Products_GetLowestOfferListingsForSKU_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Products_GetLowestOfferListingsForSKU_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetMatchingProduct Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetMatchingProduct_Inputs

	/*!
	 * Set the value of the ASIN input for this Choreo.
	*(required, string) A comma-separated list of up to 10 ASIN values used to identify products in the given marketplace.
	 */
	-(void)setASIN:(NSString*)ASIN {
		[super setInput:@"ASIN" toValue:ASIN];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMatchingProduct Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetMatchingProduct_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of products and their attributes, based on ASIN values that you specify.
 */
@implementation TMBAmazon_Marketplace_Products_GetMatchingProduct

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Products_GetMatchingProduct Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Products/GetMatchingProduct"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Products_GetMatchingProduct_ResultSet *results = [[TMBAmazon_Marketplace_Products_GetMatchingProduct_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetMatchingProduct Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Products_GetMatchingProduct_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Products_GetMatchingProduct_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetProductCategoriesForASIN Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetProductCategoriesForASIN_Inputs

	/*!
	 * Set the value of the ASIN input for this Choreo.
	*(required, string) An ASIN value used to identify a product in the given marketplace.
	 */
	-(void)setASIN:(NSString*)ASIN {
		[super setInput:@"ASIN" toValue:ASIN];
	}

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetProductCategoriesForASIN Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetProductCategoriesForASIN_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the product categories that a product belongs to, including parent categories back to the root for the marketplace. This method uses a MarketplaceId and an ASIN to uniquely identify a product.
 */
@implementation TMBAmazon_Marketplace_Products_GetProductCategoriesForASIN

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Products_GetProductCategoriesForASIN Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Products/GetProductCategoriesForASIN"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Products_GetProductCategoriesForASIN_ResultSet *results = [[TMBAmazon_Marketplace_Products_GetProductCategoriesForASIN_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetProductCategoriesForASIN Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Products_GetProductCategoriesForASIN_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Products_GetProductCategoriesForASIN_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetProductCategoriesForSKU Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetProductCategoriesForSKU_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SellerSKU input for this Choreo.
	*(required, string) A SellerSKU value used to identify a product in the given marketplace.
	 */
	-(void)setSellerSKU:(NSString*)SellerSKU {
		[super setInput:@"SellerSKU" toValue:SellerSKU];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetProductCategoriesForSKU Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetProductCategoriesForSKU_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the product categories that a product belongs to, including parent categories back to the root for the marketplace. This method uses a MarketplaceId and a SellerSKU to uniquely identify a product.
 */
@implementation TMBAmazon_Marketplace_Products_GetProductCategoriesForSKU

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Products_GetProductCategoriesForSKU Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Products/GetProductCategoriesForSKU"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Products_GetProductCategoriesForSKU_ResultSet *results = [[TMBAmazon_Marketplace_Products_GetProductCategoriesForSKU_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetProductCategoriesForSKU Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Products_GetProductCategoriesForSKU_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Products_GetProductCategoriesForSKU_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetServiceStatus Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetServiceStatus_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetServiceStatus Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_GetServiceStatus_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Status" output from an execution of this Choreo.
	 * @return - NSString* (string) The service status parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getStatus {
		return [super getOutputByName:@"Status"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * This is the standard method following MWS API GetServiceStatus standard. It can return a GREEN, GREEN_I, YELLOW or RED status.
 */
@implementation TMBAmazon_Marketplace_Products_GetServiceStatus

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Products_GetServiceStatus Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Products/GetServiceStatus"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Products_GetServiceStatus_ResultSet *results = [[TMBAmazon_Marketplace_Products_GetServiceStatus_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetServiceStatus Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Products_GetServiceStatus_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Products_GetServiceStatus_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListMatchingProducts Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_ListMatchingProducts_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the Query input for this Choreo.
	*(required, string) A search string used to search for products.
	 */
	-(void)setQuery:(NSString*)Query {
		[super setInput:@"Query" toValue:Query];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListMatchingProducts Choreo.
 */
@implementation TMBAmazon_Marketplace_Products_ListMatchingProducts_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of products and their attributes, ordered by relevancy, based on a search query that you specify.
 */
@implementation TMBAmazon_Marketplace_Products_ListMatchingProducts

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Products_ListMatchingProducts Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Products/ListMatchingProducts"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Products_ListMatchingProducts_ResultSet *results = [[TMBAmazon_Marketplace_Products_ListMatchingProducts_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListMatchingProducts Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Products_ListMatchingProducts_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Products_ListMatchingProducts_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CancelReportRequest Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_CancelReportRequest_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ReportProcessingStatus input for this Choreo.
	*(optional, string) A report processing status by which to filter report requests. Valid values are: _SUBMITTED_, _IN_PROGRESS_, _CANCELLED_, _DONE_, _DONE_NO_DATA_.
	 */
	-(void)setReportProcessingStatus:(NSString*)ReportProcessingStatus {
		[super setInput:@"ReportProcessingStatus" toValue:ReportProcessingStatus];
	}

	/*!
	 * Set the value of the ReportRequestId input for this Choreo.
	*(optional, string) A ReportRequestId value. If you pass in a ReportRequestId value, other query conditions are ignored.
	 */
	-(void)setReportRequestId:(NSString*)ReportRequestId {
		[super setInput:@"ReportRequestId" toValue:ReportRequestId];
	}

	/*!
	 * Set the value of the ReportType input for this Choreo.
	*(optional, string) A ReportType enumeration value (i.e. GET_ORDERS_DATA_).
	 */
	-(void)setReportType:(NSString*)ReportType {
		[super setInput:@"ReportType" toValue:ReportType];
	}

	/*!
	 * Set the value of the RequestedFromDate input for this Choreo.
	*(optional, date) The start of the date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setRequestedFromDate:(NSString*)RequestedFromDate {
		[super setInput:@"RequestedFromDate" toValue:RequestedFromDate];
	}

	/*!
	 * Set the value of the RequestedToDate input for this Choreo.
	*(optional, date) The end of the date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setRequestedToDate:(NSString*)RequestedToDate {
		[super setInput:@"RequestedToDate" toValue:RequestedToDate];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CancelReportRequest Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_CancelReportRequest_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Count" output from an execution of this Choreo.
	 * @return - NSString* (integer) A non-negative integer that represents the total number of report requests that were cancelled.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getCount {
		return [super getOutputByName:@"Count"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Cancels one or more report requests.
 */
@implementation TMBAmazon_Marketplace_Reports_CancelReportRequest

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_CancelReportRequest Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/CancelReportRequest"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_CancelReportRequest_ResultSet *results = [[TMBAmazon_Marketplace_Reports_CancelReportRequest_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CancelReportRequest Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_CancelReportRequest_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_CancelReportRequest_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FlatFileOrderReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_FlatFileOrderReport_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EndDate input for this Choreo.
	*(optional, date) The end of a date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setEndDate:(NSString*)EndDate {
		[super setInput:@"EndDate" toValue:EndDate];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the StartDate input for this Choreo.
	*(optional, date) The start of a date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setStartDate:(NSString*)StartDate {
		[super setInput:@"StartDate" toValue:StartDate];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 5 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FlatFileOrderReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_FlatFileOrderReport_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Report" output from an execution of this Choreo.
	 * @return - NSString* (multiline) The report contents.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReport {
		return [super getOutputByName:@"Report"];
	}

	/*!
	 * Retrieve the value of the "GeneratedReportId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The GeneratedReportId parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getGeneratedReportId {
		return [super getOutputByName:@"GeneratedReportId"];
	}

	/*!
	 * Retrieve the value of the "ReportProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The status of the report request parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportProcessingStatus {
		return [super getOutputByName:@"ReportProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "ReportRequestId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The ReportRequestId parsed from the Amazon response. This id is used in GetReportRequestList.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportRequestId {
		return [super getOutputByName:@"ReportRequestId"];
	}
	
@end

/*!
 * Returns a tab-delimited flat file order report. The report shows orders from the previous 60 days.
 */
@implementation TMBAmazon_Marketplace_Reports_FlatFileOrderReport

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_FlatFileOrderReport Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/FlatFileOrderReport"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_FlatFileOrderReport_ResultSet *results = [[TMBAmazon_Marketplace_Reports_FlatFileOrderReport_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FlatFileOrderReport Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_FlatFileOrderReport_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_FlatFileOrderReport_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetReportById Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportById_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ReportId input for this Choreo.
	*(required, integer) The id of the report to retrieve.
	 */
	-(void)setReportId:(NSString*)ReportId {
		[super setInput:@"ReportId" toValue:ReportId];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetReportById Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportById_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ContentMD5Header" output from an execution of this Choreo.
	 * @return - NSString* (string) 
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getContentMD5Header {
		return [super getOutputByName:@"ContentMD5Header"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from Amazon which contains the contents of the report requested. This is typically a flat file or XML information.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the contents of a report with a given report id.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportById

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_GetReportById Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/GetReportById"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_GetReportById_ResultSet *results = [[TMBAmazon_Marketplace_Reports_GetReportById_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetReportById Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_GetReportById_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_GetReportById_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetReportCount Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportCount_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Acknowledged input for this Choreo.
	*(optional, boolean) A Boolean value that indicates if an order report has been acknowledged by a prior call to UpdateReportAcknowledgements. Set to "true" to list order reports that have been acknowledged.
	 */
	-(void)setAcknowledged:(NSString*)Acknowledged {
		[super setInput:@"Acknowledged" toValue:Acknowledged];
	}

	/*!
	 * Set the value of the AvailableFromDate input for this Choreo.
	*(optional, date) The earliest date you are looking for, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setAvailableFromDate:(NSString*)AvailableFromDate {
		[super setInput:@"AvailableFromDate" toValue:AvailableFromDate];
	}

	/*!
	 * Set the value of the AvailableToDate input for this Choreo.
	*(optional, date) The most recent date you are looking for, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setAvailableToDate:(NSString*)AvailableToDate {
		[super setInput:@"AvailableToDate" toValue:AvailableToDate];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ReportType input for this Choreo.
	*(optional, string) A ReportType enumeration value (i.e. _GET_FLAT_FILE_OPEN_LISTINGS_DATA_).
	 */
	-(void)setReportType:(NSString*)ReportType {
		[super setInput:@"ReportType" toValue:ReportType];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetReportCount Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportCount_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Count" output from an execution of this Choreo.
	 * @return - NSString* (integer) A non-negative integer. parsed from the Amazon response, that represents the total number of reports available to download.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getCount {
		return [super getOutputByName:@"Count"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the number of your available Amazon Marketplace reports, ready for download, that were generated in the last 90 days.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportCount

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_GetReportCount Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/GetReportCount"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_GetReportCount_ResultSet *results = [[TMBAmazon_Marketplace_Reports_GetReportCount_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetReportCount Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_GetReportCount_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_GetReportCount_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetReportList Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportList_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Acknowledged input for this Choreo.
	*(optional, boolean) A Boolean value that indicates if an order report has been acknowledged by a prior call to UpdateReportAcknowledgements. Set to "true" to list order reports that have been acknowledged.
	 */
	-(void)setAcknowledged:(NSString*)Acknowledged {
		[super setInput:@"Acknowledged" toValue:Acknowledged];
	}

	/*!
	 * Set the value of the AvailableFromDate input for this Choreo.
	*(optional, date) The earliest date you are looking for, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setAvailableFromDate:(NSString*)AvailableFromDate {
		[super setInput:@"AvailableFromDate" toValue:AvailableFromDate];
	}

	/*!
	 * Set the value of the AvailableToDate input for this Choreo.
	*(optional, date) The most recent date you are looking for, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setAvailableToDate:(NSString*)AvailableToDate {
		[super setInput:@"AvailableToDate" toValue:AvailableToDate];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the MaxCount input for this Choreo.
	*(optional, integer) A non-negative integer that represents the maximum number of report requests to return. Defaults to 10. Max is 100.
	 */
	-(void)setMaxCount:(NSString*)MaxCount {
		[super setInput:@"MaxCount" toValue:MaxCount];
	}

	/*!
	 * Set the value of the ReportRequestId input for this Choreo.
	*(optional, integer) A ReportRequestId value. If you pass a ReportRequestId value, other query conditions are ignored.
	 */
	-(void)setReportRequestId:(NSString*)ReportRequestId {
		[super setInput:@"ReportRequestId" toValue:ReportRequestId];
	}

	/*!
	 * Set the value of the ReportType input for this Choreo.
	*(optional, string) A ReportType enumeration value (i.e. GET_ORDERS_DATA_).
	 */
	-(void)setReportType:(NSString*)ReportType {
		[super setInput:@"ReportType" toValue:ReportType];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetReportList Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportList_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ReportId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The report id parsed from the Amazon response. If multiple records are returned, this output variable will contain the first id in the list.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportId {
		return [super getOutputByName:@"ReportId"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of reports that were created in the previous 90 days.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportList

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_GetReportList Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/GetReportList"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_GetReportList_ResultSet *results = [[TMBAmazon_Marketplace_Reports_GetReportList_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetReportList Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_GetReportList_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_GetReportList_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetReportRequestList Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportRequestList_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the MaxCount input for this Choreo.
	*(optional, integer) A non-negative integer that represents the maximum number of report requests to return. Defaults to 10. Max is 100.
	 */
	-(void)setMaxCount:(NSString*)MaxCount {
		[super setInput:@"MaxCount" toValue:MaxCount];
	}

	/*!
	 * Set the value of the ReportProcessingStatusList input for this Choreo.
	*(optional, string) A comma separated list of up to three ReportProcessingStatuses by which to filter report requests.
	 */
	-(void)setReportProcessingStatusList:(NSString*)ReportProcessingStatusList {
		[super setInput:@"ReportProcessingStatusList" toValue:ReportProcessingStatusList];
	}

	/*!
	 * Set the value of the ReportRequestIdList input for this Choreo.
	*(optional, string) A comma separated list of up to three ReportRequestId values. If you pass in a ReportRequestId values, other query conditions are ignored.
	 */
	-(void)setReportRequestIdList:(NSString*)ReportRequestIdList {
		[super setInput:@"ReportRequestIdList" toValue:ReportRequestIdList];
	}

	/*!
	 * Set the value of the ReportTypeList input for this Choreo.
	*(optional, string) A comma separated list of up to three ReportType enumeration values.
	 */
	-(void)setReportTypeList:(NSString*)ReportTypeList {
		[super setInput:@"ReportTypeList" toValue:ReportTypeList];
	}

	/*!
	 * Set the value of the RequestedFromDate input for this Choreo.
	*(optional, date) The start of the date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setRequestedFromDate:(NSString*)RequestedFromDate {
		[super setInput:@"RequestedFromDate" toValue:RequestedFromDate];
	}

	/*!
	 * Set the value of the RequestedToDate input for this Choreo.
	*(optional, date) The end of the date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setRequestedToDate:(NSString*)RequestedToDate {
		[super setInput:@"RequestedToDate" toValue:RequestedToDate];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetReportRequestList Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportRequestList_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "GeneratedReportId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The GeneratedReportId parsed from the Amazon response. If multiple records are returned, this output variable will contain the first id in the list.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getGeneratedReportId {
		return [super getOutputByName:@"GeneratedReportId"];
	}

	/*!
	 * Retrieve the value of the "ReportProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The report status parsed from the Amazon response. If multiple records are returned, this output variable will contain the report status in the list.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportProcessingStatus {
		return [super getOutputByName:@"ReportProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "ReportRequestId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The report request id parsed from the Amazon response. If multiple records are returned, this output variable will contain the first id in the list.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportRequestId {
		return [super getOutputByName:@"ReportRequestId"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of report requests that you can use to get the ReportProcessingStatus and ReportId in order to retrieve a report.
 */
@implementation TMBAmazon_Marketplace_Reports_GetReportRequestList

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_GetReportRequestList Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/GetReportRequestList"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_GetReportRequestList_ResultSet *results = [[TMBAmazon_Marketplace_Reports_GetReportRequestList_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetReportRequestList Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_GetReportRequestList_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_GetReportRequestList_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListInventoryReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_ListInventoryReport_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 5 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListInventoryReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_ListInventoryReport_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Report" output from an execution of this Choreo.
	 * @return - NSString* (multiline) The report contents.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReport {
		return [super getOutputByName:@"Report"];
	}

	/*!
	 * Retrieve the value of the "GeneratedReportId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The GeneratedReportId parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getGeneratedReportId {
		return [super getOutputByName:@"GeneratedReportId"];
	}

	/*!
	 * Retrieve the value of the "ReportProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The status of the report request parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportProcessingStatus {
		return [super getOutputByName:@"ReportProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "ReportRequestId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The ReportRequestId parsed from the Amazon response. This id is used in GetReportRequestList.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportRequestId {
		return [super getOutputByName:@"ReportRequestId"];
	}
	
@end

/*!
 * Returns a tab-delimited report of open listings. The report contains the SKU, ASIN, Price, and Quantity fields for inventory listings.
 */
@implementation TMBAmazon_Marketplace_Reports_ListInventoryReport

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_ListInventoryReport Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/ListInventoryReport"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_ListInventoryReport_ResultSet *results = [[TMBAmazon_Marketplace_Reports_ListInventoryReport_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListInventoryReport Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_ListInventoryReport_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_ListInventoryReport_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the MerchantListingsLiteReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_MerchantListingsLiteReport_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 5 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the MerchantListingsLiteReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_MerchantListingsLiteReport_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Report" output from an execution of this Choreo.
	 * @return - NSString* (multiline) The report contents.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReport {
		return [super getOutputByName:@"Report"];
	}

	/*!
	 * Retrieve the value of the "GeneratedReportId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The GeneratedReportId parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getGeneratedReportId {
		return [super getOutputByName:@"GeneratedReportId"];
	}

	/*!
	 * Retrieve the value of the "ReportProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The status of the report request parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportProcessingStatus {
		return [super getOutputByName:@"ReportProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "ReportRequestId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The ReportRequestId parsed from the Amazon response. This id is used in GetReportRequestList.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportRequestId {
		return [super getOutputByName:@"ReportRequestId"];
	}
	
@end

/*!
 * Returns a tab-delimited flat file active listings report that contains only the SKU, ASIN, Price, and Quantity fields for items that have a quantity greater than zero.
 */
@implementation TMBAmazon_Marketplace_Reports_MerchantListingsLiteReport

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_MerchantListingsLiteReport Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/MerchantListingsLiteReport"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_MerchantListingsLiteReport_ResultSet *results = [[TMBAmazon_Marketplace_Reports_MerchantListingsLiteReport_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the MerchantListingsLiteReport Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_MerchantListingsLiteReport_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_MerchantListingsLiteReport_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the MerchantListingsReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_MerchantListingsReport_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 5 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the MerchantListingsReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_MerchantListingsReport_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Report" output from an execution of this Choreo.
	 * @return - NSString* (multiline) The report contents.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReport {
		return [super getOutputByName:@"Report"];
	}

	/*!
	 * Retrieve the value of the "GeneratedReportId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The GeneratedReportId parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getGeneratedReportId {
		return [super getOutputByName:@"GeneratedReportId"];
	}

	/*!
	 * Retrieve the value of the "ReportProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The status of the report request parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportProcessingStatus {
		return [super getOutputByName:@"ReportProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "ReportRequestId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The ReportRequestId parsed from the Amazon response. This id is used in GetReportRequestList.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportRequestId {
		return [super getOutputByName:@"ReportRequestId"];
	}
	
@end

/*!
 * Returns a tab-delimited report of active listings.
 */
@implementation TMBAmazon_Marketplace_Reports_MerchantListingsReport

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_MerchantListingsReport Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/MerchantListingsReport"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_MerchantListingsReport_ResultSet *results = [[TMBAmazon_Marketplace_Reports_MerchantListingsReport_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the MerchantListingsReport Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_MerchantListingsReport_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_MerchantListingsReport_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RequestReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_RequestReport_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EndDate input for this Choreo.
	*(optional, date) The end of a date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setEndDate:(NSString*)EndDate {
		[super setInput:@"EndDate" toValue:EndDate];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ReportOptions input for this Choreo.
	*(optional, string) A Boolean value that shows or hides an additional column of information on several order reports. When set to ShowSalesChannel=true, an additional column is added showing the sales channel.
	 */
	-(void)setReportOptions:(NSString*)ReportOptions {
		[super setInput:@"ReportOptions" toValue:ReportOptions];
	}

	/*!
	 * Set the value of the ReportType input for this Choreo.
	*(optional, string) A ReportType enumeration value. Defaults to _GET_FLAT_FILE_OPEN_LISTINGS_DATA_.
	 */
	-(void)setReportType:(NSString*)ReportType {
		[super setInput:@"ReportType" toValue:ReportType];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the StartDate input for this Choreo.
	*(optional, date) The start of a date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setStartDate:(NSString*)StartDate {
		[super setInput:@"StartDate" toValue:StartDate];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RequestReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_RequestReport_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "ReportProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The status of the report request parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportProcessingStatus {
		return [super getOutputByName:@"ReportProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "ReportRequestId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The ReportRequestId parsed from the Amazon response. This id is used in GetReportRequestList.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportRequestId {
		return [super getOutputByName:@"ReportRequestId"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a report request and submits the request to Amazon MWS.
 */
@implementation TMBAmazon_Marketplace_Reports_RequestReport

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_RequestReport Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/RequestReport"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_RequestReport_ResultSet *results = [[TMBAmazon_Marketplace_Reports_RequestReport_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RequestReport Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_RequestReport_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_RequestReport_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_RetrieveReport_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the EndDate input for this Choreo.
	*(optional, date) The end of a date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setEndDate:(NSString*)EndDate {
		[super setInput:@"EndDate" toValue:EndDate];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ReportType input for this Choreo.
	*(optional, string) A ReportType enumeration value. Defaults to _GET_FLAT_FILE_OPEN_LISTINGS_DATA_.
	 */
	-(void)setReportType:(NSString*)ReportType {
		[super setInput:@"ReportType" toValue:ReportType];
	}

	/*!
	 * Set the value of the StartDate input for this Choreo.
	*(optional, date) The start of a date range used for selecting the data to report, in ISO8601 date format (i.e. 2012-01-01).
	 */
	-(void)setStartDate:(NSString*)StartDate {
		[super setInput:@"StartDate" toValue:StartDate];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 10 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_RetrieveReport_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Report" output from an execution of this Choreo.
	 * @return - NSString* The report contents.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReport {
		return [super getOutputByName:@"Report"];
	}

	/*!
	 * Retrieve the value of the "GeneratedReportId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The GeneratedReportId parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getGeneratedReportId {
		return [super getOutputByName:@"GeneratedReportId"];
	}

	/*!
	 * Retrieve the value of the "ReportProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The status of the report request parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportProcessingStatus {
		return [super getOutputByName:@"ReportProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "ReportRequestId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The ReportRequestId parsed from the Amazon response. This id is used in GetReportRequestList.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportRequestId {
		return [super getOutputByName:@"ReportRequestId"];
	}
	
@end

/*!
 * Creates a report request of any report type, polls for the status of the report, and downloads the report when it's available.
 */
@implementation TMBAmazon_Marketplace_Reports_RetrieveReport

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_RetrieveReport Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/RetrieveReport"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_RetrieveReport_ResultSet *results = [[TMBAmazon_Marketplace_Reports_RetrieveReport_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the RetrieveReport Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_RetrieveReport_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_RetrieveReport_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UnshippedOrdersReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_UnshippedOrdersReport_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the TimeToWait input for this Choreo.
	*(optional, integer) By default, the Choreo will wait for 5 minutes to see if the report is ready for retrieval. Max is 120 minutes.
	 */
	-(void)setTimeToWait:(NSString*)TimeToWait {
		[super setInput:@"TimeToWait" toValue:TimeToWait];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UnshippedOrdersReport Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_UnshippedOrdersReport_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Report" output from an execution of this Choreo.
	 * @return - NSString* (multiline) The report contents.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReport {
		return [super getOutputByName:@"Report"];
	}

	/*!
	 * Retrieve the value of the "GeneratedReportId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The GeneratedReportId parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getGeneratedReportId {
		return [super getOutputByName:@"GeneratedReportId"];
	}

	/*!
	 * Retrieve the value of the "ReportProcessingStatus" output from an execution of this Choreo.
	 * @return - NSString* (string) The status of the report request parsed from the Amazon response.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportProcessingStatus {
		return [super getOutputByName:@"ReportProcessingStatus"];
	}

	/*!
	 * Retrieve the value of the "ReportRequestId" output from an execution of this Choreo.
	 * @return - NSString* (integer) The ReportRequestId parsed from the Amazon response. This id is used in GetReportRequestList.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getReportRequestId {
		return [super getOutputByName:@"ReportRequestId"];
	}
	
@end

/*!
 * Returns a tab-delimited flat file report that contains only orders that are not confirmed as shipped.
 */
@implementation TMBAmazon_Marketplace_Reports_UnshippedOrdersReport

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_UnshippedOrdersReport Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/UnshippedOrdersReport"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_UnshippedOrdersReport_ResultSet *results = [[TMBAmazon_Marketplace_Reports_UnshippedOrdersReport_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UnshippedOrdersReport Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_UnshippedOrdersReport_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_UnshippedOrdersReport_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateReportAcknowledgements Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_UpdateReportAcknowledgements_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSMarketplaceId input for this Choreo.
	*(required, string) The Marketplace ID provided by Amazon Web Services.
	 */
	-(void)setAWSMarketplaceId:(NSString*)AWSMarketplaceId {
		[super setInput:@"AWSMarketplaceId" toValue:AWSMarketplaceId];
	}

	/*!
	 * Set the value of the AWSMerchantId input for this Choreo.
	*(required, string) The Merchant ID provided by Amazon Web Services.
	 */
	-(void)setAWSMerchantId:(NSString*)AWSMerchantId {
		[super setInput:@"AWSMerchantId" toValue:AWSMerchantId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the Acknowledged input for this Choreo.
	*(optional, boolean) A Boolean value that indicates if an order report has been acknowledged by a prior call to UpdateReportAcknowledgements. Set to true to list order reports that have been acknowledged.
	 */
	-(void)setAcknowledged:(NSString*)Acknowledged {
		[super setInput:@"Acknowledged" toValue:Acknowledged];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MWSAuthToken input for this Choreo.
	*(optional, string) The Amazon MWS authorization token for the given seller and developer.
	 */
	-(void)setMWSAuthToken:(NSString*)MWSAuthToken {
		[super setInput:@"MWSAuthToken" toValue:MWSAuthToken];
	}

	/*!
	 * Set the value of the ReportId input for this Choreo.
	*(required, integer) The id of the report to acknowledge.
	 */
	-(void)setReportId:(NSString*)ReportId {
		[super setInput:@"ReportId" toValue:ReportId];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateReportAcknowledgements Choreo.
 */
@implementation TMBAmazon_Marketplace_Reports_UpdateReportAcknowledgements_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* Stores the response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the acknowledged status of a report.
 */
@implementation TMBAmazon_Marketplace_Reports_UpdateReportAcknowledgements

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_Marketplace_Reports_UpdateReportAcknowledgements Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/Marketplace/Reports/UpdateReportAcknowledgements"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_Marketplace_Reports_UpdateReportAcknowledgements_ResultSet *results = [[TMBAmazon_Marketplace_Reports_UpdateReportAcknowledgements_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateReportAcknowledgements Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_Marketplace_Reports_UpdateReportAcknowledgements_Inputs*)newInputSet {
		return [[TMBAmazon_Marketplace_Reports_UpdateReportAcknowledgements_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AuthorizeDBSecurityGroupIngress Choreo.
 */
@implementation TMBAmazon_RDS_AuthorizeDBSecurityGroupIngress_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the CIDRIP input for this Choreo.
	*(conditional, string) IP range that should have access. Required unless EC2SecurityGroupName and EC2SecurityGroupOwnerId are used.
	 */
	-(void)setCIDRIP:(NSString*)CIDRIP {
		[super setInput:@"CIDRIP" toValue:CIDRIP];
	}

	/*!
	 * Set the value of the DBSecurityGroupName input for this Choreo.
	*(required, string) A unique name for the security group you want to authorize.
	 */
	-(void)setDBSecurityGroupName:(NSString*)DBSecurityGroupName {
		[super setInput:@"DBSecurityGroupName" toValue:DBSecurityGroupName];
	}

	/*!
	 * Set the value of the EC2SecurityGroupId input for this Choreo.
	*(conditional, string) The ID of the EC2 security group to authorize. For VPC DB security groups, this is required. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId must be provided.
	 */
	-(void)setEC2SecurityGroupId:(NSString*)EC2SecurityGroupId {
		[super setInput:@"EC2SecurityGroupId" toValue:EC2SecurityGroupId];
	}

	/*!
	 * Set the value of the EC2SecurityGroupName input for this Choreo.
	*(conditional, string) The EC2 security group to authorize. This and EC2SecurityGroupOwnerId are required if CIDRIP is not used.
	 */
	-(void)setEC2SecurityGroupName:(NSString*)EC2SecurityGroupName {
		[super setInput:@"EC2SecurityGroupName" toValue:EC2SecurityGroupName];
	}

	/*!
	 * Set the value of the EC2SecurityGroupOwnerId input for this Choreo.
	*(conditional, string) The AWS account number for the security group owner. This and EC2SecurityGroupName are required if CIDRIP is not used.
	 */
	-(void)setEC2SecurityGroupOwnerId:(NSString*)EC2SecurityGroupOwnerId {
		[super setInput:@"EC2SecurityGroupOwnerId" toValue:EC2SecurityGroupOwnerId];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the RDS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AuthorizeDBSecurityGroupIngress Choreo.
 */
@implementation TMBAmazon_RDS_AuthorizeDBSecurityGroupIngress_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows restricted access to your database instance by adding EC2 Security Groups to the DBSecurityGroup or by specifying an allowed IP range.
 */
@implementation TMBAmazon_RDS_AuthorizeDBSecurityGroupIngress

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_RDS_AuthorizeDBSecurityGroupIngress Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/RDS/AuthorizeDBSecurityGroupIngress"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_RDS_AuthorizeDBSecurityGroupIngress_ResultSet *results = [[TMBAmazon_RDS_AuthorizeDBSecurityGroupIngress_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AuthorizeDBSecurityGroupIngress Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_RDS_AuthorizeDBSecurityGroupIngress_Inputs*)newInputSet {
		return [[TMBAmazon_RDS_AuthorizeDBSecurityGroupIngress_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateDBInstance Choreo.
 */
@implementation TMBAmazon_RDS_CreateDBInstance_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the AllocatedStorage input for this Choreo.
	*(required, integer) Storage amount (in gigabytes) to be configured for the DB. Use 5 to 1024 for MySQL , 10 to 1024 for Oracle, or 200 to 1024 for SQLServer.
	 */
	-(void)setAllocatedStorage:(NSString*)AllocatedStorage {
		[super setInput:@"AllocatedStorage" toValue:AllocatedStorage];
	}

	/*!
	 * Set the value of the AutoMinorVersionUpgrade input for this Choreo.
	*(optional, boolean) Indicates that minor engine upgrades will be applied to the DB Instance automatically during the maintenance window.
	 */
	-(void)setAutoMinorVersionUpgrade:(NSString*)AutoMinorVersionUpgrade {
		[super setInput:@"AutoMinorVersionUpgrade" toValue:AutoMinorVersionUpgrade];
	}

	/*!
	 * Set the value of the AvailabilityZone input for this Choreo.
	*(optional, string) The EC2 Availability Zone that the database instance will be created in (e.g. us-east-1a, us-east-1b, us-east-1c).
	 */
	-(void)setAvailabilityZone:(NSString*)AvailabilityZone {
		[super setInput:@"AvailabilityZone" toValue:AvailabilityZone];
	}

	/*!
	 * Set the value of the BackupRetentionPeriod input for this Choreo.
	*(optional, integer) The number of days for which automated backups are retained. When set to a positive number, backups are enabled. Set to 0 to disable automated backups.
	 */
	-(void)setBackupRetentionPeriod:(NSString*)BackupRetentionPeriod {
		[super setInput:@"BackupRetentionPeriod" toValue:BackupRetentionPeriod];
	}

	/*!
	 * Set the value of the CharacterSetName input for this Choreo.
	*(optional, string) Indicates that the DB Instance should be associated with the specified CharacterSet.
	 */
	-(void)setCharacterSetName:(NSString*)CharacterSetName {
		[super setInput:@"CharacterSetName" toValue:CharacterSetName];
	}

	/*!
	 * Set the value of the DBInstanceClass input for this Choreo.
	*(required, string) Capacity for the DB instance.  (db.t1.micro, db.m1.small, db.m1.large, db.m1.xlarge, db.m2.xlarge, db.m2.2xlarge, or db.m2.4xlarge).
	 */
	-(void)setDBInstanceClass:(NSString*)DBInstanceClass {
		[super setInput:@"DBInstanceClass" toValue:DBInstanceClass];
	}

	/*!
	 * Set the value of the DBInstanceIdentifier input for this Choreo.
	*(required, string) The DB Instance identifier. Should be in all lowercase.
	 */
	-(void)setDBInstanceIdentifier:(NSString*)DBInstanceIdentifier {
		[super setInput:@"DBInstanceIdentifier" toValue:DBInstanceIdentifier];
	}

	/*!
	 * Set the value of the DBName input for this Choreo.
	*(conditional, string) For MySQL, this is the name of the db that is created on the instance. For Oracle, it refers to the SID. Must be null for SQLServer.
	 */
	-(void)setDBName:(NSString*)DBName {
		[super setInput:@"DBName" toValue:DBName];
	}

	/*!
	 * Set the value of the DBParameterGroupName input for this Choreo.
	*(optional, string) The name of the DB Parameter Group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine will be used.
	 */
	-(void)setDBParameterGroupName:(NSString*)DBParameterGroupName {
		[super setInput:@"DBParameterGroupName" toValue:DBParameterGroupName];
	}

	/*!
	 * Set the value of the DBSecurityGroups input for this Choreo.
	*(optional, string) A comma separated list of up to 10 DB Security Groups to associate with this DB Instance.
	 */
	-(void)setDBSecurityGroups:(NSString*)DBSecurityGroups {
		[super setInput:@"DBSecurityGroups" toValue:DBSecurityGroups];
	}

	/*!
	 * Set the value of the DBSubnetGroupName input for this Choreo.
	*(optional, string) A DB Subnet Group to associate with this DB Instance. When not specified, it indicates that this is a non-VPC DB instance.
	 */
	-(void)setDBSubnetGroupName:(NSString*)DBSubnetGroupName {
		[super setInput:@"DBSubnetGroupName" toValue:DBSubnetGroupName];
	}

	/*!
	 * Set the value of the Engine input for this Choreo.
	*(required, string) The name of the database engine to use for the instance. Options are: MySQL, oracle-se1, oracle-se, oracle-ee, sqlserver-ee, sqlserver-se, sqlserver-ex, sqlserver-web.
	 */
	-(void)setEngine:(NSString*)Engine {
		[super setInput:@"Engine" toValue:Engine];
	}

	/*!
	 * Set the value of the EngineVersion input for this Choreo.
	*(optional, string) The version number of the database engine to use.
	 */
	-(void)setEngineVersion:(NSString*)EngineVersion {
		[super setInput:@"EngineVersion" toValue:EngineVersion];
	}

	/*!
	 * Set the value of the Iops input for this Choreo.
	*(optional, string) The amount of provisioned input/output operations per second to be initially allocated for the DB Instance.
	 */
	-(void)setIops:(NSString*)Iops {
		[super setInput:@"Iops" toValue:Iops];
	}

	/*!
	 * Set the value of the LicenseModel input for this Choreo.
	*(optional, string) License model information for this DB Instance. Valid values are: license-included, bring-your-own-license, general-public-license.
	 */
	-(void)setLicenseModel:(NSString*)LicenseModel {
		[super setInput:@"LicenseModel" toValue:LicenseModel];
	}

	/*!
	 * Set the value of the MasterUserPassword input for this Choreo.
	*(required, password) The master password for the DB instance.
	 */
	-(void)setMasterUserPassword:(NSString*)MasterUserPassword {
		[super setInput:@"MasterUserPassword" toValue:MasterUserPassword];
	}

	/*!
	 * Set the value of the MasterUsername input for this Choreo.
	*(required, string) The master username for the DB instance.
	 */
	-(void)setMasterUsername:(NSString*)MasterUsername {
		[super setInput:@"MasterUsername" toValue:MasterUsername];
	}

	/*!
	 * Set the value of the MultiAZ input for this Choreo.
	*(optional, boolean) Specifies if the DB Instance is a Multi-AZ deployment. You cannot set the AvailabilityZone parameter if the MultiAZ parameter is set to true.
	 */
	-(void)setMultiAZ:(NSString*)MultiAZ {
		[super setInput:@"MultiAZ" toValue:MultiAZ];
	}

	/*!
	 * Set the value of the OptionGroupName input for this Choreo.
	*(optional, string) Indicates that the DB Instance should be associated with the specified option group.
	 */
	-(void)setOptionGroupName:(NSString*)OptionGroupName {
		[super setInput:@"OptionGroupName" toValue:OptionGroupName];
	}

	/*!
	 * Set the value of the Port input for this Choreo.
	*(optional, integer) The port number on which the database accepts connections. Valid range for MySQL is 1150-65535. Valid range for Oracle is 1150-65535. Valid range for SQLServer is 1150-65535 except for 1434 and 3389.
	 */
	-(void)setPort:(NSString*)Port {
		[super setInput:@"Port" toValue:Port];
	}

	/*!
	 * Set the value of the PreferredBackupWindow input for this Choreo.
	*(optional, string) The daily time range during which automated backups are created if automated backups are enabled, using the BackupRetentionPeriod parameter. Must be in the format hh24:mi-hh24:mi (in UTC).
	 */
	-(void)setPreferredBackupWindow:(NSString*)PreferredBackupWindow {
		[super setInput:@"PreferredBackupWindow" toValue:PreferredBackupWindow];
	}

	/*!
	 * Set the value of the PreferredMaintenanceWindow input for this Choreo.
	*(optional, string) The weekly time range (in UTC) during which system maintenance can occur. Format: ddd:hh24:mi-ddd:hh24:mi.
	 */
	-(void)setPreferredMaintenanceWindow:(NSString*)PreferredMaintenanceWindow {
		[super setInput:@"PreferredMaintenanceWindow" toValue:PreferredMaintenanceWindow];
	}

	/*!
	 * Set the value of the PubliclyAccessible input for this Choreo.
	*(optional, boolean) Specifies the accessibility options for the DB Instance. The default behavior varies depending on whether a VPC has been requested or not.
	 */
	-(void)setPubliclyAccessible:(NSString*)PubliclyAccessible {
		[super setInput:@"PubliclyAccessible" toValue:PubliclyAccessible];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the RDS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}

	/*!
	 * Set the value of the VpcSecurityGroupIds input for this Choreo.
	*(optional, string) A comma separated list of up to 10 EC2 VPC Security Groups to associate with this DB Instance.
	 */
	-(void)setVpcSecurityGroupIds:(NSString*)VpcSecurityGroupIds {
		[super setInput:@"VpcSecurityGroupIds" toValue:VpcSecurityGroupIds];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateDBInstance Choreo.
 */
@implementation TMBAmazon_RDS_CreateDBInstance_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new database instance.
 */
@implementation TMBAmazon_RDS_CreateDBInstance

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_RDS_CreateDBInstance Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/RDS/CreateDBInstance"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_RDS_CreateDBInstance_ResultSet *results = [[TMBAmazon_RDS_CreateDBInstance_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateDBInstance Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_RDS_CreateDBInstance_Inputs*)newInputSet {
		return [[TMBAmazon_RDS_CreateDBInstance_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateDBSecurityGroup Choreo.
 */
@implementation TMBAmazon_RDS_CreateDBSecurityGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DBSecurityGroupDescription input for this Choreo.
	*(required, string) A description for the security group you're creating.
	 */
	-(void)setDBSecurityGroupDescription:(NSString*)DBSecurityGroupDescription {
		[super setInput:@"DBSecurityGroupDescription" toValue:DBSecurityGroupDescription];
	}

	/*!
	 * Set the value of the DBSecurityGroupName input for this Choreo.
	*(required, string) A unique name for the security group you want to create.
	 */
	-(void)setDBSecurityGroupName:(NSString*)DBSecurityGroupName {
		[super setInput:@"DBSecurityGroupName" toValue:DBSecurityGroupName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the RDS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateDBSecurityGroup Choreo.
 */
@implementation TMBAmazon_RDS_CreateDBSecurityGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a new database security group which you can use to control the access to the database instance.
 */
@implementation TMBAmazon_RDS_CreateDBSecurityGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_RDS_CreateDBSecurityGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/RDS/CreateDBSecurityGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_RDS_CreateDBSecurityGroup_ResultSet *results = [[TMBAmazon_RDS_CreateDBSecurityGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateDBSecurityGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_RDS_CreateDBSecurityGroup_Inputs*)newInputSet {
		return [[TMBAmazon_RDS_CreateDBSecurityGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateDBSnapshot Choreo.
 */
@implementation TMBAmazon_RDS_CreateDBSnapshot_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DBInstanceIdentifier input for this Choreo.
	*(required, string) The DB Instance identifier. Should be in all lowercase.
	 */
	-(void)setDBInstanceIdentifier:(NSString*)DBInstanceIdentifier {
		[super setInput:@"DBInstanceIdentifier" toValue:DBInstanceIdentifier];
	}

	/*!
	 * Set the value of the DBSnapshotIdentifier input for this Choreo.
	*(required, string) The unique identifier for the db snapshot you're creating.
	 */
	-(void)setDBSnapshotIdentifier:(NSString*)DBSnapshotIdentifier {
		[super setInput:@"DBSnapshotIdentifier" toValue:DBSnapshotIdentifier];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the RDS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateDBSnapshot Choreo.
 */
@implementation TMBAmazon_RDS_CreateDBSnapshot_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates a snapshot of an existing database instance.
 */
@implementation TMBAmazon_RDS_CreateDBSnapshot

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_RDS_CreateDBSnapshot Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/RDS/CreateDBSnapshot"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_RDS_CreateDBSnapshot_ResultSet *results = [[TMBAmazon_RDS_CreateDBSnapshot_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateDBSnapshot Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_RDS_CreateDBSnapshot_Inputs*)newInputSet {
		return [[TMBAmazon_RDS_CreateDBSnapshot_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteDBInstance Choreo.
 */
@implementation TMBAmazon_RDS_DeleteDBInstance_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DBInstanceIdentifier input for this Choreo.
	*(required, string) The ID for the DB instance to delete.
	 */
	-(void)setDBInstanceIdentifier:(NSString*)DBInstanceIdentifier {
		[super setInput:@"DBInstanceIdentifier" toValue:DBInstanceIdentifier];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the RDS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteDBInstance Choreo.
 */
@implementation TMBAmazon_RDS_DeleteDBInstance_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a specified database instance.
 */
@implementation TMBAmazon_RDS_DeleteDBInstance

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_RDS_DeleteDBInstance Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/RDS/DeleteDBInstance"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_RDS_DeleteDBInstance_ResultSet *results = [[TMBAmazon_RDS_DeleteDBInstance_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteDBInstance Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_RDS_DeleteDBInstance_Inputs*)newInputSet {
		return [[TMBAmazon_RDS_DeleteDBInstance_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteDBSecurityGroup Choreo.
 */
@implementation TMBAmazon_RDS_DeleteDBSecurityGroup_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DBSecurityGroupName input for this Choreo.
	*(required, string) The name for the security group you want to delete.
	 */
	-(void)setDBSecurityGroupName:(NSString*)DBSecurityGroupName {
		[super setInput:@"DBSecurityGroupName" toValue:DBSecurityGroupName];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the RDS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteDBSecurityGroup Choreo.
 */
@implementation TMBAmazon_RDS_DeleteDBSecurityGroup_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (string) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a specified database security group.
 */
@implementation TMBAmazon_RDS_DeleteDBSecurityGroup

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_RDS_DeleteDBSecurityGroup Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/RDS/DeleteDBSecurityGroup"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_RDS_DeleteDBSecurityGroup_ResultSet *results = [[TMBAmazon_RDS_DeleteDBSecurityGroup_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteDBSecurityGroup Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_RDS_DeleteDBSecurityGroup_Inputs*)newInputSet {
		return [[TMBAmazon_RDS_DeleteDBSecurityGroup_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DeleteDBSnapshot Choreo.
 */
@implementation TMBAmazon_RDS_DeleteDBSnapshot_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DBSnapshotIdentifier input for this Choreo.
	*(required, string) A unique identifier for the snapshot you want to delete.
	 */
	-(void)setDBSnapshotIdentifier:(NSString*)DBSnapshotIdentifier {
		[super setInput:@"DBSnapshotIdentifier" toValue:DBSnapshotIdentifier];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the RDS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteDBSnapshot Choreo.
 */
@implementation TMBAmazon_RDS_DeleteDBSnapshot_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Deletes a specified database snapshot.
 */
@implementation TMBAmazon_RDS_DeleteDBSnapshot

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBAmazon_RDS_DeleteDBSnapshot Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Amazon/RDS/DeleteDBSnapshot"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBAmazon_RDS_DeleteDBSnapshot_ResultSet *results = [[TMBAmazon_RDS_DeleteDBSnapshot_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the DeleteDBSnapshot Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBAmazon_RDS_DeleteDBSnapshot_Inputs*)newInputSet {
		return [[TMBAmazon_RDS_DeleteDBSnapshot_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the DescribeDBInstances Choreo.
 */
@implementation TMBAmazon_RDS_DescribeDBInstances_Inputs

	/*!
	 * Set the value of the AWSAccessKeyId input for this Choreo.
	*(required, string) The Access Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSAccessKeyId:(NSString*)AWSAccessKeyId {
		[super setInput:@"AWSAccessKeyId" toValue:AWSAccessKeyId];
	}

	/*!
	 * Set the value of the AWSSecretKeyId input for this Choreo.
	*(required, string) The Secret Key ID provided by Amazon Web Services.
	 */
	-(void)setAWSSecretKeyId:(NSString*)AWSSecretKeyId {
		[super setInput:@"AWSSecretKeyId" toValue:AWSSecretKeyId];
	}

	/*!
	 * Set the value of the DBInstanceIdentifier input for this Choreo.
	*(optional, string) The DB Instance identifier. Should be in all lowercase.
	 */
	-(void)setDBInstanceIdentifier:(NSString*)DBInstanceIdentifier {
		[super setInput:@"DBInstanceIdentifier" toValue:DBInstanceIdentifier];
	}

	/*!
	 * Set the value of the Marker input for this Choreo.
	*(optional, integer) If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.
	 */
	-(void)setMarker:(NSString*)Marker {
		[super setInput:@"Marker" toValue:Marker];
	}

	/*!
	 * Set the value of the MaxRecords input for this Choreo.
	*(optional, integer) The max number of results to return in the response. Defaults to 100. Minimum is 20.
	 */
	-(void)setMaxRecords:(NSString*)MaxRecords {
		[super setInput:@"MaxRecords" toValue:MaxRecords];
	}

	/*!
	 * Set the value of the UserRegion input for this Choreo.
	*(optional, string) The AWS region that corresponds to the RDS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
	 */
	-(void)setUserRegion:(NSString*)UserRegion {
		[super setInput:@"UserRegion" toValue:UserRegion];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeDBInstances Choreo.
 */
@implementation TMBAmazon_RDS_DescribeDBInstances_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (xml) The response from Amazon.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns information about privisioned database instances.
 */
@implementation TMBAmazon_RDS_DescribeDBInstances

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @par