/*!
 * @file TMBException.m
 *
 * Exceptions relating to the Temboo iOS SDK
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBException.h"

@interface TMBException()
+(void)throwWithName:(Class)type andReason:(NSString*)message;
+(void)throwWithName:(Class)type reason:(NSString *)message andUserInfo:(NSDictionary*)info;
@end

@implementation TMBException

+(void)throwWithReason:(NSString*)message {
	[self throwWithName:[self class] reason:message andUserInfo:nil];
}

+(void)throwWithName:(Class)type andReason:(NSString*)message {
	[self throwWithName:type reason:message andUserInfo:nil];
}

+(void)throwWithName:(Class)type reason:(NSString*)message andUserInfo:(NSDictionary*)info {
	@throw [super exceptionWithName:NSStringFromClass(type) reason:message userInfo:info];
}

@end

@implementation TMBHTTPException

+(void)throwWithReason:(NSString*)message andStatus:(NSInteger)status {
	NSDictionary *userInfo = [NSDictionary dictionaryWithObject:[NSString stringWithFormat:@"%d", status] forKey:@"status"];
	[super throwWithName:[self class] reason:message andUserInfo:userInfo];
}

@end


@implementation TMBJSONException

+(void)throwWithReason:(NSString*)message {
	[super throwWithName:[self class] andReason:message];
}

@end

@implementation TMBNotFoundException

+(void)throwWithReason:(NSString*)message {
	[super throwWithName:[self class] andReason:message];
}

@end