/*!
 * @header Temboo iOS SDK Uber classes
 *
 * Execute Choreographies from the Temboo Uber bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBUber.Estimates.GetPriceEstimates Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetPriceEstimates Choreo.
 */
@interface TMBUber_Estimates_GetPriceEstimates_Inputs : TMBChoreographyInputSet
	-(void)setEndLatitude:(NSString*)EndLatitude;
	-(void)setEndLongitude:(NSString*)EndLongitude;
	-(void)setServerToken:(NSString*)ServerToken;
	-(void)setStartLatitude:(NSString*)StartLatitude;
	-(void)setStartLongitude:(NSString*)StartLongitude;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetPriceEstimates Choreo.
 */
@interface TMBUber_Estimates_GetPriceEstimates_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns an estimated price range for each product offered at a given location.
 */
@interface TMBUber_Estimates_GetPriceEstimates : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBUber_Estimates_GetPriceEstimates_Inputs*)newInputSet;
@end

/*! group TMBUber.Estimates_GetPriceEstimates Choreo */


/*! group TMBUber.Estimates.GetTimeEstimates Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetTimeEstimates Choreo.
 */
@interface TMBUber_Estimates_GetTimeEstimates_Inputs : TMBChoreographyInputSet
	-(void)setCustomerID:(NSString*)CustomerID;
	-(void)setProductID:(NSString*)ProductID;
	-(void)setServerToken:(NSString*)ServerToken;
	-(void)setStartLatitude:(NSString*)StartLatitude;
	-(void)setStartLongitude:(NSString*)StartLongitude;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetTimeEstimates Choreo.
 */
@interface TMBUber_Estimates_GetTimeEstimates_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns ETAs for all products offered at a given location.
 */
@interface TMBUber_Estimates_GetTimeEstimates : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBUber_Estimates_GetTimeEstimates_Inputs*)newInputSet;
@end

/*! group TMBUber.Estimates_GetTimeEstimates Choreo */


/*! group TMBUber.OAuth.FinalizeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FinalizeOAuth Choreo.
 */
@interface TMBUber_OAuth_FinalizeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setCallbackID:(NSString*)CallbackID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setSuppressErrors:(NSString*)SuppressErrors;
	-(void)setTimeout:(NSString*)Timeout;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FinalizeOAuth Choreo.
 */
@interface TMBUber_OAuth_FinalizeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getErrorMessage;
	-(NSString*)getExpires;
	-(NSString*)getRefreshToken;	
@end

/*!
 * Completes the OAuth process by retrieving an Uber access token for a user, after they have visited the authorization URL returned by the InitializeOAuth Choreo and clicked "allow."
 */
@interface TMBUber_OAuth_FinalizeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBUber_OAuth_FinalizeOAuth_Inputs*)newInputSet;
@end

/*! group TMBUber.OAuth_FinalizeOAuth Choreo */


/*! group TMBUber.OAuth.InitializeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InitializeOAuth Choreo.
 */
@interface TMBUber_OAuth_InitializeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setClientID:(NSString*)ClientID;
	-(void)setCustomCallbackID:(NSString*)CustomCallbackID;
	-(void)setForwardingURL:(NSString*)ForwardingURL;
	-(void)setScope:(NSString*)Scope;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InitializeOAuth Choreo.
 */
@interface TMBUber_OAuth_InitializeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAuthorizationURL;
	-(NSString*)getCallbackID;	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 */
@interface TMBUber_OAuth_InitializeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBUber_OAuth_InitializeOAuth_Inputs*)newInputSet;
@end

/*! group TMBUber.OAuth_InitializeOAuth Choreo */


/*! group TMBUber.OAuth.RefreshToken Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RefreshToken Choreo.
 */
@interface TMBUber_OAuth_RefreshToken_Inputs : TMBChoreographyInputSet
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RefreshToken Choreo.
 */
@interface TMBUber_OAuth_RefreshToken_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getExpires;
	-(NSString*)getNewRefreshToken;
	-(NSString*)getScope;	
@end

/*!
 * Retrieves a fresh Access Token by exchanging the Refresh Token that is associated with the expired Access Token.
 */
@interface TMBUber_OAuth_RefreshToken : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBUber_OAuth_RefreshToken_Inputs*)newInputSet;
@end

/*! group TMBUber.OAuth_RefreshToken Choreo */


/*! group TMBUber.Products.GetProductTypes Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetProductTypes Choreo.
 */
@interface TMBUber_Products_GetProductTypes_Inputs : TMBChoreographyInputSet
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setServerToken:(NSString*)ServerToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetProductTypes Choreo.
 */
@interface TMBUber_Products_GetProductTypes_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns information about the Uber products offered at a given location.
 */
@interface TMBUber_Products_GetProductTypes : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBUber_Products_GetProductTypes_Inputs*)newInputSet;
@end

/*! group TMBUber.Products_GetProductTypes Choreo */


/*! group TMBUber.User.GetActivity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetActivity Choreo.
 */
@interface TMBUber_User_GetActivity_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setLimit:(NSString*)Limit;
	-(void)setOffset:(NSString*)Offset;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetActivity Choreo.
 */
@interface TMBUber_User_GetActivity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns information about a user's activity with Uber including pickup locations and times, dropoff locations and times, the distance of past requests, and information about which products were requested.
 */
@interface TMBUber_User_GetActivity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBUber_User_GetActivity_Inputs*)newInputSet;
@end

/*! group TMBUber.User_GetActivity Choreo */


/*! group TMBUber.User.GetProfile Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetProfile Choreo.
 */
@interface TMBUber_User_GetProfile_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetProfile Choreo.
 */
@interface TMBUber_User_GetProfile_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns information about the Uber user that has authorized with the application.
 */
@interface TMBUber_User_GetProfile : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBUber_User_GetProfile_Inputs*)newInputSet;
@end

/*! group TMBUber.User_GetProfile Choreo */
