/*!
 * @header Temboo iOS SDK FedEx classes
 *
 * Execute Choreographies from the Temboo FedEx bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBFedEx.Availability.ServiceAvailability Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ServiceAvailability Choreo.
 */
@interface TMBFedEx_Availability_ServiceAvailability_Inputs : TMBChoreographyInputSet
	-(void)setAccountNumber:(NSString*)AccountNumber;
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey;
	-(void)setDestinationCountryCode:(NSString*)DestinationCountryCode;
	-(void)setDestinationPostalCode:(NSString*)DestinationPostalCode;
	-(void)setEndpoint:(NSString*)Endpoint;
	-(void)setMeterNumber:(NSString*)MeterNumber;
	-(void)setOriginCountryCode:(NSString*)OriginCountryCode;
	-(void)setOriginPostalCode:(NSString*)OriginPostalCode;
	-(void)setPassword:(NSString*)Password;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setShipDate:(NSString*)ShipDate;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ServiceAvailability Choreo.
 */
@interface TMBFedEx_Availability_ServiceAvailability_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves available shipping options and delivery dates for a specified origin and destination.
 */
@interface TMBFedEx_Availability_ServiceAvailability : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBFedEx_Availability_ServiceAvailability_Inputs*)newInputSet;
@end

/*! group TMBFedEx.Availability_ServiceAvailability Choreo */


/*! group TMBFedEx.CountryService.PostalCodeInquiry Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the PostalCodeInquiry Choreo.
 */
@interface TMBFedEx_CountryService_PostalCodeInquiry_Inputs : TMBChoreographyInputSet
	-(void)setAccountNumber:(NSString*)AccountNumber;
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey;
	-(void)setCountryCode:(NSString*)CountryCode;
	-(void)setEndpoint:(NSString*)Endpoint;
	-(void)setMeterNumber:(NSString*)MeterNumber;
	-(void)setPassword:(NSString*)Password;
	-(void)setPostalCode:(NSString*)PostalCode;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setShipDate:(NSString*)ShipDate;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PostalCodeInquiry Choreo.
 */
@interface TMBFedEx_CountryService_PostalCodeInquiry_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves location information from FedEx Web Services for a specified postal code.
 */
@interface TMBFedEx_CountryService_PostalCodeInquiry : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBFedEx_CountryService_PostalCodeInquiry_Inputs*)newInputSet;
@end

/*! group TMBFedEx.CountryService_PostalCodeInquiry Choreo */


/*! group TMBFedEx.Locations.SearchLocationsByAddress Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchLocationsByAddress Choreo.
 */
@interface TMBFedEx_Locations_SearchLocationsByAddress_Inputs : TMBChoreographyInputSet
	-(void)setAccountNumber:(NSString*)AccountNumber;
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey;
	-(void)setCity:(NSString*)City;
	-(void)setCountryCode:(NSString*)CountryCode;
	-(void)setEndpoint:(NSString*)Endpoint;
	-(void)setMeterNumber:(NSString*)MeterNumber;
	-(void)setPassword:(NSString*)Password;
	-(void)setPostalCode:(NSString*)PostalCode;
	-(void)setRadiusDistance:(NSString*)RadiusDistance;
	-(void)setRadiusUnits:(NSString*)RadiusUnits;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSortBy:(NSString*)SortBy;
	-(void)setSortOrder:(NSString*)SortOrder;
	-(void)setState:(NSString*)State;
	-(void)setStreet:(NSString*)Street;
	-(void)setSupportedServices:(NSString*)SupportedServices;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchLocationsByAddress Choreo.
 */
@interface TMBFedEx_Locations_SearchLocationsByAddress_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Searches for FedEx locations near a given address.
 */
@interface TMBFedEx_Locations_SearchLocationsByAddress : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBFedEx_Locations_SearchLocationsByAddress_Inputs*)newInputSet;
@end

/*! group TMBFedEx.Locations_SearchLocationsByAddress Choreo */


/*! group TMBFedEx.TrackingAndVisibility.TrackByNumber Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TrackByNumber Choreo.
 */
@interface TMBFedEx_TrackingAndVisibility_TrackByNumber_Inputs : TMBChoreographyInputSet
	-(void)setAccountNumber:(NSString*)AccountNumber;
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey;
	-(void)setEndpoint:(NSString*)Endpoint;
	-(void)setMeterNumber:(NSString*)MeterNumber;
	-(void)setPassword:(NSString*)Password;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTrackingNumber:(NSString*)TrackingNumber;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TrackByNumber Choreo.
 */
@interface TMBFedEx_TrackingAndVisibility_TrackByNumber_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves shipment information for a specified tracking number.
 */
@interface TMBFedEx_TrackingAndVisibility_TrackByNumber : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBFedEx_TrackingAndVisibility_TrackByNumber_Inputs*)newInputSet;
@end

/*! group TMBFedEx.TrackingAndVisibility_TrackByNumber Choreo */


/*! group TMBFedEx.TrackingAndVisibility.TrackByReference Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TrackByReference Choreo.
 */
@interface TMBFedEx_TrackingAndVisibility_TrackByReference_Inputs : TMBChoreographyInputSet
	-(void)setAccountNumber:(NSString*)AccountNumber;
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey;
	-(void)setCity:(NSString*)City;
	-(void)setCountryCode:(NSString*)CountryCode;
	-(void)setEndpoint:(NSString*)Endpoint;
	-(void)setMeterNumber:(NSString*)MeterNumber;
	-(void)setOperatingCompany:(NSString*)OperatingCompany;
	-(void)setPassword:(NSString*)Password;
	-(void)setPostalCode:(NSString*)PostalCode;
	-(void)setReference:(NSString*)Reference;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setShipDateRangeBegin:(NSString*)ShipDateRangeBegin;
	-(void)setShipDateRangeEnd:(NSString*)ShipDateRangeEnd;
	-(void)setShipmentAccountNumber:(NSString*)ShipmentAccountNumber;
	-(void)setState:(NSString*)State;
	-(void)setStreet:(NSString*)Street;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TrackByReference Choreo.
 */
@interface TMBFedEx_TrackingAndVisibility_TrackByReference_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves shipment information for a specified reference number.
 */
@interface TMBFedEx_TrackingAndVisibility_TrackByReference : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBFedEx_TrackingAndVisibility_TrackByReference_Inputs*)newInputSet;
@end

/*! group TMBFedEx.TrackingAndVisibility_TrackByReference Choreo */


/*! group TMBFedEx.Validation.AddressValidation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddressValidation Choreo.
 */
@interface TMBFedEx_Validation_AddressValidation_Inputs : TMBChoreographyInputSet
	-(void)setAccountNumber:(NSString*)AccountNumber;
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey;
	-(void)setCity:(NSString*)City;
	-(void)setClientReferenceID:(NSString*)ClientReferenceID;
	-(void)setCompanyName:(NSString*)CompanyName;
	-(void)setCountryCode:(NSString*)CountryCode;
	-(void)setEndpoint:(NSString*)Endpoint;
	-(void)setMeterNumber:(NSString*)MeterNumber;
	-(void)setPassword:(NSString*)Password;
	-(void)setPhoneNumber:(NSString*)PhoneNumber;
	-(void)setPostalCode:(NSString*)PostalCode;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setState:(NSString*)State;
	-(void)setStreet:(NSString*)Street;
	-(void)setUrbanizationCode:(NSString*)UrbanizationCode;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddressValidation Choreo.
 */
@interface TMBFedEx_Validation_AddressValidation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Validates a given address.
 */
@interface TMBFedEx_Validation_AddressValidation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBFedEx_Validation_AddressValidation_Inputs*)newInputSet;
@end

/*! group TMBFedEx.Validation_AddressValidation Choreo */
