/*!
 * @header Temboo iOS SDK DarkSky classes
 *
 * Execute Choreographies from the Temboo DarkSky bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBDarkSky.GetForecastByAddress Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetForecastByAddress Choreo.
 */
@interface TMBDarkSky_GetForecastByAddress_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAddress:(NSString*)Address;
	-(void)setExclude:(NSString*)Exclude;
	-(void)setExtend:(NSString*)Extend;
	-(void)setGeocodingAPIKey:(NSString*)GeocodingAPIKey;
	-(void)setLanguage:(NSString*)Language;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetForecastByAddress Choreo.
 */
@interface TMBDarkSky_GetForecastByAddress_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getHourlySummary;
	-(NSString*)getHumidity;
	-(NSString*)getPressure;
	-(NSString*)getSummary;
	-(NSString*)getTemperature;
	-(NSString*)getUVIndex;
	-(NSString*)getVisibility;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the current weather conditions for a specified location by address.
 */
@interface TMBDarkSky_GetForecastByAddress : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBDarkSky_GetForecastByAddress_Inputs*)newInputSet;
@end

/*! group TMBDarkSky_GetForecastByAddress Choreo */


/*! group TMBDarkSky.GetForecastByCoordinates Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetForecastByCoordinates Choreo.
 */
@interface TMBDarkSky_GetForecastByCoordinates_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setExclude:(NSString*)Exclude;
	-(void)setExtend:(NSString*)Extend;
	-(void)setLanguage:(NSString*)Language;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetForecastByCoordinates Choreo.
 */
@interface TMBDarkSky_GetForecastByCoordinates_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getHourlySummary;
	-(NSString*)getHumidity;
	-(NSString*)getPressure;
	-(NSString*)getSummary;
	-(NSString*)getTemperature;
	-(NSString*)getUVIndex;
	-(NSString*)getVisibility;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the current weather conditions for a specified location by geo-coordinates.
 */
@interface TMBDarkSky_GetForecastByCoordinates : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBDarkSky_GetForecastByCoordinates_Inputs*)newInputSet;
@end

/*! group TMBDarkSky_GetForecastByCoordinates Choreo */


/*! group TMBDarkSky.TimeMachineRequest Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TimeMachineRequest Choreo.
 */
@interface TMBDarkSky_TimeMachineRequest_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setExclude:(NSString*)Exclude;
	-(void)setExtend:(NSString*)Extend;
	-(void)setLanguage:(NSString*)Language;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setTime:(NSString*)Time;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TimeMachineRequest Choreo.
 */
@interface TMBDarkSky_TimeMachineRequest_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getHourlySummary;
	-(NSString*)getHumidity;
	-(NSString*)getPressure;
	-(NSString*)getSummary;
	-(NSString*)getTemperature;
	-(NSString*)getUVIndex;
	-(NSString*)getVisibility;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the observed (in the past) or forecasted (in the future) hour-by-hour weather and daily weather conditions for a particular date.
 */
@interface TMBDarkSky_TimeMachineRequest : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBDarkSky_TimeMachineRequest_Inputs*)newInputSet;
@end

/*! group TMBDarkSky_TimeMachineRequest Choreo */
