/*!
 * @header Temboo iOS SDK eBay classes
 *
 * Execute Choreographies from the Temboo eBay bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBeBay.Finding.FindCompletedItems Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FindCompletedItems Choreo.
 */
@interface TMBeBay_Finding_FindCompletedItems_Inputs : TMBChoreographyInputSet
	-(void)setFindCompletedItemsRequest:(NSString*)FindCompletedItemsRequest;
	-(void)setAppID:(NSString*)AppID;
	-(void)setAspectFilters:(NSString*)AspectFilters;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage;
	-(void)setGlobalID:(NSString*)GlobalID;
	-(void)setItemFilters:(NSString*)ItemFilters;
	-(void)setKeywords:(NSString*)Keywords;
	-(void)setOutputSelector:(NSString*)OutputSelector;
	-(void)setPageNumber:(NSString*)PageNumber;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSortOrder:(NSString*)SortOrder;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindCompletedItems Choreo.
 */
@interface TMBeBay_Finding_FindCompletedItems_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves items whose listings are completed and are no longer available for sale on eBay.
 */
@interface TMBeBay_Finding_FindCompletedItems : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Finding_FindCompletedItems_Inputs*)newInputSet;
@end

/*! group TMBeBay.Finding_FindCompletedItems Choreo */


/*! group TMBeBay.Finding.FindItemsAdvanced Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FindItemsAdvanced Choreo.
 */
@interface TMBeBay_Finding_FindItemsAdvanced_Inputs : TMBChoreographyInputSet
	-(void)setFindItemsAdvancedRequest:(NSString*)FindItemsAdvancedRequest;
	-(void)setAppID:(NSString*)AppID;
	-(void)setAspectFilters:(NSString*)AspectFilters;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage;
	-(void)setGlobalID:(NSString*)GlobalID;
	-(void)setItemFilters:(NSString*)ItemFilters;
	-(void)setKeywords:(NSString*)Keywords;
	-(void)setOutputSelector:(NSString*)OutputSelector;
	-(void)setPageNumber:(NSString*)PageNumber;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSortOrder:(NSString*)SortOrder;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindItemsAdvanced Choreo.
 */
@interface TMBeBay_Finding_FindItemsAdvanced_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Finds items by a keyword query and/or category and allows searching within item descriptions.
 */
@interface TMBeBay_Finding_FindItemsAdvanced : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Finding_FindItemsAdvanced_Inputs*)newInputSet;
@end

/*! group TMBeBay.Finding_FindItemsAdvanced Choreo */


/*! group TMBeBay.Finding.FindItemsByImage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FindItemsByImage Choreo.
 */
@interface TMBeBay_Finding_FindItemsByImage_Inputs : TMBChoreographyInputSet
	-(void)setFindItemsByImageRequest:(NSString*)FindItemsByImageRequest;
	-(void)setAppID:(NSString*)AppID;
	-(void)setAspectFilters:(NSString*)AspectFilters;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage;
	-(void)setGlobalID:(NSString*)GlobalID;
	-(void)setItemFilters:(NSString*)ItemFilters;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setOutputSelector:(NSString*)OutputSelector;
	-(void)setPageNumber:(NSString*)PageNumber;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSortOrder:(NSString*)SortOrder;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindItemsByImage Choreo.
 */
@interface TMBeBay_Finding_FindItemsByImage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Finds items based on their image similarity to the specified item.
 */
@interface TMBeBay_Finding_FindItemsByImage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Finding_FindItemsByImage_Inputs*)newInputSet;
@end

/*! group TMBeBay.Finding_FindItemsByImage Choreo */


/*! group TMBeBay.Finding.FindItemsByProduct Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FindItemsByProduct Choreo.
 */
@interface TMBeBay_Finding_FindItemsByProduct_Inputs : TMBChoreographyInputSet
	-(void)setFindItemsByProductRequest:(NSString*)FindItemsByProductRequest;
	-(void)setAppID:(NSString*)AppID;
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage;
	-(void)setGlobalID:(NSString*)GlobalID;
	-(void)setItemFilters:(NSString*)ItemFilters;
	-(void)setOutputSelector:(NSString*)OutputSelector;
	-(void)setPageNumber:(NSString*)PageNumber;
	-(void)setProductID:(NSString*)ProductID;
	-(void)setProductIDType:(NSString*)ProductIDType;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSortOrder:(NSString*)SortOrder;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindItemsByProduct Choreo.
 */
@interface TMBeBay_Finding_FindItemsByProduct_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Finds items based upon a product ID, such as an ISBN, UPC, EAN, or ePID.
 */
@interface TMBeBay_Finding_FindItemsByProduct : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Finding_FindItemsByProduct_Inputs*)newInputSet;
@end

/*! group TMBeBay.Finding_FindItemsByProduct Choreo */


/*! group TMBeBay.Finding.GetHistograms Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetHistograms Choreo.
 */
@interface TMBeBay_Finding_GetHistograms_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setGlobalID:(NSString*)GlobalID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetHistograms Choreo.
 */
@interface TMBeBay_Finding_GetHistograms_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns category and/or aspect histogram information for the eBay category ID you specify.
 */
@interface TMBeBay_Finding_GetHistograms : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Finding_GetHistograms_Inputs*)newInputSet;
@end

/*! group TMBeBay.Finding_GetHistograms Choreo */


/*! group TMBeBay.Shopping.FindPopularItems Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FindPopularItems Choreo.
 */
@interface TMBeBay_Shopping_FindPopularItems_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setCategoryIDExclude:(NSString*)CategoryIDExclude;
	-(void)setMaxEntries:(NSString*)MaxEntries;
	-(void)setQueryKeywords:(NSString*)QueryKeywords;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindPopularItems Choreo.
 */
@interface TMBeBay_Shopping_FindPopularItems_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Searches for popular items based on a category or keyword.
 */
@interface TMBeBay_Shopping_FindPopularItems : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Shopping_FindPopularItems_Inputs*)newInputSet;
@end

/*! group TMBeBay.Shopping_FindPopularItems Choreo */


/*! group TMBeBay.Shopping.FindProducts Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FindProducts Choreo.
 */
@interface TMBeBay_Shopping_FindProducts_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setAvailableItemsOnly:(NSString*)AvailableItemsOnly;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setDomainName:(NSString*)DomainName;
	-(void)setHideDuplicateItems:(NSString*)HideDuplicateItems;
	-(void)setIncludeSelector:(NSString*)IncludeSelector;
	-(void)setMaxEntries:(NSString*)MaxEntries;
	-(void)setPageNumber:(NSString*)PageNumber;
	-(void)setProductID:(NSString*)ProductID;
	-(void)setProductSort:(NSString*)ProductSort;
	-(void)setQueryKeywords:(NSString*)QueryKeywords;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setSortOrder:(NSString*)SortOrder;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindProducts Choreo.
 */
@interface TMBeBay_Shopping_FindProducts_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the listings for products that match the specified keywords.
 */
@interface TMBeBay_Shopping_FindProducts : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Shopping_FindProducts_Inputs*)newInputSet;
@end

/*! group TMBeBay.Shopping_FindProducts Choreo */


/*! group TMBeBay.Shopping.GetCategoryInfo Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetCategoryInfo Choreo.
 */
@interface TMBeBay_Shopping_GetCategoryInfo_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setIncludeSelector:(NSString*)IncludeSelector;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCategoryInfo Choreo.
 */
@interface TMBeBay_Shopping_GetCategoryInfo_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve high-level category information for a specified category.
 */
@interface TMBeBay_Shopping_GetCategoryInfo : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Shopping_GetCategoryInfo_Inputs*)newInputSet;
@end

/*! group TMBeBay.Shopping_GetCategoryInfo Choreo */


/*! group TMBeBay.Shopping.GetItemStatus Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetItemStatus Choreo.
 */
@interface TMBeBay_Shopping_GetItemStatus_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetItemStatus Choreo.
 */
@interface TMBeBay_Shopping_GetItemStatus_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to get the status for a group of items.
 */
@interface TMBeBay_Shopping_GetItemStatus : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Shopping_GetItemStatus_Inputs*)newInputSet;
@end

/*! group TMBeBay.Shopping_GetItemStatus Choreo */


/*! group TMBeBay.Shopping.GetMultipleItems Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetMultipleItems Choreo.
 */
@interface TMBeBay_Shopping_GetMultipleItems_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMultipleItems Choreo.
 */
@interface TMBeBay_Shopping_GetMultipleItems_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves publicly available data for one or more listings.
 */
@interface TMBeBay_Shopping_GetMultipleItems : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Shopping_GetMultipleItems_Inputs*)newInputSet;
@end

/*! group TMBeBay.Shopping_GetMultipleItems Choreo */


/*! group TMBeBay.Shopping.GetShippingCosts Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetShippingCosts Choreo.
 */
@interface TMBeBay_Shopping_GetShippingCosts_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setDestinationCountryCode:(NSString*)DestinationCountryCode;
	-(void)setDestinationPostalCode:(NSString*)DestinationPostalCode;
	-(void)setIncludeDetails:(NSString*)IncludeDetails;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setQuantitySold:(NSString*)QuantitySold;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetShippingCosts Choreo.
 */
@interface TMBeBay_Shopping_GetShippingCosts_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves shipping costs for an item.
 */
@interface TMBeBay_Shopping_GetShippingCosts : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Shopping_GetShippingCosts_Inputs*)newInputSet;
@end

/*! group TMBeBay.Shopping_GetShippingCosts Choreo */


/*! group TMBeBay.Shopping.GetUserProfile Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetUserProfile Choreo.
 */
@interface TMBeBay_Shopping_GetUserProfile_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUserProfile Choreo.
 */
@interface TMBeBay_Shopping_GetUserProfile_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves public user information based on the user ID you specify.
 */
@interface TMBeBay_Shopping_GetUserProfile : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Shopping_GetUserProfile_Inputs*)newInputSet;
@end

/*! group TMBeBay.Shopping_GetUserProfile Choreo */


/*! group TMBeBay.Trading.AddBasicListing Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddBasicListing Choreo.
 */
@interface TMBeBay_Trading_AddBasicListing_Inputs : TMBChoreographyInputSet
	-(void)setBuyItNowPrice:(NSString*)BuyItNowPrice;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setConditionID:(NSString*)ConditionID;
	-(void)setCountry:(NSString*)Country;
	-(void)setCurrency:(NSString*)Currency;
	-(void)setDispatchTimeMax:(NSString*)DispatchTimeMax;
	-(void)setExpeditedService:(NSString*)ExpeditedService;
	-(void)setItemDescription:(NSString*)ItemDescription;
	-(void)setListingDuration:(NSString*)ListingDuration;
	-(void)setListingType:(NSString*)ListingType;
	-(void)setPayPalEmailAddress:(NSString*)PayPalEmailAddress;
	-(void)setPaymentMethods:(NSString*)PaymentMethods;
	-(void)setPictureURL:(NSString*)PictureURL;
	-(void)setPostalCode:(NSString*)PostalCode;
	-(void)setQuantity:(NSString*)Quantity;
	-(void)setRefundOption:(NSString*)RefundOption;
	-(void)setReservePrice:(NSString*)ReservePrice;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setReturnPolicyDescription:(NSString*)ReturnPolicyDescription;
	-(void)setReturnsAcceptedOption:(NSString*)ReturnsAcceptedOption;
	-(void)setReturnsWithinOption:(NSString*)ReturnsWithinOption;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setShippingService:(NSString*)ShippingService;
	-(void)setShippingServiceAdditionalCost:(NSString*)ShippingServiceAdditionalCost;
	-(void)setShippingServiceCost:(NSString*)ShippingServiceCost;
	-(void)setShippingType:(NSString*)ShippingType;
	-(void)setSite:(NSString*)Site;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setStartPrice:(NSString*)StartPrice;
	-(void)setTitle:(NSString*)Title;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddBasicListing Choreo.
 */
@interface TMBeBay_Trading_AddBasicListing_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you create a basic listing on eBay using scalar inputs rather than an XML request.
 */
@interface TMBeBay_Trading_AddBasicListing : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_AddBasicListing_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_AddBasicListing Choreo */


/*! group TMBeBay.Trading.AddItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddItem Choreo.
 */
@interface TMBeBay_Trading_AddItem_Inputs : TMBChoreographyInputSet
	-(void)setAddItemRequest:(NSString*)AddItemRequest;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddItem Choreo.
 */
@interface TMBeBay_Trading_AddItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Defines a single new item and lists it on a specified eBay site.
 */
@interface TMBeBay_Trading_AddItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_AddItem_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_AddItem Choreo */


/*! group TMBeBay.Trading.AddMemberMessageAAQToPartner Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddMemberMessageAAQToPartner Choreo.
 */
@interface TMBeBay_Trading_AddMemberMessageAAQToPartner_Inputs : TMBChoreographyInputSet
	-(void)setBody:(NSString*)Body;
	-(void)setEmailCopyToSender:(NSString*)EmailCopyToSender;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setQuestionType:(NSString*)QuestionType;
	-(void)setRecipientID:(NSString*)RecipientID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setSubject:(NSString*)Subject;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddMemberMessageAAQToPartner Choreo.
 */
@interface TMBeBay_Trading_AddMemberMessageAAQToPartner_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows a buyer and seller in an order relationship to send messages to each other's My Messages Inboxes.
 */
@interface TMBeBay_Trading_AddMemberMessageAAQToPartner : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_AddMemberMessageAAQToPartner_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_AddMemberMessageAAQToPartner Choreo */


/*! group TMBeBay.Trading.AddMemberMessageRTQ Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddMemberMessageRTQ Choreo.
 */
@interface TMBeBay_Trading_AddMemberMessageRTQ_Inputs : TMBChoreographyInputSet
	-(void)setBody:(NSString*)Body;
	-(void)setDisplayToPublic:(NSString*)DisplayToPublic;
	-(void)setEmailCopyToSender:(NSString*)EmailCopyToSender;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setParentMessageID:(NSString*)ParentMessageID;
	-(void)setRecipientID:(NSString*)RecipientID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddMemberMessageRTQ Choreo.
 */
@interface TMBeBay_Trading_AddMemberMessageRTQ_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows a seller to reply to a question about an active item listing.
 */
@interface TMBeBay_Trading_AddMemberMessageRTQ : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_AddMemberMessageRTQ_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_AddMemberMessageRTQ Choreo */


/*! group TMBeBay.Trading.AddToWatchList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddToWatchList Choreo.
 */
@interface TMBeBay_Trading_AddToWatchList_Inputs : TMBChoreographyInputSet
	-(void)setItemID:(NSString*)ItemID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddToWatchList Choreo.
 */
@interface TMBeBay_Trading_AddToWatchList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Adds one or more items to the user's My eBay watch list.
 */
@interface TMBeBay_Trading_AddToWatchList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_AddToWatchList_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_AddToWatchList Choreo */


/*! group TMBeBay.Trading.CompleteSale Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CompleteSale Choreo.
 */
@interface TMBeBay_Trading_CompleteSale_Inputs : TMBChoreographyInputSet
	-(void)setCompleteSaleRequest:(NSString*)CompleteSaleRequest;
	-(void)setCommentText:(NSString*)CommentText;
	-(void)setCommentType:(NSString*)CommentType;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setNotes:(NSString*)Notes;
	-(void)setOrderID:(NSString*)OrderID;
	-(void)setOrderLineItemID:(NSString*)OrderLineItemID;
	-(void)setPaid:(NSString*)Paid;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setShipmentTrackingNumber:(NSString*)ShipmentTrackingNumber;
	-(void)setShipped:(NSString*)Shipped;
	-(void)setShippedTime:(NSString*)ShippedTime;
	-(void)setShippingCarrierUsed:(NSString*)ShippingCarrierUsed;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setTargetUser:(NSString*)TargetUser;
	-(void)setTransactionID:(NSString*)TransactionID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CompleteSale Choreo.
 */
@interface TMBeBay_Trading_CompleteSale_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows the seller to perform the final steps for completing an order.
 */
@interface TMBeBay_Trading_CompleteSale : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_CompleteSale_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_CompleteSale Choreo */


/*! group TMBeBay.Trading.EndItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the EndItem Choreo.
 */
@interface TMBeBay_Trading_EndItem_Inputs : TMBChoreographyInputSet
	-(void)setEndingReason:(NSString*)EndingReason;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSellerInventoryID:(NSString*)SellerInventoryID;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the EndItem Choreo.
 */
@interface TMBeBay_Trading_EndItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Ends the specified item listing before the date and time that it is scheduled to end per the listing duration.
 */
@interface TMBeBay_Trading_EndItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_EndItem_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_EndItem Choreo */


/*! group TMBeBay.Trading.FetchToken Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FetchToken Choreo.
 */
@interface TMBeBay_Trading_FetchToken_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setCertID:(NSString*)CertID;
	-(void)setDevID:(NSString*)DevID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSessionID:(NSString*)SessionID;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setTimeout:(NSString*)Timeout;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FetchToken Choreo.
 */
@interface TMBeBay_Trading_FetchToken_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getUserToken;
	-(NSString*)getResponse;	
@end

/*!
 * Completes the authentication process by retrieving an eBay user token after they have visited the authorization URL returned by the GetSessionID Choreo and clicked "I agree".
 */
@interface TMBeBay_Trading_FetchToken : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_FetchToken_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_FetchToken Choreo */


/*! group TMBeBay.Trading.GetCategories Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetCategories Choreo.
 */
@interface TMBeBay_Trading_GetCategories_Inputs : TMBChoreographyInputSet
	-(void)setCategoryParent:(NSString*)CategoryParent;
	-(void)setCategorySiteID:(NSString*)CategorySiteID;
	-(void)setDetailLevel:(NSString*)DetailLevel;
	-(void)setLevelLimit:(NSString*)LevelLimit;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
	-(void)setViewAllNodes:(NSString*)ViewAllNodes;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCategories Choreo.
 */
@interface TMBeBay_Trading_GetCategories_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the latest category hierarchy for the eBay site.
 */
@interface TMBeBay_Trading_GetCategories : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetCategories_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetCategories Choreo */


/*! group TMBeBay.Trading.GetCategoryFeatures Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetCategoryFeatures Choreo.
 */
@interface TMBeBay_Trading_GetCategoryFeatures_Inputs : TMBChoreographyInputSet
	-(void)setAllFeaturesForCategory:(NSString*)AllFeaturesForCategory;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setDetailLevel:(NSString*)DetailLevel;
	-(void)setFeatureID:(NSString*)FeatureID;
	-(void)setLevelLimit:(NSString*)LevelLimit;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
	-(void)setViewAllNodes:(NSString*)ViewAllNodes;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCategoryFeatures Choreo.
 */
@interface TMBeBay_Trading_GetCategoryFeatures_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns information that describes the feature and value settings that apply to the set of eBay categories.
 */
@interface TMBeBay_Trading_GetCategoryFeatures : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetCategoryFeatures_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetCategoryFeatures Choreo */


/*! group TMBeBay.Trading.GetEbayDetails Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetEbayDetails Choreo.
 */
@interface TMBeBay_Trading_GetEbayDetails_Inputs : TMBChoreographyInputSet
	-(void)setDetailName:(NSString*)DetailName;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetEbayDetails Choreo.
 */
@interface TMBeBay_Trading_GetEbayDetails_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the available meta-data for the specified eBay site.
 */
@interface TMBeBay_Trading_GetEbayDetails : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetEbayDetails_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetEbayDetails Choreo */


/*! group TMBeBay.Trading.GetEbayOfficialTime Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetEbayOfficialTime Choreo.
 */
@interface TMBeBay_Trading_GetEbayOfficialTime_Inputs : TMBChoreographyInputSet
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetEbayOfficialTime Choreo.
 */
@interface TMBeBay_Trading_GetEbayOfficialTime_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets the official eBay system time in GMT.
 */
@interface TMBeBay_Trading_GetEbayOfficialTime : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetEbayOfficialTime_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetEbayOfficialTime Choreo */


/*! group TMBeBay.Trading.GetFeedback Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetFeedback Choreo.
 */
@interface TMBeBay_Trading_GetFeedback_Inputs : TMBChoreographyInputSet
	-(void)setCommentType:(NSString*)CommentType;
	-(void)setDetailLevel:(NSString*)DetailLevel;
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage;
	-(void)setFeedbackID:(NSString*)FeedbackID;
	-(void)setFeedbackType:(NSString*)FeedbackType;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setOrderLineItemID:(NSString*)OrderLineItemID;
	-(void)setPageNumber:(NSString*)PageNumber;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setTransactionID:(NSString*)TransactionID;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFeedback Choreo.
 */
@interface TMBeBay_Trading_GetFeedback_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the feedback left for a specified user or the summary feedback data for a specific order line item or item listing.
 */
@interface TMBeBay_Trading_GetFeedback : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetFeedback_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetFeedback Choreo */


/*! group TMBeBay.Trading.GetItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetItem Choreo.
 */
@interface TMBeBay_Trading_GetItem_Inputs : TMBChoreographyInputSet
	-(void)setDetailLevel:(NSString*)DetailLevel;
	-(void)setIncludeItemSpecifics:(NSString*)IncludeItemSpecifics;
	-(void)setIncludeTaxTable:(NSString*)IncludeTaxTable;
	-(void)setIncludeWatchCount:(NSString*)IncludeWatchCount;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setTransactionID:(NSString*)TransactionID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetItem Choreo.
 */
@interface TMBeBay_Trading_GetItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getCurrentPrice;
	-(NSString*)getDaysLeft;
	-(NSString*)getHoursLeft;
	-(NSString*)getMinutesLeft;
	-(NSString*)getSecondsLeft;
	-(NSString*)getResponse;	
@end

/*!
 * Returns item data such as title, description, price information, and seller information.
 */
@interface TMBeBay_Trading_GetItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetItem_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetItem Choreo */


/*! group TMBeBay.Trading.GetItemTransactions Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetItemTransactions Choreo.
 */
@interface TMBeBay_Trading_GetItemTransactions_Inputs : TMBChoreographyInputSet
	-(void)setDetailLevel:(NSString*)DetailLevel;
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage;
	-(void)setIncludeContainingOrder:(NSString*)IncludeContainingOrder;
	-(void)setIncludeFinalValueFee:(NSString*)IncludeFinalValueFee;
	-(void)setIncludeVariations:(NSString*)IncludeVariations;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setModTimeFrom:(NSString*)ModTimeFrom;
	-(void)setModTimeTo:(NSString*)ModTimeTo;
	-(void)setNumberOfDays:(NSString*)NumberOfDays;
	-(void)setOrderLineItemID:(NSString*)OrderLineItemID;
	-(void)setPageNumber:(NSString*)PageNumber;
	-(void)setPlatform:(NSString*)Platform;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setTransactionID:(NSString*)TransactionID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetItemTransactions Choreo.
 */
@interface TMBeBay_Trading_GetItemTransactions_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves order line item (transaction) information for a specified ItemID.
 */
@interface TMBeBay_Trading_GetItemTransactions : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetItemTransactions_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetItemTransactions Choreo */


/*! group TMBeBay.Trading.GetMemberMessages Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetMemberMessages Choreo.
 */
@interface TMBeBay_Trading_GetMemberMessages_Inputs : TMBChoreographyInputSet
	-(void)setDisplayToPublic:(NSString*)DisplayToPublic;
	-(void)setEndCreationTime:(NSString*)EndCreationTime;
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setMailMessageType:(NSString*)MailMessageType;
	-(void)setMemberMessageID:(NSString*)MemberMessageID;
	-(void)setMessageStatus:(NSString*)MessageStatus;
	-(void)setPageNumber:(NSString*)PageNumber;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSenderID:(NSString*)SenderID;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setStartCreationTime:(NSString*)StartCreationTime;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMemberMessages Choreo.
 */
@interface TMBeBay_Trading_GetMemberMessages_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of the messages that buyers have posted about your active item listings.
 */
@interface TMBeBay_Trading_GetMemberMessages : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetMemberMessages_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetMemberMessages Choreo */


/*! group TMBeBay.Trading.GetSellerTransactions Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetSellerTransactions Choreo.
 */
@interface TMBeBay_Trading_GetSellerTransactions_Inputs : TMBChoreographyInputSet
	-(void)setDetailLevel:(NSString*)DetailLevel;
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage;
	-(void)setIncludeCodiceFiscale:(NSString*)IncludeCodiceFiscale;
	-(void)setIncludeContainingOrder:(NSString*)IncludeContainingOrder;
	-(void)setIncludeFinalValueFee:(NSString*)IncludeFinalValueFee;
	-(void)setInventoryTrackingMethod:(NSString*)InventoryTrackingMethod;
	-(void)setModTimeFrom:(NSString*)ModTimeFrom;
	-(void)setModTimeTo:(NSString*)ModTimeTo;
	-(void)setNumberOfDays:(NSString*)NumberOfDays;
	-(void)setPageNumber:(NSString*)PageNumber;
	-(void)setPlatform:(NSString*)Platform;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSKU:(NSString*)SKU;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSellerTransactions Choreo.
 */
@interface TMBeBay_Trading_GetSellerTransactions_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves order line item (transaction) information for the authenticated user only.
 */
@interface TMBeBay_Trading_GetSellerTransactions : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetSellerTransactions_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetSellerTransactions Choreo */


/*! group TMBeBay.Trading.GetSessionID Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetSessionID Choreo.
 */
@interface TMBeBay_Trading_GetSessionID_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setCertID:(NSString*)CertID;
	-(void)setDevID:(NSString*)DevID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setRuName:(NSString*)RuName;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSessionID Choreo.
 */
@interface TMBeBay_Trading_GetSessionID_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAuthorizationURL;
	-(NSString*)getSessionID;
	-(NSString*)getResponse;	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the authentication process.
 */
@interface TMBeBay_Trading_GetSessionID : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetSessionID_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetSessionID Choreo */


/*! group TMBeBay.Trading.GetUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetUser Choreo.
 */
@interface TMBeBay_Trading_GetUser_Inputs : TMBChoreographyInputSet
	-(void)setDetailLevel:(NSString*)DetailLevel;
	-(void)setIncludeFeatureEligibility:(NSString*)IncludeFeatureEligibility;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUser Choreo.
 */
@interface TMBeBay_Trading_GetUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves data pertaining to a single eBay user.
 */
@interface TMBeBay_Trading_GetUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_GetUser_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_GetUser Choreo */


/*! group TMBeBay.Trading.LeaveFeedback Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the LeaveFeedback Choreo.
 */
@interface TMBeBay_Trading_LeaveFeedback_Inputs : TMBChoreographyInputSet
	-(void)setLeaveFeedbackRequest:(NSString*)LeaveFeedbackRequest;
	-(void)setCommentText:(NSString*)CommentText;
	-(void)setCommentType:(NSString*)CommentType;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setOrderLineItemID:(NSString*)OrderLineItemID;
	-(void)setRating:(NSString*)Rating;
	-(void)setRatingDetail:(NSString*)RatingDetail;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setTargetUser:(NSString*)TargetUser;
	-(void)setTransactionID:(NSString*)TransactionID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the LeaveFeedback Choreo.
 */
@interface TMBeBay_Trading_LeaveFeedback_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Enables a buyer and seller to leave feedback for their order partner at the conclusion of a successful order.
 */
@interface TMBeBay_Trading_LeaveFeedback : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_LeaveFeedback_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_LeaveFeedback Choreo */


/*! group TMBeBay.Trading.PlaceOffer Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the PlaceOffer Choreo.
 */
@interface TMBeBay_Trading_PlaceOffer_Inputs : TMBChoreographyInputSet
	-(void)setPlaceOfferRequest:(NSString*)PlaceOfferRequest;
	-(void)setAction:(NSString*)Action;
	-(void)setBestOfferID:(NSString*)BestOfferID;
	-(void)setDetailLevel:(NSString*)DetailLevel;
	-(void)setEndUserIP:(NSString*)EndUserIP;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setMaxBid:(NSString*)MaxBid;
	-(void)setMessage:(NSString*)Message;
	-(void)setQuantity:(NSString*)Quantity;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserConsent:(NSString*)UserConsent;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlaceOffer Choreo.
 */
@interface TMBeBay_Trading_PlaceOffer_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows an authenticated user to to make a bid, a best offer, or a purchase on the item specified by the ItemID input field.
 */
@interface TMBeBay_Trading_PlaceOffer : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_PlaceOffer_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_PlaceOffer Choreo */


/*! group TMBeBay.Trading.ReviseItem Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ReviseItem Choreo.
 */
@interface TMBeBay_Trading_ReviseItem_Inputs : TMBChoreographyInputSet
	-(void)setReviseItemRequest:(NSString*)ReviseItemRequest;
	-(void)setBuyItNowPrice:(NSString*)BuyItNowPrice;
	-(void)setCategoryID:(NSString*)CategoryID;
	-(void)setConditionID:(NSString*)ConditionID;
	-(void)setCountry:(NSString*)Country;
	-(void)setCurrency:(NSString*)Currency;
	-(void)setDispatchTimeMax:(NSString*)DispatchTimeMax;
	-(void)setExpeditedService:(NSString*)ExpeditedService;
	-(void)setItemDescription:(NSString*)ItemDescription;
	-(void)setItemID:(NSString*)ItemID;
	-(void)setListingDuration:(NSString*)ListingDuration;
	-(void)setListingType:(NSString*)ListingType;
	-(void)setPayPalEmailAddress:(NSString*)PayPalEmailAddress;
	-(void)setPaymentMethods:(NSString*)PaymentMethods;
	-(void)setPictureURL:(NSString*)PictureURL;
	-(void)setPostalCode:(NSString*)PostalCode;
	-(void)setQuantity:(NSString*)Quantity;
	-(void)setRefundOption:(NSString*)RefundOption;
	-(void)setReservePrice:(NSString*)ReservePrice;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setReturnPolicyDescription:(NSString*)ReturnPolicyDescription;
	-(void)setReturnsAcceptedOption:(NSString*)ReturnsAcceptedOption;
	-(void)setReturnsWithinOption:(NSString*)ReturnsWithinOption;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setShippingService:(NSString*)ShippingService;
	-(void)setShippingServiceAdditionalCost:(NSString*)ShippingServiceAdditionalCost;
	-(void)setShippingServiceCost:(NSString*)ShippingServiceCost;
	-(void)setShippingType:(NSString*)ShippingType;
	-(void)setSite:(NSString*)Site;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setStartPrice:(NSString*)StartPrice;
	-(void)setTitle:(NSString*)Title;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ReviseItem Choreo.
 */
@interface TMBeBay_Trading_ReviseItem_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows a seller to change the properties of a currently active listing.
 */
@interface TMBeBay_Trading_ReviseItem : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_ReviseItem_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_ReviseItem Choreo */


/*! group TMBeBay.Trading.UploadSiteHostedPictures Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UploadSiteHostedPictures Choreo.
 */
@interface TMBeBay_Trading_UploadSiteHostedPictures_Inputs : TMBChoreographyInputSet
	-(void)setExtensionInDays:(NSString*)ExtensionInDays;
	-(void)setExternalPictureURL:(NSString*)ExternalPictureURL;
	-(void)setPictureData:(NSString*)PictureData;
	-(void)setPictureName:(NSString*)PictureName;
	-(void)setPictureSet:(NSString*)PictureSet;
	-(void)setPictureUploadPolicy:(NSString*)PictureUploadPolicy;
	-(void)setPictureWatermark:(NSString*)PictureWatermark;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSandboxMode:(NSString*)SandboxMode;
	-(void)setSiteID:(NSString*)SiteID;
	-(void)setUserToken:(NSString*)UserToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UploadSiteHostedPictures Choreo.
 */
@interface TMBeBay_Trading_UploadSiteHostedPictures_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to uploads a picture to eBay Picture Services by specifying a binary attachment or image URL.
 */
@interface TMBeBay_Trading_UploadSiteHostedPictures : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBeBay_Trading_UploadSiteHostedPictures_Inputs*)newInputSet;
@end

/*! group TMBeBay.Trading_UploadSiteHostedPictures Choreo */
