/*!
 * @TMBLinkedIn.m
 *
 * Execute Choreographies from the Temboo LinkedIn bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBLinkedIn.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the CompanyShare Choreo.
 */
@implementation TMBLinkedIn_Companies_CompanyShare_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the Comment input for this Choreo.
	*(conditional, string) A comment by the member to associated with the share. If this is not provided, you must specify the SubmittedURL.
	 */
	-(void)setComment:(NSString*)Comment {
		[super setInput:@"Comment" toValue:Comment];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the Description input for this Choreo.
	*(optional, string) The description of the content being shared.
	 */
	-(void)setDescription:(NSString*)Description {
		[super setInput:@"Description" toValue:Description];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the SharedTargetCode input for this Choreo.
	*(optional, string) A shared target code used to ensure that the shared content reaches a specific audience.
	 */
	-(void)setSharedTargetCode:(NSString*)SharedTargetCode {
		[super setInput:@"SharedTargetCode" toValue:SharedTargetCode];
	}

	/*!
	 * Set the value of the SharedTargetValue input for this Choreo.
	*(optional, string) The name of the shared target used to ensure that the shared content reaches a specific audience.
	 */
	-(void)setSharedTargetValue:(NSString*)SharedTargetValue {
		[super setInput:@"SharedTargetValue" toValue:SharedTargetValue];
	}

	/*!
	 * Set the value of the SubmittedImageURL input for this Choreo.
	*(optional, string) A fully qualified URL to a thumbnail image to accompany the shared content.
	 */
	-(void)setSubmittedImageURL:(NSString*)SubmittedImageURL {
		[super setInput:@"SubmittedImageURL" toValue:SubmittedImageURL];
	}

	/*!
	 * Set the value of the SubmittedURL input for this Choreo.
	*(optional, string) A fully qualified URL for the content being shared.
	 */
	-(void)setSubmittedURL:(NSString*)SubmittedURL {
		[super setInput:@"SubmittedURL" toValue:SubmittedURL];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(optional, string) The title of the content being shared.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the Visibility input for this Choreo.
	*(required, string) The visibility setting of the share. Valid values are: anyone, connections-only.
	 */
	-(void)setVisibility:(NSString*)Visibility {
		[super setInput:@"Visibility" toValue:Visibility];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CompanyShare Choreo.
 */
@implementation TMBLinkedIn_Companies_CompanyShare_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Posts shared comment on a company page.
 */
@implementation TMBLinkedIn_Companies_CompanyShare

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_CompanyShare Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/CompanyShare"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_CompanyShare_ResultSet *results = [[TMBLinkedIn_Companies_CompanyShare_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CompanyShare Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_CompanyShare_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_CompanyShare_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetComments Choreo.
 */
@implementation TMBLinkedIn_Companies_GetComments_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the UpdateKey input for this Choreo.
	*(required, string) The key of the update to retrieve comments for.
	 */
	-(void)setUpdateKey:(NSString*)UpdateKey {
		[super setInput:@"UpdateKey" toValue:UpdateKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetComments Choreo.
 */
@implementation TMBLinkedIn_Companies_GetComments_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns all comments for a specific company update.
 */
@implementation TMBLinkedIn_Companies_GetComments

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_GetComments Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/GetComments"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_GetComments_ResultSet *results = [[TMBLinkedIn_Companies_GetComments_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetComments Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_GetComments_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_GetComments_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetCompanyProfileByID Choreo.
 */
@implementation TMBLinkedIn_Companies_GetCompanyProfileByID_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the FieldSelector input for this Choreo.
	*(optional, string) A comma-separated list of additional field names to return (e.g., id,name,description). See Choreo notes for more details.
	 */
	-(void)setFieldSelector:(NSString*)FieldSelector {
		[super setInput:@"FieldSelector" toValue:FieldSelector];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCompanyProfileByID Choreo.
 */
@implementation TMBLinkedIn_Companies_GetCompanyProfileByID_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns profile information about a specified company.
 */
@implementation TMBLinkedIn_Companies_GetCompanyProfileByID

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_GetCompanyProfileByID Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/GetCompanyProfileByID"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_GetCompanyProfileByID_ResultSet *results = [[TMBLinkedIn_Companies_GetCompanyProfileByID_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetCompanyProfileByID Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_GetCompanyProfileByID_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_GetCompanyProfileByID_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetCompanyUpdate Choreo.
 */
@implementation TMBLinkedIn_Companies_GetCompanyUpdate_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the UpdateKey input for this Choreo.
	*(required, string) The key of the update to return.
	 */
	-(void)setUpdateKey:(NSString*)UpdateKey {
		[super setInput:@"UpdateKey" toValue:UpdateKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCompanyUpdate Choreo.
 */
@implementation TMBLinkedIn_Companies_GetCompanyUpdate_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a specific update event from the LinkedIn company page.
 */
@implementation TMBLinkedIn_Companies_GetCompanyUpdate

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_GetCompanyUpdate Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/GetCompanyUpdate"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_GetCompanyUpdate_ResultSet *results = [[TMBLinkedIn_Companies_GetCompanyUpdate_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetCompanyUpdate Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_GetCompanyUpdate_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_GetCompanyUpdate_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetCompanyUpdates Choreo.
 */
@implementation TMBLinkedIn_Companies_GetCompanyUpdates_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the Count input for this Choreo.
	*(optional, integer) The number of results to return in the response.
	 */
	-(void)setCount:(NSString*)Count {
		[super setInput:@"Count" toValue:Count];
	}

	/*!
	 * Set the value of the EventType input for this Choreo.
	*(required, string) Filter the results to only return updates of the specified event type. Valid values are: job-posting, new-product, status-update.
	 */
	-(void)setEventType:(NSString*)EventType {
		[super setInput:@"EventType" toValue:EventType];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the Start input for this Choreo.
	*(optional, integer) The page index to return. Used in combination with the Count input to page through results.
	 */
	-(void)setStart:(NSString*)Start {
		[super setInput:@"Start" toValue:Start];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCompanyUpdates Choreo.
 */
@implementation TMBLinkedIn_Companies_GetCompanyUpdates_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of update events from the LinkedIn company page.
 */
@implementation TMBLinkedIn_Companies_GetCompanyUpdates

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_GetCompanyUpdates Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/GetCompanyUpdates"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_GetCompanyUpdates_ResultSet *results = [[TMBLinkedIn_Companies_GetCompanyUpdates_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetCompanyUpdates Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_GetCompanyUpdates_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_GetCompanyUpdates_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetFollowers Choreo.
 */
@implementation TMBLinkedIn_Companies_GetFollowers_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the CompanySizes input for this Choreo.
	*(optional, string) Used to segment by a particular company size targeting code. See Choreo notes for more details.
	 */
	-(void)setCompanySizes:(NSString*)CompanySizes {
		[super setInput:@"CompanySizes" toValue:CompanySizes];
	}

	/*!
	 * Set the value of the GeographicArea input for this Choreo.
	*(optional, string) Used to segment by a particular geographic area. See Choreo notes for more details.
	 */
	-(void)setGeographicArea:(NSString*)GeographicArea {
		[super setInput:@"GeographicArea" toValue:GeographicArea];
	}

	/*!
	 * Set the value of the Industries input for this Choreo.
	*(optional, string) Used to segment by member industry. See Choreo notes for more details.
	 */
	-(void)setIndustries:(NSString*)Industries {
		[super setInput:@"Industries" toValue:Industries];
	}

	/*!
	 * Set the value of the JobFunction input for this Choreo.
	*(optional, string) Used to segment by member job function targeting code. See Choreo notes for more details.
	 */
	-(void)setJobFunction:(NSString*)JobFunction {
		[super setInput:@"JobFunction" toValue:JobFunction];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the SeniorityLevel input for this Choreo.
	*(optional, string) Used to segment by member seniority level targeting code. See Choreo notes for more details.
	 */
	-(void)setSeniorityLevel:(NSString*)SeniorityLevel {
		[super setInput:@"SeniorityLevel" toValue:SeniorityLevel];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFollowers Choreo.
 */
@implementation TMBLinkedIn_Companies_GetFollowers_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a company's followers, by segment.
 */
@implementation TMBLinkedIn_Companies_GetFollowers

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_GetFollowers Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/GetFollowers"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_GetFollowers_ResultSet *results = [[TMBLinkedIn_Companies_GetFollowers_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetFollowers Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_GetFollowers_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_GetFollowers_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetHistoricalFollowers Choreo.
 */
@implementation TMBLinkedIn_Companies_GetHistoricalFollowers_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the EndTimestamp input for this Choreo.
	*(optional, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.
	 */
	-(void)setEndTimestamp:(NSString*)EndTimestamp {
		[super setInput:@"EndTimestamp" toValue:EndTimestamp];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the StartTimestamp input for this Choreo.
	*(required, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.
	 */
	-(void)setStartTimestamp:(NSString*)StartTimestamp {
		[super setInput:@"StartTimestamp" toValue:StartTimestamp];
	}

	/*!
	 * Set the value of the TimeGranularity input for this Choreo.
	*(required, string) Granularity of statistics. Valid values are: day, month.
	 */
	-(void)setTimeGranularity:(NSString*)TimeGranularity {
		[super setInput:@"TimeGranularity" toValue:TimeGranularity];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetHistoricalFollowers Choreo.
 */
@implementation TMBLinkedIn_Companies_GetHistoricalFollowers_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a company's followers, by date range.
 */
@implementation TMBLinkedIn_Companies_GetHistoricalFollowers

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_GetHistoricalFollowers Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/GetHistoricalFollowers"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_GetHistoricalFollowers_ResultSet *results = [[TMBLinkedIn_Companies_GetHistoricalFollowers_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetHistoricalFollowers Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_GetHistoricalFollowers_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_GetHistoricalFollowers_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetHistoricalUpdates Choreo.
 */
@implementation TMBLinkedIn_Companies_GetHistoricalUpdates_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the EndTimestamp input for this Choreo.
	*(optional, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.
	 */
	-(void)setEndTimestamp:(NSString*)EndTimestamp {
		[super setInput:@"EndTimestamp" toValue:EndTimestamp];
	}

	/*!
	 * Set the value of the FieldSelector input for this Choreo.
	*(optional, string) A comma separated list of additional fields to return.
	 */
	-(void)setFieldSelector:(NSString*)FieldSelector {
		[super setInput:@"FieldSelector" toValue:FieldSelector];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the StartTimestamp input for this Choreo.
	*(required, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.
	 */
	-(void)setStartTimestamp:(NSString*)StartTimestamp {
		[super setInput:@"StartTimestamp" toValue:StartTimestamp];
	}

	/*!
	 * Set the value of the TimeGranularity input for this Choreo.
	*(required, string) Granularity of statistics. Valid values are: day, month.
	 */
	-(void)setTimeGranularity:(NSString*)TimeGranularity {
		[super setInput:@"TimeGranularity" toValue:TimeGranularity];
	}

	/*!
	 * Set the value of the UpdateKey input for this Choreo.
	*(optional, string) Optionally provide an update key value to return statistics for a specific company update.
	 */
	-(void)setUpdateKey:(NSString*)UpdateKey {
		[super setInput:@"UpdateKey" toValue:UpdateKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetHistoricalUpdates Choreo.
 */
@implementation TMBLinkedIn_Companies_GetHistoricalUpdates_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns impression and engagement data on company shares for a given company page.
 */
@implementation TMBLinkedIn_Companies_GetHistoricalUpdates

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_GetHistoricalUpdates Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/GetHistoricalUpdates"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_GetHistoricalUpdates_ResultSet *results = [[TMBLinkedIn_Companies_GetHistoricalUpdates_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetHistoricalUpdates Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_GetHistoricalUpdates_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_GetHistoricalUpdates_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLikes Choreo.
 */
@implementation TMBLinkedIn_Companies_GetLikes_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the UpdateKey input for this Choreo.
	*(required, string) The key of the update to return likes for.
	 */
	-(void)setUpdateKey:(NSString*)UpdateKey {
		[super setInput:@"UpdateKey" toValue:UpdateKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLikes Choreo.
 */
@implementation TMBLinkedIn_Companies_GetLikes_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns all likes for a specific company update.
 */
@implementation TMBLinkedIn_Companies_GetLikes

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_GetLikes Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/GetLikes"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_GetLikes_ResultSet *results = [[TMBLinkedIn_Companies_GetLikes_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLikes Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_GetLikes_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_GetLikes_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetStatistics Choreo.
 */
@implementation TMBLinkedIn_Companies_GetStatistics_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetStatistics Choreo.
 */
@implementation TMBLinkedIn_Companies_GetStatistics_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns general statistics for a company.
 */
@implementation TMBLinkedIn_Companies_GetStatistics

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_GetStatistics Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/GetStatistics"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_GetStatistics_ResultSet *results = [[TMBLinkedIn_Companies_GetStatistics_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetStatistics Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_GetStatistics_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_GetStatistics_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the IsAdmin Choreo.
 */
@implementation TMBLinkedIn_Companies_IsAdmin_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the IsAdmin Choreo.
 */
@implementation TMBLinkedIn_Companies_IsAdmin_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a simple boolean value that indicates whether the currently authenticated user is configured to be an administrator of the specified company.
 */
@implementation TMBLinkedIn_Companies_IsAdmin

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_IsAdmin Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/IsAdmin"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_IsAdmin_ResultSet *results = [[TMBLinkedIn_Companies_IsAdmin_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the IsAdmin Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_IsAdmin_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_IsAdmin_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the IsSharingEnabled Choreo.
 */
@implementation TMBLinkedIn_Companies_IsSharingEnabled_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the CompanyID input for this Choreo.
	*(required, integer) A LinkedIn assigned ID associated with the company.
	 */
	-(void)setCompanyID:(NSString*)CompanyID {
		[super setInput:@"CompanyID" toValue:CompanyID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the IsSharingEnabled Choreo.
 */
@implementation TMBLinkedIn_Companies_IsSharingEnabled_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a simple boolean value that indicates whether the specified company has sharing enabled or disabled.
 */
@implementation TMBLinkedIn_Companies_IsSharingEnabled

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_IsSharingEnabled Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/IsSharingEnabled"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_IsSharingEnabled_ResultSet *results = [[TMBLinkedIn_Companies_IsSharingEnabled_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the IsSharingEnabled Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_IsSharingEnabled_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_IsSharingEnabled_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListCompanies Choreo.
 */
@implementation TMBLinkedIn_Companies_ListCompanies_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the Count input for this Choreo.
	*(optional, integer) The number of results to return in the response.
	 */
	-(void)setCount:(NSString*)Count {
		[super setInput:@"Count" toValue:Count];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the Start input for this Choreo.
	*(optional, integer) The page index to return. Used in combination with the Count input to page through results.
	 */
	-(void)setStart:(NSString*)Start {
		[super setInput:@"Start" toValue:Start];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListCompanies Choreo.
 */
@implementation TMBLinkedIn_Companies_ListCompanies_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a list of all of the companies that the authenticated user is currently configured to be an administrator of.
 */
@implementation TMBLinkedIn_Companies_ListCompanies

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_Companies_ListCompanies Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/Companies/ListCompanies"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_Companies_ListCompanies_ResultSet *results = [[TMBLinkedIn_Companies_ListCompanies_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListCompanies Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_Companies_ListCompanies_Inputs*)newInputSet {
		return [[TMBLinkedIn_Companies_ListCompanies_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FinalizeOAuth Choreo.
 */
@implementation TMBLinkedIn_OAuth_FinalizeOAuth_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the CallbackID input for this Choreo.
	*(required, string) The callback token returned by the InitializeOAuth Choreo. Used to retrieve the callback data after the user authorizes.
	 */
	-(void)setCallbackID:(NSString*)CallbackID {
		[super setInput:@"CallbackID" toValue:CallbackID];
	}

	/*!
	 * Set the value of the OAuthTokenSecret input for this Choreo.
	*(required, string) The OAuthTokenSecret returned by the InitializeOAuth Choreo.
	 */
	-(void)setOAuthTokenSecret:(NSString*)OAuthTokenSecret {
		[super setInput:@"OAuthTokenSecret" toValue:OAuthTokenSecret];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the SuppressErrors input for this Choreo.
	*(optional, boolean) When set to true, errors received during the OAuth redirect process will be suppressed and returned in the ErrorMessage output.
	 */
	-(void)setSuppressErrors:(NSString*)SuppressErrors {
		[super setInput:@"SuppressErrors" toValue:SuppressErrors];
	}

	/*!
	 * Set the value of the Timeout input for this Choreo.
	*(optional, integer) The amount of time (in seconds) to poll your Temboo callback URL to see if your app's user has allowed or denied the request for access. Defaults to 20. Max is 60.
	 */
	-(void)setTimeout:(NSString*)Timeout {
		[super setInput:@"Timeout" toValue:Timeout];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FinalizeOAuth Choreo.
 */
@implementation TMBLinkedIn_OAuth_FinalizeOAuth_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "AccessToken" output from an execution of this Choreo.
	 * @return - NSString* (string) The Access Token retrieved during the OAuth process.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getAccessToken {
		return [super getOutputByName:@"AccessToken"];
	}

	/*!
	 * Retrieve the value of the "AccessTokenSecret" output from an execution of this Choreo.
	 * @return - NSString* (string) The Access Token Secret retrieved during the OAuth process.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getAccessTokenSecret {
		return [super getOutputByName:@"AccessTokenSecret"];
	}

	/*!
	 * Retrieve the value of the "ErrorMessage" output from an execution of this Choreo.
	 * @return - NSString* (string) Contains an error message if an error occurs during the OAuth redirect process and if SuppressErrors is set to true.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getErrorMessage {
		return [super getOutputByName:@"ErrorMessage"];
	}

	/*!
	 * Retrieve the value of the "Expires" output from an execution of this Choreo.
	 * @return - NSString* (integer) The expiration time in seconds of the access token retrieved.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getExpires {
		return [super getOutputByName:@"Expires"];
	}
	
@end

/*!
 * Completes the OAuth process by retrieving a LinkedIn access token and access token secret for a user, after they have visited the authorization URL returned by the InitializeOAuth choreo and clicked "allow."
 */
@implementation TMBLinkedIn_OAuth_FinalizeOAuth

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_OAuth_FinalizeOAuth Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/OAuth/FinalizeOAuth"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_OAuth_FinalizeOAuth_ResultSet *results = [[TMBLinkedIn_OAuth_FinalizeOAuth_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FinalizeOAuth Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_OAuth_FinalizeOAuth_Inputs*)newInputSet {
		return [[TMBLinkedIn_OAuth_FinalizeOAuth_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the InitializeOAuth Choreo.
 */
@implementation TMBLinkedIn_OAuth_InitializeOAuth_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the ForwardingURL input for this Choreo.
	*(optional, string) The URL that Temboo will redirect your users to after they grant access to your application. This should include the "https://" or "http://" prefix and be a fully qualified URL.
	 */
	-(void)setForwardingURL:(NSString*)ForwardingURL {
		[super setInput:@"ForwardingURL" toValue:ForwardingURL];
	}

	/*!
	 * Set the value of the Scope input for this Choreo.
	*(optional, string) A space delimited list of member permissions that your application requires (e.g.,  "r_basicprofile r_emailaddress w_share").
	 */
	-(void)setScope:(NSString*)Scope {
		[super setInput:@"Scope" toValue:Scope];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InitializeOAuth Choreo.
 */
@implementation TMBLinkedIn_OAuth_InitializeOAuth_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "AuthorizationURL" output from an execution of this Choreo.
	 * @return - NSString* (string) The authorization URL that the application's user needs to go to in order to grant access to your application.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getAuthorizationURL {
		return [super getOutputByName:@"AuthorizationURL"];
	}

	/*!
	 * Retrieve the value of the "CallbackID" output from an execution of this Choreo.
	 * @return - NSString* (string) An ID used to retrieve the callback data that Temboo stores once your application's user authorizes.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getCallbackID {
		return [super getOutputByName:@"CallbackID"];
	}

	/*!
	 * Retrieve the value of the "OAuthTokenSecret" output from an execution of this Choreo.
	 * @return - NSString* (string) The temporary OAuth Token Secret that can be exchanged for a final token secret using the FinalizeOAuth Choreo.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getOAuthTokenSecret {
		return [super getOutputByName:@"OAuthTokenSecret"];
	}
	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 */
@implementation TMBLinkedIn_OAuth_InitializeOAuth

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_OAuth_InitializeOAuth Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/OAuth/InitializeOAuth"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_OAuth_InitializeOAuth_ResultSet *results = [[TMBLinkedIn_OAuth_InitializeOAuth_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the InitializeOAuth Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_OAuth_InitializeOAuth_Inputs*)newInputSet {
		return [[TMBLinkedIn_OAuth_InitializeOAuth_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetMemberProfile Choreo.
 */
@implementation TMBLinkedIn_PeopleAndConnections_GetMemberProfile_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the FieldSelector input for this Choreo.
	*(optional, string) A comma separated list of profile properties to return.
	 */
	-(void)setFieldSelector:(NSString*)FieldSelector {
		[super setInput:@"FieldSelector" toValue:FieldSelector];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMemberProfile Choreo.
 */
@implementation TMBLinkedIn_PeopleAndConnections_GetMemberProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the standard default profile of the current user.
 */
@implementation TMBLinkedIn_PeopleAndConnections_GetMemberProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_PeopleAndConnections_GetMemberProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/PeopleAndConnections/GetMemberProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_PeopleAndConnections_GetMemberProfile_ResultSet *results = [[TMBLinkedIn_PeopleAndConnections_GetMemberProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetMemberProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_PeopleAndConnections_GetMemberProfile_Inputs*)newInputSet {
		return [[TMBLinkedIn_PeopleAndConnections_GetMemberProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CreateShare Choreo.
 */
@implementation TMBLinkedIn_ShareAndSocialStream_CreateShare_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by LinkedIn (AKA the Client ID).
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AccessToken input for this Choreo.
	*(required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).
	 */
	-(void)setAccessToken:(NSString*)AccessToken {
		[super setInput:@"AccessToken" toValue:AccessToken];
	}

	/*!
	 * Set the value of the AccessTokenSecret input for this Choreo.
	*(required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).
	 */
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret {
		[super setInput:@"AccessTokenSecret" toValue:AccessTokenSecret];
	}

	/*!
	 * Set the value of the Comment input for this Choreo.
	*(conditional, string) The text of the member's comment. Required unless providing Title and URL for a shared post.
	 */
	-(void)setComment:(NSString*)Comment {
		[super setInput:@"Comment" toValue:Comment];
	}

	/*!
	 * Set the value of the Description input for this Choreo.
	*(optional, string) A description of the shared content.
	 */
	-(void)setDescription:(NSString*)Description {
		[super setInput:@"Description" toValue:Description];
	}

	/*!
	 * Set the value of the ImageURL input for this Choreo.
	*(optional, string) The URL for the image of the shared content.
	 */
	-(void)setImageURL:(NSString*)ImageURL {
		[super setInput:@"ImageURL" toValue:ImageURL];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SecretKey input for this Choreo.
	*(required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).
	 */
	-(void)setSecretKey:(NSString*)SecretKey {
		[super setInput:@"SecretKey" toValue:SecretKey];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(conditional, string) The title of the shared content. Required unless providing a Comment.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the URL input for this Choreo.
	*(conditional, string) The URL for the shared content. Required unless providing a Comment.
	 */
	-(void)setURL:(NSString*)URL {
		[super setInput:@"URL" toValue:URL];
	}

	/*!
	 * Set the value of the Visibility input for this Choreo.
	*(optional, string) Determines if the post will be visible to everyone, or only those who are connected to you. Valid values are: "anyone" or "connections-only" (the default).
	 */
	-(void)setVisibility:(NSString*)Visibility {
		[super setInput:@"Visibility" toValue:Visibility];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateShare Choreo.
 */
@implementation TMBLinkedIn_ShareAndSocialStream_CreateShare_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from LinkedIn.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows you to share content on behalf of a LinkedIn member.
 */
@implementation TMBLinkedIn_ShareAndSocialStream_CreateShare

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBLinkedIn_ShareAndSocialStream_CreateShare Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/LinkedIn/ShareAndSocialStream/CreateShare"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBLinkedIn_ShareAndSocialStream_CreateShare_ResultSet *results = [[TMBLinkedIn_ShareAndSocialStream_CreateShare_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CreateShare Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBLinkedIn_ShareAndSocialStream_CreateShare_Inputs*)newInputSet {
		return [[TMBLinkedIn_ShareAndSocialStream_CreateShare_Inputs alloc] init];
	}
@end
	