/*!
 * @header Temboo iOS SDK Highrise classes
 *
 * Execute Choreographies from the Temboo Highrise bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBHighrise.CreatePeople Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreatePeople Choreo.
 */
@interface TMBHighrise_CreatePeople_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setBackground:(NSString*)Background;
	-(void)setCompanyName:(NSString*)CompanyName;
	-(void)setEmailAddress:(NSString*)EmailAddress;
	-(void)setFirstName:(NSString*)FirstName;
	-(void)setHomePhone:(NSString*)HomePhone;
	-(void)setLastName:(NSString*)LastName;
	-(void)setPassword:(NSString*)Password;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorkPhone:(NSString*)WorkPhone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreatePeople Choreo.
 */
@interface TMBHighrise_CreatePeople_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new contact record in your Highrise CRM.
 */
@interface TMBHighrise_CreatePeople : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBHighrise_CreatePeople_Inputs*)newInputSet;
@end

/*! group TMBHighrise_CreatePeople Choreo */


/*! group TMBHighrise.DeletePeople Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeletePeople Choreo.
 */
@interface TMBHighrise_DeletePeople_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setContactID:(NSString*)ContactID;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeletePeople Choreo.
 */
@interface TMBHighrise_DeletePeople_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specified contact from your Highrise CRM.
 */
@interface TMBHighrise_DeletePeople : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBHighrise_DeletePeople_Inputs*)newInputSet;
@end

/*! group TMBHighrise_DeletePeople Choreo */


/*! group TMBHighrise.ListAllPeople Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListAllPeople Choreo.
 */
@interface TMBHighrise_ListAllPeople_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAllPeople Choreo.
 */
@interface TMBHighrise_ListAllPeople_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves contacts from your Highrise CRM.
 */
@interface TMBHighrise_ListAllPeople : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBHighrise_ListAllPeople_Inputs*)newInputSet;
@end

/*! group TMBHighrise_ListAllPeople Choreo */


/*! group TMBHighrise.SearchPeople Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchPeople Choreo.
 */
@interface TMBHighrise_SearchPeople_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setCity:(NSString*)City;
	-(void)setCountry:(NSString*)Country;
	-(void)setEmailAddress:(NSString*)EmailAddress;
	-(void)setPassword:(NSString*)Password;
	-(void)setPhone:(NSString*)Phone;
	-(void)setState:(NSString*)State;
	-(void)setUsername:(NSString*)Username;
	-(void)setZip:(NSString*)Zip;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchPeople Choreo.
 */
@interface TMBHighrise_SearchPeople_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Lets you search your Highrise CRM by specifying an email search criteria.
 */
@interface TMBHighrise_SearchPeople : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBHighrise_SearchPeople_Inputs*)newInputSet;
@end

/*! group TMBHighrise_SearchPeople Choreo */


/*! group TMBHighrise.ShowPeople Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ShowPeople Choreo.
 */
@interface TMBHighrise_ShowPeople_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setConactID:(NSString*)ConactID;
	-(void)setPassword:(NSString*)Password;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ShowPeople Choreo.
 */
@interface TMBHighrise_ShowPeople_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves contacts from your Highrise CRM.
 */
@interface TMBHighrise_ShowPeople : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBHighrise_ShowPeople_Inputs*)newInputSet;
@end

/*! group TMBHighrise_ShowPeople Choreo */
