/*!
 * @file TMBTembooResource.m
 *
 * Parent class for all RESTful resources associated with a TMBTembooSession.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBTembooResource.h"
#import "TMBTembooResource_Protected.h"
#import "TMBTembooUri.h"
#import "TMBTembooSession.h"

/*!
 * Class extension - attempt to hide "protected" members
 */
@interface TMBTembooResource()
	/*! The session which owns this resource */
	@property (nonatomic, readwrite, strong) TMBTembooSession *session;
	/*! A URI fragment corresponding to the method call in the REST API that accesses this resource */
	@property (nonatomic, readwrite, strong) TMBTembooUri *uri;
@end

/*!
 * TMBTembooResource class implementation
 */
@implementation TMBTembooResource

//
// Synthesize class properties
//
@synthesize session;
@synthesize uri;

/*!
 * Initialize a RESTful resource with a session and URI
 *
 * @param s
 *		The session that owns this resource
 * @param u
 *		A URI fragment corresponding to the method call in the REST API that accesses this resource
 *
 * @return The initialized TMBTembooResource instance
 */
-(id)initWithSession:(TMBTembooSession *)s andUri:(TMBTembooUri *)u {
	
	if(self = [super init]){
		self.session = s;
		self.uri = u;
	}
	
	return self;
}

/*!
 * Release retained resources
 */

/*!
 * @return This TMBTembooResource's TMBTembooUri's description
 *
 * @see TMBTembooUri.description
 */
-(NSString*)description {
	return [self.uri description];
}

@end
