/*!
 * @header Temboo iOS SDK Yahoo classes
 *
 * Execute Choreographies from the Temboo Yahoo bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBYahoo.Finance.GetNews Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetNews Choreo.
 */
@interface TMBYahoo_Finance_GetNews_Inputs : TMBChoreographyInputSet
	-(void)setCompany:(NSString*)Company;
	-(void)setNewsType:(NSString*)NewsType;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetNews Choreo.
 */
@interface TMBYahoo_Finance_GetNews_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the most recent Yahoo Finance Company or Industry news items as an RSS feed.
 */
@interface TMBYahoo_Finance_GetNews : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_Finance_GetNews_Inputs*)newInputSet;
@end

/*! group TMBYahoo.Finance_GetNews Choreo */


/*! group TMBYahoo.Finance.GetStockQuote Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetStockQuote Choreo.
 */
@interface TMBYahoo_Finance_GetStockQuote_Inputs : TMBChoreographyInputSet
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setStockSymbol:(NSString*)StockSymbol;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetStockQuote Choreo.
 */
@interface TMBYahoo_Finance_GetStockQuote_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAsk;
	-(NSString*)getBid;
	-(NSString*)getChange;
	-(NSString*)getDaysHigh;
	-(NSString*)getDaysLow;
	-(NSString*)getLastTradePriceOnly;
	-(NSString*)getOpen;
	-(NSString*)getPreviousClose;
	-(NSString*)getVolume;
	-(NSString*)getYearHigh;
	-(NSString*)getYearLow;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information for the specified stock symbol from Yahoo Finance.
 */
@interface TMBYahoo_Finance_GetStockQuote : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_Finance_GetStockQuote_Inputs*)newInputSet;
@end

/*! group TMBYahoo.Finance_GetStockQuote Choreo */


/*! group TMBYahoo.PlaceFinder.FindByAddress Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FindByAddress Choreo.
 */
@interface TMBYahoo_PlaceFinder_FindByAddress_Inputs : TMBChoreographyInputSet
	-(void)setAddress:(NSString*)Address;
	-(void)setAppID:(NSString*)AppID;
	-(void)setGeocodeFlags:(NSString*)GeocodeFlags;
	-(void)setResponseFlags:(NSString*)ResponseFlags;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindByAddress Choreo.
 */
@interface TMBYahoo_PlaceFinder_FindByAddress_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getLatitude;
	-(NSString*)getLongitude;
	-(NSString*)getWOEID;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves complete geocoding information for a location by specifying an address or partial address.
 */
@interface TMBYahoo_PlaceFinder_FindByAddress : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_PlaceFinder_FindByAddress_Inputs*)newInputSet;
@end

/*! group TMBYahoo.PlaceFinder_FindByAddress Choreo */


/*! group TMBYahoo.PlaceFinder.FindByCoordinates Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FindByCoordinates Choreo.
 */
@interface TMBYahoo_PlaceFinder_FindByCoordinates_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setGeocodeFlags:(NSString*)GeocodeFlags;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setResponseFlags:(NSString*)ResponseFlags;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindByCoordinates Choreo.
 */
@interface TMBYahoo_PlaceFinder_FindByCoordinates_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getWOEID;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves complete location information from a specified pair of latitude and longitude coordinates.
 */
@interface TMBYahoo_PlaceFinder_FindByCoordinates : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_PlaceFinder_FindByCoordinates_Inputs*)newInputSet;
@end

/*! group TMBYahoo.PlaceFinder_FindByCoordinates Choreo */


/*! group TMBYahoo.Weather.GetTemperature Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetTemperature Choreo.
 */
@interface TMBYahoo_Weather_GetTemperature_Inputs : TMBChoreographyInputSet
	-(void)setAddress:(NSString*)Address;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetTemperature Choreo.
 */
@interface TMBYahoo_Weather_GetTemperature_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getTemperature;	
@end

/*!
 * Retrieves the current temperature from Yahoo Weather for the specified location.
 */
@interface TMBYahoo_Weather_GetTemperature : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_Weather_GetTemperature_Inputs*)newInputSet;
@end

/*! group TMBYahoo.Weather_GetTemperature Choreo */


/*! group TMBYahoo.Weather.GetWeather Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetWeather Choreo.
 */
@interface TMBYahoo_Weather_GetWeather_Inputs : TMBChoreographyInputSet
	-(void)setDay:(NSString*)Day;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setUnits:(NSString*)Units;
	-(void)setWOEID:(NSString*)WOEID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetWeather Choreo.
 */
@interface TMBYahoo_Weather_GetWeather_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getConditionCode;
	-(NSString*)getConditionText;
	-(NSString*)getForecastCode;
	-(NSString*)getForecastText;
	-(NSString*)getHigh;
	-(NSString*)getHumidity;
	-(NSString*)getLow;
	-(NSString*)getPressure;
	-(NSString*)getTemperature;
	-(NSString*)getVisibility;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the Yahoo Weather RSS Feed for any specified location by WOEID.
 */
@interface TMBYahoo_Weather_GetWeather : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_Weather_GetWeather_Inputs*)newInputSet;
@end

/*! group TMBYahoo.Weather_GetWeather Choreo */


/*! group TMBYahoo.Weather.GetWeatherByAddress Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetWeatherByAddress Choreo.
 */
@interface TMBYahoo_Weather_GetWeatherByAddress_Inputs : TMBChoreographyInputSet
	-(void)setAddress:(NSString*)Address;
	-(void)setAppID:(NSString*)AppID;
	-(void)setDay:(NSString*)Day;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetWeatherByAddress Choreo.
 */
@interface TMBYahoo_Weather_GetWeatherByAddress_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getConditionCode;
	-(NSString*)getConditionText;
	-(NSString*)getForecastCode;
	-(NSString*)getForecastText;
	-(NSString*)getHigh;
	-(NSString*)getHumidity;
	-(NSString*)getLow;
	-(NSString*)getPressure;
	-(NSString*)getTemperature;
	-(NSString*)getVisibility;
	-(NSString*)getWOEID;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the Yahoo Weather RSS Feed for any specified location by address.
 */
@interface TMBYahoo_Weather_GetWeatherByAddress : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_Weather_GetWeatherByAddress_Inputs*)newInputSet;
@end

/*! group TMBYahoo.Weather_GetWeatherByAddress Choreo */


/*! group TMBYahoo.Weather.GetWeatherByCoordinates Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetWeatherByCoordinates Choreo.
 */
@interface TMBYahoo_Weather_GetWeatherByCoordinates_Inputs : TMBChoreographyInputSet
	-(void)setAppID:(NSString*)AppID;
	-(void)setDay:(NSString*)Day;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetWeatherByCoordinates Choreo.
 */
@interface TMBYahoo_Weather_GetWeatherByCoordinates_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getConditionCode;
	-(NSString*)getConditionText;
	-(NSString*)getForecastCode;
	-(NSString*)getForecastText;
	-(NSString*)getHigh;
	-(NSString*)getHumidity;
	-(NSString*)getLow;
	-(NSString*)getPressure;
	-(NSString*)getTemperature;
	-(NSString*)getVisibility;
	-(NSString*)getWOEID;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the Yahoo Weather RSS Feed for any specified location by geo-coordinates.
 */
@interface TMBYahoo_Weather_GetWeatherByCoordinates : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_Weather_GetWeatherByCoordinates_Inputs*)newInputSet;
@end

/*! group TMBYahoo.Weather_GetWeatherByCoordinates Choreo */


/*! group TMBYahoo.YQL.RunQuery Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RunQuery Choreo.
 */
@interface TMBYahoo_YQL_RunQuery_Inputs : TMBChoreographyInputSet
	-(void)setDiagnostics:(NSString*)Diagnostics;
	-(void)setQuery:(NSString*)Query;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RunQuery Choreo.
 */
@interface TMBYahoo_YQL_RunQuery_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Executes a specified YQL (Yahoo Query Language) statement.
 */
@interface TMBYahoo_YQL_RunQuery : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_YQL_RunQuery_Inputs*)newInputSet;
@end

/*! group TMBYahoo.YQL_RunQuery Choreo */


/*! group TMBYahoo.YQL.ScrapeWebPage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ScrapeWebPage Choreo.
 */
@interface TMBYahoo_YQL_ScrapeWebPage_Inputs : TMBChoreographyInputSet
	-(void)setDiagnostics:(NSString*)Diagnostics;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setURL:(NSString*)URL;
	-(void)setXPATH:(NSString*)XPATH;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ScrapeWebPage Choreo.
 */
@interface TMBYahoo_YQL_ScrapeWebPage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Scrapes HTML from a web page and converts it to JSON or XML so that it can be reused by an application.
 */
@interface TMBYahoo_YQL_ScrapeWebPage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBYahoo_YQL_ScrapeWebPage_Inputs*)newInputSet;
@end

/*! group TMBYahoo.YQL_ScrapeWebPage Choreo */
