/*!
 * @header Temboo iOS SDK Salesforce classes
 *
 * Execute Choreographies from the Temboo Salesforce bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBSalesforce.OAuth.FinalizeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FinalizeOAuth Choreo.
 */
@interface TMBSalesforce_OAuth_FinalizeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setCallbackID:(NSString*)CallbackID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setSuppressErrors:(NSString*)SuppressErrors;
	-(void)setTimeout:(NSString*)Timeout;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FinalizeOAuth Choreo.
 */
@interface TMBSalesforce_OAuth_FinalizeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getErrorMessage;
	-(NSString*)getRefreshToken;	
@end

/*!
 * Completes the OAuth process by retrieving a Salesforce access token for a user, after they have visited the authorization URL returned by the InitializeOAuth choreo and clicked "allow."
 */
@interface TMBSalesforce_OAuth_FinalizeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_OAuth_FinalizeOAuth_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.OAuth_FinalizeOAuth Choreo */


/*! group TMBSalesforce.OAuth.InitializeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InitializeOAuth Choreo.
 */
@interface TMBSalesforce_OAuth_InitializeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setClientID:(NSString*)ClientID;
	-(void)setCustomCallbackID:(NSString*)CustomCallbackID;
	-(void)setDisplay:(NSString*)Display;
	-(void)setForwardingURL:(NSString*)ForwardingURL;
	-(void)setImmediate:(NSString*)Immediate;
	-(void)setScope:(NSString*)Scope;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InitializeOAuth Choreo.
 */
@interface TMBSalesforce_OAuth_InitializeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAuthorizationURL;
	-(NSString*)getCallbackID;	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 */
@interface TMBSalesforce_OAuth_InitializeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_OAuth_InitializeOAuth_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.OAuth_InitializeOAuth Choreo */


/*! group TMBSalesforce.Objects.CreateRecord Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateRecord Choreo.
 */
@interface TMBSalesforce_Objects_CreateRecord_Inputs : TMBChoreographyInputSet
	-(void)setSObject:(NSString*)SObject;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSObjectName:(NSString*)SObjectName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateRecord Choreo.
 */
@interface TMBSalesforce_Objects_CreateRecord_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getID;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new Salesforce Object such as an individual Account, Contact, or Lead record.
 */
@interface TMBSalesforce_Objects_CreateRecord : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Objects_CreateRecord_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Objects_CreateRecord Choreo */


/*! group TMBSalesforce.Objects.DeleteRecord Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRecord Choreo.
 */
@interface TMBSalesforce_Objects_DeleteRecord_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setID:(NSString*)ID;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSObjectName:(NSString*)SObjectName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRecord Choreo.
 */
@interface TMBSalesforce_Objects_DeleteRecord_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a Salesforce Object such as an individual Account, Contact, or Lead record.
 */
@interface TMBSalesforce_Objects_DeleteRecord : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Objects_DeleteRecord_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Objects_DeleteRecord Choreo */


/*! group TMBSalesforce.Objects.DeleteRecordFields Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRecordFields Choreo.
 */
@interface TMBSalesforce_Objects_DeleteRecordFields_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setID:(NSString*)ID;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSObjectName:(NSString*)SObjectName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRecordFields Choreo.
 */
@interface TMBSalesforce_Objects_DeleteRecordFields_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes specific field values from a specified record.
 */
@interface TMBSalesforce_Objects_DeleteRecordFields : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Objects_DeleteRecordFields_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Objects_DeleteRecordFields Choreo */


/*! group TMBSalesforce.Objects.DescribeObjectMetadata Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DescribeObjectMetadata Choreo.
 */
@interface TMBSalesforce_Objects_DescribeObjectMetadata_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSObjectName:(NSString*)SObjectName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DescribeObjectMetadata Choreo.
 */
@interface TMBSalesforce_Objects_DescribeObjectMetadata_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Describes the individual metadata at all levels for the specified object.
 */
@interface TMBSalesforce_Objects_DescribeObjectMetadata : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Objects_DescribeObjectMetadata_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Objects_DescribeObjectMetadata Choreo */


/*! group TMBSalesforce.Objects.GetObjectMetadata Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetObjectMetadata Choreo.
 */
@interface TMBSalesforce_Objects_GetObjectMetadata_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSObjectName:(NSString*)SObjectName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetObjectMetadata Choreo.
 */
@interface TMBSalesforce_Objects_GetObjectMetadata_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the individual metadata for the specified object type such as a Contact, Lead, or Account object.
 */
@interface TMBSalesforce_Objects_GetObjectMetadata : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Objects_GetObjectMetadata_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Objects_GetObjectMetadata Choreo */


/*! group TMBSalesforce.Objects.GetRecord Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetRecord Choreo.
 */
@interface TMBSalesforce_Objects_GetRecord_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setID:(NSString*)ID;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSObjectName:(NSString*)SObjectName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRecord Choreo.
 */
@interface TMBSalesforce_Objects_GetRecord_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a Salesforce Object such as an individual Account, Contact, or Lead record.
 */
@interface TMBSalesforce_Objects_GetRecord : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Objects_GetRecord_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Objects_GetRecord Choreo */


/*! group TMBSalesforce.Objects.GetRecordByExternalID Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetRecordByExternalID Choreo.
 */
@interface TMBSalesforce_Objects_GetRecordByExternalID_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFieldName:(NSString*)FieldName;
	-(void)setFieldValue:(NSString*)FieldValue;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSObjectName:(NSString*)SObjectName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRecordByExternalID Choreo.
 */
@interface TMBSalesforce_Objects_GetRecordByExternalID_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve records with a specific external ID.
 */
@interface TMBSalesforce_Objects_GetRecordByExternalID : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Objects_GetRecordByExternalID_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Objects_GetRecordByExternalID Choreo */


/*! group TMBSalesforce.Objects.ListObjectTypes Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListObjectTypes Choreo.
 */
@interface TMBSalesforce_Objects_ListObjectTypes_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListObjectTypes Choreo.
 */
@interface TMBSalesforce_Objects_ListObjectTypes_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists the available objects and their metadata for your organization's data.
 */
@interface TMBSalesforce_Objects_ListObjectTypes : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Objects_ListObjectTypes_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Objects_ListObjectTypes Choreo */


/*! group TMBSalesforce.Passwords.ChangePassword Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ChangePassword Choreo.
 */
@interface TMBSalesforce_Passwords_ChangePassword_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setID:(NSString*)ID;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setNewPassword:(NSString*)NewPassword;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ChangePassword Choreo.
 */
@interface TMBSalesforce_Passwords_ChangePassword_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Changes a user's password.
 */
@interface TMBSalesforce_Passwords_ChangePassword : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Passwords_ChangePassword_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Passwords_ChangePassword Choreo */


/*! group TMBSalesforce.Passwords.GetPasswordInfo Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetPasswordInfo Choreo.
 */
@interface TMBSalesforce_Passwords_GetPasswordInfo_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setID:(NSString*)ID;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetPasswordInfo Choreo.
 */
@interface TMBSalesforce_Passwords_GetPasswordInfo_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Gets information on a user's password.
 */
@interface TMBSalesforce_Passwords_GetPasswordInfo : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Passwords_GetPasswordInfo_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Passwords_GetPasswordInfo Choreo */


/*! group TMBSalesforce.Passwords.ResetPassword Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ResetPassword Choreo.
 */
@interface TMBSalesforce_Passwords_ResetPassword_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setID:(NSString*)ID;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ResetPassword Choreo.
 */
@interface TMBSalesforce_Passwords_ResetPassword_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getNewPassword;
	-(NSString*)getResponse;	
@end

/*!
 * Resets a user's password to new randomized password.
 */
@interface TMBSalesforce_Passwords_ResetPassword : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Passwords_ResetPassword_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Passwords_ResetPassword Choreo */


/*! group TMBSalesforce.Queries.GetNextResults Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetNextResults Choreo.
 */
@interface TMBSalesforce_Queries_GetNextResults_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setQueryLocator:(NSString*)QueryLocator;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetNextResults Choreo.
 */
@interface TMBSalesforce_Queries_GetNextResults_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getNextQueryLocator;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the remaining query results using a query locator ID.
 */
@interface TMBSalesforce_Queries_GetNextResults : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Queries_GetNextResults_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Queries_GetNextResults Choreo */


/*! group TMBSalesforce.Queries.Query Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Query Choreo.
 */
@interface TMBSalesforce_Queries_Query_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSOQL:(NSString*)SOQL;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Query Choreo.
 */
@interface TMBSalesforce_Queries_Query_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getQueryLocator;
	-(NSString*)getResponse;	
@end

/*!
 * Executes the specified SOQL query.
 */
@interface TMBSalesforce_Queries_Query : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Queries_Query_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Queries_Query Choreo */


/*! group TMBSalesforce.Resources.GetResources Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetResources Choreo.
 */
@interface TMBSalesforce_Resources_GetResources_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setVersion:(NSString*)Version;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetResources Choreo.
 */
@interface TMBSalesforce_Resources_GetResources_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * List available resources for a specified API version.
 */
@interface TMBSalesforce_Resources_GetResources : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Resources_GetResources_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Resources_GetResources Choreo */


/*! group TMBSalesforce.Searching.Search Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Search Choreo.
 */
@interface TMBSalesforce_Searching_Search_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSOSL:(NSString*)SOSL;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Search Choreo.
 */
@interface TMBSalesforce_Searching_Search_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Executes the specified SOSL search.
 */
@interface TMBSalesforce_Searching_Search : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Searching_Search_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Searching_Search Choreo */


/*! group TMBSalesforce.Searching.SearchScopeAndOrder Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchScopeAndOrder Choreo.
 */
@interface TMBSalesforce_Searching_SearchScopeAndOrder_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchScopeAndOrder Choreo.
 */
@interface TMBSalesforce_Searching_SearchScopeAndOrder_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Executes the specified SOSL search in the default global search scope of a logged-in user.
 */
@interface TMBSalesforce_Searching_SearchScopeAndOrder : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Searching_SearchScopeAndOrder_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Searching_SearchScopeAndOrder Choreo */


/*! group TMBSalesforce.Versions.ListVersions Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListVersions Choreo.
 */
@interface TMBSalesforce_Versions_ListVersions_Inputs : TMBChoreographyInputSet
	-(void)setInstanceName:(NSString*)InstanceName;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListVersions Choreo.
 */
@interface TMBSalesforce_Versions_ListVersions_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Lists summary information about each Salesforce version currently available, including the version, label, and a link to each version's root.
 */
@interface TMBSalesforce_Versions_ListVersions : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBSalesforce_Versions_ListVersions_Inputs*)newInputSet;
@end

/*! group TMBSalesforce.Versions_ListVersions Choreo */
