/*!
 * @TMBPlotly.m
 *
 * Execute Choreographies from the Temboo Plotly bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBPlotly.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the ConfigureGraph Choreo.
 */
@implementation TMBPlotly_ConfigureGraph_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Plotly.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the FileName input for this Choreo.
	*(required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
	 */
	-(void)setFileName:(NSString*)FileName {
		[super setInput:@"FileName" toValue:FileName];
	}

	/*!
	 * Set the value of the FileOption input for this Choreo.
	*(required, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details.
	 */
	-(void)setFileOption:(NSString*)FileOption {
		[super setInput:@"FileOption" toValue:FileOption];
	}

	/*!
	 * Set the value of the GraphArguments input for this Choreo.
	*(conditional, json) The data and/or styling arguments. Typically, this is in the form of a JSON array where x and y are represented as arrays of numbers or strings. See Choreo description for more details.
	 */
	-(void)setGraphArguments:(NSString*)GraphArguments {
		[super setInput:@"GraphArguments" toValue:GraphArguments];
	}

	/*!
	 * Set the value of the Layout input for this Choreo.
	*(optional, json) A key-value paired JSON object that describes the layout of the plot (e.g., {"title": "Sensor Data"}).
	 */
	-(void)setLayout:(NSString*)Layout {
		[super setInput:@"Layout" toValue:Layout];
	}

	/*!
	 * Set the value of the Origin input for this Choreo.
	*(optional, string) Specifies the type of call and the type of data in the Arguments parameter. Valid values are: plot (the default), style, or layout.
	 */
	-(void)setOrigin:(NSString*)Origin {
		[super setInput:@"Origin" toValue:Origin];
	}

	/*!
	 * Set the value of the Style input for this Choreo.
	*(optional, json) A JSON object describing the style of the graph (e.g., {"type": "bar"}). This can be applied to every single trace (default) or to the traces specified in the optional Traces input.
	 */
	-(void)setStyle:(NSString*)Style {
		[super setInput:@"Style" toValue:Style];
	}

	/*!
	 * Set the value of the Traces input for this Choreo.
	*(optional, json) Specifies the indices that the Style input object should be applied to. This should be formatted as a JSON array.
	 */
	-(void)setTraces:(NSString*)Traces {
		[super setInput:@"Traces" toValue:Traces];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A valid Plotly username.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the WorldReadable input for this Choreo.
	*(optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
	 */
	-(void)setWorldReadable:(NSString*)WorldReadable {
		[super setInput:@"WorldReadable" toValue:WorldReadable];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ConfigureGraph Choreo.
 */
@implementation TMBPlotly_ConfigureGraph_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "URL" output from an execution of this Choreo.
	 * @return - NSString* (string) The Plotly URL for the graph.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getURL {
		return [super getOutputByName:@"URL"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Plotly
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Creates, modifies, or styles a graph.
 */
@implementation TMBPlotly_ConfigureGraph

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPlotly_ConfigureGraph Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Plotly/ConfigureGraph"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPlotly_ConfigureGraph_ResultSet *results = [[TMBPlotly_ConfigureGraph_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ConfigureGraph Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPlotly_ConfigureGraph_Inputs*)newInputSet {
		return [[TMBPlotly_ConfigureGraph_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ExtendBarGraph Choreo.
 */
@implementation TMBPlotly_ExtendBarGraph_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Plotly.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the FileName input for this Choreo.
	*(required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
	 */
	-(void)setFileName:(NSString*)FileName {
		[super setInput:@"FileName" toValue:FileName];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(optional, string) The title of the graph.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A valid Plotly username.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the WorldReadable input for this Choreo.
	*(optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
	 */
	-(void)setWorldReadable:(NSString*)WorldReadable {
		[super setInput:@"WorldReadable" toValue:WorldReadable];
	}

	/*!
	 * Set the value of the XValue input for this Choreo.
	*(required, any) The "x" coordinate value to be plotted on the graph.
	 */
	-(void)setXValue:(NSString*)XValue {
		[super setInput:@"XValue" toValue:XValue];
	}

	/*!
	 * Set the value of the YValue input for this Choreo.
	*(required, any) The "y" coordinate value to be plotted on the graph.
	 */
	-(void)setYValue:(NSString*)YValue {
		[super setInput:@"YValue" toValue:YValue];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ExtendBarGraph Choreo.
 */
@implementation TMBPlotly_ExtendBarGraph_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "URL" output from an execution of this Choreo.
	 * @return - NSString* (string) The Plotly URL for the graph.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getURL {
		return [super getOutputByName:@"URL"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Plotly
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Extends the specified bar graph by plotting a single addition point.
 */
@implementation TMBPlotly_ExtendBarGraph

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPlotly_ExtendBarGraph Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Plotly/ExtendBarGraph"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPlotly_ExtendBarGraph_ResultSet *results = [[TMBPlotly_ExtendBarGraph_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ExtendBarGraph Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPlotly_ExtendBarGraph_Inputs*)newInputSet {
		return [[TMBPlotly_ExtendBarGraph_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ExtendLineGraph Choreo.
 */
@implementation TMBPlotly_ExtendLineGraph_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Plotly.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the FileName input for this Choreo.
	*(required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
	 */
	-(void)setFileName:(NSString*)FileName {
		[super setInput:@"FileName" toValue:FileName];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(optional, string) The title of the graph.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A valid Plotly username.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the WorldReadable input for this Choreo.
	*(optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
	 */
	-(void)setWorldReadable:(NSString*)WorldReadable {
		[super setInput:@"WorldReadable" toValue:WorldReadable];
	}

	/*!
	 * Set the value of the XValue input for this Choreo.
	*(required, any) The "x" coordinate value to be plotted on the graph.
	 */
	-(void)setXValue:(NSString*)XValue {
		[super setInput:@"XValue" toValue:XValue];
	}

	/*!
	 * Set the value of the YValue input for this Choreo.
	*(required, any) The "y" coordinate value to be plotted on the graph.
	 */
	-(void)setYValue:(NSString*)YValue {
		[super setInput:@"YValue" toValue:YValue];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ExtendLineGraph Choreo.
 */
@implementation TMBPlotly_ExtendLineGraph_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "URL" output from an execution of this Choreo.
	 * @return - NSString* (string) The Plotly URL for the graph.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getURL {
		return [super getOutputByName:@"URL"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Plotly
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Extends the specified line graph by plotting a single addition point.
 */
@implementation TMBPlotly_ExtendLineGraph

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPlotly_ExtendLineGraph Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Plotly/ExtendLineGraph"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPlotly_ExtendLineGraph_ResultSet *results = [[TMBPlotly_ExtendLineGraph_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ExtendLineGraph Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPlotly_ExtendLineGraph_Inputs*)newInputSet {
		return [[TMBPlotly_ExtendLineGraph_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ExtendTimeSeries Choreo.
 */
@implementation TMBPlotly_ExtendTimeSeries_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Plotly.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the FileName input for this Choreo.
	*(required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
	 */
	-(void)setFileName:(NSString*)FileName {
		[super setInput:@"FileName" toValue:FileName];
	}

	/*!
	 * Set the value of the TimeZone input for this Choreo.
	*(optional, string) If a value is not passed to the Timestamp input, the current is generated for you. When using this feature, you can indicate the desired time zone using this input. The default TimeZone is UTC.
	 */
	-(void)setTimeZone:(NSString*)TimeZone {
		[super setInput:@"TimeZone" toValue:TimeZone];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(optional, string) The title of the graph.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A valid Plotly username.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the WorldReadable input for this Choreo.
	*(optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
	 */
	-(void)setWorldReadable:(NSString*)WorldReadable {
		[super setInput:@"WorldReadable" toValue:WorldReadable];
	}

	/*!
	 * Set the value of the XValue input for this Choreo.
	*(conditional, date) The "x" coordinate timestamp to be plotted on the graph in the format YYYY-MM-DD HH:MM:SS. If not provided, this defaults to NOW().
	 */
	-(void)setXValue:(NSString*)XValue {
		[super setInput:@"XValue" toValue:XValue];
	}

	/*!
	 * Set the value of the YValue input for this Choreo.
	*(required, string) The "y" coordinate value associated with the specified timestamp.
	 */
	-(void)setYValue:(NSString*)YValue {
		[super setInput:@"YValue" toValue:YValue];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ExtendTimeSeries Choreo.
 */
@implementation TMBPlotly_ExtendTimeSeries_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "URL" output from an execution of this Choreo.
	 * @return - NSString* (string) The Plotly URL for the graph.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getURL {
		return [super getOutputByName:@"URL"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Plotly
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Extends the specified time series graph by plotting a single addition point.
 */
@implementation TMBPlotly_ExtendTimeSeries

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPlotly_ExtendTimeSeries Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Plotly/ExtendTimeSeries"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPlotly_ExtendTimeSeries_ResultSet *results = [[TMBPlotly_ExtendTimeSeries_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ExtendTimeSeries Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPlotly_ExtendTimeSeries_Inputs*)newInputSet {
		return [[TMBPlotly_ExtendTimeSeries_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PlotBarGraph Choreo.
 */
@implementation TMBPlotly_PlotBarGraph_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Plotly.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the FileName input for this Choreo.
	*(required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
	 */
	-(void)setFileName:(NSString*)FileName {
		[super setInput:@"FileName" toValue:FileName];
	}

	/*!
	 * Set the value of the FileOption input for this Choreo.
	*(optional, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details. This defaults to "overwrite".
	 */
	-(void)setFileOption:(NSString*)FileOption {
		[super setInput:@"FileOption" toValue:FileOption];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(optional, string) The title of the graph.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A valid Plotly username.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the WorldReadable input for this Choreo.
	*(optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
	 */
	-(void)setWorldReadable:(NSString*)WorldReadable {
		[super setInput:@"WorldReadable" toValue:WorldReadable];
	}

	/*!
	 * Set the value of the XValues input for this Choreo.
	*(required, json) A JSON array containing the "x" coordinate values to be plotted on the graph.
	 */
	-(void)setXValues:(NSString*)XValues {
		[super setInput:@"XValues" toValue:XValues];
	}

	/*!
	 * Set the value of the YValues input for this Choreo.
	*(required, json) A JSON array containing the "y" coordinate values to be plotted on the graph.
	 */
	-(void)setYValues:(NSString*)YValues {
		[super setInput:@"YValues" toValue:YValues];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlotBarGraph Choreo.
 */
@implementation TMBPlotly_PlotBarGraph_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "URL" output from an execution of this Choreo.
	 * @return - NSString* (string) The Plotly URL for the graph.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getURL {
		return [super getOutputByName:@"URL"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Plotly
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Plots an array of points on a bar graph.
 */
@implementation TMBPlotly_PlotBarGraph

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPlotly_PlotBarGraph Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Plotly/PlotBarGraph"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPlotly_PlotBarGraph_ResultSet *results = [[TMBPlotly_PlotBarGraph_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PlotBarGraph Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPlotly_PlotBarGraph_Inputs*)newInputSet {
		return [[TMBPlotly_PlotBarGraph_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PlotLineGraph Choreo.
 */
@implementation TMBPlotly_PlotLineGraph_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Plotly.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the FileName input for this Choreo.
	*(required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
	 */
	-(void)setFileName:(NSString*)FileName {
		[super setInput:@"FileName" toValue:FileName];
	}

	/*!
	 * Set the value of the FileOption input for this Choreo.
	*(optional, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details. This defaults to "overwrite".
	 */
	-(void)setFileOption:(NSString*)FileOption {
		[super setInput:@"FileOption" toValue:FileOption];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(optional, string) The title of the graph.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A valid Plotly username.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the WorldReadable input for this Choreo.
	*(optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
	 */
	-(void)setWorldReadable:(NSString*)WorldReadable {
		[super setInput:@"WorldReadable" toValue:WorldReadable];
	}

	/*!
	 * Set the value of the XValues input for this Choreo.
	*(required, json) A JSON array containing the "x" coordinate values to be plotted on the graph.
	 */
	-(void)setXValues:(NSString*)XValues {
		[super setInput:@"XValues" toValue:XValues];
	}

	/*!
	 * Set the value of the YValues input for this Choreo.
	*(required, json) A JSON array containing the "y" coordinate values to be plotted on the graph.
	 */
	-(void)setYValues:(NSString*)YValues {
		[super setInput:@"YValues" toValue:YValues];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlotLineGraph Choreo.
 */
@implementation TMBPlotly_PlotLineGraph_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "URL" output from an execution of this Choreo.
	 * @return - NSString* (string) The Plotly URL for the graph.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getURL {
		return [super getOutputByName:@"URL"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Plotly
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Plots an array of points on a line graph.
 */
@implementation TMBPlotly_PlotLineGraph

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPlotly_PlotLineGraph Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Plotly/PlotLineGraph"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPlotly_PlotLineGraph_ResultSet *results = [[TMBPlotly_PlotLineGraph_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PlotLineGraph Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPlotly_PlotLineGraph_Inputs*)newInputSet {
		return [[TMBPlotly_PlotLineGraph_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PlotTimeSeries Choreo.
 */
@implementation TMBPlotly_PlotTimeSeries_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Plotly.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the FileName input for this Choreo.
	*(required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
	 */
	-(void)setFileName:(NSString*)FileName {
		[super setInput:@"FileName" toValue:FileName];
	}

	/*!
	 * Set the value of the FileOption input for this Choreo.
	*(optional, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details. This defaults to "overwrite".
	 */
	-(void)setFileOption:(NSString*)FileOption {
		[super setInput:@"FileOption" toValue:FileOption];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(optional, string) The title of the graph.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the Username input for this Choreo.
	*(required, string) A valid Plotly username.
	 */
	-(void)setUsername:(NSString*)Username {
		[super setInput:@"Username" toValue:Username];
	}

	/*!
	 * Set the value of the WorldReadable input for this Choreo.
	*(optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
	 */
	-(void)setWorldReadable:(NSString*)WorldReadable {
		[super setInput:@"WorldReadable" toValue:WorldReadable];
	}

	/*!
	 * Set the value of the XValues input for this Choreo.
	*(required, json) A JSON array of timestamps representing the "x" coordinates to be plotted on the graph. Timestamps should be formatted as YYYY-MM-DD HH:MM:SS.
	 */
	-(void)setXValues:(NSString*)XValues {
		[super setInput:@"XValues" toValue:XValues];
	}

	/*!
	 * Set the value of the YValues input for this Choreo.
	*(required, json) A  JSON array of values representing the "y" coordinates associated with the specified timestamps.
	 */
	-(void)setYValues:(NSString*)YValues {
		[super setInput:@"YValues" toValue:YValues];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlotTimeSeries Choreo.
 */
@implementation TMBPlotly_PlotTimeSeries_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "URL" output from an execution of this Choreo.
	 * @return - NSString* (string) The Plotly URL for the graph.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getURL {
		return [super getOutputByName:@"URL"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Plotly
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Plots an array of time series data on a graph.
 */
@implementation TMBPlotly_PlotTimeSeries

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPlotly_PlotTimeSeries Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/Plotly/PlotTimeSeries"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPlotly_PlotTimeSeries_ResultSet *results = [[TMBPlotly_PlotTimeSeries_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PlotTimeSeries Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPlotly_PlotTimeSeries_Inputs*)newInputSet {
		return [[TMBPlotly_PlotTimeSeries_Inputs alloc] init];
	}
@end
	