/*!
 * @header Temboo iOS SDK PagerDuty classes
 *
 * Execute Choreographies from the Temboo PagerDuty bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBPagerDuty.Alerts.ListAlerts Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListAlerts Choreo.
 */
@interface TMBPagerDuty_Alerts_ListAlerts_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setFilter:(NSString*)Filter;
	-(void)setSince:(NSString*)Since;
	-(void)setSubDomain:(NSString*)SubDomain;
	-(void)setTimeZone:(NSString*)TimeZone;
	-(void)setUntil:(NSString*)Until;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAlerts Choreo.
 */
@interface TMBPagerDuty_Alerts_ListAlerts_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * List alerts for a given time range and allows you to filter by type.
 */
@interface TMBPagerDuty_Alerts_ListAlerts : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Alerts_ListAlerts_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Alerts_ListAlerts Choreo */


/*! group TMBPagerDuty.Events.AcknowledgeEvent Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AcknowledgeEvent Choreo.
 */
@interface TMBPagerDuty_Events_AcknowledgeEvent_Inputs : TMBChoreographyInputSet
	-(void)setDescription:(NSString*)Description;
	-(void)setDetails:(NSString*)Details;
	-(void)setIncidentKey:(NSString*)IncidentKey;
	-(void)setServiceKey:(NSString*)ServiceKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AcknowledgeEvent Choreo.
 */
@interface TMBPagerDuty_Events_AcknowledgeEvent_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Updates the state of an incident to "acknowleged", and allows you to log data to an incident log.
 */
@interface TMBPagerDuty_Events_AcknowledgeEvent : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Events_AcknowledgeEvent_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Events_AcknowledgeEvent Choreo */


/*! group TMBPagerDuty.Events.ResolveEvent Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ResolveEvent Choreo.
 */
@interface TMBPagerDuty_Events_ResolveEvent_Inputs : TMBChoreographyInputSet
	-(void)setDescription:(NSString*)Description;
	-(void)setDetails:(NSString*)Details;
	-(void)setIncidentKey:(NSString*)IncidentKey;
	-(void)setServiceKey:(NSString*)ServiceKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ResolveEvent Choreo.
 */
@interface TMBPagerDuty_Events_ResolveEvent_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Updates the state of an incident to "resolved", and allows you to log data to an incident log.
 */
@interface TMBPagerDuty_Events_ResolveEvent : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Events_ResolveEvent_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Events_ResolveEvent Choreo */


/*! group TMBPagerDuty.Events.TriggerEvent Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TriggerEvent Choreo.
 */
@interface TMBPagerDuty_Events_TriggerEvent_Inputs : TMBChoreographyInputSet
	-(void)setDescription:(NSString*)Description;
	-(void)setDetails:(NSString*)Details;
	-(void)setIncidentKey:(NSString*)IncidentKey;
	-(void)setServiceKey:(NSString*)ServiceKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TriggerEvent Choreo.
 */
@interface TMBPagerDuty_Events_TriggerEvent_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Triggers an event that will open a new incident or log an entry to an existing incident.
 */
@interface TMBPagerDuty_Events_TriggerEvent : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Events_TriggerEvent_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Events_TriggerEvent Choreo */


/*! group TMBPagerDuty.Incidents.AcknowledgeIncident Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AcknowledgeIncident Choreo.
 */
@interface TMBPagerDuty_Incidents_AcknowledgeIncident_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setIncidentID:(NSString*)IncidentID;
	-(void)setRequesterID:(NSString*)RequesterID;
	-(void)setSubDomain:(NSString*)SubDomain;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AcknowledgeIncident Choreo.
 */
@interface TMBPagerDuty_Incidents_AcknowledgeIncident_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Acknowledges an incident.
 */
@interface TMBPagerDuty_Incidents_AcknowledgeIncident : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Incidents_AcknowledgeIncident_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Incidents_AcknowledgeIncident Choreo */


/*! group TMBPagerDuty.Incidents.CountIncidents Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CountIncidents Choreo.
 */
@interface TMBPagerDuty_Incidents_CountIncidents_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAssignedToUser:(NSString*)AssignedToUser;
	-(void)setDateRange:(NSString*)DateRange;
	-(void)setIncidentKey:(NSString*)IncidentKey;
	-(void)setService:(NSString*)Service;
	-(void)setSince:(NSString*)Since;
	-(void)setStatus:(NSString*)Status;
	-(void)setSubDomain:(NSString*)SubDomain;
	-(void)setUntil:(NSString*)Until;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CountIncidents Choreo.
 */
@interface TMBPagerDuty_Incidents_CountIncidents_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a count of incidents that match a specified criteria.
 */
@interface TMBPagerDuty_Incidents_CountIncidents : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Incidents_CountIncidents_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Incidents_CountIncidents Choreo */


/*! group TMBPagerDuty.Incidents.GetIncident Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetIncident Choreo.
 */
@interface TMBPagerDuty_Incidents_GetIncident_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setIncidentID:(NSString*)IncidentID;
	-(void)setSubDomain:(NSString*)SubDomain;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetIncident Choreo.
 */
@interface TMBPagerDuty_Incidents_GetIncident_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns detailed information about a specified incident.
 */
@interface TMBPagerDuty_Incidents_GetIncident : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Incidents_GetIncident_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Incidents_GetIncident Choreo */


/*! group TMBPagerDuty.Incidents.ListIncidents Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListIncidents Choreo.
 */
@interface TMBPagerDuty_Incidents_ListIncidents_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAssignedToUser:(NSString*)AssignedToUser;
	-(void)setDateRange:(NSString*)DateRange;
	-(void)setFields:(NSString*)Fields;
	-(void)setIncidentKey:(NSString*)IncidentKey;
	-(void)setLimit:(NSString*)Limit;
	-(void)setOffset:(NSString*)Offset;
	-(void)setService:(NSString*)Service;
	-(void)setSince:(NSString*)Since;
	-(void)setSortBy:(NSString*)SortBy;
	-(void)setStatus:(NSString*)Status;
	-(void)setSubDomain:(NSString*)SubDomain;
	-(void)setTimeZone:(NSString*)TimeZone;
	-(void)setUntil:(NSString*)Until;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListIncidents Choreo.
 */
@interface TMBPagerDuty_Incidents_ListIncidents_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to list or search PagerDuty incidents.
 */
@interface TMBPagerDuty_Incidents_ListIncidents : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Incidents_ListIncidents_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Incidents_ListIncidents Choreo */


/*! group TMBPagerDuty.Incidents.ReassignIncident Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ReassignIncident Choreo.
 */
@interface TMBPagerDuty_Incidents_ReassignIncident_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAssignedToUser:(NSString*)AssignedToUser;
	-(void)setEscalationLevel:(NSString*)EscalationLevel;
	-(void)setIncidentID:(NSString*)IncidentID;
	-(void)setRequesterID:(NSString*)RequesterID;
	-(void)setSubDomain:(NSString*)SubDomain;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ReassignIncident Choreo.
 */
@interface TMBPagerDuty_Incidents_ReassignIncident_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Reassigns an incident.
 */
@interface TMBPagerDuty_Incidents_ReassignIncident : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Incidents_ReassignIncident_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Incidents_ReassignIncident Choreo */


/*! group TMBPagerDuty.Incidents.ResolveIncident Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ResolveIncident Choreo.
 */
@interface TMBPagerDuty_Incidents_ResolveIncident_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setIncidentID:(NSString*)IncidentID;
	-(void)setRequesterID:(NSString*)RequesterID;
	-(void)setSubDomain:(NSString*)SubDomain;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ResolveIncident Choreo.
 */
@interface TMBPagerDuty_Incidents_ResolveIncident_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Resolves an incident.
 */
@interface TMBPagerDuty_Incidents_ResolveIncident : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Incidents_ResolveIncident_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Incidents_ResolveIncident Choreo */


/*! group TMBPagerDuty.Incidents.UpdateIncidents Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateIncidents Choreo.
 */
@interface TMBPagerDuty_Incidents_UpdateIncidents_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setIncidents:(NSString*)Incidents;
	-(void)setRequesterID:(NSString*)RequesterID;
	-(void)setSubDomain:(NSString*)SubDomain;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateIncidents Choreo.
 */
@interface TMBPagerDuty_Incidents_UpdateIncidents_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to acknowledge, resolve, escalate or reassign one or more incidents.
 */
@interface TMBPagerDuty_Incidents_UpdateIncidents : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Incidents_UpdateIncidents_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Incidents_UpdateIncidents Choreo */


/*! group TMBPagerDuty.LogEntries.GetLogEntry Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLogEntry Choreo.
 */
@interface TMBPagerDuty_LogEntries_GetLogEntry_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setLogEntryID:(NSString*)LogEntryID;
	-(void)setSubDomain:(NSString*)SubDomain;
	-(void)setTimeZone:(NSString*)TimeZone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLogEntry Choreo.
 */
@interface TMBPagerDuty_LogEntries_GetLogEntry_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns details for a specific incident log entry.
 */
@interface TMBPagerDuty_LogEntries_GetLogEntry : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_LogEntries_GetLogEntry_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.LogEntries_GetLogEntry Choreo */


/*! group TMBPagerDuty.LogEntries.ListLogEntries Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListLogEntries Choreo.
 */
@interface TMBPagerDuty_LogEntries_ListLogEntries_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setInclude:(NSString*)Include;
	-(void)setIsOverview:(NSString*)IsOverview;
	-(void)setLimit:(NSString*)Limit;
	-(void)setOffset:(NSString*)Offset;
	-(void)setSince:(NSString*)Since;
	-(void)setSubDomain:(NSString*)SubDomain;
	-(void)setTimeZone:(NSString*)TimeZone;
	-(void)setUntil:(NSString*)Until;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListLogEntries Choreo.
 */
@interface TMBPagerDuty_LogEntries_ListLogEntries_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all incident log entries across an entire account.
 */
@interface TMBPagerDuty_LogEntries_ListLogEntries : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_LogEntries_ListLogEntries_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.LogEntries_ListLogEntries Choreo */


/*! group TMBPagerDuty.LogEntries.ListLogEntriesByIncident Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListLogEntriesByIncident Choreo.
 */
@interface TMBPagerDuty_LogEntries_ListLogEntriesByIncident_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setIncidentID:(NSString*)IncidentID;
	-(void)setInclude:(NSString*)Include;
	-(void)setIsOverview:(NSString*)IsOverview;
	-(void)setLimit:(NSString*)Limit;
	-(void)setOffset:(NSString*)Offset;
	-(void)setSince:(NSString*)Since;
	-(void)setSubDomain:(NSString*)SubDomain;
	-(void)setTimeZone:(NSString*)TimeZone;
	-(void)setUntil:(NSString*)Until;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListLogEntriesByIncident Choreo.
 */
@interface TMBPagerDuty_LogEntries_ListLogEntriesByIncident_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all incident log entries associated with a specific incident.
 */
@interface TMBPagerDuty_LogEntries_ListLogEntriesByIncident : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_LogEntries_ListLogEntriesByIncident_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.LogEntries_ListLogEntriesByIncident Choreo */


/*! group TMBPagerDuty.LogEntries.ListLogEntriesByUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListLogEntriesByUser Choreo.
 */
@interface TMBPagerDuty_LogEntries_ListLogEntriesByUser_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setInclude:(NSString*)Include;
	-(void)setIsOverview:(NSString*)IsOverview;
	-(void)setLimit:(NSString*)Limit;
	-(void)setOffset:(NSString*)Offset;
	-(void)setSince:(NSString*)Since;
	-(void)setSubDomain:(NSString*)SubDomain;
	-(void)setTimeZone:(NSString*)TimeZone;
	-(void)setUntil:(NSString*)Until;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListLogEntriesByUser Choreo.
 */
@interface TMBPagerDuty_LogEntries_ListLogEntriesByUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all incident log entries associated with a specific user.
 */
@interface TMBPagerDuty_LogEntries_ListLogEntriesByUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_LogEntries_ListLogEntriesByUser_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.LogEntries_ListLogEntriesByUser Choreo */


/*! group TMBPagerDuty.Reports.AlertsPerTime Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AlertsPerTime Choreo.
 */
@interface TMBPagerDuty_Reports_AlertsPerTime_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setRollup:(NSString*)Rollup;
	-(void)setSince:(NSString*)Since;
	-(void)setSubDomain:(NSString*)SubDomain;
	-(void)setUntil:(NSString*)Until;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AlertsPerTime Choreo.
 */
@interface TMBPagerDuty_Reports_AlertsPerTime_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns high-level statistics about the number of alerts sent for a specified time period.
 */
@interface TMBPagerDuty_Reports_AlertsPerTime : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Reports_AlertsPerTime_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Reports_AlertsPerTime Choreo */


/*! group TMBPagerDuty.Reports.IncidentsPerTime Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the IncidentsPerTime Choreo.
 */
@interface TMBPagerDuty_Reports_IncidentsPerTime_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setRollup:(NSString*)Rollup;
	-(void)setSince:(NSString*)Since;
	-(void)setSubDomain:(NSString*)SubDomain;
	-(void)setUntil:(NSString*)Until;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the IncidentsPerTime Choreo.
 */
@interface TMBPagerDuty_Reports_IncidentsPerTime_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns high-level statistics about the number of incidents created for a specified time period.
 */
@interface TMBPagerDuty_Reports_IncidentsPerTime : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPagerDuty_Reports_IncidentsPerTime_Inputs*)newInputSet;
@end

/*! group TMBPagerDuty.Reports_IncidentsPerTime Choreo */
