/*!
 * @header Temboo iOS SDK Mixpanel classes
 *
 * Execute Choreographies from the Temboo Mixpanel bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBMixpanel.DataExport.Events.EventData Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the EventData Choreo.
 */
@interface TMBMixpanel_DataExport_Events_EventData_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setEventNames:(NSString*)EventNames;
	-(void)setExpire:(NSString*)Expire;
	-(void)setInterval:(NSString*)Interval;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setType:(NSString*)Type;
	-(void)setUnit:(NSString*)Unit;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the EventData Choreo.
 */
@interface TMBMixpanel_DataExport_Events_EventData_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets unique, total, or average data for a set of events over the last N days, weeks, or months.
 */
@interface TMBMixpanel_DataExport_Events_EventData : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Events_EventData_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Events_EventData Choreo */


/*! group TMBMixpanel.DataExport.Events.TopEvents Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TopEvents Choreo.
 */
@interface TMBMixpanel_DataExport_Events_TopEvents_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setExpire:(NSString*)Expire;
	-(void)setLimit:(NSString*)Limit;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TopEvents Choreo.
 */
@interface TMBMixpanel_DataExport_Events_TopEvents_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets the top events for today, with their counts and the normalized percent change from yesterday.
 */
@interface TMBMixpanel_DataExport_Events_TopEvents : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Events_TopEvents_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Events_TopEvents Choreo */


/*! group TMBMixpanel.DataExport.Events.TopNames Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TopNames Choreo.
 */
@interface TMBMixpanel_DataExport_Events_TopNames_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setExpire:(NSString*)Expire;
	-(void)setLimit:(NSString*)Limit;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TopNames Choreo.
 */
@interface TMBMixpanel_DataExport_Events_TopNames_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets a list of the most common events over the last 31 days.
 */
@interface TMBMixpanel_DataExport_Events_TopNames : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Events_TopNames_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Events_TopNames Choreo */


/*! group TMBMixpanel.DataExport.Funnels.FunnelData Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FunnelData Choreo.
 */
@interface TMBMixpanel_DataExport_Funnels_FunnelData_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setExpire:(NSString*)Expire;
	-(void)setFromDate:(NSString*)FromDate;
	-(void)setFunnelID:(NSString*)FunnelID;
	-(void)setInterval:(NSString*)Interval;
	-(void)setLength:(NSString*)Length;
	-(void)setLimit:(NSString*)Limit;
	-(void)setOn:(NSString*)On;
	-(void)setToDate:(NSString*)ToDate;
	-(void)setUnit:(NSString*)Unit;
	-(void)setWhere:(NSString*)Where;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FunnelData Choreo.
 */
@interface TMBMixpanel_DataExport_Funnels_FunnelData_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets data for a specified funnel.
 */
@interface TMBMixpanel_DataExport_Funnels_FunnelData : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Funnels_FunnelData_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Funnels_FunnelData Choreo */


/*! group TMBMixpanel.DataExport.Funnels.FunnelList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FunnelList Choreo.
 */
@interface TMBMixpanel_DataExport_Funnels_FunnelList_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setExpire:(NSString*)Expire;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FunnelList Choreo.
 */
@interface TMBMixpanel_DataExport_Funnels_FunnelList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets the names and funnel_ids of your funnels.
 */
@interface TMBMixpanel_DataExport_Funnels_FunnelList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Funnels_FunnelList_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Funnels_FunnelList Choreo */


/*! group TMBMixpanel.DataExport.People.Engage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Engage Choreo.
 */
@interface TMBMixpanel_DataExport_People_Engage_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setExpire:(NSString*)Expire;
	-(void)setPage:(NSString*)Page;
	-(void)setSessionID:(NSString*)SessionID;
	-(void)setWhere:(NSString*)Where;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Engage Choreo.
 */
@interface TMBMixpanel_DataExport_People_Engage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Queries Mixpanel for data about people.
 */
@interface TMBMixpanel_DataExport_People_Engage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_People_Engage_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.People_Engage Choreo */


/*! group TMBMixpanel.DataExport.Properties.PropertyData Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the PropertyData Choreo.
 */
@interface TMBMixpanel_DataExport_Properties_PropertyData_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setEventName:(NSString*)EventName;
	-(void)setExpire:(NSString*)Expire;
	-(void)setInterval:(NSString*)Interval;
	-(void)setLimit:(NSString*)Limit;
	-(void)setPropertyName:(NSString*)PropertyName;
	-(void)setPropertyValues:(NSString*)PropertyValues;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setType:(NSString*)Type;
	-(void)setUnit:(NSString*)Unit;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PropertyData Choreo.
 */
@interface TMBMixpanel_DataExport_Properties_PropertyData_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets unique, total, or average data for of a single event and property over the last N days, weeks, or months.
 */
@interface TMBMixpanel_DataExport_Properties_PropertyData : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Properties_PropertyData_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Properties_PropertyData Choreo */


/*! group TMBMixpanel.DataExport.Properties.TopProperties Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TopProperties Choreo.
 */
@interface TMBMixpanel_DataExport_Properties_TopProperties_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setEventName:(NSString*)EventName;
	-(void)setExpire:(NSString*)Expire;
	-(void)setLimit:(NSString*)Limit;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TopProperties Choreo.
 */
@interface TMBMixpanel_DataExport_Properties_TopProperties_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets the top property names for an event.
 */
@interface TMBMixpanel_DataExport_Properties_TopProperties : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Properties_TopProperties_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Properties_TopProperties Choreo */


/*! group TMBMixpanel.DataExport.Properties.TopValues Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TopValues Choreo.
 */
@interface TMBMixpanel_DataExport_Properties_TopValues_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setEventName:(NSString*)EventName;
	-(void)setExpire:(NSString*)Expire;
	-(void)setLimit:(NSString*)Limit;
	-(void)setPropertyName:(NSString*)PropertyName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TopValues Choreo.
 */
@interface TMBMixpanel_DataExport_Properties_TopValues_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets the top values for a property.
 */
@interface TMBMixpanel_DataExport_Properties_TopValues : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Properties_TopValues_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Properties_TopValues Choreo */


/*! group TMBMixpanel.DataExport.Retention.RetentionData Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetentionData Choreo.
 */
@interface TMBMixpanel_DataExport_Retention_RetentionData_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setBornEvent:(NSString*)BornEvent;
	-(void)setBornWhere:(NSString*)BornWhere;
	-(void)setEventName:(NSString*)EventName;
	-(void)setExpire:(NSString*)Expire;
	-(void)setFromDate:(NSString*)FromDate;
	-(void)setInterval:(NSString*)Interval;
	-(void)setIntervalCount:(NSString*)IntervalCount;
	-(void)setLimit:(NSString*)Limit;
	-(void)setOn:(NSString*)On;
	-(void)setRetentionType:(NSString*)RetentionType;
	-(void)setToDate:(NSString*)ToDate;
	-(void)setUnit:(NSString*)Unit;
	-(void)setWhere:(NSString*)Where;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetentionData Choreo.
 */
@interface TMBMixpanel_DataExport_Retention_RetentionData_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets cohort analysis.
 */
@interface TMBMixpanel_DataExport_Retention_RetentionData : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Retention_RetentionData_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Retention_RetentionData Choreo */


/*! group TMBMixpanel.DataExport.Segmentation.Average Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Average Choreo.
 */
@interface TMBMixpanel_DataExport_Segmentation_Average_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setEventName:(NSString*)EventName;
	-(void)setExpire:(NSString*)Expire;
	-(void)setFromDate:(NSString*)FromDate;
	-(void)setOn:(NSString*)On;
	-(void)setToDate:(NSString*)ToDate;
	-(void)setUnit:(NSString*)Unit;
	-(void)setWhere:(NSString*)Where;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Average Choreo.
 */
@interface TMBMixpanel_DataExport_Segmentation_Average_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Averages an expression for events per unit time.
 */
@interface TMBMixpanel_DataExport_Segmentation_Average : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Segmentation_Average_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Segmentation_Average Choreo */


/*! group TMBMixpanel.DataExport.Segmentation.Numeric Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Numeric Choreo.
 */
@interface TMBMixpanel_DataExport_Segmentation_Numeric_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setBuckets:(NSString*)Buckets;
	-(void)setEventName:(NSString*)EventName;
	-(void)setExpire:(NSString*)Expire;
	-(void)setFromDate:(NSString*)FromDate;
	-(void)setOn:(NSString*)On;
	-(void)setToDate:(NSString*)ToDate;
	-(void)setType:(NSString*)Type;
	-(void)setUnit:(NSString*)Unit;
	-(void)setWhere:(NSString*)Where;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Numeric Choreo.
 */
@interface TMBMixpanel_DataExport_Segmentation_Numeric_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets data for an event, segmented and filtered by properties, with values placed into numeric buckets.
 */
@interface TMBMixpanel_DataExport_Segmentation_Numeric : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Segmentation_Numeric_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Segmentation_Numeric Choreo */


/*! group TMBMixpanel.DataExport.Segmentation.SegmentationData Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SegmentationData Choreo.
 */
@interface TMBMixpanel_DataExport_Segmentation_SegmentationData_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setEventName:(NSString*)EventName;
	-(void)setExpire:(NSString*)Expire;
	-(void)setFromDate:(NSString*)FromDate;
	-(void)setLimit:(NSString*)Limit;
	-(void)setOn:(NSString*)On;
	-(void)setToDate:(NSString*)ToDate;
	-(void)setType:(NSString*)Type;
	-(void)setUnit:(NSString*)Unit;
	-(void)setWhere:(NSString*)Where;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SegmentationData Choreo.
 */
@interface TMBMixpanel_DataExport_Segmentation_SegmentationData_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Gets data for an event, segmented and filtered by properties.
 */
@interface TMBMixpanel_DataExport_Segmentation_SegmentationData : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Segmentation_SegmentationData_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Segmentation_SegmentationData Choreo */


/*! group TMBMixpanel.DataExport.Segmentation.Sum Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Sum Choreo.
 */
@interface TMBMixpanel_DataExport_Segmentation_Sum_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAPISecret:(NSString*)APISecret;
	-(void)setEventName:(NSString*)EventName;
	-(void)setExpire:(NSString*)Expire;
	-(void)setFromDate:(NSString*)FromDate;
	-(void)setOn:(NSString*)On;
	-(void)setToDate:(NSString*)ToDate;
	-(void)setUnit:(NSString*)Unit;
	-(void)setWhere:(NSString*)Where;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Sum Choreo.
 */
@interface TMBMixpanel_DataExport_Segmentation_Sum_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Sums an expression for events per unit time.
 */
@interface TMBMixpanel_DataExport_Segmentation_Sum : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_DataExport_Segmentation_Sum_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.DataExport.Segmentation_Sum Choreo */


/*! group TMBMixpanel.Events.Track Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Track Choreo.
 */
@interface TMBMixpanel_Events_Track_Inputs : TMBChoreographyInputSet
	-(void)setDistinctID:(NSString*)DistinctID;
	-(void)setEventName:(NSString*)EventName;
	-(void)setEventProperties:(NSString*)EventProperties;
	-(void)setIP:(NSString*)IP;
	-(void)setTime:(NSString*)Time;
	-(void)setToken:(NSString*)Token;
	-(void)setVerbose:(NSString*)Verbose;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Track Choreo.
 */
@interface TMBMixpanel_Events_Track_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Records an event in Mixpanel.
 */
@interface TMBMixpanel_Events_Track : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_Events_Track_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.Events_Track Choreo */


/*! group TMBMixpanel.Profiles.Add Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Add Choreo.
 */
@interface TMBMixpanel_Profiles_Add_Inputs : TMBChoreographyInputSet
	-(void)setDistinctID:(NSString*)DistinctID;
	-(void)setIP:(NSString*)IP;
	-(void)setIgnoreTime:(NSString*)IgnoreTime;
	-(void)setProfileProperties:(NSString*)ProfileProperties;
	-(void)setTime:(NSString*)Time;
	-(void)setToken:(NSString*)Token;
	-(void)setVerbose:(NSString*)Verbose;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Add Choreo.
 */
@interface TMBMixpanel_Profiles_Add_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Adds or subtracts a value from an existing numeric property value.
 */
@interface TMBMixpanel_Profiles_Add : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_Profiles_Add_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.Profiles_Add Choreo */


/*! group TMBMixpanel.Profiles.Append Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Append Choreo.
 */
@interface TMBMixpanel_Profiles_Append_Inputs : TMBChoreographyInputSet
	-(void)setDistinctID:(NSString*)DistinctID;
	-(void)setIP:(NSString*)IP;
	-(void)setIgnoreTime:(NSString*)IgnoreTime;
	-(void)setProfileProperties:(NSString*)ProfileProperties;
	-(void)setTime:(NSString*)Time;
	-(void)setToken:(NSString*)Token;
	-(void)setVerbose:(NSString*)Verbose;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Append Choreo.
 */
@interface TMBMixpanel_Profiles_Append_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Appends a value to a list property on a profile.
 */
@interface TMBMixpanel_Profiles_Append : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_Profiles_Append_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.Profiles_Append Choreo */


/*! group TMBMixpanel.Profiles.Delete Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Delete Choreo.
 */
@interface TMBMixpanel_Profiles_Delete_Inputs : TMBChoreographyInputSet
	-(void)setDistinctID:(NSString*)DistinctID;
	-(void)setToken:(NSString*)Token;
	-(void)setVerbose:(NSString*)Verbose;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Delete Choreo.
 */
@interface TMBMixpanel_Profiles_Delete_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Permanently deletes the profile from Mixpanel, along with all of its properties.
 */
@interface TMBMixpanel_Profiles_Delete : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_Profiles_Delete_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.Profiles_Delete Choreo */


/*! group TMBMixpanel.Profiles.Set Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Set Choreo.
 */
@interface TMBMixpanel_Profiles_Set_Inputs : TMBChoreographyInputSet
	-(void)setCity:(NSString*)City;
	-(void)setCreated:(NSString*)Created;
	-(void)setDistinctID:(NSString*)DistinctID;
	-(void)setEmail:(NSString*)Email;
	-(void)setFirstName:(NSString*)FirstName;
	-(void)setIP:(NSString*)IP;
	-(void)setIgnoreTime:(NSString*)IgnoreTime;
	-(void)setLastName:(NSString*)LastName;
	-(void)setName:(NSString*)Name;
	-(void)setPhone:(NSString*)Phone;
	-(void)setProfileProperties:(NSString*)ProfileProperties;
	-(void)setRegion:(NSString*)Region;
	-(void)setTime:(NSString*)Time;
	-(void)setTimezone:(NSString*)Timezone;
	-(void)setToken:(NSString*)Token;
	-(void)setVerbose:(NSString*)Verbose;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Set Choreo.
 */
@interface TMBMixpanel_Profiles_Set_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Sets the properties of a profile.
 */
@interface TMBMixpanel_Profiles_Set : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_Profiles_Set_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.Profiles_Set Choreo */


/*! group TMBMixpanel.Profiles.SetOnce Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SetOnce Choreo.
 */
@interface TMBMixpanel_Profiles_SetOnce_Inputs : TMBChoreographyInputSet
	-(void)setDistinctID:(NSString*)DistinctID;
	-(void)setIP:(NSString*)IP;
	-(void)setIgnoreTime:(NSString*)IgnoreTime;
	-(void)setProfileProperties:(NSString*)ProfileProperties;
	-(void)setTime:(NSString*)Time;
	-(void)setToken:(NSString*)Token;
	-(void)setVerbose:(NSString*)Verbose;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SetOnce Choreo.
 */
@interface TMBMixpanel_Profiles_SetOnce_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Sets the properties of a profile, but will not overwrite existing properties.
 */
@interface TMBMixpanel_Profiles_SetOnce : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_Profiles_SetOnce_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.Profiles_SetOnce Choreo */


/*! group TMBMixpanel.Profiles.Transaction Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Transaction Choreo.
 */
@interface TMBMixpanel_Profiles_Transaction_Inputs : TMBChoreographyInputSet
	-(void)setDistinctID:(NSString*)DistinctID;
	-(void)setIP:(NSString*)IP;
	-(void)setIgnoreTime:(NSString*)IgnoreTime;
	-(void)setTime:(NSString*)Time;
	-(void)setToken:(NSString*)Token;
	-(void)setTransactionAmount:(NSString*)TransactionAmount;
	-(void)setTransactionProperties:(NSString*)TransactionProperties;
	-(void)setTransactionTime:(NSString*)TransactionTime;
	-(void)setVerbose:(NSString*)Verbose;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Transaction Choreo.
 */
@interface TMBMixpanel_Profiles_Transaction_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Appends transaction data to a profile.
 */
@interface TMBMixpanel_Profiles_Transaction : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_Profiles_Transaction_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.Profiles_Transaction Choreo */


/*! group TMBMixpanel.Profiles.Union Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Union Choreo.
 */
@interface TMBMixpanel_Profiles_Union_Inputs : TMBChoreographyInputSet
	-(void)setDistinctID:(NSString*)DistinctID;
	-(void)setIP:(NSString*)IP;
	-(void)setIgnoreTime:(NSString*)IgnoreTime;
	-(void)setProfileProperties:(NSString*)ProfileProperties;
	-(void)setTime:(NSString*)Time;
	-(void)setToken:(NSString*)Token;
	-(void)setVerbose:(NSString*)Verbose;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Union Choreo.
 */
@interface TMBMixpanel_Profiles_Union_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Merges list values with an existing list on a profile.
 */
@interface TMBMixpanel_Profiles_Union : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_Profiles_Union_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.Profiles_Union Choreo */


/*! group TMBMixpanel.Profiles.Unset Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Unset Choreo.
 */
@interface TMBMixpanel_Profiles_Unset_Inputs : TMBChoreographyInputSet
	-(void)setDistinctID:(NSString*)DistinctID;
	-(void)setIP:(NSString*)IP;
	-(void)setIgnoreTime:(NSString*)IgnoreTime;
	-(void)setProfileProperties:(NSString*)ProfileProperties;
	-(void)setTime:(NSString*)Time;
	-(void)setToken:(NSString*)Token;
	-(void)setVerbose:(NSString*)Verbose;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Unset Choreo.
 */
@interface TMBMixpanel_Profiles_Unset_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Removes the specified properties and their values from a profile.
 */
@interface TMBMixpanel_Profiles_Unset : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBMixpanel_Profiles_Unset_Inputs*)newInputSet;
@end

/*! group TMBMixpanel.Profiles_Unset Choreo */
