/*!
 * @header Temboo iOS SDK LinkedIn classes
 *
 * Execute Choreographies from the Temboo LinkedIn bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBLinkedIn.Companies.CompanyShare Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CompanyShare Choreo.
 */
@interface TMBLinkedIn_Companies_CompanyShare_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setComment:(NSString*)Comment;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setDescription:(NSString*)Description;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setSharedTargetCode:(NSString*)SharedTargetCode;
	-(void)setSharedTargetValue:(NSString*)SharedTargetValue;
	-(void)setSubmittedImageURL:(NSString*)SubmittedImageURL;
	-(void)setSubmittedURL:(NSString*)SubmittedURL;
	-(void)setTitle:(NSString*)Title;
	-(void)setVisibility:(NSString*)Visibility;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CompanyShare Choreo.
 */
@interface TMBLinkedIn_Companies_CompanyShare_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Posts shared comment on a company page.
 */
@interface TMBLinkedIn_Companies_CompanyShare : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_CompanyShare_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_CompanyShare Choreo */


/*! group TMBLinkedIn.Companies.GetComments Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetComments Choreo.
 */
@interface TMBLinkedIn_Companies_GetComments_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setUpdateKey:(NSString*)UpdateKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetComments Choreo.
 */
@interface TMBLinkedIn_Companies_GetComments_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns all comments for a specific company update.
 */
@interface TMBLinkedIn_Companies_GetComments : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_GetComments_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_GetComments Choreo */


/*! group TMBLinkedIn.Companies.GetCompanyProfileByID Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetCompanyProfileByID Choreo.
 */
@interface TMBLinkedIn_Companies_GetCompanyProfileByID_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setFieldSelector:(NSString*)FieldSelector;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCompanyProfileByID Choreo.
 */
@interface TMBLinkedIn_Companies_GetCompanyProfileByID_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns profile information about a specified company.
 */
@interface TMBLinkedIn_Companies_GetCompanyProfileByID : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_GetCompanyProfileByID_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_GetCompanyProfileByID Choreo */


/*! group TMBLinkedIn.Companies.GetCompanyUpdate Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetCompanyUpdate Choreo.
 */
@interface TMBLinkedIn_Companies_GetCompanyUpdate_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setUpdateKey:(NSString*)UpdateKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCompanyUpdate Choreo.
 */
@interface TMBLinkedIn_Companies_GetCompanyUpdate_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a specific update event from the LinkedIn company page.
 */
@interface TMBLinkedIn_Companies_GetCompanyUpdate : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_GetCompanyUpdate_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_GetCompanyUpdate Choreo */


/*! group TMBLinkedIn.Companies.GetCompanyUpdates Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetCompanyUpdates Choreo.
 */
@interface TMBLinkedIn_Companies_GetCompanyUpdates_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setCount:(NSString*)Count;
	-(void)setEventType:(NSString*)EventType;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setStart:(NSString*)Start;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCompanyUpdates Choreo.
 */
@interface TMBLinkedIn_Companies_GetCompanyUpdates_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a list of update events from the LinkedIn company page.
 */
@interface TMBLinkedIn_Companies_GetCompanyUpdates : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_GetCompanyUpdates_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_GetCompanyUpdates Choreo */


/*! group TMBLinkedIn.Companies.GetFollowers Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetFollowers Choreo.
 */
@interface TMBLinkedIn_Companies_GetFollowers_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setCompanySizes:(NSString*)CompanySizes;
	-(void)setGeographicArea:(NSString*)GeographicArea;
	-(void)setIndustries:(NSString*)Industries;
	-(void)setJobFunction:(NSString*)JobFunction;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setSeniorityLevel:(NSString*)SeniorityLevel;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFollowers Choreo.
 */
@interface TMBLinkedIn_Companies_GetFollowers_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a company's followers, by segment.
 */
@interface TMBLinkedIn_Companies_GetFollowers : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_GetFollowers_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_GetFollowers Choreo */


/*! group TMBLinkedIn.Companies.GetHistoricalFollowers Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetHistoricalFollowers Choreo.
 */
@interface TMBLinkedIn_Companies_GetHistoricalFollowers_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setEndTimestamp:(NSString*)EndTimestamp;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setStartTimestamp:(NSString*)StartTimestamp;
	-(void)setTimeGranularity:(NSString*)TimeGranularity;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetHistoricalFollowers Choreo.
 */
@interface TMBLinkedIn_Companies_GetHistoricalFollowers_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a company's followers, by date range.
 */
@interface TMBLinkedIn_Companies_GetHistoricalFollowers : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_GetHistoricalFollowers_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_GetHistoricalFollowers Choreo */


/*! group TMBLinkedIn.Companies.GetHistoricalUpdates Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetHistoricalUpdates Choreo.
 */
@interface TMBLinkedIn_Companies_GetHistoricalUpdates_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setEndTimestamp:(NSString*)EndTimestamp;
	-(void)setFieldSelector:(NSString*)FieldSelector;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setStartTimestamp:(NSString*)StartTimestamp;
	-(void)setTimeGranularity:(NSString*)TimeGranularity;
	-(void)setUpdateKey:(NSString*)UpdateKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetHistoricalUpdates Choreo.
 */
@interface TMBLinkedIn_Companies_GetHistoricalUpdates_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns impression and engagement data on company shares for a given company page.
 */
@interface TMBLinkedIn_Companies_GetHistoricalUpdates : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_GetHistoricalUpdates_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_GetHistoricalUpdates Choreo */


/*! group TMBLinkedIn.Companies.GetLikes Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLikes Choreo.
 */
@interface TMBLinkedIn_Companies_GetLikes_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setUpdateKey:(NSString*)UpdateKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLikes Choreo.
 */
@interface TMBLinkedIn_Companies_GetLikes_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns all likes for a specific company update.
 */
@interface TMBLinkedIn_Companies_GetLikes : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_GetLikes_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_GetLikes Choreo */


/*! group TMBLinkedIn.Companies.GetStatistics Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetStatistics Choreo.
 */
@interface TMBLinkedIn_Companies_GetStatistics_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetStatistics Choreo.
 */
@interface TMBLinkedIn_Companies_GetStatistics_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns general statistics for a company.
 */
@interface TMBLinkedIn_Companies_GetStatistics : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_GetStatistics_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_GetStatistics Choreo */


/*! group TMBLinkedIn.Companies.IsAdmin Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the IsAdmin Choreo.
 */
@interface TMBLinkedIn_Companies_IsAdmin_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the IsAdmin Choreo.
 */
@interface TMBLinkedIn_Companies_IsAdmin_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a simple boolean value that indicates whether the currently authenticated user is configured to be an administrator of the specified company.
 */
@interface TMBLinkedIn_Companies_IsAdmin : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_IsAdmin_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_IsAdmin Choreo */


/*! group TMBLinkedIn.Companies.IsSharingEnabled Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the IsSharingEnabled Choreo.
 */
@interface TMBLinkedIn_Companies_IsSharingEnabled_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCompanyID:(NSString*)CompanyID;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the IsSharingEnabled Choreo.
 */
@interface TMBLinkedIn_Companies_IsSharingEnabled_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a simple boolean value that indicates whether the specified company has sharing enabled or disabled.
 */
@interface TMBLinkedIn_Companies_IsSharingEnabled : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_IsSharingEnabled_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_IsSharingEnabled Choreo */


/*! group TMBLinkedIn.Companies.ListCompanies Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListCompanies Choreo.
 */
@interface TMBLinkedIn_Companies_ListCompanies_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setCount:(NSString*)Count;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setStart:(NSString*)Start;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListCompanies Choreo.
 */
@interface TMBLinkedIn_Companies_ListCompanies_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a list of all of the companies that the authenticated user is currently configured to be an administrator of.
 */
@interface TMBLinkedIn_Companies_ListCompanies : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_Companies_ListCompanies_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.Companies_ListCompanies Choreo */


/*! group TMBLinkedIn.OAuth.FinalizeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FinalizeOAuth Choreo.
 */
@interface TMBLinkedIn_OAuth_FinalizeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setCallbackID:(NSString*)CallbackID;
	-(void)setOAuthTokenSecret:(NSString*)OAuthTokenSecret;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setSuppressErrors:(NSString*)SuppressErrors;
	-(void)setTimeout:(NSString*)Timeout;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FinalizeOAuth Choreo.
 */
@interface TMBLinkedIn_OAuth_FinalizeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getAccessTokenSecret;
	-(NSString*)getErrorMessage;
	-(NSString*)getExpires;	
@end

/*!
 * Completes the OAuth process by retrieving a LinkedIn access token and access token secret for a user, after they have visited the authorization URL returned by the InitializeOAuth choreo and clicked "allow."
 */
@interface TMBLinkedIn_OAuth_FinalizeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_OAuth_FinalizeOAuth_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.OAuth_FinalizeOAuth Choreo */


/*! group TMBLinkedIn.OAuth.InitializeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InitializeOAuth Choreo.
 */
@interface TMBLinkedIn_OAuth_InitializeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setForwardingURL:(NSString*)ForwardingURL;
	-(void)setScope:(NSString*)Scope;
	-(void)setSecretKey:(NSString*)SecretKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InitializeOAuth Choreo.
 */
@interface TMBLinkedIn_OAuth_InitializeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAuthorizationURL;
	-(NSString*)getCallbackID;
	-(NSString*)getOAuthTokenSecret;	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 */
@interface TMBLinkedIn_OAuth_InitializeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_OAuth_InitializeOAuth_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.OAuth_InitializeOAuth Choreo */


/*! group TMBLinkedIn.PeopleAndConnections.GetMemberProfile Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetMemberProfile Choreo.
 */
@interface TMBLinkedIn_PeopleAndConnections_GetMemberProfile_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setFieldSelector:(NSString*)FieldSelector;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMemberProfile Choreo.
 */
@interface TMBLinkedIn_PeopleAndConnections_GetMemberProfile_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the standard default profile of the current user.
 */
@interface TMBLinkedIn_PeopleAndConnections_GetMemberProfile : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_PeopleAndConnections_GetMemberProfile_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.PeopleAndConnections_GetMemberProfile Choreo */


/*! group TMBLinkedIn.ShareAndSocialStream.CreateShare Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateShare Choreo.
 */
@interface TMBLinkedIn_ShareAndSocialStream_CreateShare_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAccessTokenSecret:(NSString*)AccessTokenSecret;
	-(void)setComment:(NSString*)Comment;
	-(void)setDescription:(NSString*)Description;
	-(void)setImageURL:(NSString*)ImageURL;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSecretKey:(NSString*)SecretKey;
	-(void)setTitle:(NSString*)Title;
	-(void)setURL:(NSString*)URL;
	-(void)setVisibility:(NSString*)Visibility;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateShare Choreo.
 */
@interface TMBLinkedIn_ShareAndSocialStream_CreateShare_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to share content on behalf of a LinkedIn member.
 */
@interface TMBLinkedIn_ShareAndSocialStream_CreateShare : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBLinkedIn_ShareAndSocialStream_CreateShare_Inputs*)newInputSet;
@end

/*! group TMBLinkedIn.ShareAndSocialStream_CreateShare Choreo */
